/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import android.app.Application;
import android.os.Build;
import android.os.ConditionVariable;
import android.text.TextUtils;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.core.api.DownloadLatestWebViewStatus;
import com.unity3d.services.core.api.Lifecycle;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.IModuleConfiguration;
import com.unity3d.services.core.connectivity.ConnectivityMonitor;
import com.unity3d.services.core.connectivity.IConnectivityListener;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.SDKMetrics;
import com.unity3d.services.core.request.WebRequest;
import com.unity3d.services.core.webview.WebViewApp;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class InitializeThread
extends Thread {
    private static InitializeThread _thread;
    private InitializeState _state;
    private boolean _stopThread = false;

    private InitializeThread(InitializeState initializeState) {
        this._state = initializeState;
    }

    public static DownloadLatestWebViewStatus downloadLatestWebView() {
        synchronized (InitializeThread.class) {
            InitializeThread initializeThread;
            if (_thread != null) {
                DownloadLatestWebViewStatus downloadLatestWebViewStatus = DownloadLatestWebViewStatus.INIT_QUEUE_NOT_EMPTY;
                return downloadLatestWebViewStatus;
            }
            if (SdkProperties.getLatestConfiguration() == null) {
                DownloadLatestWebViewStatus downloadLatestWebViewStatus = DownloadLatestWebViewStatus.MISSING_LATEST_CONFIG;
                return downloadLatestWebViewStatus;
            }
            InitializeStateCheckForCachedWebViewUpdate initializeStateCheckForCachedWebViewUpdate = new InitializeStateCheckForCachedWebViewUpdate(SdkProperties.getLatestConfiguration());
            _thread = initializeThread = new InitializeThread(initializeStateCheckForCachedWebViewUpdate);
            _thread.setName("UnityAdsDownloadThread");
            _thread.start();
            initializeStateCheckForCachedWebViewUpdate = DownloadLatestWebViewStatus.BACKGROUND_DOWNLOAD_STARTED;
            return initializeStateCheckForCachedWebViewUpdate;
        }
    }

    public static void initialize(Configuration configuration) {
        synchronized (InitializeThread.class) {
            if (_thread == null) {
                InitializeThread initializeThread;
                InitializeStateLoadConfigFile initializeStateLoadConfigFile = new InitializeStateLoadConfigFile(configuration);
                _thread = initializeThread = new InitializeThread(initializeStateLoadConfigFile);
                _thread.setName("UnityAdsInitializeThread");
                _thread.start();
            }
            return;
        }
    }

    private static byte[] loadCachedFileToByteArray(File object) throws IOException {
        if (object != null && ((File)object).exists()) {
            try {
                object = Utilities.readFileBytes((File)object);
                return object;
            }
            catch (IOException iOException) {
                throw new IOException("could not read from file");
            }
        }
        throw new IOException("file not found");
    }

    public static void reset() {
        synchronized (InitializeThread.class) {
            if (_thread == null) {
                InitializeThread initializeThread;
                InitializeStateForceReset initializeStateForceReset = new InitializeStateForceReset();
                _thread = initializeThread = new InitializeThread(initializeStateForceReset);
                _thread.setName("UnityAdsResetThread");
                _thread.start();
            }
            return;
        }
    }

    public void quit() {
        this._stopThread = true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            boolean bl;
            if (this._state == null || (bl = this._stopThread)) break;
            {
                catch (OutOfMemoryError outOfMemoryError) {}
            }
            try {
                this._state = this._state.execute();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Runnable runnable2 = new Exception(outOfMemoryError);
                DeviceLog.exception((String)"Unity Ads SDK failed to initialize due to application doesn't have enough memory to initialize Unity Ads SDK", (Exception)((Object)runnable2));
                runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        SdkProperties.notifyInitializationFailed((UnityAds.UnityAdsInitializationError)UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, (String)"Unity Ads SDK failed to initialize due to application doesn't have enough memory to initialize Unity Ads SDK");
                    }
                };
                Utilities.runOnUiThread((Runnable)runnable2);
                runnable2 = new InitializeStateForceReset();
                this._state = runnable2;
                catch (Exception exception) {
                    DeviceLog.exception((String)"Unity Ads SDK encountered an error during initialization, cancel initialization", (Exception)exception);
                    runnable2 = new Runnable(){

                        @Override
                        public void run() {
                            SdkProperties.notifyInitializationFailed((UnityAds.UnityAdsInitializationError)UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, (String)"Unity Ads SDK encountered an error during initialization, cancel initialization");
                        }
                    };
                    Utilities.runOnUiThread((Runnable)runnable2);
                    runnable2 = new InitializeStateForceReset();
                    this._state = runnable2;
                }
                continue;
            }
            break;
        }
        _thread = null;
    }

    private static abstract class InitializeState {
        private InitializeState() {
        }

        public abstract InitializeState execute();
    }

    public static class InitializeStateCheckForCachedWebViewUpdate
    extends InitializeState {
        private Configuration _configuration;

        public InitializeStateCheckForCachedWebViewUpdate(Configuration configuration) {
            this._configuration = configuration;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public InitializeState execute() {
            try {
                Object object = new File(SdkProperties.getLocalWebViewFile());
                object = InitializeThread.loadCachedFileToByteArray((File)object);
                if (!Utilities.Sha256((byte[])object).equals(this._configuration.getWebViewHash())) return new InitializeStateDownloadWebView(this._configuration);
                String string2 = new String((byte[])object, "UTF-8");
                return new InitializeStateUpdateCache(this._configuration, string2);
            }
            catch (Exception exception) {
                return new InitializeStateDownloadWebView(this._configuration);
            }
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }
    }

    public static class InitializeStateCheckForUpdatedWebView
    extends InitializeState {
        private Configuration _configuration;
        private Configuration _localWebViewConfiguration;
        private byte[] _localWebViewData;

        public InitializeStateCheckForUpdatedWebView(Configuration configuration, byte[] byArray, Configuration configuration2) {
            this._configuration = configuration;
            this._localWebViewData = byArray;
            this._localWebViewConfiguration = configuration2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public InitializeState execute() {
            Object object;
            try {
                object = Utilities.Sha256((byte[])this._localWebViewData);
                if (!((String)object).equals(this._configuration.getWebViewHash())) {
                    SdkProperties.setLatestConfiguration((Configuration)this._configuration);
                }
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    Configuration configuration = this._localWebViewConfiguration;
                    if (configuration != null && this._localWebViewConfiguration.getWebViewHash() != null && this._localWebViewConfiguration.getWebViewHash().equals(object) && SdkProperties.getVersionName().equals(this._localWebViewConfiguration.getSdkVersion())) {
                        object = new String(this._localWebViewData, "UTF-8");
                        return new InitializeStateCreate(this._localWebViewConfiguration, (String)object);
                    }
                    if (this._configuration != null && this._configuration.getWebViewHash().equals(object)) {
                        object = new String(this._localWebViewData, "UTF-8");
                        return new InitializeStateCreate(this._configuration, (String)object);
                    }
                }
            }
            catch (Exception exception) {}
            object = new InitializeStateLoadWeb(this._configuration);
            return new InitializeStateCleanCache(this._configuration, (InitializeState)object);
        }
    }

    public static class InitializeStateCleanCache
    extends InitializeState {
        private Configuration _configuration;
        private InitializeState _nextState;

        public InitializeStateCleanCache(Configuration configuration, InitializeState initializeState) {
            this._configuration = configuration;
            this._nextState = initializeState;
        }

        @Override
        public InitializeState execute() {
            try {
                File file = new File(SdkProperties.getLocalConfigurationFilepath());
                File file2 = new File(SdkProperties.getLocalWebViewFile());
                file.delete();
                file2.delete();
            }
            catch (Exception exception) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Failure trying to clean cache: ");
                stringBuilder.append(exception.getMessage());
                DeviceLog.error((String)stringBuilder.toString());
            }
            return this._nextState;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }
    }

    public static class InitializeStateCleanCacheIgnoreError
    extends InitializeStateCleanCache {
        public InitializeStateCleanCacheIgnoreError(Configuration configuration, InitializeState initializeState) {
            super(configuration, initializeState);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public InitializeState execute() {
            block3: {
                try {
                    InitializeState initializeState = super.execute();
                    boolean bl = initializeState instanceof InitializeStateError;
                    if (bl) break block3;
                    return initializeState;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return null;
        }
    }

    public static class InitializeStateComplete
    extends InitializeState {
        private Configuration _configuration;

        public InitializeStateComplete(Configuration configuration) {
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            for (String string2 : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration object = this._configuration.getModuleConfiguration(string2);
                if (object == null) continue;
                object.initCompleteState(this._configuration);
            }
            return null;
        }
    }

    public static class InitializeStateConfig
    extends InitializeState {
        private Configuration _configuration = new Configuration(SdkProperties.getConfigUrl());
        private Configuration _localConfig;
        private int _maxRetries;
        private int _retries = 0;
        private long _retryDelay;
        private double _scalingFactor;

        public InitializeStateConfig(Configuration configuration) {
            this._retryDelay = configuration.getRetryDelay();
            this._maxRetries = configuration.getMaxRetries();
            this._scalingFactor = configuration.getRetryScalingFactor();
            this._localConfig = configuration;
        }

        @Override
        public InitializeState execute() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unity Ads init: load configuration from ");
            stringBuilder.append(SdkProperties.getConfigUrl());
            DeviceLog.info((String)stringBuilder.toString());
            try {
                this._configuration.makeRequest();
            }
            catch (Exception exception) {
                int n2 = this._retries;
                if (n2 < this._maxRetries) {
                    double d2 = this._retryDelay;
                    double d3 = this._scalingFactor;
                    Double.isNaN(d2);
                    this._retryDelay = (long)(d2 * d3);
                    this._retries = n2 + 1;
                    return new InitializeStateRetry(this, this._retryDelay);
                }
                return new InitializeStateNetworkError("network config request", exception, this, this._localConfig);
            }
            if (this._configuration.getDelayWebViewUpdate()) {
                return new InitializeStateLoadCacheConfigAndWebView(this._configuration, this._localConfig);
            }
            return new InitializeStateLoadCache(this._configuration);
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }
    }

    public static class InitializeStateCreate
    extends InitializeState {
        public static final String InitializeStateCreateStateName = "create webapp";
        private Configuration _configuration;
        private String _webViewData;

        public InitializeStateCreate(Configuration configuration, String string2) {
            this._configuration = configuration;
            this._webViewData = string2;
        }

        @Override
        public InitializeState execute() {
            Object object;
            block2: {
                DeviceLog.debug((String)"Unity Ads init: creating webapp");
                object = this._configuration;
                object.setWebViewData(this._webViewData);
                try {
                    boolean bl = WebViewApp.create(object);
                    if (!bl) break block2;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    DeviceLog.exception((String)"Illegal Thread", (Exception)illegalThreadStateException);
                    return new InitializeStateError(InitializeStateCreateStateName, illegalThreadStateException, this._configuration);
                }
                return new InitializeStateComplete(this._configuration);
            }
            object = WebViewApp.getCurrentApp().getWebAppFailureMessage() != null ? WebViewApp.getCurrentApp().getWebAppFailureMessage() : "Unity Ads WebApp creation failed";
            DeviceLog.error((String)object);
            return new InitializeStateError(InitializeStateCreateStateName, new Exception((String)object), this._configuration);
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        public String getWebData() {
            return this._webViewData;
        }
    }

    public static class InitializeStateDownloadWebView
    extends InitializeState {
        private Configuration _configuration;
        private int _retries;
        private long _retryDelay;

        public InitializeStateDownloadWebView(Configuration configuration) {
            this._configuration = configuration;
            this._retries = 0;
            this._retryDelay = configuration.getRetryDelay();
        }

        @Override
        public InitializeState execute() {
            Object object;
            Object object2 = new StringBuilder();
            ((StringBuilder)object2).append("Unity Ads init: downloading webapp from ");
            ((StringBuilder)object2).append(this._configuration.getWebViewUrl());
            DeviceLog.info((String)((StringBuilder)object2).toString());
            object2 = null;
            Object var2_3 = null;
            try {
                object = new WebRequest(this._configuration.getWebViewUrl(), "GET", null);
            }
            catch (Exception exception) {
                DeviceLog.exception((String)"Malformed URL", (Exception)exception);
                return null;
            }
            try {
                object = object.makeRequest();
            }
            catch (Exception exception) {
                if (this._retries < this._configuration.getMaxRetries()) {
                    double d2 = this._retryDelay;
                    double d3 = this._configuration.getRetryScalingFactor();
                    Double.isNaN(d2);
                    this._retryDelay = (long)(d2 * d3);
                    ++this._retries;
                    object2 = new InitializeStateRetry(this, this._retryDelay);
                }
                return object2;
            }
            String string2 = this._configuration.getWebViewHash();
            object2 = var2_3;
            if (object != null) {
                object2 = var2_3;
                if (string2 != null) {
                    object2 = var2_3;
                    if (Utilities.Sha256((String)object).equals(string2)) {
                        object2 = new InitializeStateUpdateCache(this._configuration, (String)object);
                    }
                }
            }
            return object2;
        }
    }

    public static class InitializeStateError
    extends InitializeState {
        protected Configuration _configuration;
        Exception _exception;
        String _state;

        public InitializeStateError(String string2, Exception exception, Configuration configuration) {
            this._state = string2;
            this._exception = exception;
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            String[] stringArray = new StringBuilder();
            stringArray.append("Unity Ads init: halting init in ");
            stringArray.append(this._state);
            stringArray.append(": ");
            stringArray.append(this._exception.getMessage());
            DeviceLog.error((String)stringArray.toString());
            for (String string2 : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration object = this._configuration.getModuleConfiguration(string2);
                if (object == null) continue;
                object.initErrorState(this._configuration, this._state, this._exception.getMessage());
            }
            SDKMetrics.getInstance().sendEventWithTags("native_initialization_failed", (Map)new HashMap<String, String>(){
                {
                    this.put("stt", InitializeStateError.this._state.replaceAll(" ", "_"));
                }
            });
            return null;
        }
    }

    public static class InitializeStateForceReset
    extends InitializeStateReset {
        public InitializeStateForceReset() {
            super(new Configuration());
        }

        @Override
        public InitializeState execute() {
            SdkProperties.setInitializeState((SdkProperties.InitializationState)SdkProperties.InitializationState.NOT_INITIALIZED);
            super.execute();
            return null;
        }
    }

    public static class InitializeStateInitModules
    extends InitializeState {
        public static final String InitializeStateInitModuleStateName = "init modules";
        private Configuration _configuration;

        public InitializeStateInitModules(Configuration configuration) {
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            for (String string2 : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration object = this._configuration.getModuleConfiguration(string2);
                if (object == null || object.initModuleState(this._configuration)) continue;
                return new InitializeStateError(InitializeStateInitModuleStateName, new Exception("Unity Ads config server resolves to loopback address (due to ad blocker?)"), this._configuration);
            }
            return new InitializeStateConfig(this._configuration);
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }
    }

    public static class InitializeStateLoadCache
    extends InitializeState {
        private Configuration _configuration;

        public InitializeStateLoadCache(Configuration configuration) {
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            Object object;
            DeviceLog.debug((String)"Unity Ads init: check if webapp can be loaded from local cache");
            try {
                object = new File(SdkProperties.getLocalWebViewFile());
                object = Utilities.readFileBytes((File)object);
            }
            catch (Exception exception) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unity Ads init: webapp not found in local cache: ");
                stringBuilder.append(exception.getMessage());
                DeviceLog.debug((String)stringBuilder.toString());
                return new InitializeStateLoadWeb(this._configuration);
            }
            String string2 = Utilities.Sha256((byte[])object);
            if (string2 != null && string2.equals(this._configuration.getWebViewHash())) {
                try {
                    object = new String((byte[])object, "UTF-8");
                }
                catch (Exception exception) {
                    return new InitializeStateError("load cache", exception, this._configuration);
                }
                DeviceLog.info((String)"Unity Ads init: webapp loaded from local cache");
                return new InitializeStateCreate(this._configuration, (String)object);
            }
            return new InitializeStateLoadWeb(this._configuration);
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }
    }

    public static class InitializeStateLoadCacheConfigAndWebView
    extends InitializeState {
        private Configuration _configuration;
        private Configuration _localConfig;

        public InitializeStateLoadCacheConfigAndWebView(Configuration configuration, Configuration configuration2) {
            this._configuration = configuration;
            this._localConfig = configuration2;
        }

        @Override
        public InitializeState execute() {
            try {
                Object object = new File(SdkProperties.getLocalWebViewFile());
                object = InitializeThread.loadCachedFileToByteArray((File)object);
                object = new InitializeStateCheckForUpdatedWebView(this._configuration, (byte[])object, this._localConfig);
                return object;
            }
            catch (Exception exception) {
                InitializeStateLoadWeb initializeStateLoadWeb = new InitializeStateLoadWeb(this._configuration);
                return new InitializeStateCleanCache(this._configuration, initializeStateLoadWeb);
            }
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }
    }

    public static class InitializeStateLoadConfigFile
    extends InitializeState {
        private Configuration _configuration;

        public InitializeStateLoadConfigFile(Configuration configuration) {
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            DeviceLog.debug((String)"Unity Ads init: Loading Config File Parameters");
            File file = new File(SdkProperties.getLocalConfigurationFilepath());
            if (!file.exists()) {
                return new InitializeStateReset(this._configuration);
            }
            try {
                String string2 = new String(Utilities.readFileBytes((File)file));
                file = new JSONObject(string2);
                string2 = new Configuration((JSONObject)file);
                if (SdkProperties.getVersionName().equals(string2.getSdkVersion())) {
                    this._configuration = string2;
                    return this._configuration;
                }
            }
            catch (Exception exception) {
                DeviceLog.debug((String)"Unity Ads init: Using default configuration parameters");
            }
            finally {
                return new InitializeStateReset(this._configuration);
            }
        }
    }

    public static class InitializeStateLoadWeb
    extends InitializeState {
        private Configuration _configuration;
        private int _maxRetries;
        private int _retries;
        private long _retryDelay;
        private double _scalingFactor;

        public InitializeStateLoadWeb(Configuration configuration) {
            this._configuration = configuration;
            this._retries = 0;
            this._retryDelay = configuration.getRetryDelay();
            this._maxRetries = configuration.getMaxRetries();
            this._scalingFactor = configuration.getRetryScalingFactor();
        }

        @Override
        public InitializeState execute() {
            CharSequence charSequence = new StringBuilder();
            charSequence.append("Unity Ads init: loading webapp from ");
            charSequence.append(this._configuration.getWebViewUrl());
            DeviceLog.info((String)charSequence.toString());
            try {
                charSequence = new WebRequest(this._configuration.getWebViewUrl(), "GET", null);
            }
            catch (MalformedURLException malformedURLException) {
                DeviceLog.exception((String)"Malformed URL", (Exception)malformedURLException);
                return new InitializeStateError("malformed webview request", malformedURLException, this._configuration);
            }
            try {
                charSequence = charSequence.makeRequest();
            }
            catch (Exception exception) {
                int n2 = this._retries;
                if (n2 < this._maxRetries) {
                    double d2 = this._retryDelay;
                    double d3 = this._scalingFactor;
                    Double.isNaN(d2);
                    this._retryDelay = (long)(d2 * d3);
                    this._retries = n2 + 1;
                    return new InitializeStateRetry(this, this._retryDelay);
                }
                return new InitializeStateNetworkError("network webview request", exception, this, this._configuration);
            }
            String string2 = this._configuration.getWebViewHash();
            if (string2 != null && !Utilities.Sha256((String)charSequence).equals(string2)) {
                return new InitializeStateError("invalid hash", new Exception("Invalid webViewHash"), this._configuration);
            }
            if (string2 != null) {
                Utilities.writeFile((File)new File(SdkProperties.getLocalWebViewFile()), (String)charSequence);
            }
            return new InitializeStateCreate(this._configuration, (String)charSequence);
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }
    }

    public static class InitializeStateNetworkError
    extends InitializeStateError
    implements IConnectivityListener {
        private static long _lastConnectedEventTimeMs;
        private static int _receivedConnectedEvents;
        private ConditionVariable _conditionVariable;
        private int _connectedEventThreshold;
        private InitializeState _erroredState;
        private int _maximumConnectedEvents;
        private long _networkErrorTimeout;
        private String _state;

        public InitializeStateNetworkError(String string2, Exception exception, InitializeState initializeState, Configuration configuration) {
            super(string2, exception, configuration);
            this._state = string2;
            _receivedConnectedEvents = 0;
            _lastConnectedEventTimeMs = 0L;
            this._erroredState = initializeState;
            this._networkErrorTimeout = configuration.getNetworkErrorTimeout();
            this._maximumConnectedEvents = configuration.getMaximumConnectedEvents();
            this._connectedEventThreshold = configuration.getConnectedEventThreshold();
        }

        private boolean shouldHandleConnectedEvent() {
            return System.currentTimeMillis() - _lastConnectedEventTimeMs >= (long)this._connectedEventThreshold && _receivedConnectedEvents <= this._maximumConnectedEvents;
        }

        @Override
        public InitializeState execute() {
            DeviceLog.error((String)"Unity Ads init: network error, waiting for connection events");
            this._conditionVariable = new ConditionVariable();
            ConnectivityMonitor.addListener((IConnectivityListener)this);
            if (this._conditionVariable.block(this._networkErrorTimeout)) {
                ConnectivityMonitor.removeListener((IConnectivityListener)this);
                return this._erroredState;
            }
            ConnectivityMonitor.removeListener((IConnectivityListener)this);
            return new InitializeStateError(this._state, new Exception("No connected events within the timeout!"), this._configuration);
        }

        public void onConnected() {
            ++_receivedConnectedEvents;
            DeviceLog.debug((String)"Unity Ads init got connected event");
            if (this.shouldHandleConnectedEvent()) {
                this._conditionVariable.open();
            }
            if (_receivedConnectedEvents > this._maximumConnectedEvents) {
                ConnectivityMonitor.removeListener((IConnectivityListener)this);
            }
            _lastConnectedEventTimeMs = System.currentTimeMillis();
        }

        public void onDisconnected() {
            DeviceLog.debug((String)"Unity Ads init got disconnected event");
        }
    }

    public static class InitializeStateReset
    extends InitializeState {
        private Configuration _configuration;
        private int _resetWebAppTimeout;

        public InitializeStateReset(Configuration configuration) {
            this._configuration = configuration;
            this._resetWebAppTimeout = configuration.getResetWebappTimeout();
        }

        private void unregisterLifecycleCallbacks() {
            if (Lifecycle.getLifecycleListener() != null) {
                if (ClientProperties.getApplication() != null) {
                    ClientProperties.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)Lifecycle.getLifecycleListener());
                }
                Lifecycle.setLifecycleListener(null);
            }
        }

        @Override
        public InitializeState execute() {
            DeviceLog.debug((String)"Unity Ads init: starting init");
            ConditionVariable object2 = new ConditionVariable();
            String[] stringArray = WebViewApp.getCurrentApp();
            if (stringArray != null) {
                boolean bl;
                stringArray.resetWebViewAppInitialization();
                if (stringArray.getWebView() != null) {
                    Utilities.runOnUiThread((Runnable)new Runnable((WebViewApp)stringArray, object2){
                        final /* synthetic */ WebViewApp val$currentApp;
                        final /* synthetic */ ConditionVariable val$cv;
                        {
                            this.val$currentApp = webViewApp;
                            this.val$cv = conditionVariable;
                        }

                        @Override
                        public void run() {
                            this.val$currentApp.getWebView().destroy();
                            this.val$currentApp.setWebView(null);
                            this.val$cv.open();
                        }
                    });
                    bl = object2.block((long)this._resetWebAppTimeout);
                } else {
                    bl = true;
                }
                if (!bl) {
                    return new InitializeStateError("reset webapp", new Exception("Reset failed on opening ConditionVariable"), this._configuration);
                }
            }
            if (Build.VERSION.SDK_INT > 13) {
                this.unregisterLifecycleCallbacks();
            }
            SdkProperties.setCacheDirectory(null);
            if (SdkProperties.getCacheDirectory() == null) {
                return new InitializeStateError("reset webapp", new Exception("Cache directory is NULL"), this._configuration);
            }
            SdkProperties.setInitialized((boolean)false);
            for (String string2 : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration iModuleConfiguration = this._configuration.getModuleConfiguration(string2);
                if (iModuleConfiguration == null) continue;
                iModuleConfiguration.resetState(this._configuration);
            }
            return new InitializeStateInitModules(this._configuration);
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }
    }

    public static class InitializeStateRetry
    extends InitializeState {
        long _delay;
        InitializeState _state;

        public InitializeStateRetry(InitializeState initializeState, long l2) {
            this._state = initializeState;
            this._delay = l2;
        }

        @Override
        public InitializeState execute() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unity Ads init: retrying in ");
            stringBuilder.append(this._delay);
            stringBuilder.append(" milliseconds");
            DeviceLog.debug((String)stringBuilder.toString());
            try {
                Thread.sleep(this._delay);
            }
            catch (Exception exception) {
                DeviceLog.exception((String)"Init retry interrupted", (Exception)exception);
            }
            return this._state;
        }
    }

    public static class InitializeStateUpdateCache
    extends InitializeState {
        private Configuration _configuration;
        private String _webViewData;

        public InitializeStateUpdateCache(Configuration configuration, String string2) {
            this._configuration = configuration;
            this._webViewData = string2;
        }

        @Override
        public InitializeState execute() {
            if (this._configuration != null && this._webViewData != null) {
                try {
                    File file = new File(SdkProperties.getLocalWebViewFile());
                    Utilities.writeFile((File)file, (String)this._webViewData);
                    file = new File(SdkProperties.getLocalConfigurationFilepath());
                    Utilities.writeFile((File)file, (String)this._configuration.getJSONString());
                }
                catch (Exception exception) {
                    return new InitializeStateCleanCacheIgnoreError(this._configuration, null);
                }
            }
            return null;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }
    }
}

