/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.IInitializationListener;
import com.unity3d.services.core.configuration.IInitializationNotificationCenter;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InitializationNotificationCenter
implements IInitializationNotificationCenter {
    private static InitializationNotificationCenter instance;
    private HashMap<Integer, IInitializationListener> _sdkListeners = new HashMap();

    public static InitializationNotificationCenter getInstance() {
        if (instance == null) {
            instance = new InitializationNotificationCenter();
        }
        return instance;
    }

    private void removeListener(Integer n2) {
        this._sdkListeners.remove(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addListener(IInitializationListener iInitializationListener) {
        HashMap<Integer, IInitializationListener> hashMap = this._sdkListeners;
        synchronized (hashMap) {
            if (iInitializationListener != null) {
                HashMap<Integer, IInitializationListener> hashMap2 = this._sdkListeners;
                Integer n2 = new Integer(iInitializationListener.hashCode());
                hashMap2.put(n2, iInitializationListener);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeListener(IInitializationListener iInitializationListener) {
        HashMap<Integer, IInitializationListener> hashMap = this._sdkListeners;
        synchronized (hashMap) {
            if (iInitializationListener != null) {
                Integer n2 = new Integer(iInitializationListener.hashCode());
                this.removeListener(n2);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void triggerOnSdkInitializationFailed(String runnable2, final int n2) {
        HashMap<Integer, IInitializationListener> hashMap = this._sdkListeners;
        synchronized (hashMap) {
            Iterator iterator2 = new Iterator();
            ((StringBuilder)((Object)iterator2)).append("SDK Failed to Initialize due to ");
            ((StringBuilder)((Object)iterator2)).append((String)((Object)runnable2));
            final String string2 = ((StringBuilder)((Object)iterator2)).toString();
            DeviceLog.error((String)string2);
            ArrayList arrayList = new ArrayList();
            iterator2 = this._sdkListeners.entrySet().iterator();
            while (iterator2.hasNext()) {
                final Map.Entry entry = (Map.Entry)iterator2.next();
                if (entry.getValue() != null) {
                    runnable2 = new Runnable(){

                        @Override
                        public void run() {
                            ((IInitializationListener)entry.getValue()).onSdkInitializationFailed(string2, n2);
                        }
                    };
                    Utilities.runOnUiThread((Runnable)runnable2);
                    continue;
                }
                arrayList.add(entry.getKey());
            }
            iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                runnable2 = (Integer)iterator2.next();
                this._sdkListeners.remove(runnable2);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void triggerOnSdkInitialized() {
        HashMap<Integer, IInitializationListener> hashMap = this._sdkListeners;
        synchronized (hashMap) {
            Runnable runnable2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Object object = this._sdkListeners.entrySet().iterator();
            while (object.hasNext()) {
                final Map.Entry<Integer, IInitializationListener> entry = object.next();
                if (entry.getValue() != null) {
                    runnable2 = new Runnable(){

                        @Override
                        public void run() {
                            ((IInitializationListener)entry.getValue()).onSdkInitialized();
                        }
                    };
                    Utilities.runOnUiThread((Runnable)runnable2);
                    continue;
                }
                arrayList.add(entry.getKey());
            }
            runnable2 = arrayList.iterator();
            while (runnable2.hasNext()) {
                object = (Integer)runnable2.next();
                this._sdkListeners.remove(object);
            }
            return;
        }
    }
}

