/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.api;

import com.unity3d.services.core.configuration.InitializeThread;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;

public class Sdk {
    @WebViewExposed
    public static void downloadLatestWebView(WebViewCallback webViewCallback) {
        DeviceLog.debug((String)"Unity Ads init: WebView called download");
        webViewCallback.invoke(InitializeThread.downloadLatestWebView().getValue());
    }

    @WebViewExposed
    public static void getDebugMode(WebViewCallback webViewCallback) {
        webViewCallback.invoke(SdkProperties.getDebugMode());
    }

    @WebViewExposed
    public static void initComplete(WebViewCallback webViewCallback) {
        DeviceLog.debug((String)"Web Application initialized");
        SdkProperties.setInitialized((boolean)true);
        WebViewApp.getCurrentApp().setWebAppInitialized(true);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void initError(String string2, Integer n2, WebViewCallback webViewCallback) {
        WebViewApp.getCurrentApp().setWebAppFailureMessage(string2);
        WebViewApp.getCurrentApp().setWebAppFailureCode(n2);
        WebViewApp.getCurrentApp().setWebAppInitialized(false);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void loadComplete(WebViewCallback webViewCallback) {
        DeviceLog.debug((String)"Web Application loaded");
        Object object = WebViewApp.getCurrentApp();
        boolean bl = true;
        ((WebViewApp)object).setWebAppLoaded(true);
        String string2 = ClientProperties.getGameId();
        boolean bl2 = SdkProperties.isTestMode();
        String string3 = ClientProperties.getAppName();
        object = ClientProperties.getAppVersion();
        int n2 = SdkProperties.getVersionCode();
        String string4 = SdkProperties.getVersionName();
        boolean bl3 = ClientProperties.isAppDebuggable();
        String string5 = SdkProperties.getConfigUrl();
        String string6 = WebViewApp.getCurrentApp().getConfiguration().getWebViewUrl();
        String string7 = WebViewApp.getCurrentApp().getConfiguration().getWebViewHash();
        String string8 = WebViewApp.getCurrentApp().getConfiguration().getWebViewVersion();
        long l2 = SdkProperties.getInitializationTime();
        boolean bl4 = SdkProperties.isReinitialized();
        boolean bl5 = SdkProperties.isPerPlacementLoadEnabled();
        if (SdkProperties.getLatestConfiguration() == null) {
            bl = false;
        }
        webViewCallback.invoke(string2, bl2, string3, object, n2, string4, bl3, string5, string6, string7, string8, l2, bl4, bl5, bl, Device.getElapsedRealtime());
    }

    @WebViewExposed
    public static void logDebug(String string2, WebViewCallback webViewCallback) {
        DeviceLog.debug((String)string2);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void logError(String string2, WebViewCallback webViewCallback) {
        DeviceLog.error((String)string2);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void logInfo(String string2, WebViewCallback webViewCallback) {
        DeviceLog.info((String)string2);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void logWarning(String string2, WebViewCallback webViewCallback) {
        DeviceLog.warning((String)string2);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void reinitialize(WebViewCallback webViewCallback) {
        SdkProperties.setReinitialized((boolean)true);
        InitializeThread.initialize(WebViewApp.getCurrentApp().getConfiguration());
    }

    @WebViewExposed
    public static void setDebugMode(Boolean bl, WebViewCallback webViewCallback) {
        SdkProperties.setDebugMode((boolean)bl);
        webViewCallback.invoke(new Object[0]);
    }
}

