/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.banners;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.placement.Placement;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.IUnityBannerListener;
import com.unity3d.services.banners.UnityBannerSize;
import com.unity3d.services.banners.properties.BannerRefreshInfo;
import com.unity3d.services.banners.view.BannerPosition;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.misc.ViewUtilities;
import com.unity3d.services.core.properties.ClientProperties;
import java.util.concurrent.TimeUnit;

public final class UnityBanners {
    private static UnityBanners instance;
    private IUnityBannerListener _bannerListener;
    private BannerPosition _currentBannerPosition = BannerPosition.NONE;
    private BannerWrapper _currentBannerWrapper;

    private UnityBanners() {
    }

    private void _destroy() {
        BannerWrapper bannerWrapper = this._currentBannerWrapper;
        if (bannerWrapper != null) {
            bannerWrapper.destroy();
            this._currentBannerWrapper = null;
        }
    }

    private void _loadBanner(Activity object, String object2) {
        if (this._currentBannerWrapper == null) {
            object2 = new BannerAdRefreshView((Activity)object, (String)object2, new UnityBannerSize(320, 50));
            object = new BannerWrapper((Context)object, (BannerAdRefreshView)((Object)object2));
            ((BannerWrapper)((Object)object)).setBannerPosition(this._currentBannerPosition);
            this._currentBannerWrapper = object;
            ((BannerAdRefreshView)((Object)object2)).setListener((BannerView.IListener)new BannerView.Listener((BannerWrapper)((Object)object)){
                final /* synthetic */ BannerWrapper val$bannerWrapper;
                {
                    this.val$bannerWrapper = bannerWrapper;
                }

                public void onBannerClick(BannerView bannerView) {
                    if (_bannerListener != null) {
                        _bannerListener.onUnityBannerClick(bannerView.getPlacementId());
                    }
                }

                public void onBannerFailedToLoad(BannerView bannerView, BannerErrorInfo bannerErrorInfo) {
                    if (_bannerListener != null) {
                        IUnityBannerListener iUnityBannerListener = _bannerListener;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(bannerView.getPlacementId());
                        stringBuilder.append(" ");
                        stringBuilder.append(bannerErrorInfo.errorMessage);
                        iUnityBannerListener.onUnityBannerError(stringBuilder.toString());
                    }
                }

                public void onBannerLoaded(BannerView bannerView) {
                    if (_bannerListener != null) {
                        _bannerListener.onUnityBannerLoaded(bannerView.getPlacementId(), (View)this.val$bannerWrapper);
                    }
                }
            });
            ((BannerAdRefreshView)((Object)object2)).load();
        } else {
            UnityBanners.sendError("A Banner is already in use, please call destroy before loading another banner!");
        }
    }

    @Deprecated
    public static void destroy() {
        UnityBanners.getInstance()._destroy();
    }

    @Deprecated
    public static IUnityBannerListener getBannerListener() {
        return UnityBanners.getInstance()._bannerListener;
    }

    private static UnityBanners getInstance() {
        if (instance == null) {
            instance = new UnityBanners();
        }
        return instance;
    }

    @Deprecated
    public static void loadBanner(Activity activity) {
        UnityBanners.loadBanner(activity, Placement.getDefaultBannerPlacement());
    }

    @Deprecated
    public static void loadBanner(Activity object, String string2) {
        DeviceLog.entered();
        if (!UnityAds.isSupported()) {
            UnityBanners.sendError("Unity Ads is not supported on this device.");
        }
        if (!UnityAds.isInitialized()) {
            UnityBanners.sendError("UnityAds is not initialized.");
            return;
        }
        if (!UnityAds.isReady((String)string2)) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Banner placement ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" is not ready");
            UnityBanners.sendError(((StringBuilder)object).toString());
            return;
        }
        ClientProperties.setActivity((Activity)object);
        UnityBanners.getInstance()._loadBanner((Activity)object, string2);
    }

    private static void sendError(final String string2) {
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IUnityBannerListener iUnityBannerListener = UnityBanners.getBannerListener();
                if (iUnityBannerListener != null) {
                    iUnityBannerListener.onUnityBannerError(string2);
                }
            }
        });
    }

    @Deprecated
    public static void setBannerListener(IUnityBannerListener iUnityBannerListener) {
        UnityBanners.getInstance()._bannerListener = iUnityBannerListener;
    }

    @Deprecated
    public static void setBannerPosition(BannerPosition bannerPosition) {
        UnityBanners.getInstance()._currentBannerPosition = bannerPosition;
    }

    private class BannerAdRefreshView
    extends RelativeLayout {
        private BannerView bannerView;
        private boolean didLoad;
        private boolean didShow;
        private boolean didSubscribeToLifecycle;
        private LifecycleListener lifecycleListener;
        private String placementId;
        private Handler refreshHandler;
        private long refreshRate;
        private long refreshTime;
        private Runnable reloadRunnable;

        public BannerAdRefreshView(Activity activity, String string2, UnityBannerSize unityBannerSize) {
            super((Context)activity);
            this.didLoad = false;
            this.refreshRate = 30L;
            this.didShow = false;
            this.didSubscribeToLifecycle = false;
            this.placementId = string2;
            this.refreshHandler = new Handler();
            this.reloadRunnable = new Runnable(){

                @Override
                public void run() {
                    this.reload();
                }
            };
            this.setupLayoutParams();
            this.setBackgroundColor(0);
            this.bannerView = new BannerView(activity, string2, unityBannerSize);
            this.addView((View)this.bannerView);
        }

        private void reload() {
            this.bannerView.load();
            this.refreshTime = SystemClock.uptimeMillis() + TimeUnit.SECONDS.toMillis(this.refreshRate);
            this.refreshHandler.postAtTime(this.reloadRunnable, this.refreshTime);
        }

        private void setupLayoutParams() {
            this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        }

        private void startReloadTask() {
            long l2;
            long l3 = SystemClock.uptimeMillis();
            if (l3 < (l2 = this.refreshTime)) {
                this.refreshHandler.postAtTime(this.reloadRunnable, l2);
            } else {
                this.reload();
            }
        }

        private void stopReloadTask() {
            Runnable runnable2;
            Handler handler = this.refreshHandler;
            if (handler != null && (runnable2 = this.reloadRunnable) != null) {
                handler.removeCallbacks(runnable2);
            }
        }

        private void subscribeToLifecycle() {
            if (!this.didSubscribeToLifecycle && Build.VERSION.SDK_INT >= 14 && ClientProperties.getApplication() != null) {
                this.lifecycleListener = new LifecycleListener(){

                    @Override
                    public void onActivityDestroyed(Activity activity) {
                        this.stopReloadTask();
                    }

                    @Override
                    public void onActivityPaused(Activity activity) {
                        this.stopReloadTask();
                    }

                    @Override
                    public void onActivityResumed(Activity activity) {
                        this.startReloadTask();
                    }

                    @Override
                    public void onActivityStopped(Activity activity) {
                        this.stopReloadTask();
                    }
                };
                this.didSubscribeToLifecycle = true;
                ClientProperties.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.lifecycleListener);
            }
        }

        private void unsubscribeFromLifecycle() {
            if (this.didSubscribeToLifecycle && Build.VERSION.SDK_INT >= 14 && this.lifecycleListener != null && ClientProperties.getApplication() != null) {
                this.didSubscribeToLifecycle = false;
                ClientProperties.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.lifecycleListener);
            }
        }

        public void destroy() {
            this.stopReloadTask();
            this.bannerView.destroy();
            Utilities.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    this.removeAllViews();
                }
            });
            this.bannerView = null;
        }

        public BannerView.IListener getListener() {
            return this.bannerView.getListener();
        }

        public String getPlacementId() {
            return this.bannerView.getPlacementId();
        }

        public UnityBannerSize getSize() {
            return this.bannerView.getSize();
        }

        public void load() {
            if (!this.didLoad) {
                this.didLoad = true;
                Integer n2 = BannerRefreshInfo.getInstance().getRefreshRate(this.placementId);
                if (n2 != null) {
                    this.refreshRate = n2.longValue();
                }
                this.reload();
            }
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.subscribeToLifecycle();
            if (this.didShow) {
                this.startReloadTask();
            } else {
                this.didShow = true;
            }
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.stopReloadTask();
            this.unsubscribeFromLifecycle();
        }

        protected void onMeasure(int n2, int n3) {
            if (!true) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            super.onMeasure(n2, n3);
        }

        public void setListener(BannerView.IListener iListener) {
            this.bannerView.setListener(iListener);
        }

        private class LifecycleListener
        implements Application.ActivityLifecycleCallbacks {
            private LifecycleListener() {
            }

            public void onActivityCreated(Activity activity, Bundle bundle) {
            }

            public void onActivityDestroyed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }
        }
    }

    private class BannerWrapper
    extends FrameLayout {
        private BannerAdRefreshView _bannerAdRefreshView;
        private BannerPosition _bannerPosition;

        public BannerWrapper(Context context, BannerAdRefreshView bannerAdRefreshView) {
            super(context);
            this._bannerPosition = BannerPosition.NONE;
            this._bannerAdRefreshView = bannerAdRefreshView;
            this.addView((View)this._bannerAdRefreshView);
            this.setupLayoutConstraints();
            this.setBackgroundColor(0);
        }

        private void setupLayoutConstraints() {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
            layoutParams.gravity = this._bannerPosition.getGravity();
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }

        public void destroy() {
            Utilities.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    this.removeAllViews();
                    ViewUtilities.removeViewFromParent((View)this);
                }
            });
            BannerAdRefreshView bannerAdRefreshView = this._bannerAdRefreshView;
            if (bannerAdRefreshView != null) {
                bannerAdRefreshView.destroy();
                this._bannerAdRefreshView = null;
            }
        }

        protected void onMeasure(int n2, int n3) {
            if (!true) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            super.onMeasure(n2, n3);
        }

        public void setBannerPosition(BannerPosition bannerPosition) {
            this._bannerPosition = bannerPosition;
            this.setupLayoutConstraints();
        }
    }
}

