/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ar.view;

import android.content.Context;
import android.opengl.GLDebugHelper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GLSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback2 {
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    private static final boolean LOG_ATTACH_DETACH = false;
    private static final boolean LOG_EGL = false;
    private static final boolean LOG_PAUSE_RESUME = false;
    private static final boolean LOG_RENDERER = false;
    private static final boolean LOG_RENDERER_DRAW_FRAME = false;
    private static final boolean LOG_SURFACE = false;
    private static final boolean LOG_THREADS = false;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    private static final String TAG = "GLSurfaceView";
    private static final GLThreadManager sGLThreadManager = new GLThreadManager();
    private int mDebugFlags;
    private boolean mDetached;
    private EGLConfigChooser mEGLConfigChooser;
    private int mEGLContextClientVersion;
    private EGLContextFactory mEGLContextFactory;
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private GLThread mGLThread;
    private GLWrapper mGLWrapper;
    private boolean mPreserveEGLContextOnPause;
    private Renderer mRenderer;
    private final WeakReference<GLSurfaceView> mThisWeakRef = new WeakReference<GLSurfaceView>(this);

    public GLSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public GLSurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    static /* synthetic */ Renderer access$1000(GLSurfaceView gLSurfaceView) {
        return gLSurfaceView.mRenderer;
    }

    static /* synthetic */ boolean access$900(GLSurfaceView gLSurfaceView) {
        return gLSurfaceView.mPreserveEGLContextOnPause;
    }

    private void checkRenderThreadState() {
        if (this.mGLThread == null) {
            return;
        }
        throw new IllegalStateException("setRenderer has already been called for this instance.");
    }

    private void init() {
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getDebugFlags() {
        return this.mDebugFlags;
    }

    public boolean getPreserveEGLContextOnPause() {
        return this.mPreserveEGLContextOnPause;
    }

    public int getRenderMode() {
        return this.mGLThread.getRenderMode();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mDetached && this.mRenderer != null) {
            GLThread gLThread = this.mGLThread;
            int n2 = gLThread != null ? gLThread.getRenderMode() : 1;
            this.mGLThread = new GLThread(this.mThisWeakRef);
            if (n2 != 1) {
                this.mGLThread.setRenderMode(n2);
            }
            this.mGLThread.start();
        }
        this.mDetached = false;
    }

    protected void onDetachedFromWindow() {
        GLThread gLThread = this.mGLThread;
        if (gLThread != null) {
            gLThread.requestExitAndWait();
        }
        this.mDetached = true;
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int n2, int n3) {
        if (!true) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        super.onMeasure(n2, n3);
    }

    public void onPause() {
        this.mGLThread.onPause();
    }

    public void onResume() {
        this.mGLThread.onResume();
    }

    public void queueEvent(Runnable runnable2) {
        this.mGLThread.queueEvent(runnable2);
    }

    public void requestRender() {
        this.mGLThread.requestRender();
    }

    public void setDebugFlags(int n2) {
        this.mDebugFlags = n2;
    }

    public void setEGLConfigChooser(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.setEGLConfigChooser(new ComponentSizeChooser(n2, n3, n4, n5, n6, n7));
    }

    public void setEGLConfigChooser(EGLConfigChooser eGLConfigChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = eGLConfigChooser;
    }

    public void setEGLConfigChooser(boolean bl) {
        this.setEGLConfigChooser(new SimpleEGLConfigChooser(bl));
    }

    public void setEGLContextClientVersion(int n2) {
        this.checkRenderThreadState();
        this.mEGLContextClientVersion = n2;
    }

    public void setEGLContextFactory(EGLContextFactory eGLContextFactory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = eGLContextFactory;
    }

    public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory eGLWindowSurfaceFactory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = eGLWindowSurfaceFactory;
    }

    public void setGLWrapper(GLWrapper gLWrapper) {
        this.mGLWrapper = gLWrapper;
    }

    public void setPreserveEGLContextOnPause(boolean bl) {
        this.mPreserveEGLContextOnPause = bl;
    }

    public void setRenderMode(int n2) {
        this.mGLThread.setRenderMode(n2);
    }

    public void setRenderer(Renderer renderer) {
        this.checkRenderThreadState();
        if (this.mEGLConfigChooser == null) {
            this.mEGLConfigChooser = new SimpleEGLConfigChooser(true);
        }
        if (this.mEGLContextFactory == null) {
            this.mEGLContextFactory = new DefaultContextFactory();
        }
        if (this.mEGLWindowSurfaceFactory == null) {
            this.mEGLWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
        }
        this.mRenderer = renderer;
        this.mGLThread = new GLThread(this.mThisWeakRef);
        this.mGLThread.start();
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
        this.mGLThread.onWindowResize(n3, n4);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mGLThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mGLThread.surfaceDestroyed();
    }

    @Deprecated
    public void surfaceRedrawNeeded(SurfaceHolder surfaceHolder) {
    }

    public void surfaceRedrawNeededAsync(SurfaceHolder object, Runnable runnable2) {
        object = this.mGLThread;
        if (object != null) {
            ((GLThread)object).requestRenderAndNotify(runnable2);
        }
    }

    public void swapBuffers() {
        this.mGLThread.swapBuffers();
    }

    private abstract class BaseConfigChooser
    implements EGLConfigChooser {
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] nArray) {
            this.mConfigSpec = this.filterConfigSpec(nArray);
        }

        private int[] filterConfigSpec(int[] nArray) {
            if (GLSurfaceView.this.mEGLContextClientVersion != 2 && GLSurfaceView.this.mEGLContextClientVersion != 3) {
                return nArray;
            }
            int n2 = nArray.length;
            int[] nArray2 = new int[n2 + 2];
            int n3 = n2 - 1;
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            nArray2[n3] = 12352;
            nArray2[n2] = GLSurfaceView.this.mEGLContextClientVersion == 2 ? 4 : 64;
            nArray2[n2 + 1] = 12344;
            return nArray2;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            if (eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, null, 0, nArray)) {
                int n2 = nArray[0];
                if (n2 > 0) {
                    EGLConfig[] eGLConfigArray = new EGLConfig[n2];
                    if (eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, eGLConfigArray, n2, nArray)) {
                        if ((eGL10 = this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray)) != null) {
                            return eGL10;
                        }
                        throw new IllegalArgumentException("No config chosen");
                    }
                    throw new IllegalArgumentException("eglChooseConfig#2 failed");
                }
                throw new IllegalArgumentException("No configs match configSpec");
            }
            throw new IllegalArgumentException("eglChooseConfig failed");
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser {
        protected int mAlphaSize;
        protected int mBlueSize;
        protected int mDepthSize;
        protected int mGreenSize;
        protected int mRedSize;
        protected int mStencilSize;
        private int[] mValue;

        public ComponentSizeChooser(int n2, int n3, int n4, int n5, int n6, int n7) {
            super(new int[]{12324, n2, 12323, n3, 12322, n4, 12321, n5, 12325, n6, 12326, n7, 12344});
            this.mValue = new int[1];
            this.mRedSize = n2;
            this.mGreenSize = n3;
            this.mBlueSize = n4;
            this.mAlphaSize = n5;
            this.mDepthSize = n6;
            this.mStencilSize = n7;
        }

        private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n2, int n3) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n2, this.mValue)) {
                return this.mValue[0];
            }
            return n3;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            for (EGLConfig eGLConfig : eGLConfigArray) {
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                if (n2 < this.mDepthSize || n3 < this.mStencilSize) continue;
                n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
                n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                if (n2 != this.mRedSize || n3 != this.mGreenSize || n4 != this.mBlueSize || n5 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }
    }

    private class DefaultContextFactory
    implements EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private DefaultContextFactory() {
        }

        @Override
        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, GLSurfaceView.this.mEGLContextClientVersion, 12344};
            EGLContext eGLContext = EGL10.EGL_NO_CONTEXT;
            if (GLSurfaceView.this.mEGLContextClientVersion == 0) {
                nArray = null;
            }
            return eGL10.eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray);
        }

        @Override
        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            if (!eGL10.eglDestroyContext(eGLDisplay, eGLContext)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("display:");
                stringBuilder.append(eGLDisplay);
                stringBuilder.append(" context: ");
                stringBuilder.append(eGLContext);
                Log.e((String)"DefaultContextFactory", (String)stringBuilder.toString());
                EglHelper.throwEglException("eglDestroyContex", eGL10.eglGetError());
            }
        }
    }

    private static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object) {
            Object var5_6 = null;
            try {
                eGL10 = eGL10.eglCreateWindowSurface(eGLDisplay, eGLConfig, object, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)GLSurfaceView.TAG, (String)"eglCreateWindowSurface", (Throwable)illegalArgumentException);
                eGL10 = var5_6;
            }
            return eGL10;
        }

        @Override
        public void destroySurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
            eGL10.eglDestroySurface(eGLDisplay, eGLSurface);
        }
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    private static class EglHelper {
        EGL10 mEgl;
        EGLConfig mEglConfig;
        EGLContext mEglContext;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        private WeakReference<GLSurfaceView> mGLSurfaceViewWeakRef;

        public EglHelper(WeakReference<GLSurfaceView> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        private void destroySurfaceImp() {
            Object object = this.mEglSurface;
            if (object != null && object != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                object = (GLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
                if (object != null) {
                    ((GLSurfaceView)((Object)object)).mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                }
                this.mEglSurface = null;
            }
        }

        public static String formatEglError(String string2, int n2) {
            return "";
        }

        public static void logEglErrorAsWarning(String string2, String string3, int n2) {
            Log.w((String)string2, (String)EglHelper.formatEglError(string3, n2));
        }

        private void throwEglException(String string2) {
            EglHelper.throwEglException(string2, this.mEgl.eglGetError());
        }

        public static void throwEglException(String string2, int n2) {
            throw new RuntimeException(EglHelper.formatEglError(string2, n2));
        }

        GL createGL() {
            GL gL = this.mEglContext.getGL();
            GLSurfaceView gLSurfaceView = (GLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
            Object object = gL;
            if (gLSurfaceView != null) {
                GL gL2 = gL;
                if (gLSurfaceView.mGLWrapper != null) {
                    gL2 = gLSurfaceView.mGLWrapper.wrap(gL);
                }
                object = gL2;
                if ((gLSurfaceView.mDebugFlags & 3) != 0) {
                    int n2 = 0;
                    object = null;
                    if ((gLSurfaceView.mDebugFlags & 1) != 0) {
                        n2 = 1;
                    }
                    if ((gLSurfaceView.mDebugFlags & 2) != 0) {
                        object = new LogWriter();
                    }
                    object = GLDebugHelper.wrap((GL)gL2, (int)n2, (Writer)object);
                }
            }
            return object;
        }

        public boolean createSurface() {
            if (this.mEgl != null) {
                if (this.mEglDisplay != null) {
                    if (this.mEglConfig != null) {
                        this.destroySurfaceImp();
                        GLSurfaceView gLSurfaceView = (GLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
                        this.mEglSurface = gLSurfaceView != null ? gLSurfaceView.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, gLSurfaceView.getHolder()) : null;
                        gLSurfaceView = this.mEglSurface;
                        if (gLSurfaceView != null && gLSurfaceView != EGL10.EGL_NO_SURFACE) {
                            EGL10 eGL10 = this.mEgl;
                            gLSurfaceView = this.mEglDisplay;
                            EGLSurface eGLSurface = this.mEglSurface;
                            if (!eGL10.eglMakeCurrent((EGLDisplay)gLSurfaceView, eGLSurface, eGLSurface, this.mEglContext)) {
                                EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.mEgl.eglGetError());
                                return false;
                            }
                            return true;
                        }
                        if (this.mEgl.eglGetError() == 12299) {
                            Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                        }
                        return false;
                    }
                    throw new RuntimeException("mEglConfig not initialized");
                }
                throw new RuntimeException("eglDisplay not initialized");
            }
            throw new RuntimeException("egl not initialized");
        }

        public void destroySurface() {
            this.destroySurfaceImp();
        }

        public void finish() {
            Object object;
            if (this.mEglContext != null) {
                object = (GLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
                if (object != null) {
                    ((GLSurfaceView)((Object)object)).mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                }
                this.mEglContext = null;
            }
            if ((object = this.mEglDisplay) != null) {
                this.mEgl.eglTerminate(object);
                this.mEglDisplay = null;
            }
        }

        public void start() {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mEglDisplay != EGL10.EGL_NO_DISPLAY) {
                Object object = new int[2];
                if (this.mEgl.eglInitialize(this.mEglDisplay, object)) {
                    object = (Object)((GLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get()));
                    if (object == null) {
                        this.mEglConfig = null;
                        this.mEglContext = null;
                    } else {
                        this.mEglConfig = ((GLSurfaceView)((Object)object)).mEGLConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
                        this.mEglContext = ((GLSurfaceView)((Object)object)).mEGLContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
                    }
                    object = this.mEglContext;
                    if (object == null || object == EGL10.EGL_NO_CONTEXT) {
                        this.mEglContext = null;
                        this.throwEglException("createContext");
                    }
                    this.mEglSurface = null;
                    return;
                }
                throw new RuntimeException("eglInitialize failed");
            }
            throw new RuntimeException("eglGetDisplay failed");
        }

        public int swap() {
            if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }
    }

    static class GLThread
    extends Thread {
        private boolean mDidDraw;
        private EglHelper mEglHelper;
        private ArrayList<Runnable> mEventQueue = new ArrayList();
        private boolean mExited;
        private Runnable mFinishDrawingRunnable = null;
        private boolean mFinishedCreatingEglSurface;
        private WeakReference<GLSurfaceView> mGLSurfaceViewWeakRef;
        private boolean mHasSurface;
        private boolean mHaveEglContext;
        private boolean mHaveEglSurface;
        private int mHeight = 0;
        private boolean mPaused;
        private boolean mRenderComplete;
        private int mRenderMode = 1;
        private boolean mRequestPaused;
        private boolean mRequestRender = true;
        private boolean mRequestSwap;
        private boolean mShouldExit;
        private boolean mShouldReleaseEglContext;
        private boolean mSizeChanged = true;
        private boolean mSurfaceIsBad;
        private boolean mWaitingForSurface;
        private boolean mWantRenderNotification = false;
        private int mWidth = 0;

        GLThread(WeakReference<GLSurfaceView> weakReference) {
            this.mGLSurfaceViewWeakRef = weakReference;
        }

        static /* synthetic */ boolean access$1102(GLThread gLThread, boolean bl) {
            gLThread.mExited = bl;
            return bl;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void guardedRun() throws InterruptedException {
            this.mEglHelper = new EglHelper(this.mGLSurfaceViewWeakRef);
            var1_1 = 0;
            this.mHaveEglContext = false;
            this.mHaveEglSurface = false;
            this.mWantRenderNotification = false;
            var2_2 = 0;
            var3_3 = 0;
            var4_4 = 0;
            var5_5 = null;
            var6_7 = 0;
            var7_8 = null;
            var8_9 = false;
            var9_10 = 0;
            var10_11 = 0;
            var11_12 = 0;
            var12_13 /* !! */  = null;
            var13_17 = 0;
            var14_18 = 0;
            var15_19 = 0;
            block28: while (true) {
                var16_20 = GLSurfaceView.access$800();
                // MONITORENTER : var16_20
                var17_21 = var4_4;
                var18_22 = var2_2;
                while (true) {
                    block66: {
                        block67: {
                            block61: {
                                block62: {
                                    block63: {
                                        block65: {
                                            block60: {
                                                block64: {
                                                    if (this.mShouldExit) {
                                                        // MONITOREXIT : var16_20
                                                        var5_5 = GLSurfaceView.access$800();
                                                        // MONITORENTER : var5_5
                                                        this.stopEglSurfaceLocked();
                                                        this.stopEglContextLocked();
                                                        // MONITOREXIT : var5_5
                                                        return;
                                                    }
                                                    if (this.mEventQueue.isEmpty()) break block64;
                                                    var19_23 /* !! */  = this.mEventQueue.remove(var1_1);
                                                    var2_2 = var18_22;
                                                    var4_4 = var3_3;
                                                    var18_22 = var17_21;
                                                    var20_24 = var8_9;
                                                    var21_25 = var10_11;
                                                    var22_26 = var11_12;
                                                    var17_21 = var13_17;
                                                    break block65;
                                                }
                                                if (this.mPaused != this.mRequestPaused) {
                                                    var23_27 = this.mRequestPaused;
                                                    this.mPaused = this.mRequestPaused;
                                                    GLSurfaceView.access$800().notifyAll();
                                                } else {
                                                    var23_27 = false;
                                                }
                                                var2_2 = var17_21;
                                                if (this.mShouldReleaseEglContext) {
                                                    this.stopEglSurfaceLocked();
                                                    this.stopEglContextLocked();
                                                    this.mShouldReleaseEglContext = var1_1;
                                                    var2_2 = 1;
                                                }
                                                var24_28 = var18_22;
                                                if (var18_22 != 0) {
                                                    this.stopEglSurfaceLocked();
                                                    this.stopEglContextLocked();
                                                    var24_28 = 0;
                                                }
                                                if (var23_27 && this.mHaveEglSurface) {
                                                    this.stopEglSurfaceLocked();
                                                }
                                                if (var23_27 && this.mHaveEglContext && !(var23_27 = (var19_23 /* !! */  = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get()) == null ? false : GLSurfaceView.access$900((GLSurfaceView)var19_23 /* !! */ ))) {
                                                    this.stopEglContextLocked();
                                                }
                                                if (!this.mHasSurface && !this.mWaitingForSurface) {
                                                    if (this.mHaveEglSurface) {
                                                        this.stopEglSurfaceLocked();
                                                    }
                                                    this.mWaitingForSurface = true;
                                                    this.mSurfaceIsBad = var1_1;
                                                    GLSurfaceView.access$800().notifyAll();
                                                }
                                                if (this.mHasSurface && this.mWaitingForSurface) {
                                                    this.mWaitingForSurface = var1_1;
                                                    GLSurfaceView.access$800().notifyAll();
                                                }
                                                var4_4 = var3_3;
                                                if (var3_3 != 0) {
                                                    this.mWantRenderNotification = var1_1;
                                                    this.mRenderComplete = true;
                                                    GLSurfaceView.access$800().notifyAll();
                                                    var4_4 = 0;
                                                }
                                                if (this.mFinishDrawingRunnable != null) {
                                                    var5_5 = this.mFinishDrawingRunnable;
                                                    this.mFinishDrawingRunnable = null;
                                                }
                                                if (!this.readyToDraw()) break block66;
                                                var23_27 = this.mHaveEglContext;
                                                var3_3 = var2_2;
                                                var17_21 = var13_17;
                                                if (!var23_27) {
                                                    if (var2_2 != 0) {
                                                        var3_3 = 0;
                                                        var17_21 = var13_17;
                                                    } else {
                                                        this.mEglHelper.start();
                                                        this.mHaveEglContext = true;
                                                        GLSurfaceView.access$800().notifyAll();
                                                        var17_21 = 1;
                                                        var3_3 = var2_2;
                                                    }
                                                    break block60;
                                                    catch (RuntimeException var5_6) {
                                                        GLSurfaceView.access$800().releaseEglContextLocked(this);
                                                        throw var5_6;
                                                    }
                                                }
                                            }
                                            var18_22 = var6_7;
                                            var2_2 = var14_18;
                                            var13_17 = var15_19;
                                            if (this.mHaveEglContext) {
                                                var18_22 = var6_7;
                                                var2_2 = var14_18;
                                                var13_17 = var15_19;
                                                if (!this.mHaveEglSurface) {
                                                    this.mHaveEglSurface = true;
                                                    var18_22 = 1;
                                                    var2_2 = 1;
                                                    var13_17 = 1;
                                                }
                                            }
                                            if (!this.mHaveEglSurface) break block67;
                                            var6_7 = var18_22;
                                            var14_18 = var2_2;
                                            if (this.mSizeChanged) {
                                                var10_11 = this.mWidth;
                                                var11_12 = this.mHeight;
                                                this.mWantRenderNotification = true;
                                                this.mSizeChanged = var1_1;
                                                var6_7 = 1;
                                                var14_18 = 1;
                                            }
                                            this.mRequestRender = var1_1;
                                            if (this.mRequestSwap) {
                                                this.mRequestSwap = var1_1;
                                                var9_10 = 1;
                                            }
                                            GLSurfaceView.access$800().notifyAll();
                                            if (this.mWantRenderNotification) {
                                                var20_24 = true;
                                                var2_2 = var24_28;
                                                var18_22 = var3_3;
                                                var21_25 = var10_11;
                                                var22_26 = var11_12;
                                                var19_23 /* !! */  = var12_13 /* !! */ ;
                                                var15_19 = var13_17;
                                            } else {
                                                var15_19 = var13_17;
                                                var19_23 /* !! */  = var12_13 /* !! */ ;
                                                var22_26 = var11_12;
                                                var21_25 = var10_11;
                                                var20_24 = var8_9;
                                                var18_22 = var3_3;
                                                var2_2 = var24_28;
                                            }
                                        }
                                        // MONITOREXIT : var16_20
                                        if (var19_23 /* !! */  == null) ** GOTO lbl161
                                        var19_23 /* !! */ .run();
                                        var12_13 /* !! */  = null;
                                        var3_3 = var4_4;
                                        var4_4 = var18_22;
                                        var8_9 = var20_24;
                                        var10_11 = var21_25;
                                        var11_12 = var22_26;
                                        var13_17 = var17_21;
                                        continue block28;
lbl161:
                                        // 1 sources

                                        var24_28 = var14_18;
                                        if (var14_18 == 0) ** GOTO lbl-1000
                                        if (!this.mEglHelper.createSurface()) ** GOTO lbl-1000
                                        var12_13 /* !! */  = GLSurfaceView.access$800();
                                        // MONITORENTER : var12_13 /* !! */ 
                                        this.mFinishedCreatingEglSurface = true;
                                        GLSurfaceView.access$800().notifyAll();
                                        var24_28 = 0;
                                        ** GOTO lbl-1000
lbl-1000:
                                        // 1 sources

                                        {
                                            var12_13 /* !! */  = GLSurfaceView.access$800();
                                            // MONITORENTER : var12_13 /* !! */ 
                                        }
                                        this.mFinishedCreatingEglSurface = true;
                                        this.mSurfaceIsBad = true;
                                        GLSurfaceView.access$800().notifyAll();
                                        // MONITOREXIT : var12_13 /* !! */ 
                                        var3_3 = var4_4;
                                        var4_4 = var18_22;
                                        var8_9 = var20_24;
                                        var10_11 = var21_25;
                                        var11_12 = var22_26;
                                        var12_13 /* !! */  = var19_23 /* !! */ ;
                                        var13_17 = var17_21;
                                        continue block28;
lbl-1000:
                                        // 2 sources

                                        {
                                            if (var9_10 == 0 || !this.mDidDraw) ** GOTO lbl212
                                            this.mDidDraw = var1_1;
                                            var14_18 = this.mEglHelper.swap();
                                            var9_10 = var2_2;
                                            if (var14_18 == 12288) ** GOTO lbl200
                                            if (var14_18 == 12302) ** GOTO lbl-1000
                                            EglHelper.logEglErrorAsWarning("GLThread", "eglSwapBuffers", var14_18);
                                            var12_13 /* !! */  = GLSurfaceView.access$800();
                                            // MONITORENTER : var12_13 /* !! */ 
                                        }
                                        this.mSurfaceIsBad = true;
                                        GLSurfaceView.access$800().notifyAll();
                                        // MONITOREXIT : var12_13 /* !! */ 
                                        var9_10 = var2_2;
                                        ** GOTO lbl200
lbl-1000:
                                        // 1 sources

                                        {
                                            var9_10 = 1;
lbl200:
                                            // 3 sources

                                            var14_18 = 0;
                                            var2_2 = var9_10;
                                            var3_3 = var4_4;
                                            var4_4 = var18_22;
                                            var8_9 = var20_24;
                                            var9_10 = var14_18;
                                            var10_11 = var21_25;
                                            var11_12 = var22_26;
                                            var12_13 /* !! */  = var19_23 /* !! */ ;
                                            var13_17 = var17_21;
                                            var14_18 = var24_28;
                                            continue block28;
lbl212:
                                            // 1 sources

                                            var25_29 = var7_8;
                                            var26_30 = var15_19;
                                            if (var15_19 != 0) {
                                                var25_29 = (GL10)this.mEglHelper.createGL();
                                                var26_30 = 0;
                                            }
                                            var27_31 = var17_21;
                                            if (var17_21 != 0) {
                                                var12_13 /* !! */  = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                                                if (var12_13 /* !! */  != null) {
                                                    GLSurfaceView.access$1000((GLSurfaceView)var12_13 /* !! */ ).onSurfaceCreated(var25_29, this.mEglHelper.mEglConfig);
                                                }
                                                var27_31 = 0;
                                            }
                                            var17_21 = var6_7;
                                            if (var6_7 != 0) {
                                                var12_13 /* !! */  = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                                                if (var12_13 /* !! */  != null) {
                                                    GLSurfaceView.access$1000((GLSurfaceView)var12_13 /* !! */ ).onSurfaceChanged(var25_29, var21_25, var22_26);
                                                }
                                                var17_21 = 0;
                                            }
                                            var12_13 /* !! */  = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                                            var16_20 = var5_5;
                                            if (var12_13 /* !! */  != null) {
                                                GLSurfaceView.access$1000((GLSurfaceView)var12_13 /* !! */ ).onDrawFrame(var25_29);
                                                this.mDidDraw = true;
                                                var16_20 = var5_5;
                                                if (var5_5 != null) {
                                                    var5_5.run();
                                                    var16_20 = null;
                                                }
                                            }
                                            var28_32 = var2_2;
                                            var29_33 = var9_10;
                                            if (this.mRenderMode != 1) break block61;
                                            var9_10 = this.mEglHelper.swap();
                                            if (var9_10 == 12288) break block62;
                                            if (var9_10 == 12302) break block63;
                                            EglHelper.logEglErrorAsWarning("GLThread", "eglSwapBuffers", var9_10);
                                            var5_5 = GLSurfaceView.access$800();
                                            // MONITORENTER : var5_5
                                        }
                                        this.mSurfaceIsBad = true;
                                        GLSurfaceView.access$800().notifyAll();
                                        // MONITOREXIT : var5_5
                                        break block62;
                                    }
                                    var2_2 = 1;
                                }
                                var29_33 = 0;
                                var28_32 = var2_2;
                            }
                            var1_1 = var30_34 = 0;
                            var2_2 = var28_32;
                            var3_3 = var4_4;
                            var4_4 = var18_22;
                            var5_5 = var16_20;
                            var6_7 = var17_21;
                            var7_8 = var25_29;
                            var8_9 = var20_24;
                            var9_10 = var29_33;
                            var10_11 = var21_25;
                            var11_12 = var22_26;
                            var12_13 /* !! */  = var19_23 /* !! */ ;
                            var13_17 = var27_31;
                            var14_18 = var24_28;
                            var15_19 = var26_30;
                            if (!var20_24) continue block28;
                            var3_3 = 1;
                            var8_9 = false;
                            var1_1 = var30_34;
                            var2_2 = var28_32;
                            var4_4 = var18_22;
                            var5_5 = var16_20;
                            var6_7 = var17_21;
                            var7_8 = var25_29;
                            var9_10 = var29_33;
                            var10_11 = var21_25;
                            var11_12 = var22_26;
                            var12_13 /* !! */  = var19_23 /* !! */ ;
                            var13_17 = var27_31;
                            var14_18 = var24_28;
                            var15_19 = var26_30;
                            continue block28;
                        }
                        var1_1 = var2_2;
                        var26_30 = var13_17;
                        ** GOTO lbl-1000
                    }
                    var3_3 = var2_2;
                    var18_22 = var6_7;
                    var17_21 = var13_17;
                    var1_1 = var14_18;
                    var26_30 = var15_19;
                    if (var5_5 != null) {
                        Log.w((String)"GLSurfaceView", (String)"Warning, !readyToDraw() but waiting for draw finished! Early reporting draw finished.");
                        var5_5.run();
                        var5_5 = null;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var15_19 = var26_30;
                        var14_18 = var1_1;
                        var13_17 = var17_21;
                        var6_7 = var18_22;
                        var2_2 = var3_3;
                    }
                    GLSurfaceView.access$800().wait();
                    var1_1 = 0;
                    var18_22 = var24_28;
                    var3_3 = var4_4;
                    var17_21 = var2_2;
                }
                break;
            }
            catch (Throwable var12_14) {
                var5_5 = GLSurfaceView.access$800();
                // MONITORENTER : var5_5
                this.stopEglSurfaceLocked();
                this.stopEglContextLocked();
                // MONITOREXIT : var5_5
                {
                    catch (Throwable var12_15) {}
                    {
                        // MONITOREXIT : var5_5
                        throw var12_15;
                    }
                }
                throw var12_14;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean readyToDraw() {
            boolean bl = this.mPaused;
            boolean bl2 = true;
            if (bl) return false;
            if (!this.mHasSurface) return false;
            if (this.mSurfaceIsBad) return false;
            if (this.mWidth <= 0) return false;
            if (this.mHeight <= 0) return false;
            bl = bl2;
            if (this.mRequestRender) return bl;
            if (this.mRenderMode != 1) return false;
            return bl2;
        }

        private void stopEglContextLocked() {
            if (this.mHaveEglContext) {
                this.mEglHelper.finish();
                this.mHaveEglContext = false;
                sGLThreadManager.releaseEglContextLocked(this);
            }
        }

        private void stopEglSurfaceLocked() {
            if (this.mHaveEglSurface) {
                this.mHaveEglSurface = false;
                this.mEglHelper.destroySurface();
            }
        }

        public boolean ableToDraw() {
            boolean bl = this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRenderMode;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onPause() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    boolean bl = this.mPaused;
                    if (bl) return;
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onResume() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = false;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    if (!this.mPaused) return;
                    boolean bl = this.mRenderComplete;
                    if (bl) return;
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onWindowResize(int n2, int n3) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mWidth = n2;
                this.mHeight = n3;
                this.mSizeChanged = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                if (Thread.currentThread() == this) {
                    return;
                }
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    if (this.mPaused) return;
                    if (this.mRenderComplete) return;
                    boolean bl = this.ableToDraw();
                    if (!bl) return;
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void queueEvent(Runnable runnable2) {
            if (runnable2 != null) {
                GLThreadManager gLThreadManager = sGLThreadManager;
                synchronized (gLThreadManager) {
                    this.mEventQueue.add(runnable2);
                    sGLThreadManager.notifyAll();
                    return;
                }
            }
            throw new IllegalArgumentException("r must not be null");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                boolean bl;
                this.mShouldExit = true;
                sGLThreadManager.notifyAll();
                while (!(bl = this.mExited)) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        public void requestReleaseEglContextLocked() {
            this.mShouldReleaseEglContext = true;
            sGLThreadManager.notifyAll();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void requestRenderAndNotify(Runnable runnable2) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                if (Thread.currentThread() == this) {
                    return;
                }
                this.mWantRenderNotification = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                this.mFinishDrawingRunnable = runnable2;
                sGLThreadManager.notifyAll();
                return;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = new StringBuilder();
            var1_1.append("GLThread ");
            var1_1.append(this.getId());
            this.setName(var1_1.toString());
            try {
                this.guardedRun();
lbl9:
                // 2 sources

                while (true) {
                    GLSurfaceView.access$800().threadExiting(this);
                    break;
                }
            }
            catch (Throwable var1_2) {
                GLSurfaceView.access$800().threadExiting(this);
                throw var1_2;
            }
            return;
            catch (InterruptedException var1_3) {
                ** continue;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setRenderMode(int n2) {
            if (n2 >= 0 && n2 <= 1) {
                GLThreadManager gLThreadManager = sGLThreadManager;
                synchronized (gLThreadManager) {
                    this.mRenderMode = n2;
                    sGLThreadManager.notifyAll();
                    return;
                }
            }
            throw new IllegalArgumentException("renderMode");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = true;
                this.mFinishedCreatingEglSurface = false;
                sGLThreadManager.notifyAll();
                while (this.mWaitingForSurface) {
                    if (this.mFinishedCreatingEglSurface) return;
                    boolean bl = this.mExited;
                    if (bl) return;
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = false;
                sGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface) {
                    boolean bl = this.mExited;
                    if (bl) return;
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void swapBuffers() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestSwap = true;
                sGLThreadManager.notifyAll();
                return;
            }
        }
    }

    private static class GLThreadManager {
        private static String TAG = "GLThreadManager";

        private GLThreadManager() {
        }

        public void releaseEglContextLocked(GLThread gLThread) {
            this.notifyAll();
        }

        public void threadExiting(GLThread gLThread) {
            synchronized (this) {
                GLThread.access$1102(gLThread, true);
                this.notifyAll();
                return;
            }
        }
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }

    static class LogWriter
    extends Writer {
        private StringBuilder mBuilder = new StringBuilder();

        LogWriter() {
        }

        private void flushBuilder() {
            if (this.mBuilder.length() > 0) {
                Log.v((String)GLSurfaceView.TAG, (String)this.mBuilder.toString());
                StringBuilder stringBuilder = this.mBuilder;
                stringBuilder.delete(0, stringBuilder.length());
            }
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        @Override
        public void write(char[] cArray, int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = cArray[n2 + i2];
                if (c2 == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.mBuilder.append(c2);
            }
        }
    }

    public static interface Renderer {
        public void onDrawFrame(GL10 var1);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onSurfaceCreated(GL10 var1, EGLConfig var2);
    }

    private class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser(boolean bl) {
            int n2 = bl ? 16 : 0;
            super(8, 8, 8, 0, n2, 0);
        }
    }
}

