/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.operation.load;

import android.text.TextUtils;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.AdModule;
import com.unity3d.services.ads.operation.load.ILoadModule;
import com.unity3d.services.ads.operation.load.ILoadOperation;
import com.unity3d.services.ads.operation.load.LoadModuleDecoratorInitializationBuffer;
import com.unity3d.services.ads.operation.load.LoadModuleDecoratorTimeout;
import com.unity3d.services.ads.operation.load.LoadOperation;
import com.unity3d.services.ads.operation.load.LoadOperationState;
import com.unity3d.services.core.configuration.IInitializationNotificationCenter;
import com.unity3d.services.core.configuration.InitializationNotificationCenter;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.request.ISDKMetricSender;
import com.unity3d.services.core.request.SDKMetricEvents;
import com.unity3d.services.core.request.SDKMetricSender;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import com.unity3d.services.core.webview.bridge.IWebViewSharedObject;
import com.unity3d.services.core.webview.bridge.invocation.IWebViewBridgeInvocation;
import com.unity3d.services.core.webview.bridge.invocation.IWebViewBridgeInvocationCallback;
import com.unity3d.services.core.webview.bridge.invocation.WebViewBridgeInvocation;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class LoadModule
extends AdModule<ILoadOperation, LoadOperationState>
implements ILoadModule {
    private static ILoadModule _instance;
    private static String errorMsgFailedToCreateLoadRequest = "[UnityAds] Failed to create load request";
    private static String errorMsgInternalCommunicationFailure = "[UnityAds] Internal communication failure";
    private static String errorMsgInternalCommunicationTimeout = "[UnityAds] Internal communication timeout";
    private static String errorMsgPlacementIdNull = "[UnityAds] Placement ID cannot be null";

    public LoadModule(ISDKMetricSender iSDKMetricSender) {
        super(iSDKMetricSender);
    }

    public static ILoadModule getInstance() {
        if (_instance == null) {
            _instance = new LoadModuleDecoratorTimeout((ILoadModule)new LoadModuleDecoratorInitializationBuffer((ILoadModule)new LoadModule((ISDKMetricSender)new SDKMetricSender()), (IInitializationNotificationCenter)InitializationNotificationCenter.getInstance()));
        }
        return _instance;
    }

    private void sendOnUnityAdsFailedToLoad(final LoadOperationState loadOperationState, final UnityAds.UnityAdsLoadError unityAdsLoadError, final String string2) {
        if (loadOperationState != null && loadOperationState.listener != null) {
            Utilities.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    loadOperationState.listener.onUnityAdsFailedToLoad(loadOperationState.placementId, unityAdsLoadError, string2);
                }
            });
        }
    }

    public void executeAdOperation(IWebViewBridgeInvoker iWebViewBridgeInvoker, final LoadOperationState loadOperationState) {
        if (TextUtils.isEmpty((CharSequence)loadOperationState.placementId)) {
            this.sendOnUnityAdsFailedToLoad(loadOperationState, UnityAds.UnityAdsLoadError.INVALID_ARGUMENT, errorMsgPlacementIdNull);
            return;
        }
        LoadOperation loadOperation = new LoadOperation(loadOperationState, (IWebViewBridgeInvocation)new WebViewBridgeInvocation(this._executorService, iWebViewBridgeInvoker, new IWebViewBridgeInvocationCallback(){

            public void onFailure(final String string2, CallbackStatus callbackStatus) {
                LoadModule.this.sendOnUnityAdsFailedToLoad(loadOperationState, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, errorMsgInternalCommunicationFailure);
                string2 = callbackStatus == null ? "invocationFailure" : callbackStatus.toString();
                LoadModule.this._sdkMetricSender.SendSDKMetricEventWithTag(SDKMetricEvents.native_load_callback_error, new HashMap<String, String>(){
                    {
                        this.put("cbs", string2);
                    }
                });
                LoadModule.this.remove(loadOperationState.id);
            }

            public void onSuccess() {
            }

            public void onTimeout() {
                LoadModule.this.sendOnUnityAdsFailedToLoad(loadOperationState, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, errorMsgInternalCommunicationTimeout);
                LoadModule.this.getMetricSender().SendSDKMetricEvent(SDKMetricEvents.native_load_callback_timeout);
                LoadModule.this.remove(loadOperationState.id);
            }
        }));
        iWebViewBridgeInvoker = new JSONObject();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("headerBiddingOptions", (Object)loadOperationState.loadOptions.getData());
            iWebViewBridgeInvoker.put("options", (Object)jSONObject);
            iWebViewBridgeInvoker.put("listenerId", (Object)loadOperation.getId());
            iWebViewBridgeInvoker.put("placementId", (Object)loadOperationState.placementId);
            iWebViewBridgeInvoker.put("time", Device.getElapsedRealtime());
        }
        catch (NullPointerException nullPointerException) {
            this.sendOnUnityAdsFailedToLoad(loadOperationState, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, errorMsgFailedToCreateLoadRequest);
            return;
        }
        catch (JSONException jSONException) {
            this.sendOnUnityAdsFailedToLoad(loadOperationState, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, errorMsgFailedToCreateLoadRequest);
            return;
        }
        this.set((IWebViewSharedObject)loadOperation);
        loadOperation.invoke(loadOperationState.configuration.getWebViewBridgeTimeout(), new Object[]{iWebViewBridgeInvoker});
        return;
    }

    public void onUnityAdsAdLoaded(String string2) {
        ILoadOperation iLoadOperation = (ILoadOperation)this.get(string2);
        if (iLoadOperation != null && iLoadOperation.getLoadOperationState() != null) {
            iLoadOperation.onUnityAdsAdLoaded(iLoadOperation.getLoadOperationState().placementId);
            this.remove(string2);
        }
    }

    public void onUnityAdsFailedToLoad(String string2, UnityAds.UnityAdsLoadError unityAdsLoadError, String string3) {
        ILoadOperation iLoadOperation = (ILoadOperation)this.get(string2);
        if (iLoadOperation != null && iLoadOperation.getLoadOperationState() != null) {
            iLoadOperation.onUnityAdsFailedToLoad(iLoadOperation.getLoadOperationState().placementId, unityAdsLoadError, string3);
            this.remove(string2);
        }
    }
}

