/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.api;

import android.os.Build;
import com.unity3d.services.ads.video.VideoPlayerError;
import com.unity3d.services.ads.video.VideoPlayerEvent;
import com.unity3d.services.ads.video.VideoPlayerView;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.webview.WebViewEventCategory;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;

public class VideoPlayer {
    private static VideoPlayerView _videoPlayerView;

    @WebViewExposed
    public static void getCurrentPosition(WebViewCallback webViewCallback) {
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(VideoPlayer.getVideoPlayerView().getCurrentPosition());
        } else {
            webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getProgressEventInterval(WebViewCallback webViewCallback) {
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(VideoPlayer.getVideoPlayerView().getProgressEventInterval());
        } else {
            webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    public static VideoPlayerView getVideoPlayerView() {
        return _videoPlayerView;
    }

    @WebViewExposed
    public static void getVideoViewRectangle(WebViewCallback webViewCallback) {
        Object object = VideoPlayer.getVideoPlayerView();
        if (object != null) {
            object = object.getVideoViewRectangle();
            webViewCallback.invoke((int)object[0], (int)object[1], (int)object[2], (int)object[3]);
        } else {
            webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getVolume(WebViewCallback webViewCallback) {
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(Float.valueOf(VideoPlayer.getVideoPlayerView().getVolume()));
        } else {
            webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void pause(WebViewCallback webViewCallback) {
        DeviceLog.debug((String)"Pausing current video");
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().pause();
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(new Object[0]);
        } else {
            webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void play(WebViewCallback webViewCallback) {
        DeviceLog.debug((String)"Starting playback of prepared video");
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().play();
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(new Object[0]);
        } else {
            webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void prepare(String string2, Double d2, WebViewCallback webViewCallback) {
        VideoPlayer.prepare(string2, d2, 0, webViewCallback);
    }

    @WebViewExposed
    public static void prepare(final String string2, final Double d2, final Integer n2, WebViewCallback webViewCallback) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Preparing video for playback: ");
        stringBuilder.append(string2);
        DeviceLog.debug((String)stringBuilder.toString());
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().prepare(string2, d2.floatValue(), n2.intValue());
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(string2);
        } else {
            webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void seekTo(final Integer n2, WebViewCallback webViewCallback) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Seeking video to time: ");
        stringBuilder.append(n2);
        DeviceLog.debug((String)stringBuilder.toString());
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().seekTo(n2.intValue());
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(new Object[0]);
        } else {
            webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setInfoListenerEnabled(boolean bl, WebViewCallback webViewCallback) {
        if (Build.VERSION.SDK_INT > 16) {
            if (VideoPlayer.getVideoPlayerView() != null) {
                VideoPlayer.getVideoPlayerView().setInfoListenerEnabled(bl);
                webViewCallback.invoke(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.INFO, bl);
            } else {
                webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
            }
        } else {
            webViewCallback.error((Enum)VideoPlayerError.API_LEVEL_ERROR, Build.VERSION.SDK_INT, bl);
        }
    }

    @WebViewExposed
    public static void setProgressEventInterval(final Integer n2, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().setProgressEventInterval(n2.intValue());
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(new Object[0]);
        } else {
            webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    public static void setVideoPlayerView(VideoPlayerView videoPlayerView) {
        _videoPlayerView = videoPlayerView;
    }

    @WebViewExposed
    public static void setVolume(Double d2, WebViewCallback webViewCallback) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Setting video volume: ");
        stringBuilder.append(d2);
        DeviceLog.debug((String)stringBuilder.toString());
        if (VideoPlayer.getVideoPlayerView() != null) {
            VideoPlayer.getVideoPlayerView().setVolume(Float.valueOf(d2.floatValue()));
            webViewCallback.invoke(d2);
        } else {
            webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void stop(WebViewCallback webViewCallback) {
        DeviceLog.debug((String)"Stopping current video");
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().stop();
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            webViewCallback.invoke(new Object[0]);
        } else {
            webViewCallback.error((Enum)VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }
}

