/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.SparseArray;
import android.view.WindowInsets;
import com.safedk.android.analytics.brandsafety.BrandSafetyUtils;
import com.safedk.android.utils.Logger;
import com.unity3d.services.ads.adunit.AdUnitActivity;
import com.unity3d.services.ads.adunit.AdUnitError;
import com.unity3d.services.ads.adunit.AdUnitMotionEvent;
import com.unity3d.services.ads.adunit.AdUnitSoftwareActivity;
import com.unity3d.services.ads.adunit.AdUnitTransparentActivity;
import com.unity3d.services.ads.adunit.AdUnitTransparentSoftwareActivity;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdUnit {
    private static AdUnitActivity _adUnitActivity;
    private static int _currentActivityId = -1;

    private AdUnit() {
    }

    @WebViewExposed
    public static void clearMotionEventCapture(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                AdUnit.getAdUnitActivity().getLayout().clearCapture();
                webViewCallback.invoke(new Object[0]);
            } else {
                webViewCallback.error((Enum)AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void close(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            AdUnit.getAdUnitActivity().finish();
            webViewCallback.invoke(new Object[0]);
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void endMotionEventCapture(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                AdUnit.getAdUnitActivity().getLayout().endCapture();
                webViewCallback.invoke(new Object[0]);
            } else {
                webViewCallback.error((Enum)AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    public static AdUnitActivity getAdUnitActivity() {
        return _adUnitActivity;
    }

    public static int getCurrentAdUnitActivityId() {
        return _currentActivityId;
    }

    @WebViewExposed
    public static void getCurrentMotionEventCount(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                webViewCallback.invoke(AdUnit.getAdUnitActivity().getLayout().getCurrentEventCount());
            } else {
                webViewCallback.error((Enum)AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    private static ArrayList<Integer> getKeyEventList(JSONArray jSONArray) throws JSONException {
        Integer n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = 0;
        while ((n2 = Integer.valueOf(n3)) < jSONArray.length()) {
            arrayList.add(jSONArray.getInt(n2.intValue()));
            n3 = n2 + 1;
        }
        return arrayList;
    }

    @WebViewExposed
    public static void getMotionEventCount(JSONArray jSONArray, WebViewCallback webViewCallback) {
        int n2;
        JSONObject jSONObject = new ArrayList();
        for (n2 = 0; n2 < jSONArray.length(); ++n2) {
            try {
                jSONObject.add(jSONArray.getInt(n2));
                continue;
            }
            catch (Exception exception) {
                DeviceLog.exception((String)"Error retrieving int from eventTypes", (Exception)exception);
            }
        }
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                if (AdUnit.getAdUnitActivity().getLayout().getCurrentEventCount() >= AdUnit.getAdUnitActivity().getLayout().getMaxEventCount()) {
                    webViewCallback.error((Enum)AdUnitError.MAX_MOTION_EVENT_COUNT_REACHED, new Object[0]);
                    return;
                }
                jSONArray = AdUnit.getAdUnitActivity().getLayout().getEventCount(jSONObject);
                jSONObject = new JSONObject();
                for (n2 = 0; n2 < jSONArray.size(); ++n2) {
                    int n3 = jSONArray.keyAt(n2);
                    int n4 = jSONArray.get(n3);
                    try {
                        jSONObject.put(Integer.toString(n3), n4);
                        continue;
                    }
                    catch (Exception exception) {
                        DeviceLog.exception((String)"Error building response JSON", (Exception)exception);
                    }
                }
                webViewCallback.invoke(jSONObject);
            } else {
                webViewCallback.error((Enum)AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WebViewExposed
    public static void getMotionEventData(JSONObject var0, WebViewCallback var1_1) {
        var2_2 = var0.keys();
        var3_3 = new SparseArray();
        block8: while (true) {
            var4_5 = var2_2.hasNext();
            var5_6 = 0;
            if (!var4_5) break;
            var6_7 = (String)var2_2.next();
            var7_11 = Integer.parseInt(var6_7);
            if (var3_3.get(var7_11) == null) {
                var3_3.put(var7_11, new ArrayList<E>());
            }
            var8_12 /* !! */  = null;
            try {
                var6_7 = var0.getJSONArray(var6_7);
                var8_12 /* !! */  = var6_7;
            }
            catch (Exception var6_8) {
                DeviceLog.exception((String)"Couldn't fetch keyIndices", (Exception)var6_8);
            }
            if (var8_12 /* !! */  == null) continue;
            while (true) {
                if (var5_6 < var8_12 /* !! */ .length()) ** break;
                continue block8;
                try {
                    ((ArrayList)var3_3.get(var7_11)).add(var8_12 /* !! */ .getInt(var5_6));
                }
                catch (Exception var6_9) {
                    DeviceLog.exception((String)"Couldn't add value to requested infos", (Exception)var6_9);
                }
                ++var5_6;
            }
            break;
        }
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                if (AdUnit.getAdUnitActivity().getLayout().getCurrentEventCount() >= AdUnit.getAdUnitActivity().getLayout().getMaxEventCount()) {
                    var1_1.error((Enum)AdUnitError.MAX_MOTION_EVENT_COUNT_REACHED, new Object[0]);
                    return;
                }
                var8_12 /* !! */  = AdUnit.getAdUnitActivity().getLayout().getEvents(var3_3);
                var0 = new JSONObject();
                for (var5_6 = 0; var5_6 < var8_12 /* !! */ .size(); ++var5_6) {
                    var9_13 = var8_12 /* !! */ .keyAt(var5_6);
                    var6_7 = (SparseArray)var8_12 /* !! */ .get(var9_13);
                    var2_2 = new JSONObject();
                    for (var7_11 = 0; var7_11 < var6_7.size(); ++var7_11) {
                        var10_14 = new JSONObject();
                        var11_15 = var6_7.keyAt(var7_11);
                        var3_3 = (AdUnitMotionEvent)var6_7.get(var11_15);
                        try {
                            var10_14.put("action", var3_3.getAction());
                            var10_14.put("isObscured", var3_3.isObscured());
                            var10_14.put("toolType", var3_3.getToolType());
                            var10_14.put("source", var3_3.getSource());
                            var10_14.put("deviceId", var3_3.getDeviceId());
                            var10_14.put("x", (double)var3_3.getX());
                            var10_14.put("y", (double)var3_3.getY());
                            var10_14.put("eventTime", var3_3.getEventTime());
                            var10_14.put("pressure", (double)var3_3.getPressure());
                            var10_14.put("size", (double)var3_3.getSize());
                            var2_2.put(Integer.toString(var11_15), var10_14);
                            continue;
                        }
                        catch (Exception var3_4) {
                            DeviceLog.debug((String)"Couldn't construct event info", (Object[])new Object[]{var3_4});
                        }
                    }
                    try {
                        var0.put(Integer.toString(var9_13), (Object)var2_2);
                        continue;
                    }
                    catch (Exception var6_10) {
                        DeviceLog.debug((String)"Couldn't construct info object", (Object[])new Object[]{var6_10});
                    }
                }
                var1_1.invoke(new Object[]{var0});
            } else {
                var1_1.error((Enum)AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            var1_1.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getOrientation(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(AdUnit.getAdUnitActivity().getRequestedOrientation());
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebViewExposed
    public static void getSafeAreaInsets(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null && AdUnit.getAdUnitActivity().getLayout() != null) {
            void var2_7;
            if (Build.VERSION.SDK_INT < 28) {
                webViewCallback.error((Enum)AdUnitError.API_LEVEL_ERROR, new Object[0]);
                return;
            }
            WindowInsets windowInsets = AdUnit.getAdUnitActivity().getLayout().getRootWindowInsets();
            if (windowInsets == null) {
                webViewCallback.error((Enum)AdUnitError.NO_DISPLAY_CUTOUT_AVAILABLE, new Object[0]);
                return;
            }
            JSONObject jSONObject = new JSONObject();
            try {
                Object object = windowInsets.getClass().getMethod("getDisplayCutout", new Class[0]).invoke((Object)windowInsets, new Object[0]);
                if (object != null) {
                    Object object2 = object.getClass().getMethod("getSafeInsetTop", new Class[0]).invoke(object, new Object[0]);
                    Object object3 = object.getClass().getMethod("getSafeInsetRight", new Class[0]).invoke(object, new Object[0]);
                    Object object4 = object.getClass().getMethod("getSafeInsetBottom", new Class[0]).invoke(object, new Object[0]);
                    object = object.getClass().getMethod("getSafeInsetLeft", new Class[0]).invoke(object, new Object[0]);
                    jSONObject.put("top", object2);
                    jSONObject.put("right", object3);
                    jSONObject.put("bottom", object4);
                    jSONObject.put("left", object);
                    webViewCallback.invoke(jSONObject);
                    return;
                }
                webViewCallback.error((Enum)AdUnitError.NO_DISPLAY_CUTOUT_AVAILABLE, new Object[0]);
                return;
            }
            catch (JSONException jSONException) {
                webViewCallback.error((Enum)AdUnitError.DISPLAY_CUTOUT_JSON_ERROR, new Object[0]);
                DeviceLog.debug((String)"JSON error while constructing display cutout object", (Object[])new Object[]{jSONException});
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            catch (NoSuchMethodException noSuchMethodException) {
                webViewCallback.error((Enum)AdUnitError.DISPLAY_CUTOUT_METHOD_NOT_AVAILABLE, new Object[0]);
                DeviceLog.debug((String)"Method getDisplayCutout not found", (Object[])new Object[]{noSuchMethodException});
                return;
            }
            webViewCallback.error((Enum)AdUnitError.DISPLAY_CUTOUT_INVOKE_FAILED, new Object[0]);
            DeviceLog.debug((String)"Error while calling displayCutout getter", (Object[])new Object[]{var2_7});
            return;
        }
        webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void getViewFrame(String object, WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getViewFrame((String)object) != null) {
                object = AdUnit.getAdUnitActivity().getViewFrame((String)object);
                webViewCallback.invoke(object.get("x"), object.get("y"), object.get("width"), object.get("height"));
            } else {
                webViewCallback.error((Enum)AdUnitError.UNKNOWN_VIEW, new Object[0]);
            }
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    private static String[] getViewList(JSONArray jSONArray) throws JSONException {
        String[] stringArray = new String[jSONArray.length()];
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            stringArray[i2] = jSONArray.getString(i2);
        }
        return stringArray;
    }

    @WebViewExposed
    public static void getViews(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(new JSONArray(Arrays.asList(AdUnit.getAdUnitActivity().getViews())));
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void open(Integer n2, JSONArray jSONArray, Integer n3, WebViewCallback webViewCallback) {
        AdUnit.open(n2, jSONArray, n3, null, webViewCallback);
    }

    @WebViewExposed
    public static void open(Integer n2, JSONArray jSONArray, Integer n3, JSONArray jSONArray2, WebViewCallback webViewCallback) {
        AdUnit.open(n2, jSONArray, n3, jSONArray2, 0, true, webViewCallback);
    }

    @WebViewExposed
    public static void open(Integer n2, JSONArray jSONArray, Integer n3, JSONArray jSONArray2, Integer n4, Boolean bl, WebViewCallback webViewCallback) {
        AdUnit.open(n2, jSONArray, n3, jSONArray2, n4, bl, false, webViewCallback);
    }

    @WebViewExposed
    public static void open(Integer n2, JSONArray jSONArray, Integer n3, JSONArray jSONArray2, Integer n4, Boolean bl, Boolean bl2, WebViewCallback webViewCallback) {
        AdUnit.open(n2, jSONArray, n3, jSONArray2, n4, bl, bl2, 0, webViewCallback);
    }

    @WebViewExposed
    public static void open(Integer comparable, JSONArray jSONArray, Integer n2, JSONArray jSONArray2, Integer n3, Boolean bl, Boolean bl2, Integer n4, WebViewCallback webViewCallback) {
        if (!bl.booleanValue() && bl2.booleanValue()) {
            DeviceLog.debug((String)"Unity Ads opening new transparent ad unit activity, hardware acceleration disabled");
            bl = new Intent((Context)ClientProperties.getActivity(), AdUnitTransparentSoftwareActivity.class);
        } else if (bl.booleanValue() && !bl2.booleanValue()) {
            DeviceLog.debug((String)"Unity Ads opening new hardware accelerated ad unit activity");
            bl = new Intent((Context)ClientProperties.getActivity(), AdUnitActivity.class);
        } else if (bl.booleanValue() && bl2.booleanValue()) {
            DeviceLog.debug((String)"Unity Ads opening new hardware accelerated transparent ad unit activity");
            bl = new Intent((Context)ClientProperties.getActivity(), AdUnitTransparentActivity.class);
        } else {
            DeviceLog.debug((String)"Unity Ads opening new ad unit activity, hardware acceleration disabled");
            bl = new Intent((Context)ClientProperties.getActivity(), AdUnitSoftwareActivity.class);
        }
        bl.addFlags(0x10010000);
        if (comparable != null) {
            block13: {
                try {
                    bl.putExtra("activityId", (Integer)comparable);
                }
                catch (Exception exception) {
                    DeviceLog.exception((String)"Could not set activityId for intent", (Exception)exception);
                    webViewCallback.error((Enum)AdUnitError.ACTIVITY_ID, (Integer)comparable, exception.getMessage());
                    return;
                }
                AdUnit.setCurrentAdUnitActivityId((Integer)comparable);
                try {
                    bl.putExtra("views", AdUnit.getViewList(jSONArray));
                    if (jSONArray2 == null) break block13;
                }
                catch (Exception exception) {
                    DeviceLog.exception((String)"Error parsing views from viewList", (Exception)exception);
                    webViewCallback.error((Enum)AdUnitError.CORRUPTED_VIEWLIST, jSONArray, exception.getMessage());
                    return;
                }
                try {
                    bl.putExtra("keyEvents", AdUnit.getKeyEventList(jSONArray2));
                }
                catch (Exception exception) {
                    DeviceLog.exception((String)"Error parsing views from viewList", (Exception)exception);
                    webViewCallback.error((Enum)AdUnitError.CORRUPTED_KEYEVENTLIST, jSONArray2, exception.getMessage());
                    return;
                }
            }
            bl.putExtra("systemUiVisibility", n3);
            bl.putExtra("orientation", n2);
            bl.putExtra("displayCutoutMode", n4);
            AdUnit.safedk_Activity_startActivity_9d898b58165fa4ba0e12c3900a2b8533(ClientProperties.getActivity(), (Intent)bl);
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("Opened AdUnitActivity with: ");
            ((StringBuilder)comparable).append(jSONArray.toString());
            DeviceLog.debug((String)((StringBuilder)comparable).toString());
            webViewCallback.invoke(new Object[0]);
            return;
        }
        DeviceLog.error((String)"Activity ID is NULL");
        webViewCallback.error((Enum)AdUnitError.ACTIVITY_ID, "Activity ID NULL");
    }

    public static void safedk_Activity_startActivity_9d898b58165fa4ba0e12c3900a2b8533(Activity activity, Intent intent) {
        Logger.d("SafeDK-Special|SafeDK: Call> Landroid/app/Activity;->startActivity(Landroid/content/Intent;)V");
        if (intent == null) {
            return;
        }
        BrandSafetyUtils.detectAdClick(intent, "com.unity3d.ads");
        activity.startActivity(intent);
    }

    public static void setAdUnitActivity(AdUnitActivity adUnitActivity) {
        _adUnitActivity = adUnitActivity;
    }

    public static void setCurrentAdUnitActivityId(int n2) {
        _currentActivityId = n2;
    }

    @WebViewExposed
    public static void setKeepScreenOn(final Boolean bl, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setKeepScreenOn(bl.booleanValue());
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(new Object[0]);
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setKeyEventList(JSONArray jSONArray, WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            try {
                AdUnit.getAdUnitActivity().setKeyEventList(AdUnit.getKeyEventList(jSONArray));
                webViewCallback.invoke(jSONArray);
            }
            catch (Exception exception) {
                DeviceLog.exception((String)"Error parsing views from viewList", (Exception)exception);
                webViewCallback.error((Enum)AdUnitError.CORRUPTED_KEYEVENTLIST, jSONArray, exception.getMessage());
            }
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setLayoutInDisplayCutoutMode(final Integer n2, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setLayoutInDisplayCutoutMode(n2.intValue());
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(n2);
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setOrientation(final Integer n2, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setOrientation(n2.intValue());
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(n2);
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setSystemUiVisibility(final Integer n2, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setSystemUiVisibility(n2.intValue());
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(n2);
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setViewFrame(final String string2, final Integer n2, final Integer n3, final Integer n4, final Integer n5, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setViewFrame(string2, n2.intValue(), n3.intValue(), n4.intValue(), n5.intValue());
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(new Object[0]);
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setViews(final JSONArray jSONArray, WebViewCallback webViewCallback) {
        boolean bl;
        try {
            AdUnit.getViewList(jSONArray);
            bl = false;
        }
        catch (JSONException jSONException) {
            webViewCallback.error((Enum)AdUnitError.CORRUPTED_VIEWLIST, jSONArray);
            bl = true;
        }
        if (!bl) {
            Utilities.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (AdUnit.getAdUnitActivity() != null) {
                        try {
                            AdUnit.getAdUnitActivity().setViews(AdUnit.getViewList(jSONArray));
                        }
                        catch (Exception exception) {
                            DeviceLog.exception((String)"Corrupted viewlist", (Exception)exception);
                        }
                    }
                }
            });
        }
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(jSONArray);
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void startMotionEventCapture(Integer n2, WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                AdUnit.getAdUnitActivity().getLayout().startCapture(n2.intValue());
                webViewCallback.invoke(new Object[0]);
            } else {
                webViewCallback.error((Enum)AdUnitError.LAYOUT_NULL, new Object[0]);
            }
        } else {
            webViewCallback.error((Enum)AdUnitError.ADUNIT_NULL, new Object[0]);
        }
    }
}

