/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.scar.adapter.v2000.scarads;

import android.content.Context;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.query.AdInfo;
import com.unity3d.scar.adapter.common.GMAAdsError;
import com.unity3d.scar.adapter.common.IAdsErrorHandler;
import com.unity3d.scar.adapter.common.IUnityAdsError;
import com.unity3d.scar.adapter.common.scarads.IScarAd;
import com.unity3d.scar.adapter.common.scarads.IScarLoadListener;
import com.unity3d.scar.adapter.common.scarads.ScarAdMetadata;
import com.unity3d.scar.adapter.v2000.scarads.ScarAdListener;
import com.unity3d.scar.adapter.v2000.signals.QueryInfoMetadata;

public abstract class ScarAdBase<T>
implements IScarAd {
    protected T _adObj;
    protected IAdsErrorHandler _adsErrorHandler;
    protected Context _context;
    protected QueryInfoMetadata _queryInfoMetadata;
    protected ScarAdListener _scarAdListener;
    protected ScarAdMetadata _scarAdMetadata;

    public ScarAdBase(Context context, ScarAdMetadata scarAdMetadata, QueryInfoMetadata queryInfoMetadata, IAdsErrorHandler iAdsErrorHandler) {
        this._context = context;
        this._scarAdMetadata = scarAdMetadata;
        this._queryInfoMetadata = queryInfoMetadata;
        this._adsErrorHandler = iAdsErrorHandler;
    }

    public void loadAd(IScarLoadListener iScarLoadListener) {
        QueryInfoMetadata queryInfoMetadata = this._queryInfoMetadata;
        if (queryInfoMetadata != null) {
            queryInfoMetadata = new AdInfo(queryInfoMetadata.getQueryInfo(), this._scarAdMetadata.getAdString());
            queryInfoMetadata = new AdRequest.Builder().setAdInfo((AdInfo)queryInfoMetadata).build();
            this._scarAdListener.setLoadListener(iScarLoadListener);
            this.loadAdInternal((AdRequest)queryInfoMetadata, iScarLoadListener);
        } else {
            this._adsErrorHandler.handleError((IUnityAdsError)GMAAdsError.InternalLoadError(this._scarAdMetadata));
        }
    }

    protected abstract void loadAdInternal(AdRequest var1, IScarLoadListener var2);

    public void setGmaAd(T t2) {
        this._adObj = t2;
    }
}

