/*
 * Decompiled with CFR 0.152.
 */
package com.unity.udp.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import com.unity.udp.sdk.AppInfo;
import com.unity.udp.sdk.InitCallback;
import com.unity.udp.sdk.PurchaseCallback;
import com.unity.udp.sdk.PurchaseInfo;
import com.unity.udp.sdk.common.Logger;
import com.unity.udp.sdk.internal.ChannelHandler;
import com.unity.udp.sdk.internal.Utils;
import com.unity.udp.sdk.provider.ChannelProvider;
import com.unity.udp.sdk.provider.ChannelProviderService;
import com.unity3d.player.UnityPlayer;
import java.util.HashMap;
import java.util.List;

public class ChannelService {
    private static final String VALUE_PREFIX = "string:";
    private static ChannelHandler channelHandler;
    private static ChannelProviderService channelProviderService;
    private static String storeName;

    public static void consumePurchase(PurchaseInfo purchaseInfo, PurchaseCallback purchaseCallback) {
        String string2 = ChannelService.envCheck(purchaseCallback, "PurchaseCallback", purchaseInfo, "PurchaseInfo");
        if (string2 != null) {
            Logger.logError((String)string2);
            return;
        }
        channelHandler.startConsume(purchaseInfo, purchaseCallback);
    }

    public static void consumePurchases(List<PurchaseInfo> list, PurchaseCallback purchaseCallback) {
        String string2 = ChannelService.envCheck(list, "PurchaseInfos", purchaseCallback, "PurchaseCallback");
        if (string2 != null) {
            Logger.logError((String)string2);
            return;
        }
        channelHandler.startConsume(list, purchaseCallback);
    }

    public static void enableDebugLogging(boolean bl, String string2) {
        ChannelService.envCheck(channelProviderService, "ChannelProviderService", null, null);
        Logger.enableDebugLog((boolean)bl);
        if (Utils.isEmptyString((String)string2)) {
            channelProviderService.enableDebugLogging(bl);
        } else {
            channelProviderService.enableDebugLogging(bl, string2);
        }
    }

    private static String envCheck(Object object, String string2, Object object2, String string3) {
        if (object == null && string2 != null) {
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" cannot be null");
            return ((StringBuilder)object).toString();
        }
        if (object2 == null && string3 != null) {
            object = new StringBuilder();
            ((StringBuilder)object).append(string3);
            ((StringBuilder)object).append(" cannot be null");
            return ((StringBuilder)object).toString();
        }
        if (channelProviderService == null) {
            return "Channel provider cannot be null";
        }
        object = channelHandler;
        if (object != null && object.hasInitSuccess()) {
            return null;
        }
        return "Please initialize first";
    }

    public static String getStoreName() {
        String string2 = storeName;
        if (string2 == null) {
            try {
                storeName = Utils.getAndroidMetadata((Context)UnityPlayer.currentActivity, (String)"CHANNEL_NAME");
                string2 = ChannelProvider.getChannelProviderService((String)storeName).getProviderDisplayName();
                return string2;
            }
            catch (Exception exception) {
                return "UDP";
            }
        }
        return ChannelProvider.getChannelProviderService((String)string2).getProviderDisplayName();
    }

    public static void init(Activity object, AppInfo appInfo, final InitCallback initCallback) {
        Object object22;
        String string2;
        block12: {
            if (appInfo == null) {
                Logger.logError((String)"AppInfo cannot be null");
                return;
            }
            if (initCallback == null) {
                Logger.logError((String)"InitCallback cannot be null");
                return;
            }
            try {
                string2 = Utils.getAndroidMetadata((Context)object, (String)"CHANNEL_NAME");
                object22 = channelProviderService = ChannelService.selectProvider(string2);
                if (object22 != null) break block12;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Logger.logError((String)"Cannot get store name for UDP to initialize");
                return;
            }
            Logger.logError((String)"Cannot choose provider service");
            return;
        }
        if (object22.needRsaPublicKey()) {
            try {
                object22 = Utils.getAndroidMetadata((Context)object, (String)"publicKey");
                if (Utils.isEmptyString((String)object22)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Cannot get RSA public key for ");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append(" to initialize");
                    Logger.logError((String)((StringBuilder)object).toString());
                    return;
                }
                appInfo.setRSAPublicKey((String)object22);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Cannot get RSA public key for ");
                stringBuilder.append(string2);
                stringBuilder.append(" to initialize");
                Logger.logError((String)stringBuilder.toString());
                return;
            }
        }
        HashMap<ChannelProviderService, String> hashMap = new HashMap<ChannelProviderService, String>();
        if (channelProviderService.otherInfo() != null && channelProviderService.otherInfo().size() != 0) {
            for (Object object22 : channelProviderService.otherInfo()) {
                try {
                    hashMap.put((ChannelProviderService)object22, Utils.getAndroidMetadata((Context)object, (String)object22).trim());
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Logger.logError((String)String.format("Cannot get %s for %s to initialize", object22, string2));
                    return;
                }
            }
        }
        channelHandler = new ChannelHandler(appInfo, channelProviderService, hashMap);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                channelHandler.startInit(initCallback);
            }
        });
        return;
    }

    public static void purchase(final PurchaseInfo purchaseInfo, final PurchaseCallback purchaseCallback) {
        String string2 = ChannelService.envCheck(purchaseCallback, "PurchaseCallback", purchaseInfo, "PurchaseInfo");
        if (string2 != null) {
            Logger.logError((String)string2);
            return;
        }
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                channelHandler.startPurchase(purchaseInfo, purchaseCallback);
            }
        });
    }

    public static void queryInventory(String[] stringArray, PurchaseCallback purchaseCallback) {
        String string2 = ChannelService.envCheck(purchaseCallback, "PurchaseCallback", null, null);
        if (string2 != null) {
            Logger.logError((String)string2);
            return;
        }
        channelHandler.startQueryInventory(stringArray, purchaseCallback);
    }

    private static ChannelProviderService selectProvider(String string2) {
        if (Utils.isEmptyString((String)string2)) {
            Logger.logError((String)"Cannot select provider");
        }
        return ChannelProvider.getChannelProviderService((String)string2);
    }
}

