/*
 * Decompiled with CFR 0.152.
 */
package com.stansassets.core.utility;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.net.Uri;
import com.stansassets.core.utility.AN_Base64;
import com.stansassets.core.utility.AN_Base64DecoderException;
import com.stansassets.core.utility.AN_Logger;
import com.stansassets.core.utility.AN_UnityBridge;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class AN_BitmapFactory {
    public static Bitmap Decode(String object) {
        byte[] byArray = new byte[]{};
        try {
            object = AN_Base64.decode((String)object);
        }
        catch (AN_Base64DecoderException aN_Base64DecoderException) {
            aN_Base64DecoderException.printStackTrace();
            object = byArray;
        }
        return AN_BitmapFactory.Decode((byte[])object);
    }

    public static Bitmap Decode(byte[] byArray) {
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static Bitmap DecodeFile(String string2, int n2) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        int n3 = options.outWidth;
        int n4 = options.outHeight;
        int n5 = n3 > n4 ? n3 / n2 : n4 / n2;
        options.inJustDecodeBounds = false;
        options.inSampleSize = n5;
        options.inPurgeable = true;
        options = BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        if (options == null) {
            return null;
        }
        try {
            Activity activity = AN_UnityBridge.currentActivity;
            File file = new File(string2);
            string2 = AN_BitmapFactory.rotateImageIfRequired((Bitmap)options, (Context)activity, Uri.fromFile((File)file));
        }
        catch (IOException iOException) {
            AN_Logger.Log((String)"Failed to identify Image rotation data");
            iOException.printStackTrace();
            string2 = options;
        }
        n5 = n2 > string2.getWidth() ? string2.getWidth() : n2;
        int n6 = n2;
        if (n2 > string2.getHeight()) {
            n6 = string2.getHeight();
        }
        if (n3 > n4) {
            float f2 = (float)string2.getWidth() / (float)string2.getHeight();
            n6 = (int)((float)n5 / f2);
        } else {
            float f3 = (float)string2.getHeight() / (float)string2.getWidth();
            n5 = (int)((float)n6 / f3);
        }
        return Bitmap.createScaledBitmap((Bitmap)string2, (int)n5, (int)n6, (boolean)false);
    }

    public static String EncodeToBase64(Bitmap bitmap) {
        return AN_Base64.encode(AN_BitmapFactory.EncodeToBytes(bitmap));
    }

    public static String EncodeToBase64(Drawable drawable2) {
        return AN_BitmapFactory.EncodeToBase64(AN_BitmapFactory.drawableToBitmap(drawable2));
    }

    public static byte[] EncodeToBytes(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Bitmap ResizeImage(Bitmap bitmap, int n2) {
        int n3;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        int n4 = bitmap.getWidth();
        int n5 = n4 > (n3 = bitmap.getHeight()) ? n4 / n2 : n3 / n2;
        options.inJustDecodeBounds = false;
        options.inSampleSize = n5;
        options.inPurgeable = true;
        n5 = n2 > bitmap.getWidth() ? bitmap.getWidth() : n2;
        int n6 = n2;
        if (n2 > bitmap.getHeight()) {
            n6 = bitmap.getHeight();
        }
        if (n4 > n3) {
            float f2 = (float)bitmap.getWidth() / (float)bitmap.getHeight();
            n6 = (int)((float)n5 / f2);
        } else {
            float f3 = (float)bitmap.getHeight() / (float)bitmap.getWidth();
            n5 = (int)((float)n6 / f3);
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n5, (int)n6, (boolean)false);
    }

    private static Bitmap drawableToBitmap(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        int n2 = drawable2.getIntrinsicWidth();
        int n3 = 1;
        if (n2 <= 0) {
            n2 = 1;
        }
        int n4 = drawable2.getIntrinsicHeight();
        if (n4 > 0) {
            n3 = n4;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private static Bitmap rotateImage(Bitmap bitmap, int n2) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)n2);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Bitmap rotateImageIfRequired(Bitmap bitmap, Context context, Uri uri) throws IOException {
        if (uri.getScheme().equals("content")) {
            uri = context.getContentResolver().query(uri, new String[]{"orientation"}, null, null, null);
            context = bitmap;
            if (uri.moveToFirst()) {
                int n2 = uri.getInt(0);
                uri.close();
                context = AN_BitmapFactory.rotateImage(bitmap, n2);
            }
            return context;
        }
        int n3 = new ExifInterface(uri.getPath()).getAttributeInt("Orientation", 1);
        if (n3 != 3) {
            if (n3 != 6) {
                if (n3 != 8) {
                    return bitmap;
                }
                return AN_BitmapFactory.rotateImage(bitmap, 270);
            }
            return AN_BitmapFactory.rotateImage(bitmap, 90);
        }
        return AN_BitmapFactory.rotateImage(bitmap, 180);
    }
}

