/*
 * Decompiled with CFR 0.152.
 */
package com.safedk.android.utils;

import android.os.Bundle;
import com.safedk.android.utils.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SdksMapping {
    private static final String AD_COLONY_ADAPTER_CLASS_NAME = "com.applovin.mediation.adapters.AdColonyMediationAdapter";
    public static final String KEY_INSTALLED_MEDIATION_ADAPTERS = "installed_mediation_adapters";
    public static final String KEY_INSTALLED_MEDIATION_ADAPTERS_CLASS = "class";
    public static final String KEY_INSTALLED_MEDIATION_ADAPTERS_SDK_VERSION = "sdk_version";
    public static final String KEY_INSTALLED_MEDIATION_ADAPTERS_VERSION = "version";
    private static final String TAG = "SdksMapping";
    private static Set<String> redirectSupportedSdks;
    private static TreeMap<String, String> sdkAdaptersUUID;
    private static TreeMap<String, String> sdkPackageToName;
    private static TreeMap<String, String> sdkPackageToUUID;
    private static TreeMap<String, String> sdkPackageUUIDToVersion;
    private static TreeMap<String, String> sdkPackages;
    private static boolean topicSdkVersionsUpdated;

    static {
        sdkPackageToName = new TreeMap(Collections.reverseOrder());
        sdkPackageToUUID = new TreeMap(Collections.reverseOrder());
        sdkPackages = new TreeMap(Collections.reverseOrder());
        sdkPackageUUIDToVersion = new TreeMap(Collections.reverseOrder());
        sdkAdaptersUUID = new TreeMap(Collections.reverseOrder());
        sdkPackageToName.put("com.unity3d.ads", "UnityAds");
        sdkPackages.put("com.unity3d.services.ar", "com.unity3d.ads");
        sdkPackages.put("com.unity3d.services.monetization", "com.unity3d.ads");
        sdkPackages.put("com.unity3d.services.banners", "com.unity3d.ads");
        sdkPackages.put("com.unity3d.services.ads", "com.unity3d.ads");
        sdkPackageToUUID.put("com.unity3d.ads", "daaea35726ab7cd457ab61d4538fb822");
        sdkPackages.put("com.unity3d.ads", "com.unity3d.ads");
        sdkAdaptersUUID.put("com.applovin.mediation.adapters.UnityAdsMediationAdapter", "daaea35726ab7cd457ab61d4538fb822");
        sdkPackageToName.put("com.mintegral.msdk", "Mintegral");
        sdkPackages.put("com.mbridge.msdk", "com.mintegral.msdk");
        sdkPackageToUUID.put("com.mintegral.msdk", "1be9e72506f3307ce6a9e78d26d65bd0");
        sdkPackages.put("com.mintegral.msdk", "com.mintegral.msdk");
        sdkAdaptersUUID.put("com.applovin.mediation.adapters.MintegralMediationAdapter", "1be9e72506f3307ce6a9e78d26d65bd0");
        sdkPackageToName.put("com.google.ads", "AdMob");
        sdkPackages.put("com.google.android.gms.internal.ads", "com.google.ads");
        sdkPackages.put("com.google.android.gms.ads", "com.google.ads");
        sdkPackageToUUID.put("com.google.ads", "29015bbfcc182d80e7f75bd2c38e4521");
        sdkPackages.put("com.google.ads", "com.google.ads");
        sdkPackageToName.put("com.bytedance.sdk.openadsdk", "Pangle");
        sdkPackageToUUID.put("com.bytedance.sdk.openadsdk", "dd2971b0681141d57b221687791ad1bd");
        sdkPackages.put("com.bytedance.sdk.openadsdk", "com.bytedance.sdk.openadsdk");
        sdkAdaptersUUID.put("com.applovin.mediation.adapters.ByteDanceMediationAdapter", "dd2971b0681141d57b221687791ad1bd");
        sdkPackageToName.put("com.applovin", "AppLovin");
        sdkPackageToUUID.put("com.applovin", "74616804a7dc29147dfb0afe122a9fd2");
        sdkPackages.put("com.applovin", "com.applovin");
        sdkAdaptersUUID.put("com.applovin.mediation.adapters.AppLovinMediationAdapter", "74616804a7dc29147dfb0afe122a9fd2");
    }

    public static Set<String> getAllSdkNames() {
        return new HashSet<String>(sdkPackageToName.values());
    }

    public static Set<String> getAllSdkPackages() {
        return sdkPackageToName.keySet();
    }

    public static Map<String, String> getAllSdkVersionsMap() {
        return sdkPackageUUIDToVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getRedirectSupportedSdks() {
        Logger.d(TAG, "getRedirectSupportedSdks started,sdkAdaptersUUID=" + sdkAdaptersUUID.values());
        if (SdksMapping.isTopicSdkVersionsUpdated()) return redirectSupportedSdks;
        return new HashSet<String>(sdkAdaptersUUID.values());
    }

    public static TreeMap<String, String> getSdkAdaptersUUID() {
        return sdkAdaptersUUID;
    }

    public static String getSdkNameByPackage(String string2) {
        return sdkPackageToName.get(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSdkPackageByClass(String string2) {
        String string3;
        Iterator<String> iterator2 = sdkPackages.keySet().iterator();
        do {
            if (!iterator2.hasNext()) return null;
        } while (!string2.startsWith(string3 = iterator2.next()));
        return sdkPackages.get(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSdkUUIDByPackage(String string2) {
        if (!"com.safedk".equals(string2)) return sdkPackageToUUID.get(string2);
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSdkVersionByPackage(String string2) {
        if ((string2 = SdksMapping.getSdkUUIDByPackage(string2)) == null) return null;
        return sdkPackageUUIDToVersion.get(string2);
    }

    public static void init() {
        SdksMapping.printAllSdkVersions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSameSdkByPackages(String string2, String string3) {
        boolean bl;
        boolean bl2 = bl = false;
        if (string2 == null) return bl2;
        if (string3 == null) {
            return bl;
        }
        string2 = SdksMapping.getSdkNameByPackage(string2);
        string3 = SdksMapping.getSdkNameByPackage(string3);
        bl2 = bl;
        if (string2 == null) return bl2;
        bl2 = bl;
        if (string3 == null) return bl2;
        if (string2.equals(string3)) {
            return true;
        }
        bl2 = bl;
        if (!string2.regionMatches(false, 0, string3, 0, 5)) return bl2;
        return true;
    }

    public static boolean isTopicSdkVersionsUpdated() {
        Logger.d(TAG, "isTopicSdkVersionsUpdated=" + topicSdkVersionsUpdated);
        return topicSdkVersionsUpdated;
    }

    public static void printAllSdkVersions() {
        Logger.d(TAG, "printAllSdkVersions sdkPackages=" + sdkPackages.toString());
        Logger.d(TAG, "printAllSdkVersions sdkPackageToName=" + sdkPackageToName.toString());
        Logger.d(TAG, "printAllSdkVersions sdkPackageToUUID=" + sdkPackageToUUID.toString());
        Logger.d(TAG, "printAllSdkVersions sdkPackageUUIDToVersion=" + sdkPackageUUIDToVersion.toString());
        Logger.d(TAG, "printAllSdkVersions sdkAdaptersUUID=" + sdkAdaptersUUID.toString());
        Iterator<Map.Entry<String, String>> iterator2 = sdkPackageToName.entrySet().iterator();
        Logger.d(TAG, "printAllSdkVersions sdks detected: " + sdkPackageToName.entrySet().size() + " sdks with versions: " + sdkPackageUUIDToVersion.entrySet().size());
        while (iterator2.hasNext()) {
            String string2 = iterator2.next().getKey();
            Logger.d(TAG, String.format("printAllSdkVersions sdkPackage: %s, version: %s", string2, sdkPackageUUIDToVersion.get(string2)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setMaxAdapterVersions(Bundle object) {
        try {
            block11: {
                CharSequence charSequence;
                block10: {
                    block8: {
                        block9: {
                            charSequence = new StringBuilder();
                            Logger.d(TAG, ((StringBuilder)charSequence).append("getMaxAdapterVersions started, Bundle = ").append(object).toString());
                            SdksMapping.init();
                            if (!object.containsKey(KEY_INSTALLED_MEDIATION_ADAPTERS)) break block8;
                            charSequence = new StringBuilder();
                            Logger.d(TAG, ((StringBuilder)charSequence).append("getMaxAdapterVersions processing ").append(KEY_INSTALLED_MEDIATION_ADAPTERS.toUpperCase()).toString());
                            object = object.getParcelableArrayList(KEY_INSTALLED_MEDIATION_ADAPTERS);
                            if (object == null) break block9;
                            object = ((ArrayList)object).iterator();
                            break block10;
                        }
                        Logger.d(TAG, "extracting value for key installed_mediation_adapters produced null value, skipping");
                        break block11;
                    }
                    Logger.d(TAG, "getMaxAdapterVersions No adapter class version received from MAX");
                    return;
                }
                while (object.hasNext()) {
                    Object object2 = (Bundle)object.next();
                    charSequence = object2.getString(KEY_INSTALLED_MEDIATION_ADAPTERS_CLASS);
                    CharSequence charSequence2 = object2.getString(KEY_INSTALLED_MEDIATION_ADAPTERS_SDK_VERSION);
                    StringBuilder stringBuilder = new StringBuilder();
                    Logger.d(TAG, stringBuilder.append("getMaxAdapterVersions className = ").append((String)charSequence).toString());
                    stringBuilder = new StringBuilder();
                    Logger.d(TAG, stringBuilder.append("getMaxAdapterVersions classVersion = ").append((String)charSequence2).toString());
                    if (charSequence2 != null && ((String)charSequence2).length() > 0) {
                        SdksMapping.updateSdkVersionIfNeeded((String)charSequence, (String)charSequence2);
                    } else if (((String)charSequence).equals(AD_COLONY_ADAPTER_CLASS_NAME)) {
                        charSequence2 = object2.getString(KEY_INSTALLED_MEDIATION_ADAPTERS_VERSION);
                        object2 = new StringBuilder();
                        Logger.d(TAG, ((StringBuilder)object2).append("getMaxAdapterVersions ad colony adapter version special handling. version is ").append((String)charSequence2).toString());
                        SdksMapping.updateSdkVersionIfNeeded((String)charSequence, (String)charSequence2);
                    } else {
                        charSequence2 = new StringBuilder();
                        Logger.d(TAG, ((StringBuilder)charSequence2).append("getMaxAdapterVersions adapter sdk_version field is empty for class ").append((String)charSequence).toString());
                    }
                    charSequence2 = new StringBuilder();
                    Logger.d(TAG, ((StringBuilder)charSequence2).append("getRedirectSupportedSdks for className ").append((String)charSequence).append(" : ").append(SdksMapping.getRedirectSupportedSdks().contains(charSequence)).toString());
                }
                SdksMapping.setTopicSdkVersionsUpdated();
            }
            SdksMapping.printAllSdkVersions();
            return;
        }
        catch (Throwable throwable) {
            Logger.e(TAG, "getMaxAdapterVersions Exception extracting " + KEY_INSTALLED_MEDIATION_ADAPTERS.toUpperCase(), throwable);
            return;
        }
    }

    public static void setTopicSdkVersionsUpdated() {
        topicSdkVersionsUpdated = true;
        Logger.d(TAG, "setTopicSdkVersionsUpdated SdkUUIDByPackage=" + sdkPackageToUUID.toString());
        Logger.d(TAG, "setTopicSdkVersionsUpdated redirectSupprotedSdks=" + redirectSupportedSdks.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateSdkVersionIfNeeded(String string2, String string3) {
        Logger.d(TAG, "updateSdkVersionIfNeeded started, sdk=" + string2 + " , version=" + string3);
        if (SdksMapping.isTopicSdkVersionsUpdated()) {
            Logger.d(TAG, "updateSdkVersionIfNeeded Sdk configuration already updated. exiting");
            return;
        }
        if (!sdkAdaptersUUID.containsKey(string2)) {
            Logger.d(TAG, "Cannot find UUID for package " + string2);
            return;
        }
        String string4 = sdkAdaptersUUID.get(string2);
        Logger.d(TAG, "UUID for class " + string2 + " is " + string4);
        if (!sdkPackageUUIDToVersion.containsKey(string4) || sdkPackageUUIDToVersion.containsKey(string4) && string3 != null && string3.length() > 0 && !sdkPackageUUIDToVersion.get(string4).equals(string3)) {
            sdkPackageUUIDToVersion.put(string4, string3);
            Logger.d(TAG, "updateSdkVersionIfNeeded sdkPackageToVersion for class " + string2 + " (uuid " + string4 + ") updated to " + string3);
        }
        if (redirectSupportedSdks == null) {
            redirectSupportedSdks = new HashSet<String>();
        }
        if (sdkAdaptersUUID.values().contains(string4)) {
            Logger.d(TAG, "Adding " + string2 + " , packageUUID " + string4 + " to redirect supported sdks");
            redirectSupportedSdks.add(string4);
        } else {
            Logger.d(TAG, "Not Adding " + string2 + " , packageUUID " + string4 + " to redirect supported sdks");
        }
        Logger.d(TAG, "getRedirectSupportedSdks : " + SdksMapping.getRedirectSupportedSdks().toString());
    }
}

