/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okio;

import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.Sink;
import com.mbridge.msdk.thrid.okio.Source;
import com.mbridge.msdk.thrid.okio.Timeout;
import java.io.IOException;

public final class Pipe {
    final Buffer buffer = new Buffer();
    final long maxBufferSize;
    private final Sink sink = new PipeSink();
    boolean sinkClosed;
    private final Source source = new PipeSource();
    boolean sourceClosed;

    public Pipe(long l2) {
        if (l2 >= 1L) {
            this.maxBufferSize = l2;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("maxBufferSize < 1: ");
        stringBuilder.append(l2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public final Sink sink() {
        return this.sink;
    }

    public final Source source() {
        return this.source;
    }

    final class PipeSink
    implements Sink {
        final Timeout timeout = new Timeout();

        PipeSink() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sinkClosed) {
                    return;
                }
                if (Pipe.this.sourceClosed && Pipe.this.buffer.size() > 0L) {
                    IOException iOException = new IOException("source is closed");
                    throw iOException;
                }
                Pipe.this.sinkClosed = true;
                Pipe.this.buffer.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void flush() throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sinkClosed) {
                    IllegalStateException illegalStateException = new IllegalStateException("closed");
                    throw illegalStateException;
                }
                if (Pipe.this.sourceClosed && Pipe.this.buffer.size() > 0L) {
                    IOException iOException = new IOException("source is closed");
                    throw iOException;
                }
                return;
            }
        }

        public Timeout timeout() {
            return this.timeout;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void write(Buffer object, long l2) throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                block8: {
                    if (Pipe.this.sinkClosed) {
                        object = new IllegalStateException("closed");
                        throw object;
                    }
                    while (l2 > 0L) {
                        if (!Pipe.this.sourceClosed) {
                            long l3 = Pipe.this.maxBufferSize - Pipe.this.buffer.size();
                            if (l3 == 0L) {
                                this.timeout.waitUntilNotified((Object)Pipe.this.buffer);
                                continue;
                            }
                            l3 = Math.min(l3, l2);
                            Pipe.this.buffer.write(object, l3);
                            l2 -= l3;
                            Pipe.this.buffer.notifyAll();
                            continue;
                        }
                        break block8;
                    }
                    return;
                }
                object = new IOException("source is closed");
                throw object;
            }
        }
    }

    final class PipeSource
    implements Source {
        final Timeout timeout = new Timeout();

        PipeSource() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                Pipe.this.sourceClosed = true;
                Pipe.this.buffer.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public long read(Buffer object, long l2) throws IOException {
            Buffer buffer = Pipe.this.buffer;
            synchronized (buffer) {
                if (Pipe.this.sourceClosed) {
                    object = new IllegalStateException("closed");
                    throw object;
                }
                while (true) {
                    if (Pipe.this.buffer.size() != 0L) {
                        l2 = Pipe.this.buffer.read(object, l2);
                        Pipe.this.buffer.notifyAll();
                        return l2;
                    }
                    if (Pipe.this.sinkClosed) {
                        return -1L;
                    }
                    this.timeout.waitUntilNotified((Object)Pipe.this.buffer);
                }
            }
        }

        public Timeout timeout() {
            return this.timeout;
        }
    }
}

