/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.ws;

import com.mbridge.msdk.thrid.okhttp.internal.ws.WebSocketProtocol;
import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.BufferedSource;
import com.mbridge.msdk.thrid.okio.ByteString;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

final class WebSocketReader {
    boolean closed;
    private final Buffer controlFrameBuffer = new Buffer();
    final FrameCallback frameCallback;
    long frameLength;
    final boolean isClient;
    boolean isControlFrame;
    boolean isFinalFrame;
    private final Buffer.UnsafeCursor maskCursor;
    private final byte[] maskKey;
    private final Buffer messageFrameBuffer = new Buffer();
    int opcode;
    final BufferedSource source;

    WebSocketReader(boolean bl, BufferedSource object, FrameCallback frameCallback) {
        if (object != null) {
            if (frameCallback != null) {
                this.isClient = bl;
                this.source = object;
                this.frameCallback = frameCallback;
                frameCallback = null;
                object = bl ? null : (Object)new byte[4];
                this.maskKey = (byte[])object;
                object = bl ? frameCallback : new Buffer.UnsafeCursor();
                this.maskCursor = object;
                return;
            }
            throw new NullPointerException("frameCallback == null");
        }
        throw new NullPointerException("source == null");
    }

    private void readControlFrame() throws IOException {
        block10: {
            long l2 = this.frameLength;
            if (l2 > 0L) {
                this.source.readFully(this.controlFrameBuffer, l2);
                if (!this.isClient) {
                    this.controlFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                    this.maskCursor.seek(0L);
                    WebSocketProtocol.toggleMask((Buffer.UnsafeCursor)this.maskCursor, (byte[])this.maskKey);
                    this.maskCursor.close();
                }
            }
            switch (this.opcode) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unknown control opcode: ");
                    stringBuilder.append(Integer.toHexString(this.opcode));
                    throw new ProtocolException(stringBuilder.toString());
                }
                case 10: {
                    this.frameCallback.onReadPong(this.controlFrameBuffer.readByteString());
                    break;
                }
                case 9: {
                    this.frameCallback.onReadPing(this.controlFrameBuffer.readByteString());
                    break;
                }
                case 8: {
                    String string2;
                    int n2 = 1005;
                    l2 = this.controlFrameBuffer.size();
                    if (l2 == 1L) break block10;
                    if (l2 != 0L) {
                        n2 = this.controlFrameBuffer.readShort();
                        string2 = this.controlFrameBuffer.readUtf8();
                        String string3 = WebSocketProtocol.closeCodeExceptionMessage((int)n2);
                        if (string3 != null) {
                            throw new ProtocolException(string3);
                        }
                    } else {
                        string2 = "";
                    }
                    this.frameCallback.onReadClose(n2, string2);
                    this.closed = true;
                }
            }
            return;
        }
        throw new ProtocolException("Malformed close payload length of 1.");
    }

    private void readHeader() throws IOException {
        if (!this.closed) {
            int n2;
            int n3;
            long l2 = this.source.timeout().timeoutNanos();
            this.source.timeout().clearTimeout();
            try {
                n3 = this.source.readByte();
                n2 = n3 & 0xFF;
            }
            catch (Throwable throwable) {
                this.source.timeout().timeout(l2, TimeUnit.NANOSECONDS);
                throw throwable;
            }
            this.source.timeout().timeout(l2, TimeUnit.NANOSECONDS);
            this.opcode = n2 & 0xF;
            boolean bl = true;
            boolean bl2 = (n2 & 0x80) != 0;
            this.isFinalFrame = bl2;
            bl2 = (n2 & 8) != 0;
            this.isControlFrame = bl2;
            if (this.isControlFrame && !this.isFinalFrame) {
                throw new ProtocolException("Control frames must be final.");
            }
            n3 = (n2 & 0x40) != 0 ? 1 : 0;
            boolean bl3 = (n2 & 0x20) != 0;
            n2 = (n2 & 0x10) != 0 ? 1 : 0;
            if (n3 == 0 && !bl3 && n2 == 0) {
                n3 = this.source.readByte() & 0xFF;
                bl2 = (n3 & 0x80) != 0 ? bl : false;
                if (bl2 == (bl = this.isClient)) {
                    String string2 = bl ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.";
                    throw new ProtocolException(string2);
                }
                this.frameLength = n3 & 0x7F;
                l2 = this.frameLength;
                if (l2 == 126L) {
                    this.frameLength = (long)this.source.readShort() & 0xFFFFL;
                } else if (l2 == 127L) {
                    this.frameLength = this.source.readLong();
                    if (this.frameLength < 0L) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Frame length 0x");
                        stringBuilder.append(Long.toHexString(this.frameLength));
                        stringBuilder.append(" > 0x7FFFFFFFFFFFFFFF");
                        throw new ProtocolException(stringBuilder.toString());
                    }
                }
                if (this.isControlFrame && this.frameLength > 125L) {
                    throw new ProtocolException("Control frame must be less than 125B.");
                }
                if (bl2) {
                    this.source.readFully(this.maskKey);
                }
                return;
            }
            throw new ProtocolException("Reserved flags are unsupported.");
        }
        throw new IOException("closed");
    }

    private void readMessage() throws IOException {
        while (!this.closed) {
            long l2 = this.frameLength;
            if (l2 > 0L) {
                this.source.readFully(this.messageFrameBuffer, l2);
                if (!this.isClient) {
                    this.messageFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                    this.maskCursor.seek(this.messageFrameBuffer.size() - this.frameLength);
                    WebSocketProtocol.toggleMask((Buffer.UnsafeCursor)this.maskCursor, (byte[])this.maskKey);
                    this.maskCursor.close();
                }
            }
            if (this.isFinalFrame) {
                return;
            }
            this.readUntilNonControlFrame();
            if (this.opcode == 0) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Expected continuation opcode. Got: ");
            stringBuilder.append(Integer.toHexString(this.opcode));
            throw new ProtocolException(stringBuilder.toString());
        }
        IOException iOException = new IOException("closed");
        throw iOException;
    }

    private void readMessageFrame() throws IOException {
        int n2 = this.opcode;
        if (n2 != 1 && n2 != 2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unknown opcode: ");
            stringBuilder.append(Integer.toHexString(n2));
            throw new ProtocolException(stringBuilder.toString());
        }
        this.readMessage();
        if (n2 == 1) {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readUtf8());
        } else {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readByteString());
        }
    }

    private void readUntilNonControlFrame() throws IOException {
        while (!this.closed) {
            this.readHeader();
            if (!this.isControlFrame) break;
            this.readControlFrame();
        }
    }

    void processNextFrame() throws IOException {
        this.readHeader();
        if (this.isControlFrame) {
            this.readControlFrame();
        } else {
            this.readMessageFrame();
        }
    }

    public static interface FrameCallback {
        public void onReadClose(int var1, String var2);

        public void onReadMessage(ByteString var1) throws IOException;

        public void onReadMessage(String var1) throws IOException;

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);
    }
}

