/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.ws;

import com.mbridge.msdk.thrid.okhttp.Call;
import com.mbridge.msdk.thrid.okhttp.Callback;
import com.mbridge.msdk.thrid.okhttp.EventListener;
import com.mbridge.msdk.thrid.okhttp.OkHttpClient;
import com.mbridge.msdk.thrid.okhttp.Protocol;
import com.mbridge.msdk.thrid.okhttp.Request;
import com.mbridge.msdk.thrid.okhttp.Response;
import com.mbridge.msdk.thrid.okhttp.WebSocket;
import com.mbridge.msdk.thrid.okhttp.WebSocketListener;
import com.mbridge.msdk.thrid.okhttp.internal.Internal;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.connection.StreamAllocation;
import com.mbridge.msdk.thrid.okhttp.internal.ws.WebSocketProtocol;
import com.mbridge.msdk.thrid.okhttp.internal.ws.WebSocketReader;
import com.mbridge.msdk.thrid.okhttp.internal.ws.WebSocketWriter;
import com.mbridge.msdk.thrid.okio.BufferedSink;
import com.mbridge.msdk.thrid.okio.BufferedSource;
import com.mbridge.msdk.thrid.okio.ByteString;
import com.mbridge.msdk.thrid.okio.Okio;
import com.mbridge.msdk.thrid.okio.Sink;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final long CANCEL_AFTER_CLOSE_MILLIS = 60000L;
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private static final List<Protocol> ONLY_HTTP1 = Collections.singletonList(Protocol.HTTP_1_1);
    private boolean awaitingPong;
    private Call call;
    private ScheduledFuture<?> cancelFuture;
    private boolean enqueuedClose;
    private ScheduledExecutorService executor;
    private boolean failed;
    private final String key;
    final WebSocketListener listener;
    private final ArrayDeque<Object> messageAndCloseQueue;
    private final Request originalRequest;
    private final long pingIntervalMillis;
    private final ArrayDeque<ByteString> pongQueue = new ArrayDeque();
    private long queueSize;
    private final Random random;
    private WebSocketReader reader;
    private int receivedCloseCode = -1;
    private String receivedCloseReason;
    private int receivedPingCount;
    private int receivedPongCount;
    private int sentPingCount;
    private Streams streams;
    private WebSocketWriter writer;
    private final Runnable writerRunnable;

    public RealWebSocket(Request object, WebSocketListener object2, Random random, long l2) {
        this.messageAndCloseQueue = new ArrayDeque();
        if ("GET".equals(((Request)object).method())) {
            this.originalRequest = object;
            this.listener = object2;
            this.random = random;
            this.pingIntervalMillis = l2;
            object = new byte[16];
            random.nextBytes((byte[])object);
            this.key = ByteString.of((byte[])object).base64();
            this.writerRunnable = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            boolean bl = RealWebSocket.this.writeOneFrame();
                            if (!bl) break;
                        }
                        catch (IOException iOException) {
                            RealWebSocket.this.failWebSocket(iOException, null);
                            break;
                        }
                    }
                }
            };
            return;
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Request must be GET: ");
        ((StringBuilder)object2).append(((Request)object).method());
        throw new IllegalArgumentException(((StringBuilder)object2).toString());
    }

    private void runWriter() {
        ScheduledExecutorService scheduledExecutorService = this.executor;
        if (scheduledExecutorService != null) {
            scheduledExecutorService.execute(this.writerRunnable);
        }
    }

    private boolean send(ByteString byteString, int n2) {
        synchronized (this) {
            if (!this.failed) {
                if (this.enqueuedClose) {
                } else {
                    if (this.queueSize + (long)byteString.size() > 0x1000000L) {
                        this.close(1001, null);
                        return false;
                    }
                    this.queueSize += (long)byteString.size();
                    ArrayDeque<Object> arrayDeque = this.messageAndCloseQueue;
                    Message message = new Message(n2, byteString);
                    arrayDeque.add(message);
                    this.runWriter();
                    return true;
                }
            }
            return false;
        }
    }

    void awaitTermination(int n2, TimeUnit timeUnit) throws InterruptedException {
        this.executor.awaitTermination(n2, timeUnit);
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    void checkResponse(Response object) throws ProtocolException {
        if (((Response)object).code() == 101) {
            CharSequence charSequence = ((Response)object).header("Connection");
            if ("Upgrade".equalsIgnoreCase((String)charSequence)) {
                charSequence = ((Response)object).header("Upgrade");
                if ("websocket".equalsIgnoreCase((String)charSequence)) {
                    object = ((Response)object).header("Sec-WebSocket-Accept");
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append(this.key);
                    ((StringBuilder)charSequence).append("258EAFA5-E914-47DA-95CA-C5AB0DC85B11");
                    charSequence = ByteString.encodeUtf8((String)((StringBuilder)charSequence).toString()).sha1().base64();
                    if (((String)charSequence).equals(object)) {
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Expected 'Sec-WebSocket-Accept' header value '");
                    stringBuilder.append((String)charSequence);
                    stringBuilder.append("' but was '");
                    stringBuilder.append((String)object);
                    stringBuilder.append("'");
                    throw new ProtocolException(stringBuilder.toString());
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Expected 'Upgrade' header value 'websocket' but was '");
                ((StringBuilder)object).append((String)charSequence);
                ((StringBuilder)object).append("'");
                throw new ProtocolException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Expected 'Connection' header value 'Upgrade' but was '");
            ((StringBuilder)object).append((String)charSequence);
            ((StringBuilder)object).append("'");
            throw new ProtocolException(((StringBuilder)object).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected HTTP 101 response but was '");
        stringBuilder.append(((Response)object).code());
        stringBuilder.append(" ");
        stringBuilder.append(((Response)object).message());
        stringBuilder.append("'");
        throw new ProtocolException(stringBuilder.toString());
    }

    @Override
    public boolean close(int n2, String string2) {
        return this.close(n2, string2, 60000L);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean close(int n2, String object, long l2) {
        synchronized (this) {
            WebSocketProtocol.validateCloseCode((int)n2);
            Object object2 = null;
            if (object != null && (long)(object2 = ByteString.encodeUtf8((String)object)).size() > 123L) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("reason.size() > 123: ");
                ((StringBuilder)object2).append((String)object);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(((StringBuilder)object2).toString());
                throw illegalArgumentException;
            }
            if (!this.failed && !this.enqueuedClose) {
                void var3_3;
                this.enqueuedClose = true;
                ArrayDeque<Object> arrayDeque = this.messageAndCloseQueue;
                object = new Close(n2, (ByteString)object2, (long)var3_3);
                arrayDeque.add(object);
                this.runWriter();
                return true;
            }
            return false;
        }
    }

    public void connect(OkHttpClient okHttpClient) {
        okHttpClient = okHttpClient.newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        final Request request = this.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").build();
        this.call = Internal.instance.newWebSocketCall(okHttpClient, request);
        this.call.timeout().clearTimeout();
        this.call.enqueue(new Callback(){

            public void onFailure(Call call2, IOException iOException) {
                RealWebSocket.this.failWebSocket(iOException, null);
            }

            public void onResponse(Call object, Response object2) {
                StreamAllocation streamAllocation;
                try {
                    RealWebSocket.this.checkResponse((Response)object2);
                    streamAllocation = Internal.instance.streamAllocation((Call)object);
                }
                catch (ProtocolException protocolException) {
                    RealWebSocket.this.failWebSocket(protocolException, (Response)object2);
                    Util.closeQuietly((Closeable)object2);
                    return;
                }
                streamAllocation.noNewStreams();
                object = streamAllocation.connection().newWebSocketStreams(streamAllocation);
                try {
                    RealWebSocket.this.listener.onOpen(RealWebSocket.this, (Response)object2);
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("OkHttp WebSocket ");
                    ((StringBuilder)object2).append(request.url().redact());
                    object2 = ((StringBuilder)object2).toString();
                    RealWebSocket.this.initReaderAndWriter((String)object2, (Streams)object);
                    streamAllocation.connection().socket().setSoTimeout(0);
                    RealWebSocket.this.loopReader();
                }
                catch (Exception exception) {
                    RealWebSocket.this.failWebSocket(exception, null);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void failWebSocket(Exception exception, @Nullable Response response) {
        Streams streams;
        synchronized (this) {
            if (this.failed) {
                return;
            }
            this.failed = true;
            streams = this.streams;
            this.streams = null;
            if (this.cancelFuture != null) {
                this.cancelFuture.cancel(false);
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
        try {
            this.listener.onFailure(this, exception, response);
            return;
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initReaderAndWriter(String object, Streams streams) throws IOException {
        synchronized (this) {
            this.streams = streams;
            Object object2 = new WebSocketWriter(streams.client, streams.sink, this.random);
            this.writer = object2;
            object2 = new ScheduledThreadPoolExecutor(1, Util.threadFactory((String)object, false));
            this.executor = object2;
            if (this.pingIntervalMillis != 0L) {
                object2 = this.executor;
                object = new PingRunnable();
                object2.scheduleAtFixedRate((Runnable)object, this.pingIntervalMillis, this.pingIntervalMillis, TimeUnit.MILLISECONDS);
            }
            if (!this.messageAndCloseQueue.isEmpty()) {
                this.runWriter();
            }
        }
        this.reader = new WebSocketReader(streams.client, streams.source, this);
    }

    public void loopReader() throws IOException {
        while (this.receivedCloseCode == -1) {
            this.reader.processNextFrame();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onReadClose(int n2, String object) {
        Streams streams;
        if (n2 == -1) throw new IllegalArgumentException();
        synchronized (this) {
            if (this.receivedCloseCode != -1) {
                object = new IllegalStateException("already closed");
                throw object;
            }
            this.receivedCloseCode = n2;
            this.receivedCloseReason = object;
            if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                streams = this.streams;
                this.streams = null;
                if (this.cancelFuture != null) {
                    this.cancelFuture.cancel(false);
                }
                this.executor.shutdown();
            } else {
                streams = null;
            }
        }
        try {
            this.listener.onClosing(this, n2, (String)object);
            if (streams == null) return;
            this.listener.onClosed(this, n2, (String)object);
            return;
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    @Override
    public void onReadMessage(ByteString byteString) throws IOException {
        this.listener.onMessage((WebSocket)this, byteString);
    }

    @Override
    public void onReadMessage(String string2) throws IOException {
        this.listener.onMessage((WebSocket)this, string2);
    }

    @Override
    public void onReadPing(ByteString byteString) {
        synchronized (this) {
            if (!(this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty())) {
                this.pongQueue.add(byteString);
                this.runWriter();
                ++this.receivedPingCount;
                return;
            }
            return;
        }
    }

    @Override
    public void onReadPong(ByteString byteString) {
        synchronized (this) {
            ++this.receivedPongCount;
            this.awaitingPong = false;
            return;
        }
    }

    boolean pong(ByteString byteString) {
        synchronized (this) {
            if (!this.failed) {
                if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                } else {
                    this.pongQueue.add(byteString);
                    this.runWriter();
                    return true;
                }
            }
            return false;
        }
    }

    boolean processNextFrame() throws IOException {
        boolean bl = false;
        try {
            this.reader.processNextFrame();
            int n2 = this.receivedCloseCode;
            if (n2 == -1) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            this.failWebSocket(exception, null);
            return false;
        }
    }

    @Override
    public long queueSize() {
        synchronized (this) {
            long l2 = this.queueSize;
            return l2;
        }
    }

    int receivedPingCount() {
        synchronized (this) {
            int n2 = this.receivedPingCount;
            return n2;
        }
    }

    int receivedPongCount() {
        synchronized (this) {
            int n2 = this.receivedPongCount;
            return n2;
        }
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public boolean send(ByteString byteString) {
        if (byteString != null) {
            return this.send(byteString, 2);
        }
        throw new NullPointerException("bytes == null");
    }

    @Override
    public boolean send(String string2) {
        if (string2 != null) {
            return this.send(ByteString.encodeUtf8((String)string2), 1);
        }
        throw new NullPointerException("text == null");
    }

    int sentPingCount() {
        synchronized (this) {
            int n2 = this.sentPingCount;
            return n2;
        }
    }

    void tearDown() throws InterruptedException {
        ScheduledFuture<?> scheduledFuture = this.cancelFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeOneFrame() throws IOException {
        block15: {
            block16: {
                synchronized (this) {
                    block14: {
                        block19: {
                            block17: {
                                block18: {
                                    if (this.failed) {
                                        return false;
                                    }
                                    var1_1 = this.writer;
                                    var2_2 = this.pongQueue.poll();
                                    var3_3 = null;
                                    if (var2_2 != null) break block17;
                                    var4_4 = this.messageAndCloseQueue.poll();
                                    if (!(var4_4 instanceof Close)) break block18;
                                    var5_6 = this.receivedCloseCode;
                                    var6_7 = this.receivedCloseReason;
                                    if (var5_6 != -1) {
                                        var7_8 = this.streams;
                                        this.streams = null;
                                        this.executor.shutdown();
                                        var8_9 = var4_4;
                                        var4_4 = var6_7;
                                        break block14;
                                    } else {
                                        var7_8 = this.executor;
                                        var8_9 = new CancelRunnable();
                                        this.cancelFuture = var7_8.schedule((Runnable)var8_9, ((Close)var4_4).cancelAfterCloseMillis, TimeUnit.MILLISECONDS);
                                        var7_8 = var3_3;
                                        var8_9 = var4_4;
                                        var4_4 = var6_7;
                                    }
                                    break block14;
                                }
                                if (var4_4 == null) {
                                    return false;
                                }
                                var7_8 = var4_4;
                                break block19;
                            }
                            var7_8 = null;
                        }
                        var4_4 = null;
                        var5_6 = -1;
                        var8_9 = var7_8;
                        var7_8 = var3_3;
                    }
                    if (var2_2 == null) ** GOTO lbl43
                }
                try {
                    var1_1.writePong(var2_2);
                    break block15;
lbl43:
                    // 1 sources

                    if (!(var8_9 instanceof Message)) break block16;
                    var4_4 = ((Message)var8_9).data;
                    var8_9 = Okio.buffer((Sink)var1_1.newMessageSink(((Message)var8_9).formatOpcode, (long)var4_4.size()));
                    var8_9.write((ByteString)var4_4);
                    var8_9.close();
                    synchronized (this) {
                    }
                }
                catch (Throwable var4_5) {
                    Util.closeQuietly((Closeable)var7_8);
                    throw var4_5;
                }
                {
                    this.queueSize -= (long)var4_4.size();
                    break block15;
                }
            }
            if (!(var8_9 instanceof Close)) ** GOTO lbl-1000
            var8_9 = (Close)var8_9;
            var1_1.writeClose(var8_9.code, var8_9.reason);
            if (var7_8 != null) {
                this.listener.onClosed(this, var5_6, (String)var4_4);
            }
        }
        Util.closeQuietly((Closeable)var7_8);
        return true;
lbl-1000:
        // 1 sources

        {
            var4_4 = new AssertionError();
            throw var4_4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void writePingFrame() {
        // MONITORENTER : this
        if (this.failed) {
            // MONITOREXIT : this
            return;
        }
        Object object = this.writer;
        int n2 = this.awaitingPong ? this.sentPingCount : -1;
        ++this.sentPingCount;
        this.awaitingPong = true;
        // MONITOREXIT : this
        if (n2 != -1) {
            object = new StringBuilder();
            ((StringBuilder)object).append("sent ping but didn't receive pong within ");
            ((StringBuilder)object).append(this.pingIntervalMillis);
            ((StringBuilder)object).append("ms (after ");
            ((StringBuilder)object).append(n2 - 1);
            ((StringBuilder)object).append(" successful ping/pongs)");
            this.failWebSocket(new SocketTimeoutException(((StringBuilder)object).toString()), null);
            return;
        }
        try {
            object.writePing(ByteString.EMPTY);
            return;
        }
        catch (IOException iOException) {
            this.failWebSocket(iOException, null);
        }
    }

    final class CancelRunnable
    implements Runnable {
        CancelRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.cancel();
        }
    }

    static final class Close {
        final long cancelAfterCloseMillis;
        final int code;
        final ByteString reason;

        Close(int n2, ByteString byteString, long l2) {
            this.code = n2;
            this.reason = byteString;
            this.cancelAfterCloseMillis = l2;
        }
    }

    static final class Message {
        final ByteString data;
        final int formatOpcode;

        Message(int n2, ByteString byteString) {
            this.formatOpcode = n2;
            this.data = byteString;
        }
    }

    private final class PingRunnable
    implements Runnable {
        PingRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.writePingFrame();
        }
    }

    public static abstract class Streams
    implements Closeable {
        public final boolean client;
        public final BufferedSink sink;
        public final BufferedSource source;

        public Streams(boolean bl, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.client = bl;
            this.source = bufferedSource;
            this.sink = bufferedSink;
        }
    }
}

