/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.platform;

import com.mbridge.msdk.thrid.okhttp.Protocol;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.platform.Platform;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocket;

class JdkWithJettyBootPlatform
extends Platform {
    private final Class<?> clientProviderClass;
    private final Method getMethod;
    private final Method putMethod;
    private final Method removeMethod;
    private final Class<?> serverProviderClass;

    JdkWithJettyBootPlatform(Method method, Method method2, Method method3, Class<?> clazz, Class<?> clazz2) {
        this.putMethod = method;
        this.getMethod = method2;
        this.removeMethod = method3;
        this.clientProviderClass = clazz;
        this.serverProviderClass = clazz2;
    }

    public static Platform buildIfSupported() {
        try {
            Object object = Class.forName("org.eclipse.jetty.alpn.ALPN");
            Serializable serializable = new StringBuilder();
            serializable.append("org.eclipse.jetty.alpn.ALPN");
            serializable.append("$Provider");
            serializable = Class.forName(serializable.toString());
            Serializable serializable2 = new StringBuilder();
            serializable2.append("org.eclipse.jetty.alpn.ALPN");
            serializable2.append("$ClientProvider");
            serializable2 = Class.forName(serializable2.toString());
            Serializable serializable3 = new StringBuilder();
            serializable3.append("org.eclipse.jetty.alpn.ALPN");
            serializable3.append("$ServerProvider");
            serializable3 = Class.forName(serializable3.toString());
            object = new JdkWithJettyBootPlatform(((Class)object).getMethod("put", new Class[]{SSLSocket.class, serializable}), ((Class)object).getMethod("get", SSLSocket.class), ((Class)object).getMethod("remove", SSLSocket.class), (Class<?>)serializable2, (Class<?>)serializable3);
            return object;
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void afterHandshake(SSLSocket sSLSocket) {
        void var1_4;
        try {
            this.removeMethod.invoke(null, sSLSocket);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw Util.assertionError("unable to remove alpn", (Exception)var1_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String object, List<Protocol> object2) {
        void var1_4;
        List<String> list = JdkWithJettyBootPlatform.alpnProtocolNames(object2);
        try {
            object2 = Platform.class.getClassLoader();
            Class<?> clazz = this.clientProviderClass;
            object = this.serverProviderClass;
            JettyNegoProvider jettyNegoProvider = new JettyNegoProvider(list);
            object = Proxy.newProxyInstance((ClassLoader)object2, new Class[]{clazz, object}, (InvocationHandler)jettyNegoProvider);
            this.putMethod.invoke(null, sSLSocket, object);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        throw Util.assertionError("unable to set alpn", (Exception)var1_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket object) {
        void var1_4;
        block9: {
            block8: {
                block7: {
                    Object var3_6;
                    block6: {
                        Method method = this.getMethod;
                        var3_6 = null;
                        object = (JettyNegoProvider)Proxy.getInvocationHandler(method.invoke(null, object));
                        if (((JettyNegoProvider)object).unsupported || ((JettyNegoProvider)object).selected != null) break block6;
                        Platform.get().log(4, "ALPN callback dropped: HTTP/2 is disabled. Is alpn-boot on the boot class path?", null);
                        return null;
                    }
                    if (!((JettyNegoProvider)object).unsupported) break block7;
                    object = var3_6;
                    break block8;
                }
                try {
                    object = ((JettyNegoProvider)object).selected;
                }
                catch (IllegalAccessException illegalAccessException) {
                    break block9;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return object;
        }
        throw Util.assertionError("unable to get selected protocol", (Exception)var1_4);
    }

    private static class JettyNegoProvider
    implements InvocationHandler {
        private final List<String> protocols;
        String selected;
        boolean unsupported;

        JettyNegoProvider(List<String> list) {
            this.protocols = list;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string2 = method.getName();
            Class<?> clazz = method.getReturnType();
            object = objectArray;
            if (objectArray == null) {
                object = Util.EMPTY_STRING_ARRAY;
            }
            if (string2.equals("supports") && Boolean.TYPE == clazz) {
                return true;
            }
            if (string2.equals("unsupported") && Void.TYPE == clazz) {
                this.unsupported = true;
                return null;
            }
            if (string2.equals("protocols") && ((Object[])object).length == 0) {
                return this.protocols;
            }
            if ((string2.equals("selectProtocol") || string2.equals("select")) && String.class == clazz && ((Object[])object).length == 1 && object[0] instanceof List) {
                object = (List)object[0];
                int n2 = object.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!this.protocols.contains(object.get(i2))) continue;
                    this.selected = object = (String)object.get(i2);
                    return object;
                }
                this.selected = object = this.protocols.get(0);
                return object;
            }
            if ((string2.equals("protocolSelected") || string2.equals("selected")) && ((Object[])object).length == 1) {
                this.selected = (String)object[0];
                return null;
            }
            return method.invoke((Object)this, (Object[])object);
        }
    }
}

