/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.platform;

import com.mbridge.msdk.thrid.okhttp.Protocol;
import com.mbridge.msdk.thrid.okhttp.internal.platform.Platform;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.conscrypt.Conscrypt;

public class ConscryptPlatform
extends Platform {
    private ConscryptPlatform() {
    }

    public static ConscryptPlatform buildIfSupported() {
        block3: {
            try {
                Class.forName("org.conscrypt.Conscrypt");
                if (Conscrypt.isAvailable()) break block3;
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        ConscryptPlatform conscryptPlatform = new ConscryptPlatform();
        return conscryptPlatform;
    }

    private Provider getProvider() {
        return Conscrypt.newProviderBuilder().provideTrustManager().build();
    }

    @Override
    public void configureSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
        if (Conscrypt.isConscrypt((SSLSocketFactory)sSLSocketFactory)) {
            Conscrypt.setUseEngineSocket((SSLSocketFactory)sSLSocketFactory, (boolean)true);
        }
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String string2, List<Protocol> list) throws IOException {
        if (Conscrypt.isConscrypt((SSLSocket)sSLSocket)) {
            if (string2 != null) {
                Conscrypt.setUseSessionTickets((SSLSocket)sSLSocket, (boolean)true);
                Conscrypt.setHostname((SSLSocket)sSLSocket, (String)string2);
            }
            Conscrypt.setApplicationProtocols((SSLSocket)sSLSocket, (String[])Platform.alpnProtocolNames(list).toArray(new String[0]));
        } else {
            super.configureTlsExtensions(sSLSocket, string2, list);
        }
    }

    @Override
    public SSLContext getSSLContext() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLSv1.3", this.getProvider());
            return sSLContext;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS", this.getProvider());
                return sSLContext;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
            }
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        if (Conscrypt.isConscrypt((SSLSocket)sSLSocket)) {
            return Conscrypt.getApplicationProtocol((SSLSocket)sSLSocket);
        }
        return super.getSelectedProtocol(sSLSocket);
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(SSLSocketFactory object) {
        block4: {
            if (!Conscrypt.isConscrypt((SSLSocketFactory)object)) {
                return super.trustManager((SSLSocketFactory)object);
            }
            try {
                object = ConscryptPlatform.readFieldOrNull(object, Object.class, "sslParameters");
                if (object == null) break block4;
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException("clientBuilder.sslSocketFactory(SSLSocketFactory) not supported on Conscrypt", exception);
            }
            object = ConscryptPlatform.readFieldOrNull(object, X509TrustManager.class, "x509TrustManager");
            return object;
        }
        return null;
    }
}

