/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.platform;

import android.os.Build;
import android.util.Log;
import com.mbridge.msdk.thrid.okhttp.Protocol;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.platform.OptionalMethod;
import com.mbridge.msdk.thrid.okhttp.internal.platform.Platform;
import com.mbridge.msdk.thrid.okhttp.internal.tls.CertificateChainCleaner;
import com.mbridge.msdk.thrid.okhttp.internal.tls.TrustRootIndex;
import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final CloseGuard closeGuard = CloseGuard.get();
    private final OptionalMethod<Socket> getAlpnSelectedProtocol;
    private final OptionalMethod<Socket> setAlpnProtocols;
    private final OptionalMethod<Socket> setHostname;
    private final OptionalMethod<Socket> setUseSessionTickets;
    private final Class<?> sslParametersClass;

    AndroidPlatform(Class<?> clazz, OptionalMethod<Socket> optionalMethod, OptionalMethod<Socket> optionalMethod2, OptionalMethod<Socket> optionalMethod3, OptionalMethod<Socket> optionalMethod4) {
        this.sslParametersClass = clazz;
        this.setUseSessionTickets = optionalMethod;
        this.setHostname = optionalMethod2;
        this.getAlpnSelectedProtocol = optionalMethod3;
        this.setAlpnProtocols = optionalMethod4;
    }

    private boolean api23IsCleartextTrafficPermitted(String string2, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            boolean bl = (Boolean)clazz.getMethod("isCleartextTrafficPermitted", new Class[0]).invoke(object, new Object[0]);
            return bl;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.isCleartextTrafficPermitted(string2);
        }
    }

    private boolean api24IsCleartextTrafficPermitted(String string2, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            boolean bl = (Boolean)clazz.getMethod("isCleartextTrafficPermitted", String.class).invoke(object, string2);
            return bl;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.api23IsCleartextTrafficPermitted(string2, clazz, object);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Platform buildIfSupported() {
        if (!Platform.isAndroid()) {
            return null;
        }
        try {
            var0 = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            ** GOTO lbl9
        }
        catch (ClassNotFoundException var0_1) {
            try {
                var0 = Class.forName("org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
lbl9:
                // 2 sources

                var1_3 = new OptionalMethod(null, "setUseSessionTickets", new Class[]{Boolean.TYPE});
                var2_4 = new OptionalMethod(null, "setHostname", new Class[]{String.class});
                if (AndroidPlatform.supportsAlpn()) {
                    var3_5 = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
                    var4_6 = new OptionalMethod(null, "setAlpnProtocols", new Class[]{byte[].class});
                    return new AndroidPlatform((Class<?>)var0, (OptionalMethod<Socket>)var1_3, (OptionalMethod<Socket>)var2_4, (OptionalMethod<Socket>)var3_5, (OptionalMethod<Socket>)var4_6);
                } else {
                    var4_6 = var3_5 = null;
                }
                return new AndroidPlatform((Class<?>)var0, (OptionalMethod<Socket>)var1_3, (OptionalMethod<Socket>)var2_4, (OptionalMethod<Socket>)var3_5, (OptionalMethod<Socket>)var4_6);
            }
            catch (ClassNotFoundException var0_2) {
                return null;
            }
        }
    }

    static int getSdkInt() {
        try {
            int n2 = Build.VERSION.SDK_INT;
            return n2;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return 0;
        }
    }

    private static boolean supportsAlpn() {
        if (Security.getProvider("GMSCore_OpenSSL") != null) {
            return true;
        }
        try {
            Class.forName("android.net.Network");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        try {
            Object object = Class.forName("android.net.http.X509TrustManagerExtensions");
            object = new AndroidCertificateChainCleaner(object.getConstructor(X509TrustManager.class).newInstance(x509TrustManager), object.getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class));
            return object;
        }
        catch (Exception exception) {
            return super.buildCertificateChainCleaner(x509TrustManager);
        }
    }

    @Override
    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        try {
            Object object = x509TrustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", X509Certificate.class);
            ((Method)object).setAccessible(true);
            object = new AndroidTrustRootIndex(x509TrustManager, (Method)object);
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.buildTrustRootIndex(x509TrustManager);
        }
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String object, List<Protocol> list) throws IOException {
        if (object != null) {
            this.setUseSessionTickets.invokeOptionalWithoutCheckedException((Object)sSLSocket, new Object[]{true});
            this.setHostname.invokeOptionalWithoutCheckedException((Object)sSLSocket, new Object[]{object});
        }
        if ((object = this.setAlpnProtocols) != null && object.isSupported((Object)sSLSocket)) {
            object = AndroidPlatform.concatLengthPrefixed(list);
            this.setAlpnProtocols.invokeWithoutCheckedException((Object)sSLSocket, new Object[]{object});
        }
    }

    @Override
    public void connectSocket(Socket object, InetSocketAddress inetSocketAddress, int n2) throws IOException {
        try {
            ((Socket)object).connect(inetSocketAddress, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                object = new IOException("Exception in connect");
                ((Throwable)object).initCause(classCastException);
                throw object;
            }
            throw classCastException;
        }
        catch (SecurityException securityException) {
            object = new IOException("Exception in connect");
            ((Throwable)object).initCause(securityException);
            throw object;
        }
        catch (AssertionError assertionError) {
            if (Util.isAndroidGetsocknameError(assertionError)) {
                throw new IOException((Throwable)((Object)assertionError));
            }
            throw assertionError;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SSLContext getSSLContext() {
        boolean bl = true;
        try {
            int n2;
            if (Build.VERSION.SDK_INT < 16 || (n2 = Build.VERSION.SDK_INT) >= 22) {
                bl = false;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (bl) {
            try {
                return SSLContext.getInstance("TLSv1.2");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket object) {
        Object object2 = this.getAlpnSelectedProtocol;
        Object var3_3 = null;
        if (object2 == null) {
            return null;
        }
        if (!object2.isSupported(object)) {
            return null;
        }
        object2 = (byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException(object, new Object[0]);
        object = var3_3;
        if (object2 != null) {
            object = new String((byte[])object2, Util.UTF_8);
        }
        return object;
    }

    @Override
    public Object getStackTraceForCloseable(String string2) {
        return this.closeGuard.createAndOpen(string2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isCleartextTrafficPermitted(String string2) {
        void var1_5;
        if (Build.VERSION.SDK_INT < 23) {
            return super.isCleartextTrafficPermitted(string2);
        }
        try {
            Class<?> clazz = Class.forName("android.security.NetworkSecurityPolicy");
            return this.api24IsCleartextTrafficPermitted(string2, clazz, clazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Util.assertionError("unable to determine cleartext support", (Exception)var1_5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Util.assertionError("unable to determine cleartext support", (Exception)var1_5);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
            throw Util.assertionError("unable to determine cleartext support", (Exception)var1_5);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return super.isCleartextTrafficPermitted(string2);
        }
    }

    @Override
    public void log(int n2, String string2, @Nullable Throwable throwable) {
        int n3 = 5;
        if (n2 != 5) {
            n3 = 3;
        }
        CharSequence charSequence = string2;
        if (throwable != null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append('\n');
            ((StringBuilder)charSequence).append(Log.getStackTraceString((Throwable)throwable));
            charSequence = ((StringBuilder)charSequence).toString();
        }
        n2 = 0;
        int n4 = ((String)charSequence).length();
        block0: while (n2 < n4) {
            int n5 = ((String)charSequence).indexOf(10, n2);
            if (n5 == -1) {
                n5 = n4;
            }
            while (true) {
                int n6 = Math.min(n5, n2 + 4000);
                Log.println((int)n3, (String)"OkHttp", (String)((String)charSequence).substring(n2, n6));
                if (n6 >= n5) {
                    n2 = n6 + 1;
                    continue block0;
                }
                n2 = n6;
            }
        }
    }

    @Override
    public void logCloseableLeak(String string2, Object object) {
        if (!this.closeGuard.warnIfOpen(object)) {
            this.log(5, string2, null);
        }
    }

    @Override
    @Nullable
    protected X509TrustManager trustManager(SSLSocketFactory object) {
        Object obj;
        Object obj2 = obj = AndroidPlatform.readFieldOrNull(object, this.sslParametersClass, "sslParameters");
        if (obj == null) {
            try {
                obj2 = AndroidPlatform.readFieldOrNull(object, Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, object.getClass().getClassLoader()), "sslParameters");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.trustManager((SSLSocketFactory)object);
            }
        }
        if ((object = AndroidPlatform.readFieldOrNull(obj2, X509TrustManager.class, "x509TrustManager")) != null) {
            return object;
        }
        return AndroidPlatform.readFieldOrNull(obj2, X509TrustManager.class, "trustManager");
    }

    static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Method checkServerTrusted;
        private final Object x509TrustManagerExtensions;

        AndroidCertificateChainCleaner(Object object, Method method) {
            this.x509TrustManagerExtensions = object;
            this.checkServerTrusted = method;
        }

        public List<Certificate> clean(List<Certificate> object, String object2) throws SSLPeerUnverifiedException {
            try {
                object = object.toArray(new X509Certificate[object.size()]);
                object = (List)this.checkServerTrusted.invoke(this.x509TrustManagerExtensions, object, "RSA", object2);
                return object;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                object2 = new SSLPeerUnverifiedException(invocationTargetException.getMessage());
                ((Throwable)object2).initCause(invocationTargetException);
                throw object2;
            }
        }

        public boolean equals(Object object) {
            return object instanceof AndroidCertificateChainCleaner;
        }

        public int hashCode() {
            return 0;
        }
    }

    static final class AndroidTrustRootIndex
    implements TrustRootIndex {
        private final Method findByIssuerAndSignatureMethod;
        private final X509TrustManager trustManager;

        AndroidTrustRootIndex(X509TrustManager x509TrustManager, Method method) {
            this.findByIssuerAndSignatureMethod = method;
            this.trustManager = x509TrustManager;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (object == this) {
                return true;
            }
            if (!(object instanceof AndroidTrustRootIndex)) {
                return false;
            }
            object = (AndroidTrustRootIndex)object;
            if (!this.trustManager.equals(((AndroidTrustRootIndex)object).trustManager) || !this.findByIssuerAndSignatureMethod.equals(((AndroidTrustRootIndex)object).findByIssuerAndSignatureMethod)) {
                bl = false;
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
            Object var2_4 = null;
            TrustAnchor trustAnchor = (TrustAnchor)this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, x509Certificate);
            x509Certificate = var2_4;
            if (trustAnchor == null) return x509Certificate;
            try {
                return trustAnchor.getTrustedCert();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw Util.assertionError("unable to get issues and signature", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                return var2_4;
            }
        }

        public int hashCode() {
            return this.trustManager.hashCode() + this.findByIssuerAndSignatureMethod.hashCode() * 31;
        }
    }

    static final class CloseGuard {
        private final Method getMethod;
        private final Method openMethod;
        private final Method warnIfOpenMethod;

        CloseGuard(Method method, Method method2, Method method3) {
            this.getMethod = method;
            this.openMethod = method2;
            this.warnIfOpenMethod = method3;
        }

        static CloseGuard get() {
            GenericDeclaration genericDeclaration;
            GenericDeclaration genericDeclaration2;
            Method method = null;
            try {
                genericDeclaration2 = Class.forName("dalvik.system.CloseGuard");
                Method method2 = genericDeclaration2.getMethod("get", new Class[0]);
                genericDeclaration = genericDeclaration2.getMethod("open", String.class);
                genericDeclaration2 = genericDeclaration2.getMethod("warnIfOpen", new Class[0]);
                method = method2;
            }
            catch (Exception exception) {
                genericDeclaration = genericDeclaration2 = null;
            }
            return new CloseGuard(method, (Method)genericDeclaration, (Method)genericDeclaration2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Object createAndOpen(String string2) {
            Object object = this.getMethod;
            if (object == null) return null;
            try {
                object = ((Method)object).invoke(null, new Object[0]);
                this.openMethod.invoke(object, string2);
                return object;
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean warnIfOpen(Object object) {
            boolean bl;
            boolean bl2 = bl = false;
            if (object == null) return bl2;
            try {
                this.warnIfOpenMethod.invoke(object, new Object[0]);
                return true;
            }
            catch (Exception exception) {
                return bl;
            }
        }
    }
}

