/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.http2;

import com.mbridge.msdk.thrid.okhttp.Headers;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.http2.ErrorCode;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Header;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Http2Connection;
import com.mbridge.msdk.thrid.okhttp.internal.http2.StreamResetException;
import com.mbridge.msdk.thrid.okio.AsyncTimeout;
import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.BufferedSource;
import com.mbridge.msdk.thrid.okio.Sink;
import com.mbridge.msdk.thrid.okio.Source;
import com.mbridge.msdk.thrid.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;

public final class Http2Stream {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    long bytesLeftInWriteWindow;
    final Http2Connection connection;
    ErrorCode errorCode = null;
    private boolean hasResponseHeaders;
    private Header.Listener headersListener;
    private final Deque<Headers> headersQueue = new ArrayDeque<Headers>();
    final int id;
    final StreamTimeout readTimeout = new StreamTimeout();
    final FramingSink sink;
    private final FramingSource source;
    long unacknowledgedBytesRead = 0L;
    final StreamTimeout writeTimeout = new StreamTimeout();

    Http2Stream(int n2, Http2Connection http2Connection, boolean bl, boolean bl2, @Nullable Headers headers) {
        if (http2Connection != null) {
            this.id = n2;
            this.connection = http2Connection;
            this.bytesLeftInWriteWindow = http2Connection.peerSettings.getInitialWindowSize();
            this.source = new FramingSource(http2Connection.okHttpSettings.getInitialWindowSize());
            this.sink = new FramingSink();
            this.source.finished = bl2;
            this.sink.finished = bl;
            if (headers != null) {
                this.headersQueue.add(headers);
            }
            if (this.isLocallyInitiated() && headers != null) {
                throw new IllegalStateException("locally-initiated streams shouldn't have headers yet");
            }
            if (!this.isLocallyInitiated() && headers == null) {
                throw new IllegalStateException("remotely-initiated streams should have headers");
            }
            return;
        }
        throw new NullPointerException("connection == null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean closeInternal(ErrorCode errorCode) {
        synchronized (this) {
            if (this.errorCode != null) {
                return false;
            }
            if (this.source.finished && this.sink.finished) {
                return false;
            }
            this.errorCode = errorCode;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    void addBytesToWriteWindow(long l2) {
        this.bytesLeftInWriteWindow += l2;
        if (l2 > 0L) {
            this.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void cancelStreamIfNecessary() throws IOException {
        // MONITORENTER : this
        boolean bl = !this.source.finished && this.source.closed && (this.sink.finished || this.sink.closed);
        boolean bl2 = this.isOpen();
        // MONITOREXIT : this
        if (bl) {
            this.close(ErrorCode.CANCEL);
            return;
        }
        if (bl2) return;
        this.connection.removeStream(this.id);
    }

    void checkOutNotClosed() throws IOException {
        if (!this.sink.closed) {
            if (!this.sink.finished) {
                ErrorCode errorCode = this.errorCode;
                if (errorCode == null) {
                    return;
                }
                throw new StreamResetException(errorCode);
            }
            throw new IOException("stream finished");
        }
        throw new IOException("stream closed");
    }

    public void close(ErrorCode errorCode) throws IOException {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, errorCode);
    }

    public void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public ErrorCode getErrorCode() {
        synchronized (this) {
            ErrorCode errorCode = this.errorCode;
            return errorCode;
        }
    }

    public int getId() {
        return this.id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sink getSink() {
        synchronized (this) {
            if (!this.hasResponseHeaders && !this.isLocallyInitiated()) {
                IllegalStateException illegalStateException = new IllegalStateException("reply before requesting the sink");
                throw illegalStateException;
            }
            return this.sink;
        }
    }

    public Source getSource() {
        return this.source;
    }

    public boolean isLocallyInitiated() {
        int n2 = this.id;
        boolean bl = true;
        boolean bl2 = (n2 & 1) == 1;
        bl2 = this.connection.client == bl2 ? bl : false;
        return bl2;
    }

    public boolean isOpen() {
        synchronized (this) {
            block5: {
                boolean bl;
                block4: {
                    ErrorCode errorCode = this.errorCode;
                    if (errorCode == null) break block4;
                    return false;
                }
                if (!this.source.finished && !this.source.closed || !this.sink.finished && !this.sink.closed || !(bl = this.hasResponseHeaders)) break block5;
                return false;
            }
            return true;
        }
    }

    public Timeout readTimeout() {
        return this.readTimeout;
    }

    void receiveData(BufferedSource bufferedSource, int n2) throws IOException {
        this.source.receive(bufferedSource, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void receiveFin() {
        // MONITORENTER : this
        this.source.finished = true;
        boolean bl = this.isOpen();
        this.notifyAll();
        // MONITOREXIT : this
        if (bl) return;
        this.connection.removeStream(this.id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void receiveHeaders(List<Header> list) {
        // MONITORENTER : this
        this.hasResponseHeaders = true;
        this.headersQueue.add(Util.toHeaders(list));
        boolean bl = this.isOpen();
        this.notifyAll();
        // MONITOREXIT : this
        if (bl) return;
        this.connection.removeStream(this.id);
    }

    void receiveRstStream(ErrorCode errorCode) {
        synchronized (this) {
            if (this.errorCode == null) {
                this.errorCode = errorCode;
                this.notifyAll();
            }
            return;
        }
    }

    public void setHeadersListener(Header.Listener listener2) {
        synchronized (this) {
            this.headersListener = listener2;
            if (!this.headersQueue.isEmpty() && listener2 != null) {
                this.notifyAll();
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Headers takeHeaders() throws IOException {
        synchronized (this) {
            this.readTimeout.enter();
            try {
                while (this.headersQueue.isEmpty() && this.errorCode == null) {
                    this.waitForIo();
                }
            }
            finally {
                this.readTimeout.exitAndThrowIfTimedOut();
            }
            {
                if (!this.headersQueue.isEmpty()) {
                    return this.headersQueue.removeFirst();
                }
                StreamResetException streamResetException = new StreamResetException(this.errorCode);
                throw streamResetException;
            }
        }
    }

    void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeHeaders(List<Header> list, boolean bl) throws IOException {
        boolean bl2;
        if (list == null) {
            throw new NullPointerException("headers == null");
        }
        synchronized (this) {
            this.hasResponseHeaders = true;
            if (!bl) {
                this.sink.finished = true;
                bl2 = true;
                bl = true;
            } else {
                bl2 = false;
                bl = false;
            }
        }
        boolean bl3 = bl2;
        if (!bl2) {
            Http2Connection http2Connection = this.connection;
            synchronized (http2Connection) {
                bl2 = this.connection.bytesLeftInWriteWindow == 0L;
            }
            bl3 = bl2;
        }
        this.connection.writeSynReply(this.id, bl, list);
        if (bl3) {
            this.connection.flush();
        }
    }

    public Timeout writeTimeout() {
        return this.writeTimeout;
    }

    final class FramingSink
    implements Sink {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        private static final long EMIT_BUFFER_SIZE = 16384L;
        boolean closed;
        boolean finished;
        private final Buffer sendBuffer = new Buffer();

        FramingSink() {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void emitFrame(boolean bl) throws IOException {
            long l2;
            Object object = Http2Stream.this;
            synchronized (object) {
                Http2Stream.this.writeTimeout.enter();
                while (Http2Stream.this.bytesLeftInWriteWindow <= 0L && !this.finished && !this.closed && Http2Stream.this.errorCode == null) {
                    Http2Stream.this.waitForIo();
                }
                Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                Http2Stream.this.checkOutNotClosed();
                l2 = Math.min(Http2Stream.this.bytesLeftInWriteWindow, this.sendBuffer.size());
                Http2Stream http2Stream = Http2Stream.this;
                http2Stream.bytesLeftInWriteWindow -= l2;
            }
            Http2Stream.this.writeTimeout.enter();
            try {
                object = Http2Stream.this.connection;
                int n2 = Http2Stream.this.id;
                bl = bl && l2 == this.sendBuffer.size();
                ((Http2Connection)object).writeData(n2, bl, this.sendBuffer, l2);
                return;
            }
            finally {
                Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
            }
            {
                catch (Throwable throwable) {
                    Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws IOException {
            Http2Stream http2Stream;
            block11: {
                http2Stream = Http2Stream.this;
                synchronized (http2Stream) {
                    if (this.closed) {
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 4] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (Http2Stream.this.sink.finished) break block11;
                    {
                        catch (Throwable throwable) {}
                        {
                            throw throwable;
                        }
                    }
                }
                if (this.sendBuffer.size() > 0L) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                } else {
                    Http2Stream.this.connection.writeData(Http2Stream.this.id, true, null, 0L);
                }
            }
            http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                this.closed = true;
            }
            Http2Stream.this.connection.flush();
            Http2Stream.this.cancelStreamIfNecessary();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void flush() throws IOException {
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                Http2Stream.this.checkOutNotClosed();
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitFrame(false);
                Http2Stream.this.connection.flush();
            }
        }

        public Timeout timeout() {
            return Http2Stream.this.writeTimeout;
        }

        public void write(Buffer buffer, long l2) throws IOException {
            this.sendBuffer.write(buffer, l2);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }
    }

    private final class FramingSource
    implements Source {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        boolean closed;
        boolean finished;
        private final long maxByteCount;
        private final Buffer readBuffer;
        private final Buffer receiveBuffer = new Buffer();

        FramingSource(long l2) {
            this.readBuffer = new Buffer();
            this.maxByteCount = l2;
        }

        private void updateConnectionFlowControl(long l2) {
            Http2Stream.this.connection.updateConnectionFlowControl(l2);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void close() throws IOException {
            Header.Listener listener2;
            Object object;
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                this.closed = true;
                long l2 = this.readBuffer.size();
                this.readBuffer.clear();
                boolean bl = Http2Stream.this.headersQueue.isEmpty();
                object = null;
                if (!bl && Http2Stream.this.headersListener != null) {
                    object = new ArrayList(Http2Stream.this.headersQueue);
                    Http2Stream.this.headersQueue.clear();
                    listener2 = Http2Stream.this.headersListener;
                } else {
                    listener2 = null;
                }
                Http2Stream.this.notifyAll();
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var1_1
                if (l2 > 0L) {
                    this.updateConnectionFlowControl(l2);
                }
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
            Http2Stream.this.cancelStreamIfNecessary();
            if (listener2 == null) return;
            object = object.iterator();
            while (object.hasNext()) {
                listener2.onHeaders((Headers)object.next());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public long read(Buffer object, long l2) throws IOException {
            block13: {
                long l3;
                ErrorCode errorCode;
                if (l2 < 0L) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("byteCount < 0: ");
                    ((StringBuilder)object).append(l2);
                    object = new IllegalArgumentException(((StringBuilder)object).toString());
                    throw object;
                }
                while (true) {
                    Object object2;
                    Headers headers;
                    block14: {
                        block15: {
                            block16: {
                                Http2Stream http2Stream = Http2Stream.this;
                                // MONITORENTER : http2Stream
                                Http2Stream.this.readTimeout.enter();
                                errorCode = Http2Stream.this.errorCode != null ? Http2Stream.this.errorCode : null;
                                if (this.closed) break block13;
                                if (!Http2Stream.this.headersQueue.isEmpty() && Http2Stream.this.headersListener != null) {
                                    headers = (Headers)Http2Stream.this.headersQueue.removeFirst();
                                    object2 = Http2Stream.this.headersListener;
                                    l3 = -1L;
                                    break block14;
                                }
                                if (this.readBuffer.size() > 0L) {
                                    long l4 = this.readBuffer.read((Buffer)object, Math.min(l2, this.readBuffer.size()));
                                    object2 = Http2Stream.this;
                                    object2.unacknowledgedBytesRead += l4;
                                    l3 = l4;
                                    if (errorCode != null) break block15;
                                    l3 = l4;
                                    if (Http2Stream.this.unacknowledgedBytesRead >= (long)(Http2Stream.this.connection.okHttpSettings.getInitialWindowSize() / 2)) {
                                        Http2Stream.this.connection.writeWindowUpdateLater(Http2Stream.this.id, Http2Stream.this.unacknowledgedBytesRead);
                                        Http2Stream.this.unacknowledgedBytesRead = 0L;
                                        l3 = l4;
                                    }
                                    break block15;
                                }
                                if (this.finished || errorCode != null) break block16;
                                Http2Stream.this.waitForIo();
                                Http2Stream.this.readTimeout.exitAndThrowIfTimedOut();
                                // MONITOREXIT : http2Stream
                                continue;
                            }
                            l3 = -1L;
                        }
                        headers = null;
                        object2 = null;
                    }
                    Http2Stream.this.readTimeout.exitAndThrowIfTimedOut();
                    // MONITOREXIT : http2Stream
                    if (headers == null || object2 == null) break;
                    object2.onHeaders(headers);
                }
                if (l3 != -1L) {
                    this.updateConnectionFlowControl(l3);
                    return l3;
                }
                if (errorCode != null) throw new StreamResetException(errorCode);
                return -1L;
            }
            try {
                object = new IOException("stream closed");
                throw object;
            }
            catch (Throwable throwable) {
                Http2Stream.this.readTimeout.exitAndThrowIfTimedOut();
                throw throwable;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void receive(BufferedSource bufferedSource, long l2) throws IOException {
            while (l2 > 0L) {
                Http2Stream http2Stream = Http2Stream.this;
                // MONITORENTER : http2Stream
                boolean bl = this.finished;
                long l3 = this.readBuffer.size();
                long l4 = this.maxByteCount;
                boolean bl2 = true;
                boolean bl3 = l3 + l2 > l4;
                // MONITOREXIT : http2Stream
                if (bl3) {
                    bufferedSource.skip(l2);
                    Http2Stream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (bl) {
                    bufferedSource.skip(l2);
                    return;
                }
                l3 = bufferedSource.read(this.receiveBuffer, l2);
                if (l3 == -1L) throw new EOFException();
                l4 = l2 - l3;
                http2Stream = Http2Stream.this;
                // MONITORENTER : http2Stream
                if (this.closed) {
                    l3 = this.receiveBuffer.size();
                    this.receiveBuffer.clear();
                } else {
                    bl3 = this.readBuffer.size() == 0L ? bl2 : false;
                    this.readBuffer.writeAll((Source)this.receiveBuffer);
                    if (bl3) {
                        Http2Stream.this.notifyAll();
                    }
                    l3 = 0L;
                }
                // MONITOREXIT : http2Stream
                l2 = l4;
                if (l3 <= 0L) continue;
                this.updateConnectionFlowControl(l3);
                l2 = l4;
            }
        }

        public Timeout timeout() {
            return Http2Stream.this.readTimeout;
        }
    }

    class StreamTimeout
    extends AsyncTimeout {
        StreamTimeout() {
        }

        public void exitAndThrowIfTimedOut() throws IOException {
            if (!this.exit()) {
                return;
            }
            throw this.newTimeoutException(null);
        }

        protected IOException newTimeoutException(IOException iOException) {
            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("timeout");
            if (iOException != null) {
                socketTimeoutException.initCause(iOException);
            }
            return socketTimeoutException;
        }

        protected void timedOut() {
            Http2Stream.this.closeLater(ErrorCode.CANCEL);
            Http2Stream.this.connection.sendDegradedPingLater();
        }
    }
}

