/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.http2;

import com.mbridge.msdk.thrid.okhttp.Headers;
import com.mbridge.msdk.thrid.okhttp.Protocol;
import com.mbridge.msdk.thrid.okhttp.internal.NamedRunnable;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.http2.ConnectionShutdownException;
import com.mbridge.msdk.thrid.okhttp.internal.http2.ErrorCode;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Header;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Http2Reader;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Http2Stream;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Http2Writer;
import com.mbridge.msdk.thrid.okhttp.internal.http2.PushObserver;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Settings;
import com.mbridge.msdk.thrid.okhttp.internal.platform.Platform;
import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.BufferedSink;
import com.mbridge.msdk.thrid.okio.BufferedSource;
import com.mbridge.msdk.thrid.okio.ByteString;
import com.mbridge.msdk.thrid.okio.Okio;
import com.mbridge.msdk.thrid.okio.Sink;
import com.mbridge.msdk.thrid.okio.Source;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Http2Connection
implements Closeable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    static final int AWAIT_PING = 3;
    static final int DEGRADED_PING = 2;
    static final long DEGRADED_PONG_TIMEOUT_NS = 1000000000L;
    static final int INTERVAL_PING = 1;
    static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    private static final ExecutorService listenerExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Http2Connection", true));
    private long awaitPingsSent = 0L;
    private long awaitPongsReceived = 0L;
    long bytesLeftInWriteWindow;
    final boolean client;
    final Set<Integer> currentPushRequests;
    private long degradedPingsSent = 0L;
    private long degradedPongDeadlineNs = 0L;
    private long degradedPongsReceived = 0L;
    final String hostname;
    private long intervalPingsSent = 0L;
    private long intervalPongsReceived = 0L;
    int lastGoodStreamId;
    final Listener listener;
    int nextStreamId;
    Settings okHttpSettings;
    final Settings peerSettings;
    private final ExecutorService pushExecutor;
    final PushObserver pushObserver;
    final ReaderRunnable readerRunnable;
    private boolean shutdown;
    final Socket socket;
    final Map<Integer, Http2Stream> streams = new LinkedHashMap<Integer, Http2Stream>();
    long unacknowledgedBytesRead = 0L;
    final Http2Writer writer;
    private final ScheduledExecutorService writerExecutor;

    Http2Connection(Builder builder) {
        this.okHttpSettings = new Settings();
        this.peerSettings = new Settings();
        this.currentPushRequests = new LinkedHashSet<Integer>();
        this.pushObserver = builder.pushObserver;
        this.client = builder.client;
        this.listener = builder.listener;
        int n2 = builder.client ? 1 : 2;
        this.nextStreamId = n2;
        if (builder.client) {
            this.nextStreamId += 2;
        }
        if (builder.client) {
            this.okHttpSettings.set(7, 0x1000000);
        }
        this.hostname = builder.hostname;
        this.writerExecutor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(Util.format("OkHttp %s Writer", this.hostname), false));
        if (builder.pingIntervalMillis != 0) {
            this.writerExecutor.scheduleAtFixedRate((Runnable)((Object)new IntervalPingRunnable()), builder.pingIntervalMillis, builder.pingIntervalMillis, TimeUnit.MILLISECONDS);
        }
        this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(Util.format("OkHttp %s Push Observer", this.hostname), true));
        this.peerSettings.set(7, 65535);
        this.peerSettings.set(5, 16384);
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize();
        this.socket = builder.socket;
        this.writer = new Http2Writer(builder.sink, this.client);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(builder.source, this.client));
    }

    static /* synthetic */ long access$108(Http2Connection http2Connection) {
        long l2 = http2Connection.intervalPongsReceived;
        http2Connection.intervalPongsReceived = 1L + l2;
        return l2;
    }

    static /* synthetic */ long access$208(Http2Connection http2Connection) {
        long l2 = http2Connection.intervalPingsSent;
        http2Connection.intervalPingsSent = 1L + l2;
        return l2;
    }

    static /* synthetic */ boolean access$302(Http2Connection http2Connection, boolean bl) {
        http2Connection.shutdown = bl;
        return bl;
    }

    static /* synthetic */ long access$608(Http2Connection http2Connection) {
        long l2 = http2Connection.degradedPongsReceived;
        http2Connection.degradedPongsReceived = 1L + l2;
        return l2;
    }

    static /* synthetic */ long access$708(Http2Connection http2Connection) {
        long l2 = http2Connection.awaitPongsReceived;
        http2Connection.awaitPongsReceived = 1L + l2;
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void failConnection() {
        try {
            this.close(ErrorCode.PROTOCOL_ERROR, ErrorCode.PROTOCOL_ERROR);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Http2Stream newStream(int n2, List<Header> object, boolean bl) throws IOException {
        boolean bl2 = bl ^ true;
        Http2Writer http2Writer = this.writer;
        // MONITORENTER : http2Writer
        // MONITORENTER : this
        if (this.nextStreamId > 0x3FFFFFFF) {
            this.shutdown(ErrorCode.REFUSED_STREAM);
        }
        if (this.shutdown) {
            object = new ConnectionShutdownException();
            throw object;
        }
        int n3 = this.nextStreamId;
        this.nextStreamId += 2;
        Http2Stream http2Stream = new Http2Stream(n3, this, bl2, false, null);
        boolean bl3 = !bl || this.bytesLeftInWriteWindow == 0L || http2Stream.bytesLeftInWriteWindow == 0L;
        if (http2Stream.isOpen()) {
            this.streams.put(n3, http2Stream);
        }
        // MONITOREXIT : this
        if (n2 == 0) {
            this.writer.synStream(bl2, n3, n2, (List)object);
        } else {
            if (this.client) {
                object = new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                throw object;
            }
            this.writer.pushPromise(n2, n3, (List)object);
        }
        // MONITOREXIT : http2Writer
        if (!bl3) return http2Stream;
        this.writer.flush();
        return http2Stream;
    }

    private void pushExecutorExecute(NamedRunnable namedRunnable) {
        synchronized (this) {
            if (!this.shutdown) {
                this.pushExecutor.execute((Runnable)namedRunnable);
            }
            return;
        }
    }

    void awaitPong() throws InterruptedException {
        synchronized (this) {
            try {
                while (this.awaitPongsReceived < this.awaitPingsSent) {
                    this.wait();
                }
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(ErrorCode object, ErrorCode errorCode) throws IOException {
        block16: {
            Object object2;
            block14: {
                Http2Stream[] http2StreamArray = null;
                try {
                    this.shutdown((ErrorCode)object);
                    object = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                synchronized (this) {
                    if (!this.streams.isEmpty()) {
                        http2StreamArray = this.streams.values().toArray(new Http2Stream[this.streams.size()]);
                        this.streams.clear();
                    }
                    // MONITOREXIT @DISABLED, blocks:[1, 6] lbl13 : MonitorExitStatement: MONITOREXIT : this
                    object2 = object;
                    if (http2StreamArray == null) break block14;
                    {
                        catch (Throwable throwable) {}
                        {
                            throw throwable;
                        }
                    }
                }
                int n2 = http2StreamArray.length;
                int n3 = 0;
                while (true) {
                    block15: {
                        object2 = object;
                        if (n3 >= n2) break;
                        object2 = http2StreamArray[n3];
                        try {
                            ((Http2Stream)object2).close(errorCode);
                            object2 = object;
                        }
                        catch (IOException iOException) {
                            object2 = object;
                            if (object == null) break block15;
                            object2 = iOException;
                        }
                    }
                    ++n3;
                    object = object2;
                }
            }
            try {
                this.writer.close();
                object = object2;
            }
            catch (IOException iOException) {
                object = object2;
                if (object2 != null) break block16;
                object = iOException;
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writerExecutor.shutdown();
        this.pushExecutor.shutdown();
        if (object != null) throw object;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    Http2Stream getStream(int n2) {
        synchronized (this) {
            Http2Stream http2Stream = this.streams.get(n2);
            return http2Stream;
        }
    }

    public boolean isHealthy(long l2) {
        synchronized (this) {
            block5: {
                long l3;
                block4: {
                    boolean bl = this.shutdown;
                    if (!bl) break block4;
                    return false;
                }
                if (this.degradedPongsReceived >= this.degradedPingsSent || l2 < (l3 = this.degradedPongDeadlineNs)) break block5;
                return false;
            }
            return true;
        }
    }

    public int maxConcurrentStreams() {
        synchronized (this) {
            int n2 = this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
            return n2;
        }
    }

    public Http2Stream newStream(List<Header> list, boolean bl) throws IOException {
        return this.newStream(0, list, bl);
    }

    public int openStreamCount() {
        synchronized (this) {
            int n2 = this.streams.size();
            return n2;
        }
    }

    void pushDataLater(final int n2, BufferedSource object, final int n3, final boolean bl) throws IOException {
        final Buffer buffer = new Buffer();
        long l2 = n3;
        object.require(l2);
        object.read(buffer, l2);
        if (buffer.size() == l2) {
            this.pushExecutorExecute(new NamedRunnable("OkHttp %s Push Data[%s]", new Object[]{this.hostname, n2}){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void execute() {
                    try {
                        boolean bl2 = Http2Connection.this.pushObserver.onData(n2, (BufferedSource)buffer, n3, bl);
                        if (bl2) {
                            Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
                        }
                        if (!bl2) {
                            if (!bl) return;
                        }
                        Http2Connection http2Connection = Http2Connection.this;
                        synchronized (http2Connection) {
                            Http2Connection.this.currentPushRequests.remove(n2);
                        }
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            });
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(buffer.size());
        ((StringBuilder)object).append(" != ");
        ((StringBuilder)object).append(n3);
        throw new IOException(((StringBuilder)object).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void pushHeadersLater(final int n2, final List<Header> list, final boolean bl) {
        try {
            NamedRunnable namedRunnable = new NamedRunnable("OkHttp %s Push Headers[%s]", new Object[]{this.hostname, n2}){

                /*
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void execute() {
                    var1_1 = Http2Connection.this.pushObserver.onHeaders(n2, list, bl);
                    if (!var1_1) ** GOTO lbl5
                    try {
                        Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
lbl5:
                        // 2 sources

                        if (!var1_1) {
                            if (bl == false) return;
                        }
                        var2_2 = Http2Connection.this;
                        synchronized (var2_2) {
                            Http2Connection.this.currentPushRequests.remove(n2);
                        }
                    }
                    catch (IOException var2_3) {
                        return;
                    }
                }
            };
            this.pushExecutorExecute(namedRunnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void pushRequestLater(final int n2, final List<Header> list) {
        synchronized (this) {
            if (this.currentPushRequests.contains(n2)) {
                this.writeSynResetLater(n2, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(n2);
        }
        try {
            NamedRunnable namedRunnable = new NamedRunnable("OkHttp %s Push Request[%s]", new Object[]{this.hostname, n2}){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void execute() {
                    if (!Http2Connection.this.pushObserver.onRequest(n2, list)) return;
                    try {
                        Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
                        Http2Connection http2Connection = Http2Connection.this;
                        synchronized (http2Connection) {
                            Http2Connection.this.currentPushRequests.remove(n2);
                        }
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            };
            this.pushExecutorExecute(namedRunnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    void pushResetLater(final int n2, final ErrorCode errorCode) {
        this.pushExecutorExecute(new NamedRunnable("OkHttp %s Push Reset[%s]", new Object[]{this.hostname, n2}){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute() {
                Http2Connection.this.pushObserver.onReset(n2, errorCode);
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.currentPushRequests.remove(n2);
                    return;
                }
            }
        });
    }

    public Http2Stream pushStream(int n2, List<Header> list, boolean bl) throws IOException {
        if (!this.client) {
            return this.newStream(n2, list, bl);
        }
        throw new IllegalStateException("Client cannot push requests.");
    }

    boolean pushedStream(int n2) {
        boolean bl = true;
        if (n2 == 0 || (n2 & 1) != 0) {
            bl = false;
        }
        return bl;
    }

    Http2Stream removeStream(int n2) {
        synchronized (this) {
            Http2Stream http2Stream = this.streams.remove(n2);
            this.notifyAll();
            return http2Stream;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendDegradedPingLater() {
        synchronized (this) {
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            ++this.degradedPingsSent;
            this.degradedPongDeadlineNs = System.nanoTime() + 1000000000L;
        }
        try {
            ScheduledExecutorService scheduledExecutorService = this.writerExecutor;
            NamedRunnable namedRunnable = new NamedRunnable("OkHttp %s ping", new Object[]{this.hostname}){

                public void execute() {
                    Http2Connection.this.writePing(false, 2, 0);
                }
            };
            scheduledExecutorService.execute((Runnable)namedRunnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSettings(Settings settings) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            synchronized (this) {
                if (!this.shutdown) {
                    this.okHttpSettings.merge(settings);
                    // MONITOREXIT @DISABLED, blocks:[5, 6, 7] lbl6 : MonitorExitStatement: MONITOREXIT : this
                    this.writer.settings(settings);
                    return;
                }
                settings = new ConnectionShutdownException();
                throw settings;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(ErrorCode errorCode) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int n2;
            synchronized (this) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                n2 = this.lastGoodStreamId;
            }
            this.writer.goAway(n2, errorCode, Util.EMPTY_BYTE_ARRAY);
            return;
        }
    }

    public void start() throws IOException {
        this.start(true);
    }

    void start(boolean bl) throws IOException {
        if (bl) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int n2 = this.okHttpSettings.getInitialWindowSize();
            if (n2 != 65535) {
                this.writer.windowUpdate(0, (long)(n2 - 65535));
            }
        }
        new Thread((Runnable)((Object)this.readerRunnable)).start();
    }

    void updateConnectionFlowControl(long l2) {
        synchronized (this) {
            this.unacknowledgedBytesRead += l2;
            if (this.unacknowledgedBytesRead >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
                this.writeWindowUpdateLater(0, this.unacknowledgedBytesRead);
                this.unacknowledgedBytesRead = 0L;
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void writeData(int var1_1, boolean var2_2, Buffer var3_3, long var4_7) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [6 : 173->191)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writePing() {
        synchronized (this) {
            ++this.awaitPingsSent;
        }
        this.writePing(false, 3, 1330343787);
    }

    void writePing(boolean bl, int n2, int n3) {
        try {
            this.writer.ping(bl, n2, n3);
        }
        catch (IOException iOException) {
            this.failConnection();
        }
    }

    void writePingAndAwaitPong() throws InterruptedException {
        this.writePing();
        this.awaitPong();
    }

    void writeSynReply(int n2, boolean bl, List<Header> list) throws IOException {
        this.writer.synReply(bl, n2, list);
    }

    void writeSynReset(int n2, ErrorCode errorCode) throws IOException {
        this.writer.rstStream(n2, errorCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeSynResetLater(final int n2, final ErrorCode errorCode) {
        try {
            ScheduledExecutorService scheduledExecutorService = this.writerExecutor;
            NamedRunnable namedRunnable = new NamedRunnable("OkHttp %s stream %d", new Object[]{this.hostname, n2}){

                public void execute() {
                    try {
                        Http2Connection.this.writeSynReset(n2, errorCode);
                    }
                    catch (IOException iOException) {
                        Http2Connection.this.failConnection();
                    }
                }
            };
            scheduledExecutorService.execute((Runnable)namedRunnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeWindowUpdateLater(final int n2, final long l2) {
        try {
            ScheduledExecutorService scheduledExecutorService = this.writerExecutor;
            NamedRunnable namedRunnable = new NamedRunnable("OkHttp Window Update %s stream %d", new Object[]{this.hostname, n2}){

                public void execute() {
                    try {
                        Http2Connection.this.writer.windowUpdate(n2, l2);
                    }
                    catch (IOException iOException) {
                        Http2Connection.this.failConnection();
                    }
                }
            };
            scheduledExecutorService.execute((Runnable)namedRunnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return;
        }
    }

    public static class Builder {
        boolean client;
        String hostname;
        Listener listener = Listener.REFUSE_INCOMING_STREAMS;
        int pingIntervalMillis;
        PushObserver pushObserver = PushObserver.CANCEL;
        BufferedSink sink;
        Socket socket;
        BufferedSource source;

        public Builder(boolean bl) {
            this.client = bl;
        }

        public Http2Connection build() {
            return new Http2Connection(this);
        }

        public Builder listener(Listener listener2) {
            this.listener = listener2;
            return this;
        }

        public Builder pingIntervalMillis(int n2) {
            this.pingIntervalMillis = n2;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public Builder socket(Socket socket) throws IOException {
            return this.socket(socket, ((InetSocketAddress)socket.getRemoteSocketAddress()).getHostName(), Okio.buffer((Source)Okio.source((Socket)socket)), Okio.buffer((Sink)Okio.sink((Socket)socket)));
        }

        public Builder socket(Socket socket, String string2, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.socket = socket;
            this.hostname = string2;
            this.source = bufferedSource;
            this.sink = bufferedSink;
            return this;
        }
    }

    final class IntervalPingRunnable
    extends NamedRunnable {
        IntervalPingRunnable() {
            super("OkHttp %s ping", new Object[]{Http2Connection.this.hostname});
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void execute() {
            boolean bl;
            Http2Connection http2Connection = Http2Connection.this;
            // MONITORENTER : http2Connection
            if (Http2Connection.this.intervalPongsReceived < Http2Connection.this.intervalPingsSent) {
                bl = true;
            } else {
                Http2Connection.access$208(Http2Connection.this);
                bl = false;
            }
            // MONITOREXIT : http2Connection
            if (bl) {
                Http2Connection.this.failConnection();
                return;
            }
            Http2Connection.this.writePing(false, 1, 0);
        }
    }

    public static abstract class Listener {
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            @Override
            public void onStream(Http2Stream http2Stream) throws IOException {
                http2Stream.close(ErrorCode.REFUSED_STREAM);
            }
        };

        public void onSettings(Http2Connection http2Connection) {
        }

        public abstract void onStream(Http2Stream var1) throws IOException;
    }

    final class PingRunnable
    extends NamedRunnable {
        final int payload1;
        final int payload2;
        final boolean reply;

        PingRunnable(boolean bl, int n2, int n3) {
            super("OkHttp %s ping %08x%08x", new Object[]{Http2Connection.this.hostname, n2, n3});
            this.reply = bl;
            this.payload1 = n2;
            this.payload2 = n3;
        }

        public void execute() {
            Http2Connection.this.writePing(this.reply, this.payload1, this.payload2);
        }
    }

    class ReaderRunnable
    extends NamedRunnable
    implements Http2Reader.Handler {
        final Http2Reader reader;

        ReaderRunnable(Http2Reader http2Reader) {
            super("OkHttp %s", new Object[]{Http2Connection.this.hostname});
            this.reader = http2Reader;
        }

        public void ackSettings() {
        }

        public void alternateService(int n2, String string2, ByteString byteString, String string3, int n3, long l2) {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void applyAndAckSettings(boolean bl, Settings http2StreamArray) {
            block19: {
                long l2;
                Http2Writer http2Writer2 = Http2Connection.this.writer;
                synchronized (http2Writer2) {
                    Http2Connection http2Connection = Http2Connection.this;
                    synchronized (http2Connection) {
                    }
                    {
                        int n2 = Http2Connection.this.peerSettings.getInitialWindowSize();
                        if (bl) {
                            Http2Connection.this.peerSettings.clear();
                        }
                        Http2Connection.this.peerSettings.merge((Settings)http2StreamArray);
                        int n3 = Http2Connection.this.peerSettings.getInitialWindowSize();
                        http2StreamArray = null;
                        if (n3 != -1 && n3 != n2) {
                            long l3;
                            l2 = l3 = (long)(n3 - n2);
                            if (!Http2Connection.this.streams.isEmpty()) {
                                http2StreamArray = Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                                l2 = l3;
                            }
                        } else {
                            l2 = 0L;
                        }
                    }
                    {
                        try {
                            Http2Connection.this.writer.applyAndAckSettings(Http2Connection.this.peerSettings);
                        }
                        catch (IOException iOException) {
                            Http2Connection.this.failConnection();
                        }
                        if (http2StreamArray == null) break block19;
                    }
                }
                for (Http2Writer http2Writer2 : http2StreamArray) {
                    synchronized (http2Writer2) {
                        http2Writer2.addBytesToWriteWindow(l2);
                    }
                }
            }
            listenerExecutor.execute((Runnable)new NamedRunnable("OkHttp %s settings", new Object[]{Http2Connection.this.hostname}){

                public void execute() {
                    Http2Connection.this.listener.onSettings(Http2Connection.this);
                }
            });
        }

        public void data(boolean bl, int n2, BufferedSource bufferedSource, int n3) throws IOException {
            if (Http2Connection.this.pushedStream(n2)) {
                Http2Connection.this.pushDataLater(n2, bufferedSource, n3, bl);
                return;
            }
            Object object = Http2Connection.this.getStream(n2);
            if (object == null) {
                Http2Connection.this.writeSynResetLater(n2, ErrorCode.PROTOCOL_ERROR);
                object = Http2Connection.this;
                long l2 = n3;
                ((Http2Connection)object).updateConnectionFlowControl(l2);
                bufferedSource.skip(l2);
                return;
            }
            ((Http2Stream)object).receiveData(bufferedSource, n3);
            if (bl) {
                ((Http2Stream)object).receiveFin();
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void execute() {
            Throwable throwable222;
            block11: {
                block10: {
                    Object object;
                    Object object2;
                    block9: {
                        Object object3;
                        Object object4;
                        block12: {
                            object4 = ErrorCode.INTERNAL_ERROR;
                            object2 = ErrorCode.INTERNAL_ERROR;
                            object = object4;
                            object3 = object4;
                            this.reader.readConnectionPreface((Http2Reader.Handler)this);
                            do {
                                object = object4;
                                object3 = object4;
                            } while (this.reader.nextFrame(false, (Http2Reader.Handler)this));
                            object = object4;
                            object3 = object4;
                            object4 = ErrorCode.NO_ERROR;
                            object = object4;
                            object3 = object4;
                            ErrorCode errorCode = ErrorCode.CANCEL;
                            object2 = Http2Connection.this;
                            object3 = object4;
                            object = errorCode;
                            object4 = object2;
                            break block12;
                            {
                                catch (Throwable throwable222) {
                                    break block9;
                                }
                                catch (IOException iOException) {}
                                object = object3;
                                {
                                    object = object3 = ErrorCode.PROTOCOL_ERROR;
                                    ErrorCode errorCode2 = ErrorCode.PROTOCOL_ERROR;
                                    object4 = Http2Connection.this;
                                    object = errorCode2;
                                }
                            }
                        }
                        ((Http2Connection)object4).close((ErrorCode)object3, (ErrorCode)object);
                        break block10;
                    }
                    try {
                        Http2Connection.this.close((ErrorCode)object, (ErrorCode)object2);
                        break block11;
                    }
                    catch (IOException iOException) {}
                    catch (IOException iOException) {}
                }
                Util.closeQuietly((Closeable)this.reader);
                return;
            }
            Util.closeQuietly((Closeable)this.reader);
            throw throwable222;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void goAway(int n2, ErrorCode object, ByteString http2StreamArray) {
            http2StreamArray.size();
            object = Http2Connection.this;
            synchronized (object) {
                http2StreamArray = Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                Http2Connection.access$302(Http2Connection.this, true);
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
            int n3 = http2StreamArray.length;
            int n4 = 0;
            while (n4 < n3) {
                object = http2StreamArray[n4];
                if (((Http2Stream)object).getId() > n2 && ((Http2Stream)object).isLocallyInitiated()) {
                    ((Http2Stream)object).receiveRstStream(ErrorCode.REFUSED_STREAM);
                    Http2Connection.this.removeStream(((Http2Stream)object).getId());
                }
                ++n4;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void headers(boolean bl, int n2, int n3, List<Header> object) {
            Object object2;
            if (Http2Connection.this.pushedStream(n2)) {
                Http2Connection.this.pushHeadersLater(n2, (List<Header>)object, bl);
                return;
            }
            Http2Connection http2Connection = Http2Connection.this;
            synchronized (http2Connection) {
                object2 = Http2Connection.this.getStream(n2);
                if (object2 == null) {
                    if (Http2Connection.this.shutdown) {
                        return;
                    }
                    if (n2 <= Http2Connection.this.lastGoodStreamId) {
                        return;
                    }
                    if (n2 % 2 == Http2Connection.this.nextStreamId % 2) {
                        return;
                    }
                    object2 = Util.toHeaders(object);
                    object = new Http2Stream(n2, Http2Connection.this, false, bl, (Headers)object2);
                    Http2Connection.this.lastGoodStreamId = n2;
                    Http2Connection.this.streams.put(n2, (Http2Stream)object);
                    ExecutorService executorService = listenerExecutor;
                    object2 = new NamedRunnable("OkHttp %s stream %d", new Object[]{Http2Connection.this.hostname, n2}, (Http2Stream)object){
                        final /* synthetic */ Http2Stream val$newStream;
                        {
                            this.val$newStream = http2Stream;
                            super(string2, objectArray);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void execute() {
                            try {
                                Http2Connection.this.listener.onStream(this.val$newStream);
                                return;
                            }
                            catch (IOException iOException) {
                                Platform platform = Platform.get();
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("Http2Connection.Listener failure for ");
                                stringBuilder.append(Http2Connection.this.hostname);
                                platform.log(4, stringBuilder.toString(), iOException);
                                try {
                                    this.val$newStream.close(ErrorCode.PROTOCOL_ERROR);
                                    return;
                                }
                                catch (IOException iOException2) {
                                    return;
                                }
                            }
                        }
                    };
                    executorService.execute((Runnable)object2);
                    return;
                }
            }
            ((Http2Stream)object2).receiveHeaders((List<Header>)object);
            if (bl) {
                ((Http2Stream)object2).receiveFin();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void ping(boolean bl, int n2, int n3) {
            if (bl) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Throwable throwable2;
                    block10: {
                        block9: {
                            if (n2 == 1) {
                                try {
                                    Http2Connection.access$108(Http2Connection.this);
                                    break block9;
                                }
                                catch (Throwable throwable2) {
                                    break block10;
                                }
                            }
                            if (n2 == 2) {
                                Http2Connection.access$608(Http2Connection.this);
                            } else {
                                if (n2 != 3) return;
                                Http2Connection.access$708(Http2Connection.this);
                                Http2Connection.this.notifyAll();
                            }
                        }
                        return;
                    }
                    throw throwable2;
                }
            }
            try {
                ScheduledExecutorService scheduledExecutorService = Http2Connection.this.writerExecutor;
                PingRunnable pingRunnable = new PingRunnable(true, n2, n3);
                scheduledExecutorService.execute((Runnable)((Object)pingRunnable));
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                return;
            }
        }

        public void priority(int n2, int n3, int n4, boolean bl) {
        }

        public void pushPromise(int n2, int n3, List<Header> list) {
            Http2Connection.this.pushRequestLater(n3, list);
        }

        public void rstStream(int n2, ErrorCode errorCode) {
            if (Http2Connection.this.pushedStream(n2)) {
                Http2Connection.this.pushResetLater(n2, errorCode);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.removeStream(n2);
            if (http2Stream != null) {
                http2Stream.receiveRstStream(errorCode);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void settings(final boolean bl, final Settings settings) {
            try {
                ScheduledExecutorService scheduledExecutorService = Http2Connection.this.writerExecutor;
                NamedRunnable namedRunnable = new NamedRunnable("OkHttp %s ACK Settings", new Object[]{Http2Connection.this.hostname}){

                    public void execute() {
                        ReaderRunnable.this.applyAndAckSettings(bl, settings);
                    }
                };
                scheduledExecutorService.execute((Runnable)namedRunnable);
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void windowUpdate(int n2, long l2) {
            if (n2 == 0) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection http2Connection2 = Http2Connection.this;
                    http2Connection2.bytesLeftInWriteWindow += l2;
                    Http2Connection.this.notifyAll();
                    return;
                }
            }
            Http2Stream http2Stream = Http2Connection.this.getStream(n2);
            if (http2Stream == null) return;
            synchronized (http2Stream) {
                http2Stream.addBytesToWriteWindow(l2);
                return;
            }
        }
    }
}

