/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.http2;

import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Header;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Huffman;
import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.BufferedSink;
import com.mbridge.msdk.thrid.okio.BufferedSource;
import com.mbridge.msdk.thrid.okio.ByteString;
import com.mbridge.msdk.thrid.okio.Okio;
import com.mbridge.msdk.thrid.okio.Source;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class Hpack {
    static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX;
    private static final int PREFIX_4_BITS = 15;
    private static final int PREFIX_5_BITS = 31;
    private static final int PREFIX_6_BITS = 63;
    private static final int PREFIX_7_BITS = 127;
    static final Header[] STATIC_HEADER_TABLE;

    static {
        STATIC_HEADER_TABLE = new Header[]{new Header(Header.TARGET_AUTHORITY, ""), new Header(Header.TARGET_METHOD, "GET"), new Header(Header.TARGET_METHOD, "POST"), new Header(Header.TARGET_PATH, "/"), new Header(Header.TARGET_PATH, "/index.html"), new Header(Header.TARGET_SCHEME, "http"), new Header(Header.TARGET_SCHEME, "https"), new Header(Header.RESPONSE_STATUS, "200"), new Header(Header.RESPONSE_STATUS, "204"), new Header(Header.RESPONSE_STATUS, "206"), new Header(Header.RESPONSE_STATUS, "304"), new Header(Header.RESPONSE_STATUS, "400"), new Header(Header.RESPONSE_STATUS, "404"), new Header(Header.RESPONSE_STATUS, "500"), new Header("accept-charset", ""), new Header("accept-encoding", "gzip, deflate"), new Header("accept-language", ""), new Header("accept-ranges", ""), new Header("accept", ""), new Header("access-control-allow-origin", ""), new Header("age", ""), new Header("allow", ""), new Header("authorization", ""), new Header("cache-control", ""), new Header("content-disposition", ""), new Header("content-encoding", ""), new Header("content-language", ""), new Header("content-length", ""), new Header("content-location", ""), new Header("content-range", ""), new Header("content-type", ""), new Header("cookie", ""), new Header("date", ""), new Header("etag", ""), new Header("expect", ""), new Header("expires", ""), new Header("from", ""), new Header("host", ""), new Header("if-match", ""), new Header("if-modified-since", ""), new Header("if-none-match", ""), new Header("if-range", ""), new Header("if-unmodified-since", ""), new Header("last-modified", ""), new Header("link", ""), new Header("location", ""), new Header("max-forwards", ""), new Header("proxy-authenticate", ""), new Header("proxy-authorization", ""), new Header("range", ""), new Header("referer", ""), new Header("refresh", ""), new Header("retry-after", ""), new Header("server", ""), new Header("set-cookie", ""), new Header("strict-transport-security", ""), new Header("transfer-encoding", ""), new Header("user-agent", ""), new Header("vary", ""), new Header("via", ""), new Header("www-authenticate", "")};
        NAME_TO_FIRST_INDEX = Hpack.nameToFirstIndex();
    }

    private Hpack() {
    }

    static ByteString checkLowercase(ByteString byteString) throws IOException {
        int n2 = byteString.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by2 = byteString.getByte(i2);
            if (by2 < 65 || by2 > 90) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("PROTOCOL_ERROR response malformed: mixed case name: ");
            stringBuilder.append(byteString.utf8());
            throw new IOException(stringBuilder.toString());
        }
        return byteString;
    }

    private static Map<ByteString, Integer> nameToFirstIndex() {
        Header[] headerArray;
        LinkedHashMap<ByteString, Integer> linkedHashMap = new LinkedHashMap<ByteString, Integer>(STATIC_HEADER_TABLE.length);
        for (int i2 = 0; i2 < (headerArray = STATIC_HEADER_TABLE).length; ++i2) {
            if (linkedHashMap.containsKey(headerArray[i2].name)) continue;
            linkedHashMap.put(Hpack.STATIC_HEADER_TABLE[i2].name, i2);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    static final class Reader {
        Header[] dynamicTable;
        int dynamicTableByteCount = 0;
        int headerCount = 0;
        private final List<Header> headerList = new ArrayList<Header>();
        private final int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        int nextHeaderIndex;
        private final BufferedSource source;

        Reader(int n2, int n3, Source source) {
            this.dynamicTable = new Header[8];
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerTableSizeSetting = n2;
            this.maxDynamicTableByteCount = n3;
            this.source = Okio.buffer((Source)source);
        }

        Reader(int n2, Source source) {
            this(n2, n2, source);
        }

        private void adjustDynamicTableByteCount() {
            int n2 = this.maxDynamicTableByteCount;
            int n3 = this.dynamicTableByteCount;
            if (n2 < n3) {
                if (n2 == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(n3 - n2);
                }
            }
        }

        private void clearDynamicTable() {
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int dynamicTableIndex(int n2) {
            return this.nextHeaderIndex + 1 + n2;
        }

        private int evictToRecoverBytes(int n2) {
            int n3 = 0;
            int n4 = 0;
            if (n2 > 0) {
                int n5 = n2;
                n2 = n4;
                for (n3 = this.dynamicTable.length - 1; n3 >= this.nextHeaderIndex && n5 > 0; --n3) {
                    n5 -= this.dynamicTable[n3].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[n3].hpackSize;
                    --this.headerCount;
                    ++n2;
                }
                Header[] headerArray = this.dynamicTable;
                n3 = this.nextHeaderIndex;
                System.arraycopy(headerArray, n3 + 1, headerArray, n3 + 1 + n2, this.headerCount);
                this.nextHeaderIndex += n2;
                n3 = n2;
            }
            return n3;
        }

        private ByteString getName(int n2) throws IOException {
            Object object;
            if (this.isStaticHeader(n2)) {
                return Hpack.STATIC_HEADER_TABLE[n2].name;
            }
            int n3 = this.dynamicTableIndex(n2 - STATIC_HEADER_TABLE.length);
            if (n3 >= 0 && n3 < ((Header[])(object = this.dynamicTable)).length) {
                return ((Header)object[n3]).name;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Header index too large ");
            ((StringBuilder)object).append(n2 + 1);
            throw new IOException(((StringBuilder)object).toString());
        }

        private void insertIntoDynamicTable(int n2, Header header) {
            int n3;
            this.headerList.add(header);
            int n4 = n3 = header.hpackSize;
            if (n2 != -1) {
                n4 = n3 - this.dynamicTable[this.dynamicTableIndex((int)n2)].hpackSize;
            }
            if (n4 > (n3 = this.maxDynamicTableByteCount)) {
                this.clearDynamicTable();
                return;
            }
            int n5 = this.evictToRecoverBytes(this.dynamicTableByteCount + n4 - n3);
            if (n2 == -1) {
                n2 = this.headerCount;
                Header[] headerArray = this.dynamicTable;
                if (n2 + 1 > headerArray.length) {
                    Header[] headerArray2 = new Header[headerArray.length * 2];
                    System.arraycopy(headerArray, 0, headerArray2, headerArray.length, headerArray.length);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = headerArray2;
                }
                n2 = this.nextHeaderIndex;
                this.nextHeaderIndex = n2 - 1;
                this.dynamicTable[n2] = header;
                ++this.headerCount;
            } else {
                n3 = this.dynamicTableIndex(n2);
                this.dynamicTable[n2 + (n3 + n5)] = header;
            }
            this.dynamicTableByteCount += n4;
        }

        private boolean isStaticHeader(int n2) {
            boolean bl = true;
            if (n2 < 0 || n2 > STATIC_HEADER_TABLE.length - 1) {
                bl = false;
            }
            return bl;
        }

        private int readByte() throws IOException {
            return this.source.readByte() & 0xFF;
        }

        private void readIndexedHeader(int n2) throws IOException {
            Object object;
            block4: {
                block3: {
                    block2: {
                        if (!this.isStaticHeader(n2)) break block2;
                        Header header = STATIC_HEADER_TABLE[n2];
                        this.headerList.add(header);
                        break block3;
                    }
                    int n3 = this.dynamicTableIndex(n2 - STATIC_HEADER_TABLE.length);
                    if (n3 < 0 || n3 >= ((Header[])(object = this.dynamicTable)).length) break block4;
                    this.headerList.add((Header)object[n3]);
                }
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Header index too large ");
            ((StringBuilder)object).append(n2 + 1);
            throw new IOException(((StringBuilder)object).toString());
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int n2) throws IOException {
            this.insertIntoDynamicTable(-1, new Header(this.getName(n2), this.readByteString()));
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            this.insertIntoDynamicTable(-1, new Header(Hpack.checkLowercase(this.readByteString()), this.readByteString()));
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int n2) throws IOException {
            ByteString byteString = this.getName(n2);
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            ByteString byteString = Hpack.checkLowercase(this.readByteString());
            ByteString byteString2 = this.readByteString();
            this.headerList.add(new Header(byteString, byteString2));
        }

        public List<Header> getAndResetHeaderList() {
            ArrayList<Header> arrayList = new ArrayList<Header>(this.headerList);
            this.headerList.clear();
            return arrayList;
        }

        int maxDynamicTableByteCount() {
            return this.maxDynamicTableByteCount;
        }

        ByteString readByteString() throws IOException {
            int n2 = this.readByte();
            boolean bl = (n2 & 0x80) == 128;
            n2 = this.readInt(n2, 127);
            if (bl) {
                return ByteString.of((byte[])Huffman.get().decode(this.source.readByteArray((long)n2)));
            }
            return this.source.readByteString((long)n2);
        }

        void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                int n2 = this.source.readByte() & 0xFF;
                if (n2 != 128) {
                    if ((n2 & 0x80) == 128) {
                        this.readIndexedHeader(this.readInt(n2, 127) - 1);
                        continue;
                    }
                    if (n2 == 64) {
                        this.readLiteralHeaderWithIncrementalIndexingNewName();
                        continue;
                    }
                    if ((n2 & 0x40) == 64) {
                        this.readLiteralHeaderWithIncrementalIndexingIndexedName(this.readInt(n2, 63) - 1);
                        continue;
                    }
                    if ((n2 & 0x20) == 32) {
                        this.maxDynamicTableByteCount = this.readInt(n2, 31);
                        if ((n2 = this.maxDynamicTableByteCount) >= 0 && n2 <= this.headerTableSizeSetting) {
                            this.adjustDynamicTableByteCount();
                            continue;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Invalid dynamic table size update ");
                        stringBuilder.append(this.maxDynamicTableByteCount);
                        throw new IOException(stringBuilder.toString());
                    }
                    if (n2 != 16 && n2 != 0) {
                        this.readLiteralHeaderWithoutIndexingIndexedName(this.readInt(n2, 15) - 1);
                        continue;
                    }
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                throw new IOException("index == 0");
            }
        }

        int readInt(int n2, int n3) throws IOException {
            int n4;
            if ((n2 &= n3) < n3) {
                return n2;
            }
            n2 = 0;
            while (((n4 = this.readByte()) & 0x80) != 0) {
                n3 += (n4 & 0x7F) << n2;
                n2 += 7;
            }
            return n3 + (n4 << n2);
        }
    }

    static final class Writer {
        private static final int SETTINGS_HEADER_TABLE_SIZE = 4096;
        private static final int SETTINGS_HEADER_TABLE_SIZE_LIMIT = 16384;
        Header[] dynamicTable;
        int dynamicTableByteCount = 0;
        private boolean emitDynamicTableSizeUpdate;
        int headerCount = 0;
        int headerTableSizeSetting;
        int maxDynamicTableByteCount;
        int nextHeaderIndex;
        private final Buffer out;
        private int smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
        private final boolean useCompression;

        Writer(int n2, boolean bl, Buffer buffer) {
            this.dynamicTable = new Header[8];
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerTableSizeSetting = n2;
            this.maxDynamicTableByteCount = n2;
            this.useCompression = bl;
            this.out = buffer;
        }

        Writer(Buffer buffer) {
            this(4096, true, buffer);
        }

        private void adjustDynamicTableByteCount() {
            int n2 = this.maxDynamicTableByteCount;
            int n3 = this.dynamicTableByteCount;
            if (n2 < n3) {
                if (n2 == 0) {
                    this.clearDynamicTable();
                } else {
                    this.evictToRecoverBytes(n3 - n2);
                }
            }
        }

        private void clearDynamicTable() {
            Arrays.fill(this.dynamicTable, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n2) {
            int n3 = 0;
            int n4 = 0;
            if (n2 > 0) {
                int n5 = n2;
                n2 = n4;
                for (n3 = this.dynamicTable.length - 1; n3 >= this.nextHeaderIndex && n5 > 0; --n3) {
                    n5 -= this.dynamicTable[n3].hpackSize;
                    this.dynamicTableByteCount -= this.dynamicTable[n3].hpackSize;
                    --this.headerCount;
                    ++n2;
                }
                Object[] objectArray = this.dynamicTable;
                n3 = this.nextHeaderIndex;
                System.arraycopy(objectArray, n3 + 1, objectArray, n3 + 1 + n2, this.headerCount);
                objectArray = this.dynamicTable;
                n3 = this.nextHeaderIndex;
                Arrays.fill(objectArray, n3 + 1, n3 + 1 + n2, null);
                this.nextHeaderIndex += n2;
                n3 = n2;
            }
            return n3;
        }

        private void insertIntoDynamicTable(Header header) {
            int n2 = header.hpackSize;
            int n3 = this.maxDynamicTableByteCount;
            if (n2 > n3) {
                this.clearDynamicTable();
                return;
            }
            this.evictToRecoverBytes(this.dynamicTableByteCount + n2 - n3);
            n3 = this.headerCount;
            Header[] headerArray = this.dynamicTable;
            if (n3 + 1 > headerArray.length) {
                Header[] headerArray2 = new Header[headerArray.length * 2];
                System.arraycopy(headerArray, 0, headerArray2, headerArray.length, headerArray.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = headerArray2;
            }
            n3 = this.nextHeaderIndex;
            this.nextHeaderIndex = n3 - 1;
            this.dynamicTable[n3] = header;
            ++this.headerCount;
            this.dynamicTableByteCount += n2;
        }

        void setHeaderTableSizeSetting(int n2) {
            this.headerTableSizeSetting = n2;
            int n3 = this.maxDynamicTableByteCount;
            if (n3 == (n2 = Math.min(n2, 16384))) {
                return;
            }
            if (n2 < n3) {
                this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, n2);
            }
            this.emitDynamicTableSizeUpdate = true;
            this.maxDynamicTableByteCount = n2;
            this.adjustDynamicTableByteCount();
        }

        void writeByteString(ByteString byteString) throws IOException {
            if (this.useCompression && Huffman.get().encodedLength(byteString) < byteString.size()) {
                Buffer buffer = new Buffer();
                Huffman.get().encode(byteString, (BufferedSink)buffer);
                byteString = buffer.readByteString();
                this.writeInt(byteString.size(), 127, 128);
                this.out.write(byteString);
            } else {
                this.writeInt(byteString.size(), 127, 0);
                this.out.write(byteString);
            }
        }

        /*
         * Unable to fully structure code
         */
        void writeHeaders(List<Header> var1_1) throws IOException {
            if (this.emitDynamicTableSizeUpdate) {
                var2_2 = this.smallestHeaderTableSizeSetting;
                if (var2_2 < this.maxDynamicTableByteCount) {
                    this.writeInt(var2_2, 31, 32);
                }
                this.emitDynamicTableSizeUpdate = false;
                this.smallestHeaderTableSizeSetting = 0x7FFFFFFF;
                this.writeInt(this.maxDynamicTableByteCount, 31, 32);
            }
            var3_3 = var1_1.size();
            for (var4_4 = 0; var4_4 < var3_3; ++var4_4) {
                block16: {
                    block15: {
                        var5_5 = var1_1.get(var4_4);
                        var6_6 = var5_5.name.toAsciiLowercase();
                        var7_7 = var5_5.value;
                        var8_8 = Hpack.NAME_TO_FIRST_INDEX.get(var6_6);
                        if (var8_8 == null) break block15;
                        var9_9 = var8_8 + 1;
                        if (var9_9 <= 1 || var9_9 >= 8) ** GOTO lbl-1000
                        if (Util.equal(Hpack.STATIC_HEADER_TABLE[var9_9 - 1].value, var7_7)) {
                            var2_2 = var9_9;
                        } else if (Util.equal(Hpack.STATIC_HEADER_TABLE[var9_9].value, var7_7)) {
                            var2_2 = var9_9++;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var2_2 = var9_9;
                            var9_9 = -1;
                        }
                        break block16;
                    }
                    var9_9 = -1;
                    var2_2 = -1;
                }
                var10_10 = var9_9;
                var11_11 = var2_2;
                if (var9_9 == -1) {
                    var12_12 = this.nextHeaderIndex + 1;
                    var13_13 = this.dynamicTable.length;
                    while (true) {
                        var10_10 = var9_9;
                        var11_11 = var2_2;
                        if (var12_12 >= var13_13) break;
                        var10_10 = var2_2;
                        if (Util.equal(this.dynamicTable[var12_12].name, var6_6)) {
                            if (Util.equal(this.dynamicTable[var12_12].value, var7_7)) {
                                var9_9 = this.nextHeaderIndex;
                                var10_10 = Hpack.STATIC_HEADER_TABLE.length + (var12_12 - var9_9);
                                var11_11 = var2_2;
                                break;
                            }
                            var10_10 = var2_2;
                            if (var2_2 == -1) {
                                var10_10 = var12_12 - this.nextHeaderIndex + Hpack.STATIC_HEADER_TABLE.length;
                            }
                        }
                        ++var12_12;
                        var2_2 = var10_10;
                    }
                }
                if (var10_10 != -1) {
                    this.writeInt(var10_10, 127, 128);
                    continue;
                }
                if (var11_11 == -1) {
                    this.out.writeByte(64);
                    this.writeByteString(var6_6);
                    this.writeByteString(var7_7);
                    this.insertIntoDynamicTable(var5_5);
                    continue;
                }
                if (var6_6.startsWith(Header.PSEUDO_PREFIX) && !Header.TARGET_AUTHORITY.equals((Object)var6_6)) {
                    this.writeInt(var11_11, 15, 0);
                    this.writeByteString(var7_7);
                    continue;
                }
                this.writeInt(var11_11, 63, 64);
                this.writeByteString(var7_7);
                this.insertIntoDynamicTable(var5_5);
            }
        }

        void writeInt(int n2, int n3, int n4) {
            if (n2 < n3) {
                this.out.writeByte(n2 | n4);
                return;
            }
            this.out.writeByte(n4 | n3);
            n2 -= n3;
            while (n2 >= 128) {
                this.out.writeByte(0x80 | n2 & 0x7F);
                n2 >>>= 7;
            }
            this.out.writeByte(n2);
        }
    }
}

