/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.http1;

import com.mbridge.msdk.thrid.okhttp.CookieJar;
import com.mbridge.msdk.thrid.okhttp.Headers;
import com.mbridge.msdk.thrid.okhttp.HttpUrl;
import com.mbridge.msdk.thrid.okhttp.OkHttpClient;
import com.mbridge.msdk.thrid.okhttp.Request;
import com.mbridge.msdk.thrid.okhttp.Response;
import com.mbridge.msdk.thrid.okhttp.ResponseBody;
import com.mbridge.msdk.thrid.okhttp.internal.Internal;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.connection.RealConnection;
import com.mbridge.msdk.thrid.okhttp.internal.connection.StreamAllocation;
import com.mbridge.msdk.thrid.okhttp.internal.http.HttpCodec;
import com.mbridge.msdk.thrid.okhttp.internal.http.HttpHeaders;
import com.mbridge.msdk.thrid.okhttp.internal.http.RealResponseBody;
import com.mbridge.msdk.thrid.okhttp.internal.http.RequestLine;
import com.mbridge.msdk.thrid.okhttp.internal.http.StatusLine;
import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.BufferedSink;
import com.mbridge.msdk.thrid.okio.BufferedSource;
import com.mbridge.msdk.thrid.okio.ForwardingTimeout;
import com.mbridge.msdk.thrid.okio.Okio;
import com.mbridge.msdk.thrid.okio.Sink;
import com.mbridge.msdk.thrid.okio.Source;
import com.mbridge.msdk.thrid.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;

public final class Http1Codec
implements HttpCodec {
    private static final int HEADER_LIMIT = 262144;
    private static final int STATE_CLOSED = 6;
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    final OkHttpClient client;
    private long headerLimit = 262144L;
    final BufferedSink sink;
    final BufferedSource source;
    int state = 0;
    final StreamAllocation streamAllocation;

    public Http1Codec(OkHttpClient okHttpClient, StreamAllocation streamAllocation, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        this.client = okHttpClient;
        this.streamAllocation = streamAllocation;
        this.source = bufferedSource;
        this.sink = bufferedSink;
    }

    private String readHeaderLine() throws IOException {
        String string2 = this.source.readUtf8LineStrict(this.headerLimit);
        this.headerLimit -= (long)string2.length();
        return string2;
    }

    public void cancel() {
        RealConnection realConnection = this.streamAllocation.connection();
        if (realConnection != null) {
            realConnection.cancel();
        }
    }

    public Sink createRequestBody(Request request, long l2) {
        if ("chunked".equalsIgnoreCase(request.header("Transfer-Encoding"))) {
            return this.newChunkedSink();
        }
        if (l2 != -1L) {
            return this.newFixedLengthSink(l2);
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    void detachTimeout(ForwardingTimeout forwardingTimeout) {
        Timeout timeout = forwardingTimeout.delegate();
        forwardingTimeout.setDelegate(Timeout.NONE);
        timeout.clearDeadline();
        timeout.clearTimeout();
    }

    public void finishRequest() throws IOException {
        this.sink.flush();
    }

    public void flushRequest() throws IOException {
        this.sink.flush();
    }

    public boolean isClosed() {
        boolean bl = this.state == 6;
        return bl;
    }

    public Sink newChunkedSink() {
        if (this.state == 1) {
            this.state = 2;
            return new ChunkedSink();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("state: ");
        stringBuilder.append(this.state);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public Source newChunkedSource(HttpUrl object) throws IOException {
        if (this.state == 4) {
            this.state = 5;
            return new ChunkedSource((HttpUrl)object);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("state: ");
        ((StringBuilder)object).append(this.state);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    public Sink newFixedLengthSink(long l2) {
        if (this.state == 1) {
            this.state = 2;
            return new FixedLengthSink(l2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("state: ");
        stringBuilder.append(this.state);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public Source newFixedLengthSource(long l2) throws IOException {
        if (this.state == 4) {
            this.state = 5;
            return new FixedLengthSource(l2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("state: ");
        stringBuilder.append(this.state);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public Source newUnknownLengthSource() throws IOException {
        if (this.state == 4) {
            StreamAllocation streamAllocation = this.streamAllocation;
            if (streamAllocation != null) {
                this.state = 5;
                streamAllocation.noNewStreams();
                return new UnknownLengthSource();
            }
            throw new IllegalStateException("streamAllocation == null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("state: ");
        stringBuilder.append(this.state);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public ResponseBody openResponseBody(Response response) throws IOException {
        this.streamAllocation.eventListener.responseBodyStart(this.streamAllocation.call);
        String string2 = response.header("Content-Type");
        if (!HttpHeaders.hasBody((Response)response)) {
            return new RealResponseBody(string2, 0L, Okio.buffer((Source)this.newFixedLengthSource(0L)));
        }
        if ("chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) {
            return new RealResponseBody(string2, -1L, Okio.buffer((Source)this.newChunkedSource(response.request().url())));
        }
        long l2 = HttpHeaders.contentLength((Response)response);
        if (l2 != -1L) {
            return new RealResponseBody(string2, l2, Okio.buffer((Source)this.newFixedLengthSource(l2)));
        }
        return new RealResponseBody(string2, -1L, Okio.buffer((Source)this.newUnknownLengthSource()));
    }

    public Headers readHeaders() throws IOException {
        String string2;
        Headers.Builder builder = new Headers.Builder();
        while ((string2 = this.readHeaderLine()).length() != 0) {
            Internal.instance.addLenient(builder, string2);
        }
        return builder.build();
    }

    public Response.Builder readResponseHeaders(boolean bl) throws IOException {
        Object object;
        block7: {
            StatusLine statusLine;
            block6: {
                int n2 = this.state;
                if (n2 != 1 && n2 != 3) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("state: ");
                    stringBuilder.append(this.state);
                    throw new IllegalStateException(stringBuilder.toString());
                }
                try {
                    statusLine = StatusLine.parse((String)this.readHeaderLine());
                    object = new Response.Builder();
                    object = ((Response.Builder)object).protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.readHeaders());
                    if (!bl) break block6;
                }
                catch (EOFException eOFException) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("unexpected end of stream on ");
                    ((StringBuilder)object).append(this.streamAllocation);
                    object = new IOException(((StringBuilder)object).toString());
                    ((Throwable)object).initCause(eOFException);
                    throw object;
                }
                if (statusLine.code != 100) break block6;
                return null;
            }
            if (statusLine.code != 100) break block7;
            this.state = 3;
            return object;
        }
        this.state = 4;
        return object;
    }

    public void writeRequest(Headers object, String string2) throws IOException {
        if (this.state == 0) {
            this.sink.writeUtf8(string2).writeUtf8("\r\n");
            int n2 = ((Headers)object).size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.sink.writeUtf8(((Headers)object).name(i2)).writeUtf8(": ").writeUtf8(((Headers)object).value(i2)).writeUtf8("\r\n");
            }
            this.sink.writeUtf8("\r\n");
            this.state = 1;
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("state: ");
        ((StringBuilder)object).append(this.state);
        object = new IllegalStateException(((StringBuilder)object).toString());
        throw object;
    }

    public void writeRequestHeaders(Request request) throws IOException {
        String string2 = RequestLine.get((Request)request, (Proxy.Type)this.streamAllocation.connection().route().proxy().type());
        this.writeRequest(request.headers(), string2);
    }

    private abstract class AbstractSource
    implements Source {
        protected long bytesRead;
        protected boolean closed;
        protected final ForwardingTimeout timeout;

        private AbstractSource() {
            this.timeout = new ForwardingTimeout(Http1Codec.this.source.timeout());
            this.bytesRead = 0L;
        }

        protected final void endOfInput(boolean bl, IOException serializable) throws IOException {
            if (Http1Codec.this.state == 6) {
                return;
            }
            if (Http1Codec.this.state == 5) {
                Http1Codec.this.detachTimeout(this.timeout);
                Http1Codec http1Codec = Http1Codec.this;
                http1Codec.state = 6;
                if (http1Codec.streamAllocation != null) {
                    Http1Codec.this.streamAllocation.streamFinished(bl ^ true, (HttpCodec)Http1Codec.this, this.bytesRead, (IOException)serializable);
                }
                return;
            }
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("state: ");
            ((StringBuilder)serializable).append(Http1Codec.this.state);
            throw new IllegalStateException(((StringBuilder)serializable).toString());
        }

        public long read(Buffer buffer, long l2) throws IOException {
            block3: {
                try {
                    l2 = Http1Codec.this.source.read(buffer, l2);
                    if (l2 <= 0L) break block3;
                }
                catch (IOException iOException) {
                    this.endOfInput(false, iOException);
                    throw iOException;
                }
                this.bytesRead += l2;
            }
            return l2;
        }

        public Timeout timeout() {
            return this.timeout;
        }
    }

    private final class ChunkedSink
    implements Sink {
        private boolean closed;
        private final ForwardingTimeout timeout;

        ChunkedSink() {
            this.timeout = new ForwardingTimeout(Http1Codec.this.sink.timeout());
        }

        public void close() throws IOException {
            synchronized (this) {
                block4: {
                    boolean bl = this.closed;
                    if (!bl) break block4;
                    return;
                }
                this.closed = true;
                Http1Codec.this.sink.writeUtf8("0\r\n\r\n");
                Http1Codec.this.detachTimeout(this.timeout);
                Http1Codec.this.state = 3;
                return;
            }
        }

        public void flush() throws IOException {
            synchronized (this) {
                block4: {
                    boolean bl = this.closed;
                    if (!bl) break block4;
                    return;
                }
                Http1Codec.this.sink.flush();
                return;
            }
        }

        public Timeout timeout() {
            return this.timeout;
        }

        public void write(Buffer buffer, long l2) throws IOException {
            if (!this.closed) {
                if (l2 == 0L) {
                    return;
                }
                Http1Codec.this.sink.writeHexadecimalUnsignedLong(l2);
                Http1Codec.this.sink.writeUtf8("\r\n");
                Http1Codec.this.sink.write(buffer, l2);
                Http1Codec.this.sink.writeUtf8("\r\n");
                return;
            }
            throw new IllegalStateException("closed");
        }
    }

    private class ChunkedSource
    extends AbstractSource {
        private static final long NO_CHUNK_YET = -1L;
        private long bytesRemainingInChunk = -1L;
        private boolean hasMoreChunks = true;
        private final HttpUrl url;

        ChunkedSource(HttpUrl httpUrl) {
            this.url = httpUrl;
        }

        private void readChunkSize() throws IOException {
            String string2;
            block4: {
                block5: {
                    if (this.bytesRemainingInChunk != -1L) {
                        Http1Codec.this.source.readUtf8LineStrict();
                    }
                    try {
                        boolean bl;
                        this.bytesRemainingInChunk = Http1Codec.this.source.readHexadecimalUnsignedLong();
                        string2 = Http1Codec.this.source.readUtf8LineStrict().trim();
                        if (this.bytesRemainingInChunk < 0L || !string2.isEmpty() && !(bl = string2.startsWith(";"))) break block4;
                        if (this.bytesRemainingInChunk != 0L) break block5;
                        this.hasMoreChunks = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ProtocolException(numberFormatException.getMessage());
                    }
                    HttpHeaders.receiveHeaders((CookieJar)Http1Codec.this.client.cookieJar(), (HttpUrl)this.url, (Headers)Http1Codec.this.readHeaders());
                    this.endOfInput(true, null);
                }
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("expected chunk size and optional extensions but was \"");
            stringBuilder.append(this.bytesRemainingInChunk);
            stringBuilder.append(string2);
            stringBuilder.append("\"");
            ProtocolException protocolException = new ProtocolException(stringBuilder.toString());
            throw protocolException;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }

        @Override
        public long read(Buffer object, long l2) throws IOException {
            if (l2 >= 0L) {
                if (!this.closed) {
                    if (!this.hasMoreChunks) {
                        return -1L;
                    }
                    long l3 = this.bytesRemainingInChunk;
                    if (l3 == 0L || l3 == -1L) {
                        this.readChunkSize();
                        if (!this.hasMoreChunks) {
                            return -1L;
                        }
                    }
                    if ((l2 = super.read((Buffer)object, Math.min(l2, this.bytesRemainingInChunk))) != -1L) {
                        this.bytesRemainingInChunk -= l2;
                        return l2;
                    }
                    object = new ProtocolException("unexpected end of stream");
                    this.endOfInput(false, (IOException)object);
                    throw object;
                }
                throw new IllegalStateException("closed");
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("byteCount < 0: ");
            ((StringBuilder)object).append(l2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
    }

    private final class FixedLengthSink
    implements Sink {
        private long bytesRemaining;
        private boolean closed;
        private final ForwardingTimeout timeout;

        FixedLengthSink(long l2) {
            this.timeout = new ForwardingTimeout(Http1Codec.this.sink.timeout());
            this.bytesRemaining = l2;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.bytesRemaining <= 0L) {
                Http1Codec.this.detachTimeout(this.timeout);
                Http1Codec.this.state = 3;
                return;
            }
            throw new ProtocolException("unexpected end of stream");
        }

        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1Codec.this.sink.flush();
        }

        public Timeout timeout() {
            return this.timeout;
        }

        public void write(Buffer object, long l2) throws IOException {
            if (!this.closed) {
                Util.checkOffsetAndCount(object.size(), 0L, l2);
                if (l2 <= this.bytesRemaining) {
                    Http1Codec.this.sink.write((Buffer)object, l2);
                    this.bytesRemaining -= l2;
                    return;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("expected ");
                ((StringBuilder)object).append(this.bytesRemaining);
                ((StringBuilder)object).append(" bytes but received ");
                ((StringBuilder)object).append(l2);
                throw new ProtocolException(((StringBuilder)object).toString());
            }
            throw new IllegalStateException("closed");
        }
    }

    private class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        FixedLengthSource(long l2) throws IOException {
            this.bytesRemaining = l2;
            if (this.bytesRemaining == 0L) {
                this.endOfInput(true, null);
            }
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }

        @Override
        public long read(Buffer object, long l2) throws IOException {
            if (l2 >= 0L) {
                if (!this.closed) {
                    long l3 = this.bytesRemaining;
                    if (l3 == 0L) {
                        return -1L;
                    }
                    if ((l2 = super.read((Buffer)object, Math.min(l3, l2))) != -1L) {
                        this.bytesRemaining -= l2;
                        if (this.bytesRemaining == 0L) {
                            this.endOfInput(true, null);
                        }
                        return l2;
                    }
                    object = new ProtocolException("unexpected end of stream");
                    this.endOfInput(false, (IOException)object);
                    throw object;
                }
                throw new IllegalStateException("closed");
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("byteCount < 0: ");
            ((StringBuilder)object).append(l2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
    }

    private class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        UnknownLengthSource() {
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.inputExhausted) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }

        @Override
        public long read(Buffer object, long l2) throws IOException {
            if (l2 >= 0L) {
                if (!this.closed) {
                    if (this.inputExhausted) {
                        return -1L;
                    }
                    if ((l2 = super.read((Buffer)object, l2)) == -1L) {
                        this.inputExhausted = true;
                        this.endOfInput(true, null);
                        return -1L;
                    }
                    return l2;
                }
                throw new IllegalStateException("closed");
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("byteCount < 0: ");
            ((StringBuilder)object).append(l2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
    }
}

