/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.connection;

import com.mbridge.msdk.thrid.okhttp.Address;
import com.mbridge.msdk.thrid.okhttp.Call;
import com.mbridge.msdk.thrid.okhttp.CertificatePinner;
import com.mbridge.msdk.thrid.okhttp.Connection;
import com.mbridge.msdk.thrid.okhttp.ConnectionPool;
import com.mbridge.msdk.thrid.okhttp.ConnectionSpec;
import com.mbridge.msdk.thrid.okhttp.EventListener;
import com.mbridge.msdk.thrid.okhttp.Handshake;
import com.mbridge.msdk.thrid.okhttp.HttpUrl;
import com.mbridge.msdk.thrid.okhttp.Interceptor;
import com.mbridge.msdk.thrid.okhttp.OkHttpClient;
import com.mbridge.msdk.thrid.okhttp.Protocol;
import com.mbridge.msdk.thrid.okhttp.Request;
import com.mbridge.msdk.thrid.okhttp.Response;
import com.mbridge.msdk.thrid.okhttp.Route;
import com.mbridge.msdk.thrid.okhttp.internal.Internal;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.Version;
import com.mbridge.msdk.thrid.okhttp.internal.connection.ConnectionSpecSelector;
import com.mbridge.msdk.thrid.okhttp.internal.connection.RouteException;
import com.mbridge.msdk.thrid.okhttp.internal.connection.StreamAllocation;
import com.mbridge.msdk.thrid.okhttp.internal.http.HttpCodec;
import com.mbridge.msdk.thrid.okhttp.internal.http.HttpHeaders;
import com.mbridge.msdk.thrid.okhttp.internal.http1.Http1Codec;
import com.mbridge.msdk.thrid.okhttp.internal.http2.ErrorCode;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Http2Codec;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Http2Connection;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Http2Stream;
import com.mbridge.msdk.thrid.okhttp.internal.platform.Platform;
import com.mbridge.msdk.thrid.okhttp.internal.tls.OkHostnameVerifier;
import com.mbridge.msdk.thrid.okhttp.internal.ws.RealWebSocket;
import com.mbridge.msdk.thrid.okio.BufferedSink;
import com.mbridge.msdk.thrid.okio.BufferedSource;
import com.mbridge.msdk.thrid.okio.Okio;
import com.mbridge.msdk.thrid.okio.Sink;
import com.mbridge.msdk.thrid.okio.Source;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class RealConnection
extends Http2Connection.Listener
implements Connection {
    private static final int MAX_TUNNEL_ATTEMPTS = 21;
    private static final String NPE_THROW_WITH_NULL = "throw with null exception";
    public int allocationLimit = 1;
    public final List<Reference<StreamAllocation>> allocations = new ArrayList<Reference<StreamAllocation>>();
    private final ConnectionPool connectionPool;
    private Handshake handshake;
    private Http2Connection http2Connection;
    public long idleAtNanos = Long.MAX_VALUE;
    public boolean noNewStreams;
    private Protocol protocol;
    private Socket rawSocket;
    private final Route route;
    private BufferedSink sink;
    private Socket socket;
    private BufferedSource source;
    public int successCount;

    public RealConnection(ConnectionPool connectionPool, Route route) {
        this.connectionPool = connectionPool;
        this.route = route;
    }

    private void connectSocket(int n2, int n3, Call call2, EventListener object) throws IOException {
        NullPointerException nullPointerException2;
        block4: {
            Proxy proxy = this.route.proxy();
            Object object2 = this.route.address();
            object2 = proxy.type() != Proxy.Type.DIRECT && proxy.type() != Proxy.Type.HTTP ? new Socket(proxy) : ((Address)object2).socketFactory().createSocket();
            this.rawSocket = object2;
            ((EventListener)object).connectStart(call2, this.route.socketAddress(), proxy);
            this.rawSocket.setSoTimeout(n3);
            try {
                Platform.get().connectSocket(this.rawSocket, this.route.socketAddress(), n2);
            }
            catch (ConnectException connectException) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Failed to connect to ");
                ((StringBuilder)object).append(this.route.socketAddress());
                object = new ConnectException(((StringBuilder)object).toString());
                ((Throwable)object).initCause(connectException);
                throw object;
            }
            try {
                this.source = Okio.buffer((Source)Okio.source((Socket)this.rawSocket));
                this.sink = Okio.buffer((Sink)Okio.sink((Socket)this.rawSocket));
            }
            catch (NullPointerException nullPointerException2) {
                if (NPE_THROW_WITH_NULL.equals(nullPointerException2.getMessage())) break block4;
            }
            return;
        }
        throw new IOException(nullPointerException2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectTls(ConnectionSpecSelector object) throws IOException {
        void var1_4;
        Object object2;
        block14: {
            IOException iOException;
            Object object3;
            block15: {
                Address address = this.route.address();
                object2 = address.sslSocketFactory();
                object3 = null;
                ConnectionSpec connectionSpec = null;
                iOException = null;
                try {
                    object2 = (SSLSocket)((SSLSocketFactory)object2).createSocket(this.rawSocket, address.url().host(), address.url().port(), true);
                }
                catch (Throwable throwable) {
                    object2 = object3;
                    break block14;
                }
                catch (AssertionError assertionError) {
                    object = connectionSpec;
                    break block15;
                }
                try {
                    connectionSpec = object.configureSecureSocket((SSLSocket)object2);
                    if (connectionSpec.supportsTlsExtensions()) {
                        Platform.get().configureTlsExtensions((SSLSocket)object2, address.url().host(), address.protocols());
                    }
                    ((SSLSocket)object2).startHandshake();
                    object = ((SSLSocket)object2).getSession();
                    object3 = Handshake.get((SSLSession)object);
                    if (!address.hostnameVerifier().verify(address.url().host(), (SSLSession)object)) {
                        object = ((Handshake)object3).peerCertificates();
                        boolean bl = object.isEmpty();
                        if (!bl) {
                            object = (X509Certificate)object.get(0);
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append("Hostname ");
                            ((StringBuilder)object3).append(address.url().host());
                            ((StringBuilder)object3).append(" not verified:\n    certificate: ");
                            ((StringBuilder)object3).append(CertificatePinner.pin((Certificate)object));
                            ((StringBuilder)object3).append("\n    DN: ");
                            ((StringBuilder)object3).append(((X509Certificate)object).getSubjectDN().getName());
                            ((StringBuilder)object3).append("\n    subjectAltNames: ");
                            ((StringBuilder)object3).append(OkHostnameVerifier.allSubjectAltNames((X509Certificate)object));
                            iOException = new SSLPeerUnverifiedException(((StringBuilder)object3).toString());
                            throw iOException;
                        }
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("Hostname ");
                        ((StringBuilder)object3).append(address.url().host());
                        ((StringBuilder)object3).append(" not verified (no certificates)");
                        object = new SSLPeerUnverifiedException(((StringBuilder)object3).toString());
                        throw object;
                    }
                    address.certificatePinner().check(address.url().host(), ((Handshake)object3).peerCertificates());
                    object = iOException;
                    if (connectionSpec.supportsTlsExtensions()) {
                        object = Platform.get().getSelectedProtocol((SSLSocket)object2);
                    }
                    this.socket = object2;
                    this.source = Okio.buffer((Source)Okio.source((Socket)this.socket));
                    this.sink = Okio.buffer((Sink)Okio.sink((Socket)this.socket));
                    this.handshake = object3;
                    object = object != null ? Protocol.get((String)object) : Protocol.HTTP_1_1;
                    this.protocol = object;
                    if (object2 != null) {
                        Platform.get().afterHandshake((SSLSocket)object2);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    break block14;
                }
                catch (AssertionError assertionError) {
                    object = object2;
                    object2 = assertionError;
                }
            }
            object3 = object;
            {
                if (Util.isAndroidGetsocknameError((AssertionError)object2)) {
                    object3 = object;
                    object3 = object;
                    iOException = new IOException((Throwable)object2);
                    object3 = object;
                    throw iOException;
                }
                object3 = object;
                throw object2;
            }
        }
        if (object2 != null) {
            Platform.get().afterHandshake((SSLSocket)object2);
        }
        Util.closeQuietly((Socket)object2);
        throw var1_4;
    }

    private void connectTunnel(int n2, int n3, int n4, Call call2, EventListener eventListener) throws IOException {
        Request request = this.createTunnelRequest();
        HttpUrl httpUrl = request.url();
        for (int i2 = 0; i2 < 21; ++i2) {
            this.connectSocket(n2, n3, call2, eventListener);
            request = this.createTunnel(n3, n4, request, httpUrl);
            if (request == null) break;
            Util.closeQuietly(this.rawSocket);
            this.rawSocket = null;
            this.sink = null;
            this.source = null;
            eventListener.connectEnd(call2, this.route.socketAddress(), this.route.proxy(), null);
        }
    }

    private Request createTunnel(int n2, int n3, Request object, HttpUrl object2) throws IOException {
        block3: {
            Object object3;
            block4: {
                block5: {
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("CONNECT ");
                    ((StringBuilder)object3).append(Util.hostHeader((HttpUrl)object2, true));
                    ((StringBuilder)object3).append(" HTTP/1.1");
                    object2 = ((StringBuilder)object3).toString();
                    do {
                        long l2;
                        Http1Codec http1Codec = new Http1Codec(null, null, this.source, this.sink);
                        this.source.timeout().timeout((long)n2, TimeUnit.MILLISECONDS);
                        this.sink.timeout().timeout((long)n3, TimeUnit.MILLISECONDS);
                        http1Codec.writeRequest(((Request)object).headers(), (String)object2);
                        http1Codec.finishRequest();
                        object3 = http1Codec.readResponseHeaders(false).request((Request)object).build();
                        long l3 = l2 = HttpHeaders.contentLength((Response)object3);
                        if (l2 == -1L) {
                            l3 = 0L;
                        }
                        object = http1Codec.newFixedLengthSource(l3);
                        Util.skipAll((Source)object, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
                        object.close();
                        int n4 = ((Response)object3).code();
                        if (n4 == 200) break block3;
                        if (n4 != 407) break block4;
                        object = this.route.address().proxyAuthenticator().authenticate(this.route, (Response)object3);
                        if (object == null) break block5;
                    } while (!"close".equalsIgnoreCase(((Response)object3).header("Connection")));
                    return object;
                }
                throw new IOException("Failed to authenticate with proxy");
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unexpected response code for CONNECT: ");
            ((StringBuilder)object).append(((Response)object3).code());
            throw new IOException(((StringBuilder)object).toString());
        }
        if (this.source.buffer().exhausted() && this.sink.buffer().exhausted()) {
            return null;
        }
        object = new IOException("TLS tunnel buffered too many bytes!");
        throw object;
    }

    private Request createTunnelRequest() throws IOException {
        Object object = new Request.Builder().url(this.route.address().url()).method("CONNECT", null).header("Host", Util.hostHeader(this.route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", Version.userAgent()).build();
        Object object2 = new Response.Builder().request((Request)object).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
        object2 = this.route.address().proxyAuthenticator().authenticate(this.route, (Response)object2);
        if (object2 != null) {
            object = object2;
        }
        return object;
    }

    private void establishProtocol(ConnectionSpecSelector connectionSpecSelector, int n2, Call call2, EventListener eventListener) throws IOException {
        if (this.route.address().sslSocketFactory() == null) {
            if (this.route.address().protocols().contains(Protocol.H2_PRIOR_KNOWLEDGE)) {
                this.socket = this.rawSocket;
                this.protocol = Protocol.H2_PRIOR_KNOWLEDGE;
                this.startHttp2(n2);
                return;
            }
            this.socket = this.rawSocket;
            this.protocol = Protocol.HTTP_1_1;
            return;
        }
        eventListener.secureConnectStart(call2);
        this.connectTls(connectionSpecSelector);
        eventListener.secureConnectEnd(call2, this.handshake);
        if (this.protocol == Protocol.HTTP_2) {
            this.startHttp2(n2);
        }
    }

    private void startHttp2(int n2) throws IOException {
        this.socket.setSoTimeout(0);
        this.http2Connection = new Http2Connection.Builder(true).socket(this.socket, this.route.address().url().host(), this.source, this.sink).listener(this).pingIntervalMillis(n2).build();
        this.http2Connection.start();
    }

    public static RealConnection testConnection(ConnectionPool object, Route route, Socket socket, long l2) {
        object = new RealConnection((ConnectionPool)object, route);
        ((RealConnection)object).socket = socket;
        ((RealConnection)object).idleAtNanos = l2;
        return object;
    }

    public void cancel() {
        Util.closeQuietly(this.rawSocket);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(int n2, int n3, int n4, int n5, boolean bl, Call object, EventListener eventListener) {
        if (this.protocol != null) {
            object = new IllegalStateException("already connected");
            throw object;
        }
        Object object2 = this.route.address().connectionSpecs();
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector(object2);
        if (this.route.address().sslSocketFactory() == null) {
            if (!object2.contains(ConnectionSpec.CLEARTEXT)) throw new RouteException((IOException)new UnknownServiceException("CLEARTEXT communication not enabled for client"));
            object2 = this.route.address().url().host();
            if (!Platform.get().isCleartextTrafficPermitted((String)object2)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("CLEARTEXT communication to ");
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(" not permitted by network security policy");
                throw new RouteException((IOException)new UnknownServiceException(((StringBuilder)object).toString()));
            }
        } else if (this.route.address().protocols().contains(Protocol.H2_PRIOR_KNOWLEDGE)) throw new RouteException((IOException)new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS"));
        RouteException routeException = null;
        while (true) {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            try {
                                if (!this.route.requiresTunnel()) break block16;
                                this.connectTunnel(n2, n3, n4, (Call)object, eventListener);
                                object2 = this.rawSocket;
                                if (object2 != null) break block17;
                                break block18;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                                break block19;
                            }
                        }
                        try {
                            this.connectSocket(n2, n3, (Call)object, eventListener);
                        }
                        catch (IOException iOException) {
                            break block19;
                        }
                    }
                    try {
                        this.establishProtocol(connectionSpecSelector, n5, (Call)object, eventListener);
                        eventListener.connectEnd((Call)object, this.route.socketAddress(), this.route.proxy(), this.protocol);
                    }
                    catch (IOException iOException) {
                        break block19;
                    }
                }
                if (this.route.requiresTunnel()) {
                    if (this.rawSocket == null) throw new RouteException((IOException)new ProtocolException("Too many tunnel connections attempted: 21"));
                }
                if (this.http2Connection == null) return;
                object = this.connectionPool;
                synchronized (object) {
                    this.allocationLimit = this.http2Connection.maxConcurrentStreams();
                    return;
                }
            }
            Util.closeQuietly(this.socket);
            Util.closeQuietly(this.rawSocket);
            this.socket = null;
            this.rawSocket = null;
            this.source = null;
            this.sink = null;
            this.handshake = null;
            this.protocol = null;
            this.http2Connection = null;
            eventListener.connectFailed((Call)object, this.route.socketAddress(), this.route.proxy(), null, (IOException)object2);
            if (routeException == null) {
                routeException = new RouteException((IOException)object2);
            } else {
                routeException.addConnectException((IOException)object2);
            }
            if (!bl) throw routeException;
            if (!connectionSpecSelector.connectionFailed((IOException)object2)) throw routeException;
        }
    }

    @Override
    public Handshake handshake() {
        return this.handshake;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEligible(Address address, @Nullable Route route) {
        if (this.allocations.size() >= this.allocationLimit) return false;
        if (this.noNewStreams) {
            return false;
        }
        if (!Internal.instance.equalsNonHost(this.route.address(), address)) {
            return false;
        }
        if (address.url().host().equals(this.route().address().url().host())) {
            return true;
        }
        if (this.http2Connection == null) {
            return false;
        }
        if (route == null) {
            return false;
        }
        if (route.proxy().type() != Proxy.Type.DIRECT) {
            return false;
        }
        if (this.route.proxy().type() != Proxy.Type.DIRECT) {
            return false;
        }
        if (!this.route.socketAddress().equals(route.socketAddress())) {
            return false;
        }
        if (route.address().hostnameVerifier() != OkHostnameVerifier.INSTANCE) {
            return false;
        }
        if (!this.supportsUrl(address.url())) {
            return false;
        }
        try {
            address.certificatePinner().check(address.url().host(), this.handshake().peerCertificates());
            return true;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHealthy(boolean bl) {
        int n2;
        if (this.socket.isClosed()) return false;
        if (this.socket.isInputShutdown()) return false;
        if (this.socket.isOutputShutdown()) {
            return false;
        }
        Http2Connection http2Connection = this.http2Connection;
        if (http2Connection != null) {
            return http2Connection.isHealthy(System.nanoTime());
        }
        if (!bl) return true;
        try {
            n2 = this.socket.getSoTimeout();
        }
        catch (IOException iOException) {
            return false;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return true;
        }
        try {
            this.socket.setSoTimeout(1);
            bl = this.source.exhausted();
            if (!bl) return true;
            return false;
        }
        finally {
            this.socket.setSoTimeout(n2);
        }
    }

    public boolean isMultiplexed() {
        boolean bl = this.http2Connection != null;
        return bl;
    }

    public HttpCodec newCodec(OkHttpClient okHttpClient, Interceptor.Chain chain, StreamAllocation streamAllocation) throws SocketException {
        Http2Connection http2Connection = this.http2Connection;
        if (http2Connection != null) {
            return new Http2Codec(okHttpClient, chain, streamAllocation, http2Connection);
        }
        this.socket.setSoTimeout(chain.readTimeoutMillis());
        this.source.timeout().timeout((long)chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.sink.timeout().timeout((long)chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
        return new Http1Codec(okHttpClient, streamAllocation, this.source, this.sink);
    }

    public RealWebSocket.Streams newWebSocketStreams(final StreamAllocation streamAllocation) {
        return new RealWebSocket.Streams(true, this.source, this.sink){

            @Override
            public void close() throws IOException {
                StreamAllocation streamAllocation2 = streamAllocation;
                streamAllocation2.streamFinished(true, streamAllocation2.codec(), -1L, null);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onSettings(Http2Connection http2Connection) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.allocationLimit = http2Connection.maxConcurrentStreams();
            return;
        }
    }

    @Override
    public void onStream(Http2Stream http2Stream) throws IOException {
        http2Stream.close(ErrorCode.REFUSED_STREAM);
    }

    @Override
    public Protocol protocol() {
        return this.protocol;
    }

    @Override
    public Route route() {
        return this.route;
    }

    @Override
    public Socket socket() {
        return this.socket;
    }

    public boolean supportsUrl(HttpUrl httpUrl) {
        boolean bl;
        if (httpUrl.port() != this.route.address().url().port()) {
            return false;
        }
        boolean bl2 = httpUrl.host().equals(this.route.address().url().host());
        boolean bl3 = bl = true;
        if (!bl2) {
            bl3 = this.handshake != null && OkHostnameVerifier.INSTANCE.verify(httpUrl.host(), (X509Certificate)this.handshake.peerCertificates().get(0)) ? bl : false;
        }
        return bl3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Connection{");
        stringBuilder.append(this.route.address().url().host());
        stringBuilder.append(":");
        stringBuilder.append(this.route.address().url().port());
        stringBuilder.append(", proxy=");
        stringBuilder.append(this.route.proxy());
        stringBuilder.append(" hostAddress=");
        stringBuilder.append(this.route.socketAddress());
        stringBuilder.append(" cipherSuite=");
        Object object = this.handshake;
        object = object != null ? ((Handshake)object).cipherSuite() : "none";
        stringBuilder.append(object);
        stringBuilder.append(" protocol=");
        stringBuilder.append(this.protocol);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

