/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.cache2;

import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.cache2.FileOperator;
import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.ByteString;
import com.mbridge.msdk.thrid.okio.Source;
import com.mbridge.msdk.thrid.okio.Timeout;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

final class Relay {
    private static final long FILE_HEADER_SIZE = 32L;
    static final ByteString PREFIX_CLEAN = ByteString.encodeUtf8((String)"OkHttp cache v1\n");
    static final ByteString PREFIX_DIRTY = ByteString.encodeUtf8((String)"OkHttp DIRTY :(\n");
    private static final int SOURCE_FILE = 2;
    private static final int SOURCE_UPSTREAM = 1;
    final Buffer buffer;
    final long bufferMaxSize;
    boolean complete;
    RandomAccessFile file;
    private final ByteString metadata;
    int sourceCount;
    Source upstream;
    final Buffer upstreamBuffer = new Buffer();
    long upstreamPos;
    Thread upstreamReader;

    private Relay(RandomAccessFile randomAccessFile, Source source, long l2, ByteString byteString, long l3) {
        this.buffer = new Buffer();
        this.file = randomAccessFile;
        this.upstream = source;
        boolean bl = source == null;
        this.complete = bl;
        this.upstreamPos = l2;
        this.metadata = byteString;
        this.bufferMaxSize = l3;
    }

    public static Relay edit(File object, Source object2, ByteString byteString, long l2) throws IOException {
        object = new RandomAccessFile((File)object, "rw");
        object2 = new Relay((RandomAccessFile)object, (Source)object2, 0L, byteString, l2);
        ((RandomAccessFile)object).setLength(0L);
        super.writeHeader(PREFIX_DIRTY, -1L, -1L);
        return object2;
    }

    public static Relay read(File object) throws IOException {
        object = new RandomAccessFile((File)object, "rw");
        FileOperator fileOperator = new FileOperator(((RandomAccessFile)object).getChannel());
        Buffer buffer = new Buffer();
        fileOperator.read(0L, buffer, 32L);
        if (buffer.readByteString((long)PREFIX_CLEAN.size()).equals((Object)PREFIX_CLEAN)) {
            long l2 = buffer.readLong();
            long l3 = buffer.readLong();
            buffer = new Buffer();
            fileOperator.read(l2 + 32L, buffer, l3);
            return new Relay((RandomAccessFile)object, null, l2, buffer.readByteString(), 0L);
        }
        throw new IOException("unreadable cache file");
    }

    private void writeHeader(ByteString byteString, long l2, long l3) throws IOException {
        Buffer buffer = new Buffer();
        buffer.write(byteString);
        buffer.writeLong(l2);
        buffer.writeLong(l3);
        if (buffer.size() == 32L) {
            new FileOperator(this.file.getChannel()).write(0L, buffer, 32L);
            return;
        }
        throw new IllegalArgumentException();
    }

    private void writeMetadata(long l2) throws IOException {
        Buffer buffer = new Buffer();
        buffer.write(this.metadata);
        new FileOperator(this.file.getChannel()).write(32L + l2, buffer, (long)this.metadata.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void commit(long l2) throws IOException {
        this.writeMetadata(l2);
        this.file.getChannel().force(false);
        this.writeHeader(PREFIX_CLEAN, l2, this.metadata.size());
        this.file.getChannel().force(false);
        synchronized (this) {
            this.complete = true;
        }
        Util.closeQuietly((Closeable)this.upstream);
        this.upstream = null;
    }

    boolean isClosed() {
        boolean bl = this.file == null;
        return bl;
    }

    public ByteString metadata() {
        return this.metadata;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Source newSource() {
        synchronized (this) {
            if (this.file == null) {
                return null;
            }
            ++this.sourceCount;
            return new RelaySource();
        }
    }

    class RelaySource
    implements Source {
        private FileOperator fileOperator;
        private long sourcePos;
        private final Timeout timeout = new Timeout();

        RelaySource() {
            this.fileOperator = new FileOperator(Relay.this.file.getChannel());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            if (this.fileOperator == null) {
                return;
            }
            RandomAccessFile randomAccessFile = null;
            this.fileOperator = null;
            Relay relay = Relay.this;
            // MONITORENTER : relay
            Relay relay2 = Relay.this;
            --relay2.sourceCount;
            if (Relay.this.sourceCount == 0) {
                randomAccessFile = Relay.this.file;
                Relay.this.file = null;
            }
            // MONITOREXIT : relay
            if (randomAccessFile == null) return;
            Util.closeQuietly(randomAccessFile);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public long read(Buffer object, long l2) throws IOException {
            long l3;
            long l4;
            Relay relay;
            block25: {
                int n2;
                block24: {
                    if (this.fileOperator == null) {
                        object = new IllegalStateException("closed");
                        throw object;
                    }
                    relay = Relay.this;
                    // MONITORENTER : relay
                    while ((l4 = this.sourcePos) == (l3 = Relay.this.upstreamPos)) {
                        if (Relay.this.complete) {
                            // MONITOREXIT : relay
                            return -1L;
                        }
                        if (Relay.this.upstreamReader != null) {
                            this.timeout.waitUntilNotified((Object)Relay.this);
                            continue;
                        }
                        Relay.this.upstreamReader = Thread.currentThread();
                        n2 = 1;
                        // MONITOREXIT : relay
                        break block24;
                    }
                    l4 = l3 - Relay.this.buffer.size();
                    if (this.sourcePos >= l4) {
                        l2 = Math.min(l2, l3 - this.sourcePos);
                        Relay.this.buffer.copyTo(object, this.sourcePos - l4, l2);
                        this.sourcePos += l2;
                        // MONITOREXIT : relay
                        return l2;
                    }
                    // MONITOREXIT : relay
                    n2 = 2;
                }
                if (n2 == 2) {
                    l2 = Math.min(l2, l3 - this.sourcePos);
                    this.fileOperator.read(this.sourcePos + 32L, object, l2);
                    this.sourcePos += l2;
                    return l2;
                }
                try {
                    l4 = Relay.this.upstream.read(Relay.this.upstreamBuffer, Relay.this.bufferMaxSize);
                    if (l4 != -1L) break block25;
                    Relay.this.commit(l3);
                    relay = Relay.this;
                }
                catch (Throwable throwable) {
                    object = Relay.this;
                    // MONITORENTER : object
                    Relay.this.upstreamReader = null;
                    Relay.this.notifyAll();
                    // MONITOREXIT : object
                    throw throwable;
                }
                Relay.this.upstreamReader = null;
                Relay.this.notifyAll();
                // MONITOREXIT : relay
                return -1L;
            }
            l2 = Math.min(l4, l2);
            Relay.this.upstreamBuffer.copyTo(object, 0L, l2);
            this.sourcePos += l2;
            this.fileOperator.write(l3 + 32L, Relay.this.upstreamBuffer.clone(), l4);
            object = Relay.this;
            // MONITORENTER : object
            Relay.this.buffer.write(Relay.this.upstreamBuffer, l4);
            if (Relay.this.buffer.size() > Relay.this.bufferMaxSize) {
                Relay.this.buffer.skip(Relay.this.buffer.size() - Relay.this.bufferMaxSize);
            }
            relay = Relay.this;
            relay.upstreamPos += l4;
            // MONITOREXIT : object
            object = Relay.this;
            // MONITORENTER : object
            Relay.this.upstreamReader = null;
            Relay.this.notifyAll();
            // MONITOREXIT : object
            return l2;
        }

        public Timeout timeout() {
            return this.timeout;
        }
    }
}

