/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal.cache;

import com.mbridge.msdk.thrid.okhttp.CacheControl;
import com.mbridge.msdk.thrid.okhttp.Headers;
import com.mbridge.msdk.thrid.okhttp.Request;
import com.mbridge.msdk.thrid.okhttp.Response;
import com.mbridge.msdk.thrid.okhttp.internal.Internal;
import com.mbridge.msdk.thrid.okhttp.internal.http.HttpDate;
import com.mbridge.msdk.thrid.okhttp.internal.http.HttpHeaders;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class CacheStrategy {
    @Nullable
    public final Response cacheResponse;
    @Nullable
    public final Request networkRequest;

    CacheStrategy(Request request, Response response) {
        this.networkRequest = request;
        this.cacheResponse = response;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isCacheable(Response var0, Request var1_1) {
        block6: {
            var2_2 = var0.code();
            var3_3 = false;
            if (var2_2 == 200 || var2_2 == 410 || var2_2 == 414 || var2_2 == 501 || var2_2 == 203 || var2_2 == 204) break block6;
            if (var2_2 == 307) ** GOTO lbl-1000
            if (var2_2 == 308 || var2_2 == 404 || var2_2 == 405) break block6;
            switch (var2_2) {
                default: {
                    ** GOTO lbl11
                }
                case 302: lbl-1000:
                // 2 sources

                {
                    if (var0.header("Expires") != null || var0.cacheControl().maxAgeSeconds() != -1 || var0.cacheControl().isPublic() || var0.cacheControl().isPrivate()) break;
lbl11:
                    // 2 sources

                    return false;
                }
                case 300: 
                case 301: 
            }
        }
        var4_4 = var3_3;
        if (!var0.cacheControl().noStore()) {
            var4_4 = var3_3;
            if (!var1_1.cacheControl().noStore()) {
                var4_4 = true;
            }
        }
        return var4_4;
    }

    public static class Factory {
        private int ageSeconds = -1;
        final Response cacheResponse;
        private String etag;
        private Date expires;
        private Date lastModified;
        private String lastModifiedString;
        final long nowMillis;
        private long receivedResponseMillis;
        final Request request;
        private long sentRequestMillis;
        private Date servedDate;
        private String servedDateString;

        public Factory(long l2, Request object, Response object2) {
            this.nowMillis = l2;
            this.request = object;
            this.cacheResponse = object2;
            if (object2 != null) {
                this.sentRequestMillis = ((Response)object2).sentRequestAtMillis();
                this.receivedResponseMillis = ((Response)object2).receivedResponseAtMillis();
                Headers headers = ((Response)object2).headers();
                int n2 = headers.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    object2 = headers.name(i2);
                    object = headers.value(i2);
                    if ("Date".equalsIgnoreCase((String)object2)) {
                        this.servedDate = HttpDate.parse((String)object);
                        this.servedDateString = object;
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase((String)object2)) {
                        this.expires = HttpDate.parse((String)object);
                        continue;
                    }
                    if ("Last-Modified".equalsIgnoreCase((String)object2)) {
                        this.lastModified = HttpDate.parse((String)object);
                        this.lastModifiedString = object;
                        continue;
                    }
                    if ("ETag".equalsIgnoreCase((String)object2)) {
                        this.etag = object;
                        continue;
                    }
                    if (!"Age".equalsIgnoreCase((String)object2)) continue;
                    this.ageSeconds = HttpHeaders.parseSeconds((String)object, (int)-1);
                }
            }
        }

        private long cacheResponseAge() {
            Date date = this.servedDate;
            long l2 = 0L;
            if (date != null) {
                l2 = Math.max(0L, this.receivedResponseMillis - date.getTime());
            }
            long l3 = l2;
            if (this.ageSeconds != -1) {
                l3 = Math.max(l2, TimeUnit.SECONDS.toMillis(this.ageSeconds));
            }
            l2 = this.receivedResponseMillis;
            return l3 + (l2 - this.sentRequestMillis) + (this.nowMillis - l2);
        }

        private long computeFreshnessLifetime() {
            Object object = this.cacheResponse.cacheControl();
            if (((CacheControl)object).maxAgeSeconds() != -1) {
                return TimeUnit.SECONDS.toMillis(((CacheControl)object).maxAgeSeconds());
            }
            object = this.expires;
            long l2 = 0L;
            if (object != null) {
                object = this.servedDate;
                long l3 = object != null ? ((Date)object).getTime() : this.receivedResponseMillis;
                l3 = this.expires.getTime() - l3;
                if (l3 > 0L) {
                    l2 = l3;
                }
                return l2;
            }
            long l4 = l2;
            if (this.lastModified != null) {
                l4 = l2;
                if (this.cacheResponse.request().url().query() == null) {
                    object = this.servedDate;
                    l4 = object != null ? ((Date)object).getTime() : this.sentRequestMillis;
                    long l5 = l4 - this.lastModified.getTime();
                    l4 = l2;
                    if (l5 > 0L) {
                        l4 = l5 / 10L;
                    }
                }
            }
            return l4;
        }

        private CacheStrategy getCandidate() {
            block12: {
                block16: {
                    Object object;
                    Object object2;
                    block14: {
                        block15: {
                            block13: {
                                long l2;
                                if (this.cacheResponse == null) {
                                    return new CacheStrategy(this.request, null);
                                }
                                if (this.request.isHttps() && this.cacheResponse.handshake() == null) {
                                    return new CacheStrategy(this.request, null);
                                }
                                if (!CacheStrategy.isCacheable(this.cacheResponse, this.request)) {
                                    return new CacheStrategy(this.request, null);
                                }
                                object2 = this.request.cacheControl();
                                if (((CacheControl)object2).noCache() || Factory.hasConditions(this.request)) break block12;
                                object = this.cacheResponse.cacheControl();
                                long l3 = this.cacheResponseAge();
                                long l4 = l2 = this.computeFreshnessLifetime();
                                if (((CacheControl)object2).maxAgeSeconds() != -1) {
                                    l4 = Math.min(l2, TimeUnit.SECONDS.toMillis(((CacheControl)object2).maxAgeSeconds()));
                                }
                                int n2 = ((CacheControl)object2).minFreshSeconds();
                                long l5 = 0L;
                                l2 = n2 != -1 ? TimeUnit.SECONDS.toMillis(((CacheControl)object2).minFreshSeconds()) : 0L;
                                long l6 = l5;
                                if (!((CacheControl)object).mustRevalidate()) {
                                    l6 = l5;
                                    if (((CacheControl)object2).maxStaleSeconds() != -1) {
                                        l6 = TimeUnit.SECONDS.toMillis(((CacheControl)object2).maxStaleSeconds());
                                    }
                                }
                                if (!((CacheControl)object).noCache() && (l2 += l3) < l6 + l4) {
                                    object = this.cacheResponse.newBuilder();
                                    if (l2 >= l4) {
                                        ((Response.Builder)object).addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                                    }
                                    if (l3 > 86400000L && this.isFreshnessLifetimeHeuristic()) {
                                        ((Response.Builder)object).addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                                    }
                                    return new CacheStrategy(null, ((Response.Builder)object).build());
                                }
                                object = this.etag;
                                object2 = "If-Modified-Since";
                                if (object == null) break block13;
                                object2 = "If-None-Match";
                                break block14;
                            }
                            if (this.lastModified == null) break block15;
                            object = this.lastModifiedString;
                            break block14;
                        }
                        if (this.servedDate == null) break block16;
                        object = this.servedDateString;
                    }
                    Headers.Builder builder = this.request.headers().newBuilder();
                    Internal.instance.addLenient(builder, (String)object2, (String)object);
                    return new CacheStrategy(this.request.newBuilder().headers(builder.build()).build(), this.cacheResponse);
                }
                return new CacheStrategy(this.request, null);
            }
            return new CacheStrategy(this.request, null);
        }

        private static boolean hasConditions(Request request) {
            boolean bl = request.header("If-Modified-Since") != null || request.header("If-None-Match") != null;
            return bl;
        }

        private boolean isFreshnessLifetimeHeuristic() {
            boolean bl = this.cacheResponse.cacheControl().maxAgeSeconds() == -1 && this.expires == null;
            return bl;
        }

        public CacheStrategy get() {
            CacheStrategy cacheStrategy;
            CacheStrategy cacheStrategy2 = cacheStrategy = this.getCandidate();
            if (cacheStrategy.networkRequest != null) {
                cacheStrategy2 = cacheStrategy;
                if (this.request.cacheControl().onlyIfCached()) {
                    cacheStrategy2 = new CacheStrategy(null, null);
                }
            }
            return cacheStrategy2;
        }
    }
}

