/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp.internal;

import com.mbridge.msdk.thrid.okhttp.Headers;
import com.mbridge.msdk.thrid.okhttp.HttpUrl;
import com.mbridge.msdk.thrid.okhttp.RequestBody;
import com.mbridge.msdk.thrid.okhttp.ResponseBody;
import com.mbridge.msdk.thrid.okhttp.internal.Internal;
import com.mbridge.msdk.thrid.okhttp.internal.http2.Header;
import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.BufferedSource;
import com.mbridge.msdk.thrid.okio.ByteString;
import com.mbridge.msdk.thrid.okio.Source;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final RequestBody EMPTY_REQUEST;
    public static final ResponseBody EMPTY_RESPONSE;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final Charset ISO_8859_1;
    public static final Comparator<String> NATURAL_ORDER;
    public static final TimeZone UTC;
    private static final Charset UTF_16_BE;
    private static final ByteString UTF_16_BE_BOM;
    private static final Charset UTF_16_LE;
    private static final ByteString UTF_16_LE_BOM;
    private static final Charset UTF_32_BE;
    private static final ByteString UTF_32_BE_BOM;
    private static final Charset UTF_32_LE;
    private static final ByteString UTF_32_LE_BOM;
    public static final Charset UTF_8;
    private static final ByteString UTF_8_BOM;
    private static final Pattern VERIFY_AS_IP_ADDRESS;
    private static final Method addSuppressedExceptionMethod;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        void var1_5;
        EMPTY_BYTE_ARRAY = new byte[0];
        EMPTY_STRING_ARRAY = new String[0];
        byte[] byArray = EMPTY_BYTE_ARRAY;
        Object var1_3 = null;
        EMPTY_RESPONSE = ResponseBody.create(null, byArray);
        EMPTY_REQUEST = RequestBody.create(null, EMPTY_BYTE_ARRAY);
        UTF_8_BOM = ByteString.decodeHex((String)"efbbbf");
        UTF_16_BE_BOM = ByteString.decodeHex((String)"feff");
        UTF_16_LE_BOM = ByteString.decodeHex((String)"fffe");
        UTF_32_BE_BOM = ByteString.decodeHex((String)"0000ffff");
        UTF_32_LE_BOM = ByteString.decodeHex((String)"ffff0000");
        UTF_8 = Charset.forName("UTF-8");
        ISO_8859_1 = Charset.forName("ISO-8859-1");
        UTF_16_BE = Charset.forName("UTF-16BE");
        UTF_16_LE = Charset.forName("UTF-16LE");
        UTF_32_BE = Charset.forName("UTF-32BE");
        UTF_32_LE = Charset.forName("UTF-32LE");
        UTC = TimeZone.getTimeZone("GMT");
        NATURAL_ORDER = new Comparator<String>(){

            @Override
            public int compare(String string2, String string3) {
                return string2.compareTo(string3);
            }
        };
        try {
            Method method;
            Method method2 = method = Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class);
        }
        catch (Exception exception) {}
        addSuppressedExceptionMethod = var1_5;
        VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
    }

    private Util() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addSuppressedIfPossible(Throwable throwable, Throwable throwable2) {
        Method method = addSuppressedExceptionMethod;
        if (method == null) return;
        try {
            method.invoke((Object)throwable, throwable2);
            return;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AssertionError assertionError(String object, Exception exception) {
        object = new AssertionError(object);
        try {
            ((Throwable)object).initCause(exception);
            return object;
        }
        catch (IllegalStateException illegalStateException) {
            return object;
        }
    }

    public static Charset bomAwareCharset(BufferedSource bufferedSource, Charset charset) throws IOException {
        if (bufferedSource.rangeEquals(0L, UTF_8_BOM)) {
            bufferedSource.skip((long)UTF_8_BOM.size());
            return UTF_8;
        }
        if (bufferedSource.rangeEquals(0L, UTF_16_BE_BOM)) {
            bufferedSource.skip((long)UTF_16_BE_BOM.size());
            return UTF_16_BE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_16_LE_BOM)) {
            bufferedSource.skip((long)UTF_16_LE_BOM.size());
            return UTF_16_LE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_32_BE_BOM)) {
            bufferedSource.skip((long)UTF_32_BE_BOM.size());
            return UTF_32_BE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_32_LE_BOM)) {
            bufferedSource.skip((long)UTF_32_LE_BOM.size());
            return UTF_32_LE;
        }
        return charset;
    }

    public static String canonicalizeHost(String string2) {
        block7: {
            if (string2.contains(":")) {
                Object object = string2.startsWith("[") && string2.endsWith("]") ? Util.decodeIpv6(string2, 1, string2.length() - 1) : Util.decodeIpv6(string2, 0, string2.length());
                if (object == null) {
                    return null;
                }
                if (((Object)(object = (Object)((InetAddress)object).getAddress())).length == 16) {
                    return Util.inet6AddressToAscii((byte[])object);
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Invalid IPv6 address: '");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("'");
                throw new AssertionError((Object)((StringBuilder)object).toString());
            }
            try {
                string2 = IDN.toASCII(string2).toLowerCase(Locale.US);
                if (!string2.isEmpty()) break block7;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        boolean bl = Util.containsInvalidHostnameAsciiCodes(string2);
        if (bl) {
            return null;
        }
        return string2;
    }

    public static int checkDuration(String string2, long l2, TimeUnit object) {
        if (l2 >= 0L) {
            if (object != null) {
                long l3 = ((TimeUnit)((Object)object)).toMillis(l2);
                if (l3 <= Integer.MAX_VALUE) {
                    if (l3 == 0L && l2 > 0L) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append(" too small.");
                        throw new IllegalArgumentException(((StringBuilder)object).toString());
                    }
                    return (int)l3;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" too large.");
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            throw new NullPointerException("unit == null");
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" < 0");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public static void checkOffsetAndCount(long l2, long l3, long l4) {
        if ((l3 | l4) >= 0L && l3 <= l2 && l2 - l3 >= l4) {
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket == null) return;
        try {
            serverSocket.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Socket socket) {
        if (socket == null) return;
        try {
            socket.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            if (!"bio == null".equals(runtimeException.getMessage())) throw runtimeException;
            return;
        }
        catch (AssertionError assertionError) {
            if (!Util.isAndroidGetsocknameError(assertionError)) throw assertionError;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static String[] concat(String[] stringArray, String string2) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = string2;
        return stringArray2;
    }

    private static boolean containsInvalidHostnameAsciiCodes(String string2) {
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 > '\u001f' && c2 < '\u007f') {
                if (" #%/:?@[\\]".indexOf(c2) == -1) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        int n2 = 97;
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - n2 + 10;
        }
        n2 = 65;
        if (c2 < 'A') return -1;
        if (c2 > 'F') return -1;
        return c2 - n2 + 10;
    }

    private static boolean decodeIpv4Suffix(String string2, int n2, int n3, byte[] byArray, int n4) {
        int n5 = n4;
        int n6 = n2;
        while (n6 < n3) {
            char c2;
            if (n5 == byArray.length) {
                return false;
            }
            n2 = n6;
            if (n5 != n4) {
                if (string2.charAt(n6) != '.') {
                    return false;
                }
                n2 = n6 + 1;
            }
            int n7 = 0;
            for (n6 = n2; n6 < n3 && (c2 = string2.charAt(n6)) >= '0' && c2 <= '9'; ++n6) {
                if (n7 == 0 && n2 != n6) {
                    return false;
                }
                if ((n7 = n7 * 10 + c2 - 48) <= 255) continue;
                return false;
            }
            if (n6 - n2 == 0) {
                return false;
            }
            byArray[n5] = (byte)n7;
            ++n5;
        }
        return n5 == n4 + 4;
    }

    @Nullable
    private static InetAddress decodeIpv6(String object, int n2, int n3) {
        int n4;
        int n5;
        byte[] byArray;
        block16: {
            byArray = new byte[16];
            int n6 = 0;
            int n7 = -1;
            int n8 = -1;
            while (true) {
                n5 = n6;
                n4 = n7;
                if (n2 >= n3) break block16;
                if (n6 == byArray.length) {
                    return null;
                }
                n4 = n2 + 2;
                if (n4 <= n3 && ((String)object).regionMatches(n2, "::", 0, 2)) {
                    if (n7 != -1) {
                        return null;
                    }
                    n2 = n5 = n6 + 2;
                    if (n4 == n3) {
                        n4 = n2;
                        break block16;
                    }
                    n8 = n4;
                    n6 = n5;
                    n7 = n2;
                    n2 = n8;
                } else {
                    n5 = n2;
                    if (n6 != 0) {
                        if (((String)object).regionMatches(n2, ":", 0, 1)) {
                            n5 = n2 + 1;
                        } else {
                            if (((String)object).regionMatches(n2, ".", 0, 1)) {
                                if (!Util.decodeIpv4Suffix((String)object, n8, n3, byArray, n6 - 2)) {
                                    return null;
                                }
                                n5 = n6 + 2;
                                n4 = n7;
                                break block16;
                            }
                            return null;
                        }
                    }
                    n2 = n5;
                }
                n8 = 0;
                for (n5 = n2; n5 < n3 && (n4 = Util.decodeHexDigit(((String)object).charAt(n5))) != -1; ++n5) {
                    n8 = (n8 << 4) + n4;
                }
                n4 = n5 - n2;
                if (n4 == 0 || n4 > 4) break;
                n4 = n6 + 1;
                byArray[n6] = (byte)(n8 >>> 8 & 0xFF);
                n6 = n4 + 1;
                byArray[n4] = (byte)(n8 & 0xFF);
                n8 = n2;
                n2 = n5;
            }
            return null;
        }
        if (n5 != byArray.length) {
            if (n4 == -1) {
                return null;
            }
            n2 = byArray.length;
            n3 = n5 - n4;
            System.arraycopy(byArray, n4, byArray, n2 - n3, n3);
            Arrays.fill(byArray, n4, byArray.length - n5 + n4, (byte)0);
        }
        try {
            object = InetAddress.getByAddress(byArray);
            return object;
        }
        catch (UnknownHostException unknownHostException) {
            AssertionError assertionError = new AssertionError();
            throw assertionError;
        }
    }

    public static int delimiterOffset(String string2, int n2, int n3, char c2) {
        while (n2 < n3) {
            if (string2.charAt(n2) == c2) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static int delimiterOffset(String string2, int n2, int n3, String string3) {
        while (n2 < n3) {
            if (string3.indexOf(string2.charAt(n2)) != -1) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static boolean discard(Source source, int n2, TimeUnit timeUnit) {
        try {
            boolean bl = Util.skipAll(source, n2, timeUnit);
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean equal(Object object, Object object2) {
        boolean bl = object == object2 || object != null && object.equals(object2);
        return bl;
    }

    public static String format(String string2, Object ... objectArray) {
        return String.format(Locale.US, string2, objectArray);
    }

    public static String hostHeader(HttpUrl httpUrl, boolean bl) {
        CharSequence charSequence;
        block6: {
            CharSequence charSequence2;
            block5: {
                if (httpUrl.host().contains(":")) {
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append("[");
                    ((StringBuilder)charSequence2).append(httpUrl.host());
                    ((StringBuilder)charSequence2).append("]");
                    charSequence2 = ((StringBuilder)charSequence2).toString();
                } else {
                    charSequence2 = httpUrl.host();
                }
                if (bl) break block5;
                charSequence = charSequence2;
                if (httpUrl.port() == HttpUrl.defaultPort(httpUrl.scheme())) break block6;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append(":");
            ((StringBuilder)charSequence).append(httpUrl.port());
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        map = map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
        return map;
    }

    public static int indexOf(Comparator<String> comparator, String[] stringArray, String string2) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (comparator.compare(stringArray[i2], string2) != 0) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOfControlOrNonAscii(String string2) {
        int n2 = string2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 > '\u001f' && c2 < '\u007f') {
                continue;
            }
            return i2;
        }
        return -1;
    }

    private static String inet6AddressToAscii(byte[] byArray) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        while (n4 < byArray.length) {
            int n7;
            for (n7 = n4; n7 < 16 && byArray[n7] == 0 && byArray[n7 + 1] == 0; n7 += 2) {
            }
            int n8 = n7 - n4;
            int n9 = n5;
            n2 = n6;
            if (n8 > n6) {
                n9 = n5;
                n2 = n6;
                if (n8 >= 4) {
                    n2 = n8;
                    n9 = n4;
                }
            }
            n4 = n7 + 2;
            n5 = n9;
            n6 = n2;
        }
        Buffer buffer = new Buffer();
        n4 = n3;
        while (n4 < byArray.length) {
            if (n4 == n5) {
                buffer.writeByte(58);
                n4 = n2 = n4 + n6;
                if (n2 != 16) continue;
                buffer.writeByte(58);
                n4 = n2;
                continue;
            }
            if (n4 > 0) {
                buffer.writeByte(58);
            }
            buffer.writeHexadecimalUnsignedLong((long)((byArray[n4] & 0xFF) << 8 | byArray[n4 + 1] & 0xFF));
            n4 += 2;
        }
        return buffer.readUtf8();
    }

    public static String[] intersect(Comparator<? super String> comparator, String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String string2 : stringArray) {
            int n2 = stringArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (comparator.compare(string2, stringArray2[i2]) != 0) continue;
                arrayList.add(string2);
                continue block0;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        boolean bl = ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
        return bl;
    }

    public static boolean nonEmptyIntersection(Comparator<String> comparator, String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray2 != null && stringArray.length != 0 && stringArray2.length != 0) {
            for (String string2 : stringArray) {
                int n2 = stringArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (comparator.compare(string2, stringArray2[i2]) != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static X509TrustManager platformTrustManager() {
        try {
            Object object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object).init((KeyStore)null);
            Object[] objectArray = ((TrustManagerFactory)object).getTrustManagers();
            if (objectArray.length == 1 && objectArray[0] instanceof X509TrustManager) {
                return (X509TrustManager)objectArray[0];
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unexpected default trust managers:");
            stringBuilder.append(Arrays.toString(objectArray));
            object = new IllegalStateException(stringBuilder.toString());
            throw object;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Util.assertionError("No System TLS", generalSecurityException);
        }
    }

    public static boolean skipAll(Source source, int n2, TimeUnit timeUnit) throws IOException {
        long l2 = System.nanoTime();
        long l3 = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - l2 : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(Math.min(l3, timeUnit.toNanos(n2)) + l2);
        try {
            timeUnit = new Buffer();
            while (source.read((Buffer)timeUnit, 8192L) != -1L) {
                timeUnit.clear();
            }
            return true;
        }
        catch (InterruptedIOException interruptedIOException) {
            return false;
        }
        finally {
            if (l3 == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
            } else {
                source.timeout().deadlineNanoTime(l2 + l3);
            }
        }
    }

    public static int skipLeadingAsciiWhitespace(String string2, int n2, int n3) {
        while (n2 < n3) {
            char c2 = string2.charAt(n2);
            if (c2 != '\t' && c2 != '\n' && c2 != '\f' && c2 != '\r' && c2 != ' ') {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static int skipTrailingAsciiWhitespace(String string2, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            char c2 = string2.charAt(n3);
            if (c2 != '\t' && c2 != '\n' && c2 != '\f' && c2 != '\r' && c2 != ' ') {
                return n3 + 1;
            }
            --n3;
        }
        return n2;
    }

    public static ThreadFactory threadFactory(final String string2, final boolean bl) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable2) {
                runnable2 = new Thread(runnable2, string2);
                ((Thread)runnable2).setDaemon(bl);
                return runnable2;
            }
        };
    }

    public static Headers toHeaders(List<Header> header2) {
        Headers.Builder builder = new Headers.Builder();
        for (Header header2 : header2) {
            Internal.instance.addLenient(builder, header2.name.utf8(), header2.value.utf8());
        }
        return builder.build();
    }

    public static String trimSubstring(String string2, int n2, int n3) {
        n2 = Util.skipLeadingAsciiWhitespace(string2, n2, n3);
        return string2.substring(n2, Util.skipTrailingAsciiWhitespace(string2, n2, n3));
    }

    public static boolean verifyAsIpAddress(String string2) {
        return VERIFY_AS_IP_ADDRESS.matcher(string2).matches();
    }
}

