/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.MediaType;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.BufferedSource;
import com.mbridge.msdk.thrid.okio.ByteString;
import com.safedk.android.internal.special.SpecialsBridge;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

public abstract class ResponseBody
implements Closeable {
    @Nullable
    private Reader reader;

    private Charset charset() {
        Object object = this.contentType();
        object = object != null ? ((MediaType)object).charset(Util.UTF_8) : Util.UTF_8;
        return object;
    }

    public static ResponseBody create(final @Nullable MediaType mediaType, final long l2, final BufferedSource bufferedSource) {
        if (bufferedSource != null) {
            return new ResponseBody(){

                @Override
                public long contentLength() {
                    return l2;
                }

                @Override
                @Nullable
                public MediaType contentType() {
                    return mediaType;
                }

                @Override
                public BufferedSource source() {
                    return bufferedSource;
                }
            };
        }
        throw new NullPointerException("source == null");
    }

    public static ResponseBody create(@Nullable MediaType mediaType, ByteString byteString) {
        Buffer buffer = new Buffer().write(byteString);
        return ResponseBody.create(mediaType, byteString.size(), (BufferedSource)buffer);
    }

    public static ResponseBody create(@Nullable MediaType mediaType, String string2) {
        Charset charset = Util.UTF_8;
        Object object = mediaType;
        if (mediaType != null) {
            Charset charset2;
            charset = charset2 = mediaType.charset();
            object = mediaType;
            if (charset2 == null) {
                charset = Util.UTF_8;
                object = new StringBuilder();
                ((StringBuilder)object).append(mediaType);
                ((StringBuilder)object).append("; charset=utf-8");
                object = MediaType.parse(((StringBuilder)object).toString());
            }
        }
        mediaType = new Buffer().writeString(string2, charset);
        return ResponseBody.create((MediaType)object, mediaType.size(), (BufferedSource)mediaType);
    }

    public static ResponseBody create(@Nullable MediaType mediaType, byte[] byArray) {
        Buffer buffer = new Buffer().write(byArray);
        return ResponseBody.create(mediaType, byArray.length, (BufferedSource)buffer);
    }

    public final InputStream byteStream() {
        return SpecialsBridge.retrofitExceptionCatchingRequestBody_source(this).inputStream();
    }

    public final byte[] bytes() throws IOException {
        long l2 = this.contentLength();
        if (l2 <= Integer.MAX_VALUE) {
            Object object = SpecialsBridge.retrofitExceptionCatchingRequestBody_source(this);
            byte[] byArray = object.readByteArray();
            if (l2 != -1L && l2 != (long)byArray.length) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Content-Length (");
                ((StringBuilder)object).append(l2);
                ((StringBuilder)object).append(") and stream length (");
                ((StringBuilder)object).append(byArray.length);
                ((StringBuilder)object).append(") disagree");
                throw new IOException(((StringBuilder)object).toString());
            }
            return byArray;
            finally {
                Util.closeQuietly((Closeable)object);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot buffer entire body for content length: ");
        stringBuilder.append(l2);
        throw new IOException(stringBuilder.toString());
    }

    public final Reader charStream() {
        Reader reader = this.reader;
        if (reader == null) {
            this.reader = reader = new BomAwareReader(SpecialsBridge.retrofitExceptionCatchingRequestBody_source(this), this.charset());
        }
        return reader;
    }

    @Override
    public void close() {
        Util.closeQuietly((Closeable)SpecialsBridge.retrofitExceptionCatchingRequestBody_source(this));
    }

    public abstract long contentLength();

    @Nullable
    public abstract MediaType contentType();

    public abstract BufferedSource source();

    public final String string() throws IOException {
        BufferedSource bufferedSource = SpecialsBridge.retrofitExceptionCatchingRequestBody_source(this);
        try {
            String string2 = bufferedSource.readString(Util.bomAwareCharset(bufferedSource, this.charset()));
            return string2;
        }
        finally {
            Util.closeQuietly((Closeable)bufferedSource);
        }
    }

    static final class BomAwareReader
    extends Reader {
        private final Charset charset;
        private boolean closed;
        @Nullable
        private Reader delegate;
        private final BufferedSource source;

        BomAwareReader(BufferedSource bufferedSource, Charset charset) {
            this.source = bufferedSource;
            this.charset = charset;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            Reader reader = this.delegate;
            if (reader != null) {
                reader.close();
            } else {
                this.source.close();
            }
        }

        @Override
        public int read(char[] cArray, int n2, int n3) throws IOException {
            if (!this.closed) {
                Reader reader = this.delegate;
                Object object = reader;
                if (reader == null) {
                    object = Util.bomAwareCharset(this.source, this.charset);
                    this.delegate = object = new InputStreamReader(this.source.inputStream(), (Charset)object);
                }
                return ((Reader)object).read(cArray, n2, n3);
            }
            throw new IOException("Stream closed");
        }
    }
}

