/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.MediaType;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okio.BufferedSink;
import com.mbridge.msdk.thrid.okio.ByteString;
import com.mbridge.msdk.thrid.okio.Okio;
import com.mbridge.msdk.thrid.okio.Source;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

public abstract class RequestBody {
    public static RequestBody create(final @Nullable MediaType mediaType, final ByteString byteString) {
        return new RequestBody(){

            @Override
            public long contentLength() throws IOException {
                return byteString.size();
            }

            @Override
            @Nullable
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(byteString);
            }
        };
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final File file) {
        if (file != null) {
            return new RequestBody(){

                @Override
                public long contentLength() {
                    return file.length();
                }

                @Override
                @Nullable
                public MediaType contentType() {
                    return mediaType;
                }

                @Override
                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    Source source;
                    Source source2 = null;
                    try {
                        source2 = source = Okio.source((File)file);
                    }
                    catch (Throwable throwable) {
                        Util.closeQuietly(source2);
                        throw throwable;
                    }
                    bufferedSink.writeAll(source);
                    Util.closeQuietly((Closeable)source);
                }
            };
        }
        throw new NullPointerException("file == null");
    }

    public static RequestBody create(@Nullable MediaType mediaType, String string2) {
        Charset charset = Util.UTF_8;
        Object object = mediaType;
        if (mediaType != null) {
            Charset charset2;
            charset = charset2 = mediaType.charset();
            object = mediaType;
            if (charset2 == null) {
                charset = Util.UTF_8;
                object = new StringBuilder();
                ((StringBuilder)object).append(mediaType);
                ((StringBuilder)object).append("; charset=utf-8");
                object = MediaType.parse(((StringBuilder)object).toString());
            }
        }
        return RequestBody.create((MediaType)object, string2.getBytes(charset));
    }

    public static RequestBody create(@Nullable MediaType mediaType, byte[] byArray) {
        return RequestBody.create(mediaType, byArray, 0, byArray.length);
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final byte[] byArray, final int n2, final int n3) {
        if (byArray != null) {
            Util.checkOffsetAndCount(byArray.length, n2, n3);
            return new RequestBody(){

                @Override
                public long contentLength() {
                    return n3;
                }

                @Override
                @Nullable
                public MediaType contentType() {
                    return mediaType;
                }

                @Override
                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    bufferedSink.write(byArray, n2, n3);
                }
            };
        }
        throw new NullPointerException("content == null");
    }

    public long contentLength() throws IOException {
        return -1L;
    }

    @Nullable
    public abstract MediaType contentType();

    public abstract void writeTo(BufferedSink var1) throws IOException;
}

