/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.Call;
import com.mbridge.msdk.thrid.okhttp.Callback;
import com.mbridge.msdk.thrid.okhttp.EventListener;
import com.mbridge.msdk.thrid.okhttp.Interceptor;
import com.mbridge.msdk.thrid.okhttp.OkHttpClient;
import com.mbridge.msdk.thrid.okhttp.Request;
import com.mbridge.msdk.thrid.okhttp.Response;
import com.mbridge.msdk.thrid.okhttp.internal.NamedRunnable;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.cache.CacheInterceptor;
import com.mbridge.msdk.thrid.okhttp.internal.connection.ConnectInterceptor;
import com.mbridge.msdk.thrid.okhttp.internal.connection.StreamAllocation;
import com.mbridge.msdk.thrid.okhttp.internal.http.BridgeInterceptor;
import com.mbridge.msdk.thrid.okhttp.internal.http.CallServerInterceptor;
import com.mbridge.msdk.thrid.okhttp.internal.http.RealInterceptorChain;
import com.mbridge.msdk.thrid.okhttp.internal.http.RetryAndFollowUpInterceptor;
import com.mbridge.msdk.thrid.okhttp.internal.platform.Platform;
import com.mbridge.msdk.thrid.okio.AsyncTimeout;
import com.mbridge.msdk.thrid.okio.Timeout;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class RealCall
implements Call {
    final OkHttpClient client;
    @Nullable
    private EventListener eventListener;
    private boolean executed;
    final boolean forWebSocket;
    final Request originalRequest;
    final RetryAndFollowUpInterceptor retryAndFollowUpInterceptor;
    final AsyncTimeout timeout;

    private RealCall(OkHttpClient okHttpClient, Request request, boolean bl) {
        this.client = okHttpClient;
        this.originalRequest = request;
        this.forWebSocket = bl;
        this.retryAndFollowUpInterceptor = new RetryAndFollowUpInterceptor(okHttpClient, bl);
        this.timeout = new AsyncTimeout(){

            protected void timedOut() {
                RealCall.this.cancel();
            }
        };
        this.timeout.timeout((long)okHttpClient.callTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    private void captureCallStackTrace() {
        Object object = Platform.get().getStackTraceForCloseable("response.body().close()");
        this.retryAndFollowUpInterceptor.setCallStackTrace(object);
    }

    static RealCall newRealCall(OkHttpClient okHttpClient, Request object, boolean bl) {
        object = new RealCall(okHttpClient, (Request)object, bl);
        ((RealCall)object).eventListener = okHttpClient.eventListenerFactory().create((Call)object);
        return object;
    }

    @Override
    public void cancel() {
        this.retryAndFollowUpInterceptor.cancel();
    }

    @Override
    public RealCall clone() {
        return RealCall.newRealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void enqueue(Callback object) {
        synchronized (this) {
            if (!this.executed) {
                this.executed = true;
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl4 : MonitorExitStatement: MONITOREXIT : this
                this.captureCallStackTrace();
                this.eventListener.callStart(this);
                this.client.dispatcher().enqueue(new AsyncCall((Callback)object));
                return;
            }
            object = new IllegalStateException("Already Executed");
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response execute() throws IOException {
        synchronized (this) {
            if (this.executed) {
                IllegalStateException illegalStateException = new IllegalStateException("Already Executed");
                throw illegalStateException;
            }
            this.executed = true;
        }
        this.captureCallStackTrace();
        this.timeout.enter();
        this.eventListener.callStart(this);
        try {
            this.client.dispatcher().executed(this);
            Object object = this.getResponseWithInterceptorChain();
            if (object != null) {
                this.client.dispatcher().finished(this);
                return object;
            }
            object = new IOException("Canceled");
            throw object;
        }
        catch (Throwable throwable) {
        }
        catch (IOException iOException) {
            IOException iOException2 = this.timeoutExit(iOException);
            this.eventListener.callFailed(this, iOException2);
            throw iOException2;
        }
        this.client.dispatcher().finished(this);
        throw throwable;
    }

    Response getResponseWithInterceptorChain() throws IOException {
        Object object = new ArrayList<Interceptor>();
        object.addAll(this.client.interceptors());
        object.add(this.retryAndFollowUpInterceptor);
        object.add(new BridgeInterceptor(this.client.cookieJar()));
        object.add(new CacheInterceptor(this.client.internalCache()));
        object.add(new ConnectInterceptor(this.client));
        if (!this.forWebSocket) {
            object.addAll(this.client.networkInterceptors());
        }
        object.add(new CallServerInterceptor(this.forWebSocket));
        object = new RealInterceptorChain(object, null, null, null, 0, this.originalRequest, (Call)this, this.eventListener, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis()).proceed(this.originalRequest);
        if (!this.retryAndFollowUpInterceptor.isCanceled()) {
            return object;
        }
        Util.closeQuietly((Closeable)object);
        throw new IOException("Canceled");
    }

    @Override
    public boolean isCanceled() {
        return this.retryAndFollowUpInterceptor.isCanceled();
    }

    @Override
    public boolean isExecuted() {
        synchronized (this) {
            boolean bl = this.executed;
            return bl;
        }
    }

    String redactedUrl() {
        return this.originalRequest.url().redact();
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    StreamAllocation streamAllocation() {
        return this.retryAndFollowUpInterceptor.streamAllocation();
    }

    @Override
    public Timeout timeout() {
        return this.timeout;
    }

    @Nullable
    IOException timeoutExit(@Nullable IOException iOException) {
        if (!this.timeout.exit()) {
            return iOException;
        }
        InterruptedIOException interruptedIOException = new InterruptedIOException("timeout");
        if (iOException != null) {
            interruptedIOException.initCause(iOException);
        }
        return interruptedIOException;
    }

    String toLoggableString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.isCanceled() ? "canceled " : "";
        stringBuilder.append(string2);
        string2 = this.forWebSocket ? "web socket" : "call";
        stringBuilder.append(string2);
        stringBuilder.append(" to ");
        stringBuilder.append(this.redactedUrl());
        return stringBuilder.toString();
    }

    final class AsyncCall
    extends NamedRunnable {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        private final Callback responseCallback;

        AsyncCall(Callback callback2) {
            super("OkHttp %s", new Object[]{RealCall.this.redactedUrl()});
            this.responseCallback = callback2;
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void execute() {
            StringBuilder stringBuilder;
            boolean bl;
            block15: {
                block14: {
                    RealCall.this.timeout.enter();
                    Response response = RealCall.this.getResponseWithInterceptorChain();
                    boolean bl2 = true;
                    bl = true;
                    try {
                        this.responseCallback.onResponse((Call)RealCall.this, response);
                        return;
                    }
                    catch (Throwable throwable) {
                        break block14;
                    }
                    catch (IOException iOException) {
                        bl = bl2;
                        break block15;
                    }
                    catch (Throwable throwable) {
                        bl = false;
                    }
                }
                RealCall.this.cancel();
                if (bl) throw stringBuilder;
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("canceled due to ");
                stringBuilder2.append((Object)stringBuilder);
                IOException iOException = new IOException(stringBuilder2.toString());
                this.responseCallback.onFailure((Call)RealCall.this, iOException);
                throw stringBuilder;
                catch (IOException iOException2) {
                    bl = false;
                }
            }
            try {
                IOException iOException = RealCall.this.timeoutExit((IOException)((Object)stringBuilder));
                if (bl) {
                    Platform platform = Platform.get();
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("Callback failure for ");
                    stringBuilder.append(RealCall.this.toLoggableString());
                    platform.log(4, stringBuilder.toString(), iOException);
                    return;
                } else {
                    RealCall.this.eventListener.callFailed(RealCall.this, iOException);
                    this.responseCallback.onFailure((Call)RealCall.this, iOException);
                }
                return;
            }
            finally {
                RealCall.this.client.dispatcher().finished(this);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void executeOn(ExecutorService object) {
            try {
                try {
                    object.execute((Runnable)((Object)this));
                    return;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    object = new InterruptedIOException("executor rejected");
                    ((Throwable)object).initCause(rejectedExecutionException);
                    RealCall.this.eventListener.callFailed(RealCall.this, (IOException)object);
                    this.responseCallback.onFailure((Call)RealCall.this, (IOException)object);
                    RealCall.this.client.dispatcher().finished(this);
                    return;
                }
            }
            catch (Throwable throwable) {}
            RealCall.this.client.dispatcher().finished(this);
            throw throwable;
        }

        RealCall get() {
            return RealCall.this;
        }

        String host() {
            return RealCall.this.originalRequest.url().host();
        }

        Request request() {
            return RealCall.this.originalRequest;
        }
    }
}

