/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.Headers;
import com.mbridge.msdk.thrid.okhttp.MediaType;
import com.mbridge.msdk.thrid.okhttp.RequestBody;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.BufferedSink;
import com.mbridge.msdk.thrid.okio.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public final class MultipartBody
extends RequestBody {
    public static final MediaType ALTERNATIVE;
    private static final byte[] COLONSPACE;
    private static final byte[] CRLF;
    private static final byte[] DASHDASH;
    public static final MediaType DIGEST;
    public static final MediaType FORM;
    public static final MediaType MIXED;
    public static final MediaType PARALLEL;
    private final ByteString boundary;
    private long contentLength = -1L;
    private final MediaType contentType;
    private final MediaType originalType;
    private final List<Part> parts;

    static {
        MIXED = MediaType.get("multipart/mixed");
        ALTERNATIVE = MediaType.get("multipart/alternative");
        DIGEST = MediaType.get("multipart/digest");
        PARALLEL = MediaType.get("multipart/parallel");
        FORM = MediaType.get("multipart/form-data");
        COLONSPACE = new byte[]{58, 32};
        CRLF = new byte[]{13, 10};
        DASHDASH = new byte[]{45, 45};
    }

    MultipartBody(ByteString byteString, MediaType mediaType, List<Part> list) {
        this.boundary = byteString;
        this.originalType = mediaType;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(mediaType);
        stringBuilder.append("; boundary=");
        stringBuilder.append(byteString.utf8());
        this.contentType = MediaType.get(stringBuilder.toString());
        this.parts = Util.immutableList(list);
    }

    static StringBuilder appendQuotedString(StringBuilder stringBuilder, String string2) {
        stringBuilder.append('\"');
        int n2 = string2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 != '\n') {
                if (c2 != '\r') {
                    if (c2 != '\"') {
                        stringBuilder.append(c2);
                        continue;
                    }
                    stringBuilder.append("%22");
                    continue;
                }
                stringBuilder.append("%0D");
                continue;
            }
            stringBuilder.append("%0A");
        }
        stringBuilder.append('\"');
        return stringBuilder;
    }

    private long writeOrCountBytes(@Nullable BufferedSink bufferedSink, boolean bl) throws IOException {
        long l2;
        BufferedSink bufferedSink2 = bl ? (bufferedSink = new Buffer()) : null;
        int n2 = this.parts.size();
        long l3 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.parts.get(i2);
            Object object2 = ((Part)object).headers;
            object = ((Part)object).body;
            bufferedSink.write(DASHDASH);
            bufferedSink.write(this.boundary);
            bufferedSink.write(CRLF);
            if (object2 != null) {
                int n3 = ((Headers)object2).size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    bufferedSink.writeUtf8(((Headers)object2).name(i3)).write(COLONSPACE).writeUtf8(((Headers)object2).value(i3)).write(CRLF);
                }
            }
            if ((object2 = ((RequestBody)object).contentType()) != null) {
                bufferedSink.writeUtf8("Content-Type: ").writeUtf8(((MediaType)object2).toString()).write(CRLF);
            }
            if ((l2 = ((RequestBody)object).contentLength()) != -1L) {
                bufferedSink.writeUtf8("Content-Length: ").writeDecimalLong(l2).write(CRLF);
            } else if (bl) {
                bufferedSink2.clear();
                return -1L;
            }
            bufferedSink.write(CRLF);
            if (bl) {
                l3 += l2;
            } else {
                ((RequestBody)object).writeTo(bufferedSink);
            }
            bufferedSink.write(CRLF);
        }
        bufferedSink.write(DASHDASH);
        bufferedSink.write(this.boundary);
        bufferedSink.write(DASHDASH);
        bufferedSink.write(CRLF);
        l2 = l3;
        if (bl) {
            l2 = l3 + bufferedSink2.size();
            bufferedSink2.clear();
        }
        return l2;
    }

    public String boundary() {
        return this.boundary.utf8();
    }

    @Override
    public long contentLength() throws IOException {
        long l2 = this.contentLength;
        if (l2 != -1L) {
            return l2;
        }
        this.contentLength = l2 = this.writeOrCountBytes(null, true);
        return l2;
    }

    @Override
    public MediaType contentType() {
        return this.contentType;
    }

    public Part part(int n2) {
        return this.parts.get(n2);
    }

    public List<Part> parts() {
        return this.parts;
    }

    public int size() {
        return this.parts.size();
    }

    public MediaType type() {
        return this.originalType;
    }

    @Override
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        this.writeOrCountBytes(bufferedSink, false);
    }

    public static final class Builder {
        private final ByteString boundary;
        private final List<Part> parts;
        private MediaType type = MIXED;

        public Builder() {
            this(UUID.randomUUID().toString());
        }

        public Builder(String string2) {
            this.parts = new ArrayList<Part>();
            this.boundary = ByteString.encodeUtf8((String)string2);
        }

        public Builder addFormDataPart(String string2, String string3) {
            return this.addPart(Part.createFormData(string2, string3));
        }

        public Builder addFormDataPart(String string2, @Nullable String string3, RequestBody requestBody) {
            return this.addPart(Part.createFormData(string2, string3, requestBody));
        }

        public Builder addPart(@Nullable Headers headers, RequestBody requestBody) {
            return this.addPart(Part.create(headers, requestBody));
        }

        public Builder addPart(Part part) {
            if (part != null) {
                this.parts.add(part);
                return this;
            }
            throw new NullPointerException("part == null");
        }

        public Builder addPart(RequestBody requestBody) {
            return this.addPart(Part.create(requestBody));
        }

        public MultipartBody build() {
            if (!this.parts.isEmpty()) {
                return new MultipartBody(this.boundary, this.type, this.parts);
            }
            throw new IllegalStateException("Multipart body must have at least one part.");
        }

        public Builder setType(MediaType mediaType) {
            if (mediaType != null) {
                if (mediaType.type().equals("multipart")) {
                    this.type = mediaType;
                    return this;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("multipart != ");
                stringBuilder.append(mediaType);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            throw new NullPointerException("type == null");
        }
    }

    public static final class Part {
        final RequestBody body;
        @Nullable
        final Headers headers;

        private Part(@Nullable Headers headers, RequestBody requestBody) {
            this.headers = headers;
            this.body = requestBody;
        }

        public static Part create(@Nullable Headers headers, RequestBody requestBody) {
            if (requestBody != null) {
                if (headers != null && headers.get("Content-Type") != null) {
                    throw new IllegalArgumentException("Unexpected header: Content-Type");
                }
                if (headers != null && headers.get("Content-Length") != null) {
                    throw new IllegalArgumentException("Unexpected header: Content-Length");
                }
                return new Part(headers, requestBody);
            }
            throw new NullPointerException("body == null");
        }

        public static Part create(RequestBody requestBody) {
            return Part.create(null, requestBody);
        }

        public static Part createFormData(String string2, String string3) {
            return Part.createFormData(string2, null, RequestBody.create(null, string3));
        }

        public static Part createFormData(String string2, @Nullable String string3, RequestBody requestBody) {
            if (string2 != null) {
                StringBuilder stringBuilder = new StringBuilder("form-data; name=");
                MultipartBody.appendQuotedString(stringBuilder, string2);
                if (string3 != null) {
                    stringBuilder.append("; filename=");
                    MultipartBody.appendQuotedString(stringBuilder, string3);
                }
                return Part.create(new Headers.Builder().addUnsafeNonAscii("Content-Disposition", stringBuilder.toString()).build(), requestBody);
            }
            throw new NullPointerException("name == null");
        }

        public RequestBody body() {
            return this.body;
        }

        @Nullable
        public Headers headers() {
            return this.headers;
        }
    }
}

