/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class MediaType {
    private static final Pattern PARAMETER;
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final Pattern TYPE_SUBTYPE;
    @Nullable
    private final String charset;
    private final String mediaType;
    private final String subtype;
    private final String type;

    static {
        TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
        PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    }

    private MediaType(String string2, String string3, String string4, @Nullable String string5) {
        this.mediaType = string2;
        this.type = string3;
        this.subtype = string4;
        this.charset = string5;
    }

    public static MediaType get(String object) {
        Object object2 = TYPE_SUBTYPE.matcher((CharSequence)object);
        if (((Matcher)object2).lookingAt()) {
            String string2 = ((Matcher)object2).group(1).toLowerCase(Locale.US);
            String string3 = ((Matcher)object2).group(2).toLowerCase(Locale.US);
            Object object3 = null;
            Matcher matcher = PARAMETER.matcher((CharSequence)object);
            int n2 = ((Matcher)object2).end();
            while (n2 < ((String)object).length()) {
                matcher.region(n2, ((String)object).length());
                if (matcher.lookingAt()) {
                    CharSequence charSequence = matcher.group(1);
                    object2 = object3;
                    if (charSequence != null) {
                        if (!((String)charSequence).equalsIgnoreCase("charset")) {
                            object2 = object3;
                        } else {
                            charSequence = matcher.group(2);
                            if (charSequence != null) {
                                object2 = charSequence;
                                if (((String)charSequence).startsWith("'")) {
                                    object2 = charSequence;
                                    if (((String)charSequence).endsWith("'")) {
                                        object2 = charSequence;
                                        if (((String)charSequence).length() > 2) {
                                            object2 = ((String)charSequence).substring(1, ((String)charSequence).length() - 1);
                                        }
                                    }
                                }
                            } else {
                                object2 = matcher.group(3);
                            }
                            if (object3 != null && !((String)object2).equalsIgnoreCase((String)object3)) {
                                charSequence = new StringBuilder();
                                ((StringBuilder)charSequence).append("Multiple charsets defined: \"");
                                ((StringBuilder)charSequence).append((String)object3);
                                ((StringBuilder)charSequence).append("\" and: \"");
                                ((StringBuilder)charSequence).append((String)object2);
                                ((StringBuilder)charSequence).append("\" for: \"");
                                ((StringBuilder)charSequence).append((String)object);
                                ((StringBuilder)charSequence).append('\"');
                                throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
                            }
                        }
                    }
                    n2 = matcher.end();
                    object3 = object2;
                    continue;
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Parameter is not formatted correctly: \"");
                ((StringBuilder)object2).append(((String)object).substring(n2));
                ((StringBuilder)object2).append("\" for: \"");
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append('\"');
                throw new IllegalArgumentException(((StringBuilder)object2).toString());
            }
            return new MediaType((String)object, string2, string3, (String)object3);
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("No subtype found for: \"");
        ((StringBuilder)object2).append((String)object);
        ((StringBuilder)object2).append('\"');
        object = new IllegalArgumentException(((StringBuilder)object2).toString());
        throw object;
    }

    @Nullable
    public static MediaType parse(String object) {
        try {
            object = MediaType.get((String)object);
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Nullable
    public Charset charset() {
        return this.charset(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Charset charset(@Nullable Charset charset) {
        Charset charset2 = charset;
        try {
            if (this.charset == null) return charset2;
            return Charset.forName(this.charset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return charset;
        }
    }

    public boolean equals(@Nullable Object object) {
        boolean bl = object instanceof MediaType && ((MediaType)object).mediaType.equals(this.mediaType);
        return bl;
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public String subtype() {
        return this.subtype;
    }

    public String toString() {
        return this.mediaType;
    }

    public String type() {
        return this.type;
    }
}

