/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;

public final class Headers {
    private final String[] namesAndValues;

    Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] stringArray) {
        this.namesAndValues = stringArray;
    }

    static void checkName(String object) {
        if (object != null) {
            if (!((String)object).isEmpty()) {
                int n2 = ((String)object).length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    char c2 = ((String)object).charAt(i2);
                    if (c2 > ' ' && c2 < '\u007f') {
                        continue;
                    }
                    throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in header name: %s", c2, i2, object));
                }
                return;
            }
            throw new IllegalArgumentException("name is empty");
        }
        object = new NullPointerException("name == null");
        throw object;
    }

    static void checkValue(String object, String string2) {
        if (object != null) {
            int n2 = ((String)object).length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = ((String)object).charAt(i2);
                if ((c2 > '\u001f' || c2 == '\t') && c2 < '\u007f') {
                    continue;
                }
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in %s value: %s", c2, i2, string2, object));
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("value for name ");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" == null");
        object = new NullPointerException(((StringBuilder)object).toString());
        throw object;
    }

    private static String get(String[] stringArray, String string2) {
        for (int i2 = stringArray.length - 2; i2 >= 0; i2 -= 2) {
            if (!string2.equalsIgnoreCase(stringArray[i2])) continue;
            return stringArray[i2 + 1];
        }
        return null;
    }

    public static Headers of(Map<String, String> iterator2) {
        if (iterator2 != null) {
            String[] stringArray = new String[iterator2.size() * 2];
            int n2 = 0;
            for (Map.Entry entry : iterator2.entrySet()) {
                if (entry.getKey() != null && entry.getValue() != null) {
                    String string2 = ((String)entry.getKey()).trim();
                    entry = ((String)entry.getValue()).trim();
                    Headers.checkName(string2);
                    Headers.checkValue((String)((Object)entry), string2);
                    stringArray[n2] = string2;
                    stringArray[n2 + 1] = entry;
                    n2 += 2;
                    continue;
                }
                throw new IllegalArgumentException("Headers cannot be null");
            }
            return new Headers(stringArray);
        }
        iterator2 = new NullPointerException("headers == null");
        throw iterator2;
    }

    public static Headers of(String ... object) {
        if (object != null) {
            if (((String[])object).length % 2 == 0) {
                block4: {
                    object = (String[])object.clone();
                    int n2 = 0;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= ((Object)object).length) break block4;
                        if (object[n3] == null) break;
                        object[n3] = ((String)object[n3]).trim();
                        ++n3;
                    }
                    throw new IllegalArgumentException("Headers cannot be null");
                }
                for (int i2 = n2; i2 < ((Object)object).length; i2 += 2) {
                    Object object2 = object[i2];
                    Object object3 = object[i2 + 1];
                    Headers.checkName((String)object2);
                    Headers.checkValue((String)object3, (String)object2);
                }
                return new Headers((String[])object);
            }
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        object = new NullPointerException("namesAndValues == null");
        throw object;
    }

    public long byteCount() {
        String[] stringArray = this.namesAndValues;
        long l2 = stringArray.length * 2;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 += (long)this.namesAndValues[i2].length();
        }
        return l2;
    }

    public boolean equals(@Nullable Object object) {
        boolean bl = object instanceof Headers && Arrays.equals(((Headers)object).namesAndValues, this.namesAndValues);
        return bl;
    }

    @Nullable
    public String get(String string2) {
        return Headers.get(this.namesAndValues, string2);
    }

    @Nullable
    public Date getDate(String object) {
        object = (object = this.get((String)object)) != null ? HttpDate.parse((String)object) : null;
        return object;
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    public String name(int n2) {
        return this.namesAndValues[n2 * 2];
    }

    public Set<String> names() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            treeSet.add(this.name(i2));
        }
        return Collections.unmodifiableSet(treeSet);
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        Collections.addAll(builder.namesAndValues, this.namesAndValues);
        return builder;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public Map<String, List<String>> toMultimap() {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ArrayList<String> arrayList;
            String string2 = this.name(i2).toLowerCase(Locale.US);
            ArrayList<String> arrayList2 = arrayList = (ArrayList<String>)treeMap.get(string2);
            if (arrayList == null) {
                arrayList2 = new ArrayList<String>(2);
                treeMap.put(string2, arrayList2);
            }
            arrayList2.add(this.value(i2));
        }
        return treeMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(this.name(i2));
            stringBuilder.append(": ");
            stringBuilder.append(this.value(i2));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String value(int n2) {
        return this.namesAndValues[n2 * 2 + 1];
    }

    public List<String> values(String list) {
        int n2 = this.size();
        ArrayList<String> arrayList = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            ArrayList<String> arrayList2 = arrayList;
            if (((String)((Object)list)).equalsIgnoreCase(this.name(i2))) {
                arrayList2 = arrayList;
                if (arrayList == null) {
                    arrayList2 = new ArrayList<String>(2);
                }
                arrayList2.add(this.value(i2));
            }
            arrayList = arrayList2;
        }
        list = arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
        return list;
    }

    public static final class Builder {
        final List<String> namesAndValues = new ArrayList<String>(20);

        public Builder add(String string2) {
            int n2 = string2.indexOf(":");
            if (n2 != -1) {
                return this.add(string2.substring(0, n2).trim(), string2.substring(n2 + 1));
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unexpected header: ");
            stringBuilder.append(string2);
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        public Builder add(String string2, String string3) {
            Headers.checkName(string2);
            Headers.checkValue(string3, string2);
            return this.addLenient(string2, string3);
        }

        public Builder add(String string2, Date comparable) {
            if (comparable != null) {
                this.add(string2, HttpDate.format((Date)comparable));
                return this;
            }
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("value for name ");
            ((StringBuilder)comparable).append(string2);
            ((StringBuilder)comparable).append(" == null");
            throw new NullPointerException(((StringBuilder)comparable).toString());
        }

        public Builder addAll(Headers headers) {
            int n2 = headers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.addLenient(headers.name(i2), headers.value(i2));
            }
            return this;
        }

        Builder addLenient(String string2) {
            int n2 = string2.indexOf(":", 1);
            if (n2 != -1) {
                return this.addLenient(string2.substring(0, n2), string2.substring(n2 + 1));
            }
            if (string2.startsWith(":")) {
                return this.addLenient("", string2.substring(1));
            }
            return this.addLenient("", string2);
        }

        Builder addLenient(String string2, String string3) {
            this.namesAndValues.add(string2);
            this.namesAndValues.add(string3.trim());
            return this;
        }

        public Builder addUnsafeNonAscii(String string2, String string3) {
            Headers.checkName(string2);
            return this.addLenient(string2, string3);
        }

        public Headers build() {
            return new Headers(this);
        }

        public String get(String string2) {
            for (int i2 = this.namesAndValues.size() - 2; i2 >= 0; i2 -= 2) {
                if (!string2.equalsIgnoreCase(this.namesAndValues.get(i2))) continue;
                return this.namesAndValues.get(i2 + 1);
            }
            return null;
        }

        public Builder removeAll(String string2) {
            int n2 = 0;
            while (n2 < this.namesAndValues.size()) {
                int n3 = n2;
                if (string2.equalsIgnoreCase(this.namesAndValues.get(n2))) {
                    this.namesAndValues.remove(n2);
                    this.namesAndValues.remove(n2);
                    n3 = n2 - 2;
                }
                n2 = n3 + 2;
            }
            return this;
        }

        public Builder set(String string2, String string3) {
            Headers.checkName(string2);
            Headers.checkValue(string3, string2);
            this.removeAll(string2);
            this.addLenient(string2, string3);
            return this;
        }

        public Builder set(String string2, Date comparable) {
            if (comparable != null) {
                this.set(string2, HttpDate.format((Date)comparable));
                return this;
            }
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("value for name ");
            ((StringBuilder)comparable).append(string2);
            ((StringBuilder)comparable).append(" == null");
            throw new NullPointerException(((StringBuilder)comparable).toString());
        }
    }
}

