/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.CipherSuite;
import com.mbridge.msdk.thrid.okhttp.TlsVersion;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

public final class Handshake {
    private final CipherSuite cipherSuite;
    private final List<Certificate> localCertificates;
    private final List<Certificate> peerCertificates;
    private final TlsVersion tlsVersion;

    private Handshake(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        this.tlsVersion = tlsVersion;
        this.cipherSuite = cipherSuite;
        this.peerCertificates = list;
        this.localCertificates = list2;
    }

    public static Handshake get(TlsVersion tlsVersion, CipherSuite cipherSuite, List<Certificate> list, List<Certificate> list2) {
        if (tlsVersion != null) {
            if (cipherSuite != null) {
                return new Handshake(tlsVersion, cipherSuite, Util.immutableList(list), Util.immutableList(list2));
            }
            throw new NullPointerException("cipherSuite == null");
        }
        throw new NullPointerException("tlsVersion == null");
    }

    public static Handshake get(SSLSession object) throws IOException {
        Object object2 = object.getCipherSuite();
        if (object2 != null) {
            if (!"SSL_NULL_WITH_NULL_NULL".equals(object2)) {
                CipherSuite cipherSuite = CipherSuite.forJavaName((String)object2);
                object2 = object.getProtocol();
                if (object2 != null) {
                    if (!"NONE".equals(object2)) {
                        TlsVersion tlsVersion = TlsVersion.forJavaName((String)object2);
                        try {
                            object2 = object.getPeerCertificates();
                        }
                        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                            object2 = null;
                        }
                        object2 = object2 != null ? Util.immutableList(object2) : Collections.emptyList();
                        object = object.getLocalCertificates();
                        object = object != null ? Util.immutableList(object) : Collections.emptyList();
                        return new Handshake(tlsVersion, cipherSuite, (List<Certificate>)object2, (List<Certificate>)object);
                    }
                    throw new IOException("tlsVersion == NONE");
                }
                throw new IllegalStateException("tlsVersion == null");
            }
            throw new IOException("cipherSuite == SSL_NULL_WITH_NULL_NULL");
        }
        throw new IllegalStateException("cipherSuite == null");
    }

    public CipherSuite cipherSuite() {
        return this.cipherSuite;
    }

    public boolean equals(@Nullable Object object) {
        boolean bl = object instanceof Handshake;
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        object = (Handshake)object;
        bl = bl2;
        if (this.tlsVersion.equals((Object)((Handshake)object).tlsVersion)) {
            bl = bl2;
            if (this.cipherSuite.equals(((Handshake)object).cipherSuite)) {
                bl = bl2;
                if (this.peerCertificates.equals(((Handshake)object).peerCertificates)) {
                    bl = bl2;
                    if (this.localCertificates.equals(((Handshake)object).localCertificates)) {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        return (((527 + this.tlsVersion.hashCode()) * 31 + this.cipherSuite.hashCode()) * 31 + this.peerCertificates.hashCode()) * 31 + this.localCertificates.hashCode();
    }

    public List<Certificate> localCertificates() {
        return this.localCertificates;
    }

    @Nullable
    public Principal localPrincipal() {
        X500Principal x500Principal = !this.localCertificates.isEmpty() ? ((X509Certificate)this.localCertificates.get(0)).getSubjectX500Principal() : null;
        return x500Principal;
    }

    public List<Certificate> peerCertificates() {
        return this.peerCertificates;
    }

    @Nullable
    public Principal peerPrincipal() {
        X500Principal x500Principal = !this.peerCertificates.isEmpty() ? ((X509Certificate)this.peerCertificates.get(0)).getSubjectX500Principal() : null;
        return x500Principal;
    }

    public TlsVersion tlsVersion() {
        return this.tlsVersion;
    }
}

