/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.HttpUrl;
import com.mbridge.msdk.thrid.okhttp.MediaType;
import com.mbridge.msdk.thrid.okhttp.RequestBody;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.BufferedSink;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class FormBody
extends RequestBody {
    private static final MediaType CONTENT_TYPE = MediaType.get("application/x-www-form-urlencoded");
    private final List<String> encodedNames;
    private final List<String> encodedValues;

    FormBody(List<String> list, List<String> list2) {
        this.encodedNames = Util.immutableList(list);
        this.encodedValues = Util.immutableList(list2);
    }

    private long writeOrCountBytes(@Nullable BufferedSink bufferedSink, boolean bl) {
        long l2;
        bufferedSink = bl ? new Buffer() : bufferedSink.buffer();
        int n2 = this.encodedNames.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                bufferedSink.writeByte(38);
            }
            bufferedSink.writeUtf8(this.encodedNames.get(i2));
            bufferedSink.writeByte(61);
            bufferedSink.writeUtf8(this.encodedValues.get(i2));
        }
        if (bl) {
            l2 = bufferedSink.size();
            bufferedSink.clear();
        } else {
            l2 = 0L;
        }
        return l2;
    }

    @Override
    public long contentLength() {
        return this.writeOrCountBytes(null, true);
    }

    @Override
    public MediaType contentType() {
        return CONTENT_TYPE;
    }

    public String encodedName(int n2) {
        return this.encodedNames.get(n2);
    }

    public String encodedValue(int n2) {
        return this.encodedValues.get(n2);
    }

    public String name(int n2) {
        return HttpUrl.percentDecode(this.encodedName(n2), true);
    }

    public int size() {
        return this.encodedNames.size();
    }

    public String value(int n2) {
        return HttpUrl.percentDecode(this.encodedValue(n2), true);
    }

    @Override
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        this.writeOrCountBytes(bufferedSink, false);
    }

    public static final class Builder {
        private final Charset charset;
        private final List<String> names = new ArrayList<String>();
        private final List<String> values = new ArrayList<String>();

        public Builder() {
            this(null);
        }

        public Builder(Charset charset) {
            this.charset = charset;
        }

        public Builder add(String string2, String string3) {
            if (string2 != null) {
                if (string3 != null) {
                    this.names.add(HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#&!$(),~", false, false, true, true, this.charset));
                    this.values.add(HttpUrl.canonicalize(string3, " \"':;<=>@[]^`{}|/\\?#&!$(),~", false, false, true, true, this.charset));
                    return this;
                }
                throw new NullPointerException("value == null");
            }
            throw new NullPointerException("name == null");
        }

        public Builder addEncoded(String string2, String string3) {
            if (string2 != null) {
                if (string3 != null) {
                    this.names.add(HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#&!$(),~", true, false, true, true, this.charset));
                    this.values.add(HttpUrl.canonicalize(string3, " \"':;<=>@[]^`{}|/\\?#&!$(),~", true, false, true, true, this.charset));
                    return this;
                }
                throw new NullPointerException("value == null");
            }
            throw new NullPointerException("name == null");
        }

        public FormBody build() {
            return new FormBody(this.names, this.values);
        }
    }
}

