/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.Call;
import com.mbridge.msdk.thrid.okhttp.RealCall;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class Dispatcher {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    @Nullable
    private ExecutorService executorService;
    @Nullable
    private Runnable idleCallback;
    private int maxRequests = 64;
    private int maxRequestsPerHost = 5;
    private final Deque<RealCall.AsyncCall> readyAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall.AsyncCall> runningAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall> runningSyncCalls = new ArrayDeque<RealCall>();

    public Dispatcher() {
    }

    public Dispatcher(ExecutorService executorService) {
        this.executorService = executorService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private <T> void finished(Deque<T> object, T t2) {
        // MONITORENTER : this
        if (object.remove(t2)) {
            object = this.idleCallback;
            // MONITOREXIT : this
            if (this.promoteAndExecute()) return;
            if (object == null) return;
            object.run();
            return;
        }
        object = new AssertionError((Object)"Call wasn't in-flight!");
        throw object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean promoteAndExecute() {
        boolean bl;
        int n2;
        int n3;
        ArrayList<RealCall.AsyncCall> arrayList = new ArrayList<RealCall.AsyncCall>();
        synchronized (this) {
            Iterator<RealCall.AsyncCall> iterator2 = this.readyAsyncCalls.iterator();
            while (iterator2.hasNext()) {
                RealCall.AsyncCall asyncCall = iterator2.next();
                if (this.runningAsyncCalls.size() >= this.maxRequests) break;
                if (this.runningCallsForHost(asyncCall) >= this.maxRequestsPerHost) continue;
                iterator2.remove();
                arrayList.add(asyncCall);
                this.runningAsyncCalls.add(asyncCall);
            }
            n3 = this.runningCallsCount();
            n2 = 0;
            bl = n3 > 0;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl18 : MonitorExitStatement: MONITOREXIT : this
            n3 = arrayList.size();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        while (n2 < n3) {
            ((RealCall.AsyncCall)((Object)arrayList.get(n2))).executeOn(this.executorService());
            ++n2;
        }
        return bl;
    }

    private int runningCallsForHost(RealCall.AsyncCall asyncCall) {
        Iterator<RealCall.AsyncCall> iterator2 = this.runningAsyncCalls.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            RealCall.AsyncCall asyncCall2 = iterator2.next();
            if (asyncCall2.get().forWebSocket || !asyncCall2.host().equals(asyncCall.host())) continue;
            ++n2;
        }
        return n2;
    }

    public void cancelAll() {
        synchronized (this) {
            try {
                Iterator<Object> iterator2 = this.readyAsyncCalls.iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().get().cancel();
                }
                iterator2 = this.runningAsyncCalls.iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().get().cancel();
                }
                iterator2 = this.runningSyncCalls.iterator();
                while (iterator2.hasNext()) {
                    ((RealCall)iterator2.next()).cancel();
                }
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void enqueue(RealCall.AsyncCall asyncCall) {
        synchronized (this) {
            this.readyAsyncCalls.add(asyncCall);
        }
        this.promoteAndExecute();
    }

    void executed(RealCall realCall) {
        synchronized (this) {
            this.runningSyncCalls.add(realCall);
            return;
        }
    }

    public ExecutorService executorService() {
        synchronized (this) {
            Object object;
            if (this.executorService == null) {
                object = TimeUnit.SECONDS;
                SynchronousQueue<Runnable> synchronousQueue = new SynchronousQueue<Runnable>();
                ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, (TimeUnit)((Object)object), synchronousQueue, Util.threadFactory("OkHttp Dispatcher", false));
                this.executorService = threadPoolExecutor;
            }
            object = this.executorService;
            return object;
        }
    }

    void finished(RealCall.AsyncCall asyncCall) {
        this.finished(this.runningAsyncCalls, asyncCall);
    }

    void finished(RealCall realCall) {
        this.finished(this.runningSyncCalls, realCall);
    }

    public int getMaxRequests() {
        synchronized (this) {
            int n2 = this.maxRequests;
            return n2;
        }
    }

    public int getMaxRequestsPerHost() {
        synchronized (this) {
            int n2 = this.maxRequestsPerHost;
            return n2;
        }
    }

    public List<Call> queuedCalls() {
        synchronized (this) {
            try {
                ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
                Object object = this.readyAsyncCalls.iterator();
                while (object.hasNext()) {
                    arrayList.add(object.next().get());
                }
                object = Collections.unmodifiableList(arrayList);
                return object;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public int queuedCallsCount() {
        synchronized (this) {
            int n2 = this.readyAsyncCalls.size();
            return n2;
        }
    }

    public List<Call> runningCalls() {
        synchronized (this) {
            try {
                ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
                arrayList.addAll(this.runningSyncCalls);
                Object object = this.runningAsyncCalls.iterator();
                while (object.hasNext()) {
                    arrayList.add(object.next().get());
                }
                object = Collections.unmodifiableList(arrayList);
                return object;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public int runningCallsCount() {
        synchronized (this) {
            int n2 = this.runningAsyncCalls.size();
            int n3 = this.runningSyncCalls.size();
            return n2 + n3;
        }
    }

    public void setIdleCallback(@Nullable Runnable runnable2) {
        synchronized (this) {
            this.idleCallback = runnable2;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxRequests(int n2) {
        if (n2 >= 1) {
            synchronized (this) {
                this.maxRequests = n2;
            }
            this.promoteAndExecute();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("max < 1: ");
        stringBuilder.append(n2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxRequestsPerHost(int n2) {
        if (n2 >= 1) {
            synchronized (this) {
                this.maxRequestsPerHost = n2;
            }
            this.promoteAndExecute();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("max < 1: ");
        stringBuilder.append(n2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }
}

