/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.Headers;
import com.mbridge.msdk.thrid.okhttp.HttpUrl;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.http.HttpDate;
import com.mbridge.msdk.thrid.okhttp.internal.publicsuffix.PublicSuffixDatabase;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Cookie {
    private static final Pattern DAY_OF_MONTH_PATTERN;
    private static final Pattern MONTH_PATTERN;
    private static final Pattern TIME_PATTERN;
    private static final Pattern YEAR_PATTERN;
    private final String domain;
    private final long expiresAt;
    private final boolean hostOnly;
    private final boolean httpOnly;
    private final String name;
    private final String path;
    private final boolean persistent;
    private final boolean secure;
    private final String value;

    static {
        YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
        MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
        DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
        TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");
    }

    Cookie(Builder builder) {
        if (builder.name != null) {
            if (builder.value != null) {
                if (builder.domain != null) {
                    this.name = builder.name;
                    this.value = builder.value;
                    this.expiresAt = builder.expiresAt;
                    this.domain = builder.domain;
                    this.path = builder.path;
                    this.secure = builder.secure;
                    this.httpOnly = builder.httpOnly;
                    this.persistent = builder.persistent;
                    this.hostOnly = builder.hostOnly;
                    return;
                }
                throw new NullPointerException("builder.domain == null");
            }
            throw new NullPointerException("builder.value == null");
        }
        throw new NullPointerException("builder.name == null");
    }

    private Cookie(String string2, String string3, long l2, String string4, String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string2;
        this.value = string3;
        this.expiresAt = l2;
        this.domain = string4;
        this.path = string5;
        this.secure = bl;
        this.httpOnly = bl2;
        this.hostOnly = bl3;
        this.persistent = bl4;
    }

    private static int dateCharacterOffset(String string2, int n2, int n3, boolean bl) {
        while (n2 < n3) {
            char c2 = string2.charAt(n2);
            c2 = !(c2 < ' ' && c2 != '\t' || c2 >= '\u007f' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == ':') ? (char)'\u0000' : '\u0001';
            if (c2 == (bl ^ '\u0001')) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    private static boolean domainMatch(String string2, String string3) {
        if (string2.equals(string3)) {
            return true;
        }
        return string2.endsWith(string3) && string2.charAt(string2.length() - string3.length() - 1) == '.' && !Util.verifyAsIpAddress(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static Cookie parse(long l2, HttpUrl object, String string2) {
        int n2 = string2.length();
        int n3 = Util.delimiterOffset(string2, 0, n2, ';');
        int n4 = Util.delimiterOffset(string2, 0, n3, '=');
        if (n4 == n3) {
            return null;
        }
        String string3 = Util.trimSubstring(string2, 0, n4);
        if (string3.isEmpty()) return null;
        if (Util.indexOfControlOrNonAscii(string3) != -1) {
            return null;
        }
        String string4 = Util.trimSubstring(string2, n4 + 1, n3);
        if (Util.indexOfControlOrNonAscii(string4) != -1) {
            return null;
        }
        ++n3;
        String string5 = null;
        Object object2 = string5;
        long l3 = -1L;
        long l4 = 253402300799999L;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        while (true) {
            boolean bl5;
            long l5;
            boolean bl6;
            Object object3;
            boolean bl7;
            long l6;
            String string6;
            block24: {
                block27: {
                    block28: {
                        block29: {
                            block26: {
                                block22: {
                                    String string7;
                                    block25: {
                                        block23: {
                                            block21: {
                                                if (n3 >= n2) break block22;
                                                n4 = Util.delimiterOffset(string2, n3, n2, ';');
                                                int n5 = Util.delimiterOffset(string2, n3, n4, '=');
                                                string7 = Util.trimSubstring(string2, n3, n5);
                                                string6 = n5 < n4 ? Util.trimSubstring(string2, n5 + 1, n4) : "";
                                                if (string7.equalsIgnoreCase("expires")) {
                                                    l4 = l6 = Cookie.parseExpires(string6, 0, string6.length());
                                                    break block21;
                                                }
                                                if (!string7.equalsIgnoreCase("max-age")) break block23;
                                                try {
                                                    l3 = l6 = Cookie.parseMaxAge(string6);
                                                }
                                                catch (IllegalArgumentException | NumberFormatException illegalArgumentException) {
                                                    string6 = string5;
                                                    l6 = l3;
                                                    bl7 = bl;
                                                    object3 = object2;
                                                    bl6 = bl3;
                                                    l5 = l4;
                                                    bl5 = bl4;
                                                }
                                            }
                                            bl5 = true;
                                            string6 = string5;
                                            l6 = l3;
                                            bl7 = bl;
                                            object3 = object2;
                                            bl6 = bl3;
                                            l5 = l4;
                                            break block24;
                                        }
                                        if (string7.equalsIgnoreCase("domain")) {
                                            string6 = Cookie.parseDomain(string6);
                                            bl6 = false;
                                            l6 = l3;
                                            bl7 = bl;
                                            object3 = object2;
                                            l5 = l4;
                                            bl5 = bl4;
                                        }
                                        if (!string7.equalsIgnoreCase("path")) break block25;
                                        object3 = string6;
                                        string6 = string5;
                                        l6 = l3;
                                        bl7 = bl;
                                        bl6 = bl3;
                                        l5 = l4;
                                        bl5 = bl4;
                                        break block24;
                                    }
                                    if (string7.equalsIgnoreCase("secure")) {
                                        bl7 = true;
                                        string6 = string5;
                                        l6 = l3;
                                        object3 = object2;
                                        bl6 = bl3;
                                        l5 = l4;
                                        bl5 = bl4;
                                        break block24;
                                    } else {
                                        string6 = string5;
                                        l6 = l3;
                                        bl7 = bl;
                                        object3 = object2;
                                        bl6 = bl3;
                                        l5 = l4;
                                        bl5 = bl4;
                                        if (string7.equalsIgnoreCase("httponly")) {
                                            bl2 = true;
                                            bl5 = bl4;
                                            l5 = l4;
                                            bl6 = bl3;
                                            object3 = object2;
                                            bl7 = bl;
                                            l6 = l3;
                                            string6 = string5;
                                        }
                                    }
                                    break block24;
                                }
                                l6 = Long.MIN_VALUE;
                                if (l3 != Long.MIN_VALUE) break block26;
                                l2 = l6;
                                break block27;
                            }
                            if (l3 == -1L) break block28;
                            l4 = l3 <= 9223372036854775L ? l3 * 1000L : Long.MAX_VALUE;
                            if ((l4 = l2 + l4) < l2) break block29;
                            l2 = l4;
                            if (l4 <= 253402300799999L) break block27;
                        }
                        l2 = 253402300799999L;
                        break block27;
                    }
                    l2 = l4;
                }
                string6 = ((HttpUrl)object).host();
                if (string5 == null) {
                    string2 = string6;
                } else {
                    if (!Cookie.domainMatch(string6, string5)) {
                        return null;
                    }
                    string2 = string5;
                }
                if (string6.length() != string2.length() && PublicSuffixDatabase.get().getEffectiveTldPlusOne(string2) == null) {
                    return null;
                }
                string5 = "/";
                if (object2 != null) {
                    if (((String)object2).startsWith("/")) return new Cookie(string3, string4, l2, string2, (String)object2, bl, bl2, bl3, bl4);
                }
                object2 = ((HttpUrl)object).encodedPath();
                n3 = ((String)object2).lastIndexOf(47);
                object = string5;
                if (n3 != 0) {
                    object = ((String)object2).substring(0, n3);
                }
                object2 = object;
                return new Cookie(string3, string4, l2, string2, (String)object2, bl, bl2, bl3, bl4);
            }
            n3 = n4 + 1;
            string5 = string6;
            l3 = l6;
            bl = bl7;
            object2 = object3;
            bl3 = bl6;
            l4 = l5;
            bl4 = bl5;
        }
    }

    @Nullable
    public static Cookie parse(HttpUrl httpUrl, String string2) {
        return Cookie.parse(System.currentTimeMillis(), httpUrl, string2);
    }

    public static List<Cookie> parseAll(HttpUrl list, Headers object) {
        List<String> list2 = ((Headers)object).values("Set-Cookie");
        int n2 = list2.size();
        object = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Cookie cookie = Cookie.parse((HttpUrl)((Object)list), list2.get(i2));
            if (cookie == null) continue;
            Object object2 = object;
            if (object == null) {
                object2 = new ArrayList();
            }
            object2.add(cookie);
            object = object2;
        }
        list = object != null ? Collections.unmodifiableList(object) : Collections.emptyList();
        return list;
    }

    private static String parseDomain(String string2) {
        if (!string2.endsWith(".")) {
            String string3 = string2;
            if (string2.startsWith(".")) {
                string3 = string2.substring(1);
            }
            if ((string2 = Util.canonicalizeHost(string3)) != null) {
                return string2;
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private static long parseExpires(String object, int n2, int n3) {
        int n4 = Cookie.dateCharacterOffset((String)object, n2, n3, false);
        Matcher matcher = TIME_PATTERN.matcher((CharSequence)object);
        n2 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        while (n4 < n3) {
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15 = Cookie.dateCharacterOffset((String)object, n4 + 1, n3, true);
            matcher.region(n4, n15);
            if (n5 == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                n4 = Integer.parseInt(matcher.group(1));
                n14 = Integer.parseInt(matcher.group(2));
                n13 = Integer.parseInt(matcher.group(3));
                n12 = n2;
                n11 = n6;
                n10 = n7;
            } else if (n6 == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                n11 = Integer.parseInt(matcher.group(1));
                n12 = n2;
                n4 = n5;
                n10 = n7;
                n14 = n8;
                n13 = n9;
            } else if (n7 == -1 && matcher.usePattern(MONTH_PATTERN).matches()) {
                String string2 = matcher.group(1).toLowerCase(Locale.US);
                n10 = MONTH_PATTERN.pattern().indexOf(string2) / 4;
                n12 = n2;
                n4 = n5;
                n11 = n6;
                n14 = n8;
                n13 = n9;
            } else {
                n12 = n2;
                n4 = n5;
                n11 = n6;
                n10 = n7;
                n14 = n8;
                n13 = n9;
                if (n2 == -1) {
                    n12 = n2;
                    n4 = n5;
                    n11 = n6;
                    n10 = n7;
                    n14 = n8;
                    n13 = n9;
                    if (matcher.usePattern(YEAR_PATTERN).matches()) {
                        n12 = Integer.parseInt(matcher.group(1));
                        n13 = n9;
                        n14 = n8;
                        n10 = n7;
                        n11 = n6;
                        n4 = n5;
                    }
                }
            }
            n15 = Cookie.dateCharacterOffset((String)object, n15 + 1, n3, false);
            n2 = n12;
            n5 = n4;
            n6 = n11;
            n7 = n10;
            n8 = n14;
            n9 = n13;
            n4 = n15;
        }
        n3 = n2;
        if (n2 >= 70) {
            n3 = n2;
            if (n2 <= 99) {
                n3 = n2 + 1900;
            }
        }
        n2 = n3;
        if (n3 >= 0) {
            n2 = n3;
            if (n3 <= 69) {
                n2 = n3 + 2000;
            }
        }
        if (n2 >= 1601) {
            if (n7 != -1) {
                if (n6 >= 1 && n6 <= 31) {
                    if (n5 >= 0 && n5 <= 23) {
                        if (n8 >= 0 && n8 <= 59) {
                            if (n9 >= 0 && n9 <= 59) {
                                object = new GregorianCalendar(Util.UTC);
                                ((Calendar)object).setLenient(false);
                                ((Calendar)object).set(1, n2);
                                ((Calendar)object).set(2, n7 - 1);
                                ((Calendar)object).set(5, n6);
                                ((Calendar)object).set(11, n5);
                                ((Calendar)object).set(12, n8);
                                ((Calendar)object).set(13, n9);
                                ((Calendar)object).set(14, 0);
                                return ((Calendar)object).getTimeInMillis();
                            }
                            throw new IllegalArgumentException();
                        }
                        throw new IllegalArgumentException();
                    }
                    throw new IllegalArgumentException();
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
        object = new IllegalArgumentException();
        throw object;
    }

    private static long parseMaxAge(String string2) {
        long l2 = Long.MIN_VALUE;
        try {
            long l3 = Long.parseLong(string2);
            if (l3 > 0L) {
                l2 = l3;
            }
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            if (string2.matches("-?\\d+")) {
                if (!string2.startsWith("-")) {
                    l2 = Long.MAX_VALUE;
                }
                return l2;
            }
            throw numberFormatException;
        }
    }

    private static boolean pathMatch(HttpUrl object, String string2) {
        if (((String)(object = ((HttpUrl)object).encodedPath())).equals(string2)) {
            return true;
        }
        if (((String)object).startsWith(string2)) {
            if (string2.endsWith("/")) {
                return true;
            }
            if (((String)object).charAt(string2.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    public String domain() {
        return this.domain;
    }

    public boolean equals(@Nullable Object object) {
        boolean bl = object instanceof Cookie;
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        object = (Cookie)object;
        bl = bl2;
        if (((Cookie)object).name.equals(this.name)) {
            bl = bl2;
            if (((Cookie)object).value.equals(this.value)) {
                bl = bl2;
                if (((Cookie)object).domain.equals(this.domain)) {
                    bl = bl2;
                    if (((Cookie)object).path.equals(this.path)) {
                        bl = bl2;
                        if (((Cookie)object).expiresAt == this.expiresAt) {
                            bl = bl2;
                            if (((Cookie)object).secure == this.secure) {
                                bl = bl2;
                                if (((Cookie)object).httpOnly == this.httpOnly) {
                                    bl = bl2;
                                    if (((Cookie)object).persistent == this.persistent) {
                                        bl = bl2;
                                        if (((Cookie)object).hostOnly == this.hostOnly) {
                                            bl = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    public long expiresAt() {
        return this.expiresAt;
    }

    public int hashCode() {
        int n2 = this.name.hashCode();
        int n3 = this.value.hashCode();
        int n4 = this.domain.hashCode();
        int n5 = this.path.hashCode();
        long l2 = this.expiresAt;
        return ((((((((527 + n2) * 31 + n3) * 31 + n4) * 31 + n5) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (this.secure ^ 1)) * 31 + (this.httpOnly ^ 1)) * 31 + (this.persistent ^ 1)) * 31 + (this.hostOnly ^ 1);
    }

    public boolean hostOnly() {
        return this.hostOnly;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public boolean matches(HttpUrl httpUrl) {
        boolean bl = this.hostOnly ? httpUrl.host().equals(this.domain) : Cookie.domainMatch(httpUrl.host(), this.domain);
        if (!bl) {
            return false;
        }
        if (!Cookie.pathMatch(httpUrl, this.path)) {
            return false;
        }
        return !this.secure || httpUrl.isHttps();
    }

    public String name() {
        return this.name;
    }

    public String path() {
        return this.path;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public boolean secure() {
        return this.secure;
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append('=');
        stringBuilder.append(this.value);
        if (this.persistent) {
            if (this.expiresAt == Long.MIN_VALUE) {
                stringBuilder.append("; max-age=0");
            } else {
                stringBuilder.append("; expires=");
                stringBuilder.append(HttpDate.format((Date)new Date(this.expiresAt)));
            }
        }
        if (!this.hostOnly) {
            stringBuilder.append("; domain=");
            if (bl) {
                stringBuilder.append(".");
            }
            stringBuilder.append(this.domain);
        }
        stringBuilder.append("; path=");
        stringBuilder.append(this.path);
        if (this.secure) {
            stringBuilder.append("; secure");
        }
        if (this.httpOnly) {
            stringBuilder.append("; httponly");
        }
        return stringBuilder.toString();
    }

    public String value() {
        return this.value;
    }

    public static final class Builder {
        @Nullable
        String domain;
        long expiresAt = 253402300799999L;
        boolean hostOnly;
        boolean httpOnly;
        @Nullable
        String name;
        String path = "/";
        boolean persistent;
        boolean secure;
        @Nullable
        String value;

        private Builder domain(String string2, boolean bl) {
            if (string2 != null) {
                CharSequence charSequence = Util.canonicalizeHost(string2);
                if (charSequence != null) {
                    this.domain = charSequence;
                    this.hostOnly = bl;
                    return this;
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("unexpected domain: ");
                ((StringBuilder)charSequence).append(string2);
                throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
            }
            throw new NullPointerException("domain == null");
        }

        public Cookie build() {
            return new Cookie(this);
        }

        public Builder domain(String string2) {
            return this.domain(string2, false);
        }

        public Builder expiresAt(long l2) {
            long l3 = l2;
            if (l2 <= 0L) {
                l3 = Long.MIN_VALUE;
            }
            l2 = l3;
            if (l3 > 253402300799999L) {
                l2 = 253402300799999L;
            }
            this.expiresAt = l2;
            this.persistent = true;
            return this;
        }

        public Builder hostOnlyDomain(String string2) {
            return this.domain(string2, true);
        }

        public Builder httpOnly() {
            this.httpOnly = true;
            return this;
        }

        public Builder name(String string2) {
            if (string2 != null) {
                if (string2.trim().equals(string2)) {
                    this.name = string2;
                    return this;
                }
                throw new IllegalArgumentException("name is not trimmed");
            }
            throw new NullPointerException("name == null");
        }

        public Builder path(String string2) {
            if (string2.startsWith("/")) {
                this.path = string2;
                return this;
            }
            throw new IllegalArgumentException("path must start with '/'");
        }

        public Builder secure() {
            this.secure = true;
            return this;
        }

        public Builder value(String string2) {
            if (string2 != null) {
                if (string2.trim().equals(string2)) {
                    this.value = string2;
                    return this;
                }
                throw new IllegalArgumentException("value is not trimmed");
            }
            throw new NullPointerException("value == null");
        }
    }
}

