/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.Address;
import com.mbridge.msdk.thrid.okhttp.Route;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.connection.RealConnection;
import com.mbridge.msdk.thrid.okhttp.internal.connection.RouteDatabase;
import com.mbridge.msdk.thrid.okhttp.internal.connection.StreamAllocation;
import com.mbridge.msdk.thrid.okhttp.internal.platform.Platform;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class ConnectionPool {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final Executor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp ConnectionPool", true));
    private final Runnable cleanupRunnable = new Runnable(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long l2;
            while ((l2 = ConnectionPool.this.cleanup(System.nanoTime())) != -1L) {
                if (l2 <= 0L) continue;
                long l3 = l2 / 1000000L;
                ConnectionPool connectionPool = ConnectionPool.this;
                synchronized (connectionPool) {
                    try {
                        try {
                            ConnectionPool.this.wait(l3, (int)(l2 - 1000000L * l3));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Throwable throwable) {}
                    throw throwable;
                }
            }
            return;
        }
    };
    boolean cleanupRunning;
    private final Deque<RealConnection> connections = new ArrayDeque<RealConnection>();
    private final long keepAliveDurationNs;
    private final int maxIdleConnections;
    final RouteDatabase routeDatabase = new RouteDatabase();

    public ConnectionPool() {
        this(5, 5L, TimeUnit.MINUTES);
    }

    public ConnectionPool(int n2, long l2, TimeUnit object) {
        this.maxIdleConnections = n2;
        this.keepAliveDurationNs = ((TimeUnit)((Object)object)).toNanos(l2);
        if (l2 > 0L) {
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("keepAliveDuration <= 0: ");
        ((StringBuilder)object).append(l2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    private int pruneAndGetAllocationCount(RealConnection realConnection, long l2) {
        List<Reference<StreamAllocation>> list = realConnection.allocations;
        int n2 = 0;
        while (n2 < list.size()) {
            StreamAllocation.StreamAllocationReference streamAllocationReference = list.get(n2);
            if (streamAllocationReference.get() != null) {
                ++n2;
                continue;
            }
            streamAllocationReference = streamAllocationReference;
            CharSequence charSequence = new StringBuilder();
            charSequence.append("A connection to ");
            charSequence.append(realConnection.route().address().url());
            charSequence.append(" was leaked. Did you forget to close a response body?");
            charSequence = charSequence.toString();
            Platform.get().logCloseableLeak((String)charSequence, streamAllocationReference.callStackTrace);
            list.remove(n2);
            realConnection.noNewStreams = true;
            if (!list.isEmpty()) continue;
            realConnection.idleAtNanos = l2 - this.keepAliveDurationNs;
            return 0;
        }
        return list.size();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    long cleanup(long l2) {
        // MONITORENTER : this
        Iterator<RealConnection> iterator2 = this.connections.iterator();
        long l3 = Long.MIN_VALUE;
        RealConnection realConnection = null;
        int n2 = 0;
        int n3 = 0;
        while (iterator2.hasNext()) {
            RealConnection realConnection2 = iterator2.next();
            if (this.pruneAndGetAllocationCount(realConnection2, l2) > 0) {
                ++n3;
                continue;
            }
            int n4 = n2 + 1;
            long l4 = l2 - realConnection2.idleAtNanos;
            n2 = n4;
            if (l4 <= l3) continue;
            realConnection = realConnection2;
            l3 = l4;
            n2 = n4;
        }
        if (l3 < this.keepAliveDurationNs && n2 <= this.maxIdleConnections) {
            if (n2 > 0) {
                l2 = this.keepAliveDurationNs;
                // MONITOREXIT : this
                return l2 - l3;
            }
            if (n3 > 0) {
                l2 = this.keepAliveDurationNs;
                // MONITOREXIT : this
                return l2;
            }
            this.cleanupRunning = false;
            // MONITOREXIT : this
            return -1L;
        }
        this.connections.remove(realConnection);
        // MONITOREXIT : this
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : this
                throw throwable;
            }
        }
        Util.closeQuietly(realConnection.socket());
        return 0L;
    }

    boolean connectionBecameIdle(RealConnection realConnection) {
        if (!realConnection.noNewStreams && this.maxIdleConnections != 0) {
            this.notifyAll();
            return false;
        }
        this.connections.remove(realConnection);
        return true;
    }

    public int connectionCount() {
        synchronized (this) {
            int n2 = this.connections.size();
            return n2;
        }
    }

    @Nullable
    Socket deduplicate(Address address, StreamAllocation streamAllocation) {
        for (RealConnection realConnection : this.connections) {
            if (!realConnection.isEligible(address, null) || !realConnection.isMultiplexed() || realConnection == streamAllocation.connection()) continue;
            return streamAllocation.releaseAndAcquire(realConnection);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void evictAll() {
        Iterator<RealConnection> iterator2;
        ArrayList<RealConnection> arrayList = new ArrayList<RealConnection>();
        synchronized (this) {
            iterator2 = this.connections.iterator();
            while (iterator2.hasNext()) {
                RealConnection realConnection = iterator2.next();
                if (!realConnection.allocations.isEmpty()) continue;
                realConnection.noNewStreams = true;
                arrayList.add(realConnection);
                iterator2.remove();
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl13 : MonitorExitStatement: MONITOREXIT : this
            iterator2 = arrayList.iterator();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        while (iterator2.hasNext()) {
            Util.closeQuietly(iterator2.next().socket());
        }
    }

    @Nullable
    RealConnection get(Address address, StreamAllocation streamAllocation, Route route) {
        for (RealConnection realConnection : this.connections) {
            if (!realConnection.isEligible(address, route)) continue;
            streamAllocation.acquire(realConnection, true);
            return realConnection;
        }
        return null;
    }

    public int idleConnectionCount() {
        synchronized (this) {
            int n2 = 0;
            try {
                Iterator<RealConnection> iterator2 = this.connections.iterator();
                while (iterator2.hasNext()) {
                    boolean bl = iterator2.next().allocations.isEmpty();
                    if (!bl) continue;
                    ++n2;
                }
            }
            catch (Throwable throwable) {}
            {
                throw throwable;
            }
            return n2;
        }
    }

    void put(RealConnection realConnection) {
        if (!this.cleanupRunning) {
            this.cleanupRunning = true;
            executor.execute(this.cleanupRunnable);
        }
        this.connections.add(realConnection);
    }
}

