/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.internal.Util;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public final class Challenge {
    private final Map<String, String> authParams;
    private final String scheme;

    public Challenge(String string2, String string3) {
        if (string2 != null) {
            if (string3 != null) {
                this.scheme = string2;
                this.authParams = Collections.singletonMap("realm", string3);
                return;
            }
            throw new NullPointerException("realm == null");
        }
        throw new NullPointerException("scheme == null");
    }

    public Challenge(String object, Map<String, String> entry2) {
        if (object != null) {
            if (entry2 != null) {
                this.scheme = object;
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                for (Map.Entry<String, String> entry2 : entry2.entrySet()) {
                    object = entry2.getKey() == null ? null : ((String)entry2.getKey()).toLowerCase(Locale.US);
                    linkedHashMap.put(object, entry2.getValue());
                }
                this.authParams = Collections.unmodifiableMap(linkedHashMap);
                return;
            }
            throw new NullPointerException("authParams == null");
        }
        object = new NullPointerException("scheme == null");
        throw object;
    }

    public Map<String, String> authParams() {
        return this.authParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Charset charset() {
        String string2 = this.authParams.get("charset");
        if (string2 == null) return Util.ISO_8859_1;
        try {
            return Charset.forName(string2);
        }
        catch (Exception exception) {
            return Util.ISO_8859_1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Challenge)) return false;
        object = (Challenge)object;
        if (!((Challenge)object).scheme.equals(this.scheme)) return false;
        if (!((Challenge)object).authParams.equals(this.authParams)) return false;
        return true;
    }

    public int hashCode() {
        return (899 + this.scheme.hashCode()) * 31 + this.authParams.hashCode();
    }

    public String realm() {
        return this.authParams.get("realm");
    }

    public String scheme() {
        return this.scheme;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.scheme);
        stringBuilder.append(" authParams=");
        stringBuilder.append(this.authParams);
        return stringBuilder.toString();
    }

    public Challenge withCharset(Charset charset) {
        if (charset != null) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.authParams);
            linkedHashMap.put("charset", charset.name());
            return new Challenge(this.scheme, linkedHashMap);
        }
        throw new NullPointerException("charset == null");
    }
}

