/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.HttpUrl;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.tls.CertificateChainCleaner;
import com.mbridge.msdk.thrid.okio.ByteString;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class CertificatePinner {
    public static final CertificatePinner DEFAULT = new Builder().build();
    @Nullable
    private final CertificateChainCleaner certificateChainCleaner;
    private final Set<Pin> pins;

    CertificatePinner(Set<Pin> set, @Nullable CertificateChainCleaner certificateChainCleaner) {
        this.pins = set;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public static String pin(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("sha256/");
            stringBuilder.append(CertificatePinner.sha256((X509Certificate)certificate).base64());
            return stringBuilder.toString();
        }
        throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
    }

    static ByteString sha1(X509Certificate x509Certificate) {
        return ByteString.of((byte[])x509Certificate.getPublicKey().getEncoded()).sha1();
    }

    static ByteString sha256(X509Certificate x509Certificate) {
        return ByteString.of((byte[])x509Certificate.getPublicKey().getEncoded()).sha256();
    }

    public void check(String object, List<Certificate> object2) throws SSLPeerUnverifiedException {
        int n2;
        int n3;
        List<Pin> list = this.findMatchingPins((String)object);
        if (list.isEmpty()) {
            return;
        }
        Object object3 = this.certificateChainCleaner;
        List list2 = object2;
        if (object3 != null) {
            list2 = object3.clean(object2, (String)object);
        }
        int n4 = list2.size();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            X509Certificate x509Certificate = (X509Certificate)list2.get(n3);
            int n6 = list.size();
            object2 = object3 = null;
            for (n2 = 0; n2 < n6; ++n2) {
                Object object4;
                Pin pin = list.get(n2);
                if (pin.hashAlgorithm.equals("sha256/")) {
                    object4 = object3;
                    if (object3 == null) {
                        object4 = CertificatePinner.sha256(x509Certificate);
                    }
                    object3 = object4;
                    if (!pin.hash.equals(object4)) continue;
                    return;
                }
                if (pin.hashAlgorithm.equals("sha1/")) {
                    object4 = object2;
                    if (object2 == null) {
                        object4 = CertificatePinner.sha1(x509Certificate);
                    }
                    object2 = object4;
                    if (!pin.hash.equals(object4)) continue;
                    return;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("unsupported hashAlgorithm: ");
                ((StringBuilder)object).append(pin.hashAlgorithm);
                throw new AssertionError((Object)((StringBuilder)object).toString());
            }
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Certificate pinning failure!");
        ((StringBuilder)object2).append("\n  Peer certificate chain:");
        n2 = list2.size();
        for (n3 = 0; n3 < n2; ++n3) {
            object3 = (X509Certificate)list2.get(n3);
            ((StringBuilder)object2).append("\n    ");
            ((StringBuilder)object2).append(CertificatePinner.pin((Certificate)object3));
            ((StringBuilder)object2).append(": ");
            ((StringBuilder)object2).append(((X509Certificate)object3).getSubjectDN().getName());
        }
        ((StringBuilder)object2).append("\n  Pinned certificates for ");
        ((StringBuilder)object2).append((String)object);
        ((StringBuilder)object2).append(":");
        n2 = list.size();
        for (n3 = n5; n3 < n2; ++n3) {
            object = list.get(n3);
            ((StringBuilder)object2).append("\n    ");
            ((StringBuilder)object2).append(object);
        }
        object = new SSLPeerUnverifiedException(((StringBuilder)object2).toString());
        throw object;
    }

    public void check(String string2, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        this.check(string2, Arrays.asList(certificateArray));
    }

    public boolean equals(@Nullable Object object) {
        boolean bl;
        block5: {
            block4: {
                bl = true;
                if (object == this) {
                    return true;
                }
                if (!(object instanceof CertificatePinner)) break block4;
                CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
                object = (CertificatePinner)object;
                if (Util.equal(certificateChainCleaner, ((CertificatePinner)object).certificateChainCleaner) && this.pins.equals(((CertificatePinner)object).pins)) break block5;
            }
            bl = false;
        }
        return bl;
    }

    List<Pin> findMatchingPins(String string2) {
        List<Pin> list = Collections.emptyList();
        for (Pin pin : this.pins) {
            if (!pin.matches(string2)) continue;
            List<Pin> list2 = list;
            if (list.isEmpty()) {
                list2 = new ArrayList<Pin>();
            }
            list2.add(pin);
            list = list2;
        }
        return list;
    }

    public int hashCode() {
        CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
        int n2 = certificateChainCleaner != null ? certificateChainCleaner.hashCode() : 0;
        return n2 * 31 + this.pins.hashCode();
    }

    CertificatePinner withCertificateChainCleaner(@Nullable CertificateChainCleaner object) {
        object = Util.equal(this.certificateChainCleaner, object) ? this : new CertificatePinner(this.pins, (CertificateChainCleaner)object);
        return object;
    }

    public static final class Builder {
        private final List<Pin> pins = new ArrayList<Pin>();

        public Builder add(String object, String ... stringArray) {
            if (object != null) {
                for (String string2 : stringArray) {
                    this.pins.add(new Pin((String)object, string2));
                }
                return this;
            }
            object = new NullPointerException("pattern == null");
            throw object;
        }

        public CertificatePinner build() {
            return new CertificatePinner(new LinkedHashSet<Pin>(this.pins), null);
        }
    }

    static final class Pin {
        private static final String WILDCARD = "*.";
        final String canonicalHostname;
        final ByteString hash;
        final String hashAlgorithm;
        final String pattern;

        Pin(String charSequence, String string2) {
            block8: {
                block7: {
                    block6: {
                        this.pattern = charSequence;
                        if (((String)charSequence).startsWith(WILDCARD)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("http://");
                            stringBuilder.append(((String)charSequence).substring(2));
                            charSequence = HttpUrl.get(stringBuilder.toString()).host();
                        } else {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("http://");
                            stringBuilder.append((String)charSequence);
                            charSequence = HttpUrl.get(stringBuilder.toString()).host();
                        }
                        this.canonicalHostname = charSequence;
                        if (!string2.startsWith("sha1/")) break block6;
                        this.hashAlgorithm = "sha1/";
                        this.hash = ByteString.decodeBase64((String)string2.substring(5));
                        break block7;
                    }
                    if (!string2.startsWith("sha256/")) break block8;
                    this.hashAlgorithm = "sha256/";
                    this.hash = ByteString.decodeBase64((String)string2.substring(7));
                }
                if (this.hash != null) {
                    return;
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("pins must be base64: ");
                ((StringBuilder)charSequence).append(string2);
                throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("pins must start with 'sha256/' or 'sha1/': ");
            ((StringBuilder)charSequence).append(string2);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof Pin)) return false;
            String string2 = this.pattern;
            object = (Pin)object;
            if (!string2.equals(((Pin)object).pattern)) return false;
            if (!this.hashAlgorithm.equals(((Pin)object).hashAlgorithm)) return false;
            if (!this.hash.equals((Object)((Pin)object).hash)) return false;
            return true;
        }

        public int hashCode() {
            return ((527 + this.pattern.hashCode()) * 31 + this.hashAlgorithm.hashCode()) * 31 + this.hash.hashCode();
        }

        boolean matches(String string2) {
            if (this.pattern.startsWith(WILDCARD)) {
                String string3;
                int n2 = string2.indexOf(46);
                int n3 = string2.length();
                boolean bl = true;
                if (n3 - n2 - 1 != this.canonicalHostname.length() || !string2.regionMatches(false, n2 + 1, string3 = this.canonicalHostname, 0, string3.length())) {
                    bl = false;
                }
                return bl;
            }
            return string2.equals(this.canonicalHostname);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.hashAlgorithm);
            stringBuilder.append(this.hash.base64());
            return stringBuilder.toString();
        }
    }
}

