/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.Headers;
import com.mbridge.msdk.thrid.okhttp.internal.http.HttpHeaders;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class CacheControl {
    public static final CacheControl FORCE_CACHE;
    public static final CacheControl FORCE_NETWORK;
    @Nullable
    String headerValue;
    private final boolean immutable;
    private final boolean isPrivate;
    private final boolean isPublic;
    private final int maxAgeSeconds;
    private final int maxStaleSeconds;
    private final int minFreshSeconds;
    private final boolean mustRevalidate;
    private final boolean noCache;
    private final boolean noStore;
    private final boolean noTransform;
    private final boolean onlyIfCached;
    private final int sMaxAgeSeconds;

    static {
        FORCE_NETWORK = new Builder().noCache().build();
        FORCE_CACHE = new Builder().onlyIfCached().maxStale(Integer.MAX_VALUE, TimeUnit.SECONDS).build();
    }

    CacheControl(Builder builder) {
        this.noCache = builder.noCache;
        this.noStore = builder.noStore;
        this.maxAgeSeconds = builder.maxAgeSeconds;
        this.sMaxAgeSeconds = -1;
        this.isPrivate = false;
        this.isPublic = false;
        this.mustRevalidate = false;
        this.maxStaleSeconds = builder.maxStaleSeconds;
        this.minFreshSeconds = builder.minFreshSeconds;
        this.onlyIfCached = builder.onlyIfCached;
        this.noTransform = builder.noTransform;
        this.immutable = builder.immutable;
    }

    private CacheControl(boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, boolean bl5, int n4, int n5, boolean bl6, boolean bl7, boolean bl8, @Nullable String string2) {
        this.noCache = bl;
        this.noStore = bl2;
        this.maxAgeSeconds = n2;
        this.sMaxAgeSeconds = n3;
        this.isPrivate = bl3;
        this.isPublic = bl4;
        this.mustRevalidate = bl5;
        this.maxStaleSeconds = n4;
        this.minFreshSeconds = n5;
        this.onlyIfCached = bl6;
        this.noTransform = bl7;
        this.immutable = bl8;
        this.headerValue = string2;
    }

    private String headerValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.noCache) {
            stringBuilder.append("no-cache, ");
        }
        if (this.noStore) {
            stringBuilder.append("no-store, ");
        }
        if (this.maxAgeSeconds != -1) {
            stringBuilder.append("max-age=");
            stringBuilder.append(this.maxAgeSeconds);
            stringBuilder.append(", ");
        }
        if (this.sMaxAgeSeconds != -1) {
            stringBuilder.append("s-maxage=");
            stringBuilder.append(this.sMaxAgeSeconds);
            stringBuilder.append(", ");
        }
        if (this.isPrivate) {
            stringBuilder.append("private, ");
        }
        if (this.isPublic) {
            stringBuilder.append("public, ");
        }
        if (this.mustRevalidate) {
            stringBuilder.append("must-revalidate, ");
        }
        if (this.maxStaleSeconds != -1) {
            stringBuilder.append("max-stale=");
            stringBuilder.append(this.maxStaleSeconds);
            stringBuilder.append(", ");
        }
        if (this.minFreshSeconds != -1) {
            stringBuilder.append("min-fresh=");
            stringBuilder.append(this.minFreshSeconds);
            stringBuilder.append(", ");
        }
        if (this.onlyIfCached) {
            stringBuilder.append("only-if-cached, ");
        }
        if (this.noTransform) {
            stringBuilder.append("no-transform, ");
        }
        if (this.immutable) {
            stringBuilder.append("immutable, ");
        }
        if (stringBuilder.length() == 0) {
            return "";
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }

    public static CacheControl parse(Headers headers) {
        int n2 = headers.size();
        int n3 = 0;
        int n4 = 1;
        Object object = null;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = -1;
        int n6 = -1;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n7 = -1;
        int n8 = -1;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        while (true) {
            boolean bl9;
            boolean bl10;
            boolean bl11;
            int n9;
            int n10;
            boolean bl12;
            boolean bl13;
            boolean bl14;
            int n11;
            int n12;
            boolean bl15;
            boolean bl16;
            int n13;
            Object object2;
            block36: {
                String string2;
                String string3;
                block35: {
                    block34: {
                        block33: {
                            object2 = headers;
                            if (n3 >= n2) break;
                            string3 = ((Headers)object2).name(n3);
                            string2 = ((Headers)object2).value(n3);
                            if (!string3.equalsIgnoreCase("Cache-Control")) break block33;
                            if (object != null) break block34;
                            object = string2;
                            break block35;
                        }
                        n13 = n4;
                        object2 = object;
                        bl16 = bl;
                        bl15 = bl2;
                        n12 = n5;
                        n11 = n6;
                        bl14 = bl3;
                        bl13 = bl4;
                        bl12 = bl5;
                        n10 = n7;
                        n9 = n8;
                        bl11 = bl6;
                        bl10 = bl7;
                        bl9 = bl8;
                        if (!string3.equalsIgnoreCase("Pragma")) break block36;
                    }
                    n4 = 0;
                }
                int n14 = 0;
                while (true) {
                    n13 = n4;
                    object2 = object;
                    bl16 = bl;
                    bl15 = bl2;
                    n12 = n5;
                    n11 = n6;
                    bl14 = bl3;
                    bl13 = bl4;
                    bl12 = bl5;
                    n10 = n7;
                    n9 = n8;
                    bl11 = bl6;
                    bl10 = bl7;
                    bl9 = bl8;
                    if (n14 >= string2.length()) break;
                    n9 = HttpHeaders.skipUntil((String)string2, (int)n14, (String)"=,;");
                    string3 = string2.substring(n14, n9).trim();
                    if (n9 != string2.length() && string2.charAt(n9) != ',' && string2.charAt(n9) != ';') {
                        n12 = HttpHeaders.skipWhitespace((String)string2, (int)(n9 + 1));
                        if (n12 < string2.length() && string2.charAt(n12) == '\"') {
                            n9 = HttpHeaders.skipUntil((String)string2, (int)(++n12), (String)"\"");
                            object2 = string2.substring(n12, n9);
                            ++n9;
                        } else {
                            n9 = HttpHeaders.skipUntil((String)string2, (int)n12, (String)",;");
                            object2 = string2.substring(n12, n9).trim();
                        }
                    } else {
                        ++n9;
                        object2 = null;
                    }
                    if ("no-cache".equalsIgnoreCase(string3)) {
                        bl10 = true;
                        bl11 = bl2;
                        n12 = n5;
                        n11 = n6;
                        bl9 = bl3;
                        bl14 = bl4;
                        bl15 = bl5;
                        n10 = n7;
                        n13 = n8;
                        bl13 = bl6;
                        bl16 = bl7;
                    } else if ("no-store".equalsIgnoreCase(string3)) {
                        bl11 = true;
                        bl10 = bl;
                        n12 = n5;
                        n11 = n6;
                        bl9 = bl3;
                        bl14 = bl4;
                        bl15 = bl5;
                        n10 = n7;
                        n13 = n8;
                        bl13 = bl6;
                        bl16 = bl7;
                    } else if ("max-age".equalsIgnoreCase(string3)) {
                        n12 = HttpHeaders.parseSeconds((String)object2, (int)-1);
                        bl10 = bl;
                        bl11 = bl2;
                        n11 = n6;
                        bl9 = bl3;
                        bl14 = bl4;
                        bl15 = bl5;
                        n10 = n7;
                        n13 = n8;
                        bl13 = bl6;
                        bl16 = bl7;
                    } else if ("s-maxage".equalsIgnoreCase(string3)) {
                        n11 = HttpHeaders.parseSeconds((String)object2, (int)-1);
                        bl10 = bl;
                        bl11 = bl2;
                        n12 = n5;
                        bl9 = bl3;
                        bl14 = bl4;
                        bl15 = bl5;
                        n10 = n7;
                        n13 = n8;
                        bl13 = bl6;
                        bl16 = bl7;
                    } else if ("private".equalsIgnoreCase(string3)) {
                        bl9 = true;
                        bl10 = bl;
                        bl11 = bl2;
                        n12 = n5;
                        n11 = n6;
                        bl14 = bl4;
                        bl15 = bl5;
                        n10 = n7;
                        n13 = n8;
                        bl13 = bl6;
                        bl16 = bl7;
                    } else if ("public".equalsIgnoreCase(string3)) {
                        bl14 = true;
                        bl10 = bl;
                        bl11 = bl2;
                        n12 = n5;
                        n11 = n6;
                        bl9 = bl3;
                        bl15 = bl5;
                        n10 = n7;
                        n13 = n8;
                        bl13 = bl6;
                        bl16 = bl7;
                    } else if ("must-revalidate".equalsIgnoreCase(string3)) {
                        bl15 = true;
                        bl10 = bl;
                        bl11 = bl2;
                        n12 = n5;
                        n11 = n6;
                        bl9 = bl3;
                        bl14 = bl4;
                        n10 = n7;
                        n13 = n8;
                        bl13 = bl6;
                        bl16 = bl7;
                    } else if ("max-stale".equalsIgnoreCase(string3)) {
                        n10 = HttpHeaders.parseSeconds((String)object2, (int)Integer.MAX_VALUE);
                        bl10 = bl;
                        bl11 = bl2;
                        n12 = n5;
                        n11 = n6;
                        bl9 = bl3;
                        bl14 = bl4;
                        bl15 = bl5;
                        n13 = n8;
                        bl13 = bl6;
                        bl16 = bl7;
                    } else if ("min-fresh".equalsIgnoreCase(string3)) {
                        n13 = HttpHeaders.parseSeconds((String)object2, (int)-1);
                        bl10 = bl;
                        bl11 = bl2;
                        n12 = n5;
                        n11 = n6;
                        bl9 = bl3;
                        bl14 = bl4;
                        bl15 = bl5;
                        n10 = n7;
                        bl13 = bl6;
                        bl16 = bl7;
                    } else if ("only-if-cached".equalsIgnoreCase(string3)) {
                        bl13 = true;
                        bl10 = bl;
                        bl11 = bl2;
                        n12 = n5;
                        n11 = n6;
                        bl9 = bl3;
                        bl14 = bl4;
                        bl15 = bl5;
                        n10 = n7;
                        n13 = n8;
                        bl16 = bl7;
                    } else if ("no-transform".equalsIgnoreCase(string3)) {
                        bl16 = true;
                        bl10 = bl;
                        bl11 = bl2;
                        n12 = n5;
                        n11 = n6;
                        bl9 = bl3;
                        bl14 = bl4;
                        bl15 = bl5;
                        n10 = n7;
                        n13 = n8;
                        bl13 = bl6;
                    } else {
                        bl10 = bl;
                        bl11 = bl2;
                        n12 = n5;
                        n11 = n6;
                        bl9 = bl3;
                        bl14 = bl4;
                        bl15 = bl5;
                        n10 = n7;
                        n13 = n8;
                        bl13 = bl6;
                        bl16 = bl7;
                        if ("immutable".equalsIgnoreCase(string3)) {
                            bl8 = true;
                            bl16 = bl7;
                            bl13 = bl6;
                            n13 = n8;
                            n10 = n7;
                            bl15 = bl5;
                            bl14 = bl4;
                            bl9 = bl3;
                            n11 = n6;
                            n12 = n5;
                            bl11 = bl2;
                            bl10 = bl;
                        }
                    }
                    n14 = n9;
                    bl = bl10;
                    bl2 = bl11;
                    n5 = n12;
                    n6 = n11;
                    bl3 = bl9;
                    bl4 = bl14;
                    bl5 = bl15;
                    n7 = n10;
                    n8 = n13;
                    bl6 = bl13;
                    bl7 = bl16;
                }
            }
            ++n3;
            n4 = n13;
            object = object2;
            bl = bl16;
            bl2 = bl15;
            n5 = n12;
            n6 = n11;
            bl3 = bl14;
            bl4 = bl13;
            bl5 = bl12;
            n7 = n10;
            n8 = n9;
            bl6 = bl11;
            bl7 = bl10;
            bl8 = bl9;
        }
        if (n4 == 0) {
            object = null;
        }
        return new CacheControl(bl, bl2, n5, n6, bl3, bl4, bl5, n7, n8, bl6, bl7, bl8, (String)object);
    }

    public boolean immutable() {
        return this.immutable;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public int maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public int maxStaleSeconds() {
        return this.maxStaleSeconds;
    }

    public int minFreshSeconds() {
        return this.minFreshSeconds;
    }

    public boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public boolean noCache() {
        return this.noCache;
    }

    public boolean noStore() {
        return this.noStore;
    }

    public boolean noTransform() {
        return this.noTransform;
    }

    public boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public int sMaxAgeSeconds() {
        return this.sMaxAgeSeconds;
    }

    public String toString() {
        String string2 = this.headerValue;
        if (string2 == null) {
            this.headerValue = string2 = this.headerValue();
        }
        return string2;
    }

    public static final class Builder {
        boolean immutable;
        int maxAgeSeconds = -1;
        int maxStaleSeconds = -1;
        int minFreshSeconds = -1;
        boolean noCache;
        boolean noStore;
        boolean noTransform;
        boolean onlyIfCached;

        public CacheControl build() {
            return new CacheControl(this);
        }

        public Builder immutable() {
            this.immutable = true;
            return this;
        }

        public Builder maxAge(int n2, TimeUnit object) {
            if (n2 >= 0) {
                long l2 = ((TimeUnit)((Object)object)).toSeconds(n2);
                n2 = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
                this.maxAgeSeconds = n2;
                return this;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("maxAge < 0: ");
            ((StringBuilder)object).append(n2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }

        public Builder maxStale(int n2, TimeUnit object) {
            if (n2 >= 0) {
                long l2 = ((TimeUnit)((Object)object)).toSeconds(n2);
                n2 = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
                this.maxStaleSeconds = n2;
                return this;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("maxStale < 0: ");
            ((StringBuilder)object).append(n2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }

        public Builder minFresh(int n2, TimeUnit object) {
            if (n2 >= 0) {
                long l2 = ((TimeUnit)((Object)object)).toSeconds(n2);
                n2 = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
                this.minFreshSeconds = n2;
                return this;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("minFresh < 0: ");
            ((StringBuilder)object).append(n2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }

        public Builder noCache() {
            this.noCache = true;
            return this;
        }

        public Builder noStore() {
            this.noStore = true;
            return this;
        }

        public Builder noTransform() {
            this.noTransform = true;
            return this;
        }

        public Builder onlyIfCached() {
            this.onlyIfCached = true;
            return this;
        }
    }
}

