/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.thrid.okhttp;

import com.mbridge.msdk.thrid.okhttp.CipherSuite;
import com.mbridge.msdk.thrid.okhttp.Handshake;
import com.mbridge.msdk.thrid.okhttp.Headers;
import com.mbridge.msdk.thrid.okhttp.HttpUrl;
import com.mbridge.msdk.thrid.okhttp.MediaType;
import com.mbridge.msdk.thrid.okhttp.Protocol;
import com.mbridge.msdk.thrid.okhttp.Request;
import com.mbridge.msdk.thrid.okhttp.Response;
import com.mbridge.msdk.thrid.okhttp.ResponseBody;
import com.mbridge.msdk.thrid.okhttp.TlsVersion;
import com.mbridge.msdk.thrid.okhttp.internal.Util;
import com.mbridge.msdk.thrid.okhttp.internal.cache.CacheRequest;
import com.mbridge.msdk.thrid.okhttp.internal.cache.CacheStrategy;
import com.mbridge.msdk.thrid.okhttp.internal.cache.DiskLruCache;
import com.mbridge.msdk.thrid.okhttp.internal.cache.InternalCache;
import com.mbridge.msdk.thrid.okhttp.internal.http.HttpHeaders;
import com.mbridge.msdk.thrid.okhttp.internal.http.HttpMethod;
import com.mbridge.msdk.thrid.okhttp.internal.http.StatusLine;
import com.mbridge.msdk.thrid.okhttp.internal.io.FileSystem;
import com.mbridge.msdk.thrid.okhttp.internal.platform.Platform;
import com.mbridge.msdk.thrid.okio.Buffer;
import com.mbridge.msdk.thrid.okio.BufferedSink;
import com.mbridge.msdk.thrid.okio.BufferedSource;
import com.mbridge.msdk.thrid.okio.ByteString;
import com.mbridge.msdk.thrid.okio.ForwardingSink;
import com.mbridge.msdk.thrid.okio.ForwardingSource;
import com.mbridge.msdk.thrid.okio.Okio;
import com.mbridge.msdk.thrid.okio.Sink;
import com.mbridge.msdk.thrid.okio.Source;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public final class Cache
implements Closeable,
Flushable {
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    private static final int ENTRY_METADATA = 0;
    private static final int VERSION = 201105;
    final DiskLruCache cache;
    private int hitCount;
    final InternalCache internalCache = new InternalCache(){

        public Response get(Request request) throws IOException {
            return Cache.this.get(request);
        }

        public CacheRequest put(Response response) throws IOException {
            return Cache.this.put(response);
        }

        public void remove(Request request) throws IOException {
            Cache.this.remove(request);
        }

        public void trackConditionalCacheHit() {
            Cache.this.trackConditionalCacheHit();
        }

        public void trackResponse(CacheStrategy cacheStrategy) {
            Cache.this.trackResponse(cacheStrategy);
        }

        public void update(Response response, Response response2) {
            Cache.this.update(response, response2);
        }
    };
    private int networkCount;
    private int requestCount;
    int writeAbortCount;
    int writeSuccessCount;

    public Cache(File file, long l2) {
        this(file, l2, FileSystem.SYSTEM);
    }

    Cache(File file, long l2, FileSystem fileSystem) {
        this.cache = DiskLruCache.create(fileSystem, file, 201105, 2, l2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void abortQuietly(@Nullable DiskLruCache.Editor editor) {
        if (editor == null) return;
        try {
            editor.abort();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static String key(HttpUrl httpUrl) {
        return ByteString.encodeUtf8((String)httpUrl.toString()).md5().hex();
    }

    static int readInt(BufferedSource object) throws IOException {
        String string2;
        long l2;
        block4: {
            try {
                l2 = object.readDecimalLong();
                string2 = object.readUtf8LineStrict();
                if (l2 < 0L || l2 > Integer.MAX_VALUE) break block4;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
            if (!string2.isEmpty()) break block4;
            return (int)l2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("expected an int but was \"");
        stringBuilder.append(l2);
        stringBuilder.append(string2);
        stringBuilder.append("\"");
        object = new IOException(stringBuilder.toString());
        throw object;
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    public void delete() throws IOException {
        this.cache.delete();
    }

    public File directory() {
        return this.cache.getDirectory();
    }

    public void evictAll() throws IOException {
        this.cache.evictAll();
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    Response get(Request request) {
        Closeable closeable;
        Object object;
        block5: {
            object = Cache.key(request.url());
            try {
                closeable = this.cache.get((String)object);
                if (closeable != null) break block5;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        try {
            object = new Entry(((DiskLruCache.Snapshot)closeable).getSource(0));
            closeable = ((Entry)object).response((DiskLruCache.Snapshot)closeable);
            if (((Entry)object).matches(request, (Response)closeable)) return closeable;
        }
        catch (IOException iOException) {
            Util.closeQuietly(closeable);
            return null;
        }
        Util.closeQuietly(((Response)closeable).body());
        return null;
    }

    public int hitCount() {
        synchronized (this) {
            int n2 = this.hitCount;
            return n2;
        }
    }

    public void initialize() throws IOException {
        this.cache.initialize();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    public long maxSize() {
        return this.cache.getMaxSize();
    }

    public int networkCount() {
        synchronized (this) {
            int n2 = this.networkCount;
            return n2;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    CacheRequest put(Response object) {
        Object object2;
        block9: {
            object2 = ((Response)object).request().method();
            if (HttpMethod.invalidatesCache((String)((Response)object).request().method())) {
                this.remove(((Response)object).request());
                return null;
            }
            if (!((String)object2).equals("GET")) {
                return null;
            }
            if (HttpHeaders.hasVaryAll((Response)object)) {
                return null;
            }
            object2 = new Entry((Response)object);
            object = this.cache.edit(Cache.key(((Response)object).request().url()));
            if (object != null) break block9;
            return null;
        }
        ((Entry)object2).writeTo((DiskLruCache.Editor)object);
        return new CacheRequestImpl((DiskLruCache.Editor)object);
        {
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            block10: {
                object = null;
                break block10;
                catch (IOException iOException2) {
                    return null;
                }
            }
            this.abortQuietly((DiskLruCache.Editor)object);
            return null;
        }
    }

    void remove(Request request) throws IOException {
        this.cache.remove(Cache.key(request.url()));
    }

    public int requestCount() {
        synchronized (this) {
            int n2 = this.requestCount;
            return n2;
        }
    }

    public long size() throws IOException {
        return this.cache.size();
    }

    void trackConditionalCacheHit() {
        synchronized (this) {
            ++this.hitCount;
            return;
        }
    }

    void trackResponse(CacheStrategy cacheStrategy) {
        synchronized (this) {
            ++this.requestCount;
            if (cacheStrategy.networkRequest != null) {
                ++this.networkCount;
            } else if (cacheStrategy.cacheResponse != null) {
                ++this.hitCount;
            }
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void update(Response object, Response object2) {
        object2 = new Entry((Response)object2);
        object = ((CacheResponseBody)((Response)object).body()).snapshot;
        object = ((DiskLruCache.Snapshot)object).edit();
        if (object == null) return;
        ((Entry)object2).writeTo((DiskLruCache.Editor)object);
        ((DiskLruCache.Editor)object).commit();
        return;
        {
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            object = null;
            this.abortQuietly((DiskLruCache.Editor)object);
        }
    }

    public Iterator<String> urls() throws IOException {
        return new Iterator<String>(){
            boolean canRemove;
            final Iterator<DiskLruCache.Snapshot> delegate;
            @Nullable
            String nextUrl;
            {
                this.delegate = Cache.this.cache.snapshots();
            }

            @Override
            public boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    DiskLruCache.Snapshot snapshot = this.delegate.next();
                    try {
                        this.nextUrl = Okio.buffer((Source)snapshot.getSource(0)).readUtf8LineStrict();
                        return true;
                    }
                    catch (IOException iOException) {}
                    continue;
                    finally {
                        snapshot.close();
                    }
                }
                return false;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    String string2 = this.nextUrl;
                    this.nextUrl = null;
                    this.canRemove = true;
                    return string2;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.canRemove) {
                    this.delegate.remove();
                    return;
                }
                throw new IllegalStateException("remove() before next()");
            }
        };
    }

    public int writeAbortCount() {
        synchronized (this) {
            int n2 = this.writeAbortCount;
            return n2;
        }
    }

    public int writeSuccessCount() {
        synchronized (this) {
            int n2 = this.writeSuccessCount;
            return n2;
        }
    }

    private final class CacheRequestImpl
    implements CacheRequest {
        private Sink body;
        private Sink cacheOut;
        boolean done;
        private final DiskLruCache.Editor editor;

        CacheRequestImpl(final DiskLruCache.Editor editor) {
            this.editor = editor;
            this.cacheOut = editor.newSink(1);
            this.body = new ForwardingSink(this.cacheOut){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void close() throws IOException {
                    Cache cache = Cache.this;
                    synchronized (cache) {
                        if (CacheRequestImpl.this.done) {
                            return;
                        }
                        CacheRequestImpl.this.done = true;
                        Cache cache2 = Cache.this;
                        ++cache2.writeSuccessCount;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void abort() {
            Cache cache = Cache.this;
            synchronized (cache) {
                if (this.done) {
                    return;
                }
                this.done = true;
                Cache cache2 = Cache.this;
                ++cache2.writeAbortCount;
            }
            Util.closeQuietly((Closeable)this.cacheOut);
            try {
                this.editor.abort();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        public Sink body() {
            return this.body;
        }
    }

    private static class CacheResponseBody
    extends ResponseBody {
        private final BufferedSource bodySource;
        @Nullable
        private final String contentLength;
        @Nullable
        private final String contentType;
        final DiskLruCache.Snapshot snapshot;

        CacheResponseBody(final DiskLruCache.Snapshot snapshot, String string2, String string3) {
            this.snapshot = snapshot;
            this.contentType = string2;
            this.contentLength = string3;
            this.bodySource = Okio.buffer((Source)new ForwardingSource(snapshot.getSource(1)){

                public void close() throws IOException {
                    snapshot.close();
                    super.close();
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long contentLength() {
            long l2;
            long l3 = l2 = -1L;
            try {
                if (this.contentLength == null) return l3;
                return Long.parseLong(this.contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                return l2;
            }
        }

        @Override
        public MediaType contentType() {
            Object object = this.contentType;
            object = object != null ? MediaType.parse((String)object) : null;
            return object;
        }

        @Override
        public BufferedSource source() {
            return this.bodySource;
        }
    }

    private static final class Entry {
        private static final String RECEIVED_MILLIS;
        private static final String SENT_MILLIS;
        private final int code;
        @Nullable
        private final Handshake handshake;
        private final String message;
        private final Protocol protocol;
        private final long receivedResponseMillis;
        private final String requestMethod;
        private final Headers responseHeaders;
        private final long sentRequestMillis;
        private final String url;
        private final Headers varyHeaders;

        static {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Platform.get().getPrefix());
            stringBuilder.append("-Sent-Millis");
            SENT_MILLIS = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append(Platform.get().getPrefix());
            stringBuilder.append("-Received-Millis");
            RECEIVED_MILLIS = stringBuilder.toString();
        }

        Entry(Response response) {
            this.url = response.request().url().toString();
            this.varyHeaders = HttpHeaders.varyHeaders((Response)response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Entry(Source source) throws IOException {
            block9: {
                Object object;
                int n2;
                int n3;
                Object object2;
                Object object3;
                try {
                    object3 = Okio.buffer((Source)source);
                    this.url = object3.readUtf8LineStrict();
                    this.requestMethod = object3.readUtf8LineStrict();
                    object2 = new Object();
                    n3 = Cache.readInt((BufferedSource)object3);
                    int n4 = 0;
                    for (n2 = 0; n2 < n3; ++n2) {
                        ((Headers.Builder)object2).addLenient(object3.readUtf8LineStrict());
                    }
                }
                catch (Throwable throwable) {
                    source.close();
                    throw throwable;
                }
                {
                    this.varyHeaders = ((Headers.Builder)object2).build();
                    object2 = StatusLine.parse((String)object3.readUtf8LineStrict());
                    this.protocol = ((StatusLine)object2).protocol;
                    this.code = ((StatusLine)object2).code;
                    this.message = ((StatusLine)object2).message;
                    object = new Headers.Builder();
                    n3 = Cache.readInt((BufferedSource)object3);
                    for (n2 = n4; n2 < n3; ++n2) {
                        ((Headers.Builder)object).addLenient(object3.readUtf8LineStrict());
                    }
                }
                {
                    object2 = ((Headers.Builder)object).get(SENT_MILLIS);
                    Object object4 = ((Headers.Builder)object).get(RECEIVED_MILLIS);
                    ((Headers.Builder)object).removeAll(SENT_MILLIS);
                    ((Headers.Builder)object).removeAll(RECEIVED_MILLIS);
                    long l2 = 0L;
                    long l3 = object2 != null ? Long.parseLong((String)object2) : 0L;
                    this.sentRequestMillis = l3;
                    l3 = l2;
                    if (object4 != null) {
                        l3 = Long.parseLong((String)object4);
                    }
                    this.receivedResponseMillis = l3;
                    this.responseHeaders = ((Headers.Builder)object).build();
                    if (this.isHttps()) {
                        object2 = object3.readUtf8LineStrict();
                        if (((String)object2).length() > 0) {
                            ((StringBuilder)object3).append("expected \"\" but was \"");
                            ((StringBuilder)object3).append((String)object2);
                            ((StringBuilder)object3).append("\"");
                            object4 = new IOException(((StringBuilder)object3).toString());
                            throw object4;
                        }
                        object4 = CipherSuite.forJavaName((String)object3.readUtf8LineStrict());
                        object2 = this.readCertificateList((BufferedSource)object3);
                        object = this.readCertificateList((BufferedSource)object3);
                        object3 = !object3.exhausted() ? TlsVersion.forJavaName((String)object3.readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                        this.handshake = Handshake.get((TlsVersion)object3, (CipherSuite)object4, object2, (List<Certificate>)object);
                        break block9;
                    }
                    this.handshake = null;
                }
            }
            source.close();
        }

        private boolean isHttps() {
            return this.url.startsWith("https://");
        }

        private List<Certificate> readCertificateList(BufferedSource bufferedSource) throws IOException {
            ArrayList<Certificate> arrayList;
            CertificateFactory certificateFactory;
            int n2 = Cache.readInt(bufferedSource);
            if (n2 == -1) {
                return Collections.emptyList();
            }
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
                arrayList = new ArrayList<Certificate>(n2);
            }
            catch (CertificateException certificateException) {
                IOException iOException = new IOException(certificateException.getMessage());
                throw iOException;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = bufferedSource.readUtf8LineStrict();
                Buffer buffer = new Buffer();
                buffer.write(ByteString.decodeBase64((String)string2));
                arrayList.add(certificateFactory.generateCertificate(buffer.inputStream()));
                continue;
            }
            return arrayList;
        }

        private void writeCertList(BufferedSink bufferedSink, List<Certificate> list) throws IOException {
            int n2;
            bufferedSink.writeDecimalLong((long)list.size()).writeByte(10);
            try {
                n2 = list.size();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                IOException iOException = new IOException(certificateEncodingException.getMessage());
                throw iOException;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                bufferedSink.writeUtf8(ByteString.of((byte[])list.get(i2).getEncoded()).base64()).writeByte(10);
                continue;
            }
            return;
        }

        public boolean matches(Request request, Response response) {
            boolean bl = this.url.equals(request.url().toString()) && this.requestMethod.equals(request.method()) && HttpHeaders.varyMatches((Response)response, (Headers)this.varyHeaders, (Request)request);
            return bl;
        }

        public Response response(DiskLruCache.Snapshot snapshot) {
            String string2 = this.responseHeaders.get("Content-Type");
            String string3 = this.responseHeaders.get("Content-Length");
            Request request = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(request).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, string2, string3)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }

        public void writeTo(DiskLruCache.Editor editor) throws IOException {
            int n2;
            int n3 = 0;
            editor = Okio.buffer((Sink)editor.newSink(0));
            editor.writeUtf8(this.url).writeByte(10);
            editor.writeUtf8(this.requestMethod).writeByte(10);
            editor.writeDecimalLong(this.varyHeaders.size()).writeByte(10);
            int n4 = this.varyHeaders.size();
            for (n2 = 0; n2 < n4; ++n2) {
                editor.writeUtf8(this.varyHeaders.name(n2)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(n2)).writeByte(10);
            }
            editor.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
            editor.writeDecimalLong(this.responseHeaders.size() + 2).writeByte(10);
            n4 = this.responseHeaders.size();
            for (n2 = n3; n2 < n4; ++n2) {
                editor.writeUtf8(this.responseHeaders.name(n2)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(n2)).writeByte(10);
            }
            editor.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
            editor.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
            if (this.isHttps()) {
                editor.writeByte(10);
                editor.writeUtf8(this.handshake.cipherSuite().javaName()).writeByte(10);
                this.writeCertList((BufferedSink)editor, this.handshake.peerCertificates());
                this.writeCertList((BufferedSink)editor, this.handshake.localCertificates());
                editor.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
            }
            editor.close();
        }
    }
}

