/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.video;

import com.mbridge.msdk.playercommon.exoplayer2.ParserException;
import com.mbridge.msdk.playercommon.exoplayer2.util.CodecSpecificDataUtil;
import com.mbridge.msdk.playercommon.exoplayer2.util.NalUnitUtil;
import com.mbridge.msdk.playercommon.exoplayer2.util.ParsableByteArray;
import java.util.ArrayList;
import java.util.List;

public final class AvcConfig {
    public final int height;
    public final List<byte[]> initializationData;
    public final int nalUnitLengthFieldLength;
    public final float pixelWidthAspectRatio;
    public final int width;

    private AvcConfig(List<byte[]> list, int n2, int n3, int n4, float f2) {
        this.initializationData = list;
        this.nalUnitLengthFieldLength = n2;
        this.width = n3;
        this.height = n4;
        this.pixelWidthAspectRatio = f2;
    }

    private static byte[] buildNalUnitForChild(ParsableByteArray parsableByteArray) {
        int n2 = parsableByteArray.readUnsignedShort();
        int n3 = parsableByteArray.getPosition();
        parsableByteArray.skipBytes(n2);
        return CodecSpecificDataUtil.buildNalUnit((byte[])parsableByteArray.data, (int)n3, (int)n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AvcConfig parse(ParsableByteArray object) throws ParserException {
        try {
            object.skipBytes(4);
            int n2 = (object.readUnsignedByte() & 3) + 1;
            if (n2 != 3) {
                float f2;
                int n3;
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                int n4 = object.readUnsignedByte() & 0x1F;
                for (n3 = 0; n3 < n4; ++n3) {
                    arrayList.add(AvcConfig.buildNalUnitForChild(object));
                }
                int n5 = object.readUnsignedByte();
                for (n3 = 0; n3 < n5; ++n3) {
                    arrayList.add(AvcConfig.buildNalUnitForChild(object));
                }
                if (n4 > 0) {
                    byte[] byArray = (byte[])arrayList.get(0);
                    NalUnitUtil.SpsData spsData = NalUnitUtil.parseSpsNalUnit((byte[])((byte[])arrayList.get(0)), (int)n2, (int)byArray.length);
                    n3 = spsData.width;
                    n4 = spsData.height;
                    f2 = spsData.pixelWidthAspectRatio;
                    return new AvcConfig(arrayList, n2, n3, n4, f2);
                }
                n3 = -1;
                n4 = -1;
                f2 = 1.0f;
                return new AvcConfig(arrayList, n2, n3, n4, f2);
            }
            IllegalStateException illegalStateException = new IllegalStateException();
            throw illegalStateException;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ParserException parserException = new ParserException("Error parsing AVC config", (Throwable)arrayIndexOutOfBoundsException);
            throw parserException;
        }
    }
}

