/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.util;

import com.mbridge.msdk.playercommon.exoplayer2.C;
import com.mbridge.msdk.playercommon.exoplayer2.PlaybackParameters;
import com.mbridge.msdk.playercommon.exoplayer2.util.Clock;
import com.mbridge.msdk.playercommon.exoplayer2.util.MediaClock;

public final class StandaloneMediaClock
implements MediaClock {
    private long baseElapsedMs;
    private long baseUs;
    private final Clock clock;
    private PlaybackParameters playbackParameters;
    private boolean started;

    public StandaloneMediaClock(Clock clock) {
        this.clock = clock;
        this.playbackParameters = PlaybackParameters.DEFAULT;
    }

    public final PlaybackParameters getPlaybackParameters() {
        return this.playbackParameters;
    }

    public final long getPositionUs() {
        long l2;
        long l3 = l2 = this.baseUs;
        if (this.started) {
            l3 = this.clock.elapsedRealtime() - this.baseElapsedMs;
            l3 = this.playbackParameters.speed == 1.0f ? C.msToUs(l3) : this.playbackParameters.getMediaTimeUsForPlayoutTimeMs(l3);
            l3 = l2 + l3;
        }
        return l3;
    }

    public final void resetPosition(long l2) {
        this.baseUs = l2;
        if (this.started) {
            this.baseElapsedMs = this.clock.elapsedRealtime();
        }
    }

    public final PlaybackParameters setPlaybackParameters(PlaybackParameters playbackParameters) {
        if (this.started) {
            this.resetPosition(this.getPositionUs());
        }
        this.playbackParameters = playbackParameters;
        return playbackParameters;
    }

    public final void start() {
        if (!this.started) {
            this.baseElapsedMs = this.clock.elapsedRealtime();
            this.started = true;
        }
    }

    public final void stop() {
        if (this.started) {
            this.resetPosition(this.getPositionUs());
            this.started = false;
        }
    }
}

