/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.upstream.cache;

import android.net.Uri;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.DataSink;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.DataSource;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.DataSourceException;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.DataSpec;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.FileDataSource;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.TeeDataSource;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.cache.Cache;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.cache.CacheDataSink;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.cache.CacheSpan;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.cache.CacheUtil;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.cache.ContentMetadata;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.cache.ContentMetadataInternal;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.cache.ContentMetadataMutations;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;

public final class CacheDataSource
implements DataSource {
    public static final int CACHE_IGNORED_REASON_ERROR = 0;
    public static final int CACHE_IGNORED_REASON_UNSET_LENGTH = 1;
    private static final int CACHE_NOT_IGNORED = -1;
    public static final long DEFAULT_MAX_CACHE_FILE_SIZE = 0x200000L;
    public static final int FLAG_BLOCK_ON_CACHE = 1;
    public static final int FLAG_IGNORE_CACHE_FOR_UNSET_LENGTH_REQUESTS = 4;
    public static final int FLAG_IGNORE_CACHE_ON_ERROR = 2;
    private static final long MIN_READ_BEFORE_CHECKING_CACHE = 102400L;
    private Uri actualUri;
    private final boolean blockOnCache;
    private long bytesRemaining;
    private final Cache cache;
    private final DataSource cacheReadDataSource;
    private final DataSource cacheWriteDataSource;
    private long checkCachePosition;
    private DataSource currentDataSource;
    private boolean currentDataSpecLengthUnset;
    private CacheSpan currentHoleSpan;
    private boolean currentRequestIgnoresCache;
    private final EventListener eventListener;
    private int flags;
    private final boolean ignoreCacheForUnsetLengthRequests;
    private final boolean ignoreCacheOnError;
    private String key;
    private long readPosition;
    private boolean seenCacheError;
    private long totalCachedBytesRead;
    private final DataSource upstreamDataSource;
    private Uri uri;

    public CacheDataSource(Cache cache, DataSource dataSource) {
        this(cache, dataSource, 0, 0x200000L);
    }

    public CacheDataSource(Cache cache, DataSource dataSource, int n2) {
        this(cache, dataSource, n2, 0x200000L);
    }

    public CacheDataSource(Cache cache, DataSource dataSource, int n2, long l2) {
        this(cache, dataSource, (DataSource)new FileDataSource(), (DataSink)new CacheDataSink(cache, l2), n2, null);
    }

    public CacheDataSource(Cache cache, DataSource dataSource, DataSource dataSource2, DataSink dataSink, int n2, EventListener eventListener) {
        this.cache = cache;
        this.cacheReadDataSource = dataSource2;
        boolean bl = false;
        boolean bl2 = (n2 & 1) != 0;
        this.blockOnCache = bl2;
        bl2 = (n2 & 2) != 0;
        this.ignoreCacheOnError = bl2;
        bl2 = bl;
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        this.ignoreCacheForUnsetLengthRequests = bl2;
        this.upstreamDataSource = dataSource;
        this.cacheWriteDataSource = dataSink != null ? new TeeDataSource(dataSource, dataSink) : null;
        this.eventListener = eventListener;
    }

    private void closeCurrentSource() throws IOException {
        DataSource dataSource = this.currentDataSource;
        if (dataSource == null) {
            return;
        }
        try {
            dataSource.close();
            return;
        }
        finally {
            this.currentDataSource = null;
            this.currentDataSpecLengthUnset = false;
            dataSource = this.currentHoleSpan;
            if (dataSource != null) {
                this.cache.releaseHoleSpan((CacheSpan)dataSource);
                this.currentHoleSpan = null;
            }
        }
    }

    private static Uri getRedirectedUriOrDefault(Cache object, String string2, Uri uri) {
        string2 = ContentMetadataInternal.getRedirectedUri((ContentMetadata)object.getContentMetadata(string2));
        object = string2;
        if (string2 == null) {
            object = uri;
        }
        return object;
    }

    private void handleBeforeThrow(IOException iOException) {
        if (this.isReadingFromCache() || iOException instanceof Cache.CacheException) {
            this.seenCacheError = true;
        }
    }

    private boolean isBypassingCache() {
        boolean bl = this.currentDataSource == this.upstreamDataSource;
        return bl;
    }

    private static boolean isCausedByPositionOutOfRange(IOException throwable) {
        while (throwable != null) {
            if (throwable instanceof DataSourceException && ((DataSourceException)throwable).reason == 0) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    private boolean isReadingFromCache() {
        boolean bl = this.currentDataSource == this.cacheReadDataSource;
        return bl;
    }

    private boolean isReadingFromUpstream() {
        return this.isReadingFromCache() ^ true;
    }

    private boolean isWritingToCache() {
        boolean bl = this.currentDataSource == this.cacheWriteDataSource;
        return bl;
    }

    private void notifyBytesRead() {
        EventListener eventListener = this.eventListener;
        if (eventListener != null && this.totalCachedBytesRead > 0L) {
            eventListener.onCachedBytesRead(this.cache.getCacheSpace(), this.totalCachedBytesRead);
            this.totalCachedBytesRead = 0L;
        }
    }

    private void notifyCacheIgnored(int n2) {
        EventListener eventListener = this.eventListener;
        if (eventListener != null) {
            eventListener.onCacheIgnored(n2);
        }
    }

    private void openNextSource(boolean bl) throws IOException {
        long l2;
        CacheSpan cacheSpan;
        Object object;
        CacheSpan cacheSpan2;
        if (this.currentRequestIgnoresCache) {
            cacheSpan2 = null;
        } else if (this.blockOnCache) {
            try {
                cacheSpan2 = this.cache.startReadWrite(this.key, this.readPosition);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        } else {
            cacheSpan2 = this.cache.startReadWriteNonBlocking(this.key, this.readPosition);
        }
        if (cacheSpan2 == null) {
            DataSource dataSource = this.upstreamDataSource;
            object = new DataSpec(this.uri, this.readPosition, this.bytesRemaining, this.key, this.flags);
            cacheSpan = cacheSpan2;
            cacheSpan2 = dataSource;
        } else if (cacheSpan2.isCached) {
            object = Uri.fromFile((File)cacheSpan2.file);
            long l3 = this.readPosition - cacheSpan2.position;
            long l4 = cacheSpan2.length - l3;
            long l5 = this.bytesRemaining;
            l2 = l4;
            if (l5 != -1L) {
                l2 = Math.min(l4, l5);
            }
            object = new DataSpec((Uri)object, this.readPosition, l3, l2, this.key, this.flags);
            DataSource dataSource = this.cacheReadDataSource;
            cacheSpan = cacheSpan2;
            cacheSpan2 = dataSource;
        } else {
            if (cacheSpan2.isOpenEnded()) {
                l2 = this.bytesRemaining;
            } else {
                long l6 = cacheSpan2.length;
                long l7 = this.bytesRemaining;
                l2 = l6;
                if (l7 != -1L) {
                    l2 = Math.min(l6, l7);
                }
            }
            object = new DataSpec(this.uri, this.readPosition, l2, this.key, this.flags);
            DataSource dataSource = this.cacheWriteDataSource;
            if (dataSource != null) {
                cacheSpan = cacheSpan2;
                cacheSpan2 = dataSource;
            } else {
                dataSource = this.upstreamDataSource;
                this.cache.releaseHoleSpan(cacheSpan2);
                cacheSpan = null;
                cacheSpan2 = dataSource;
            }
        }
        l2 = !this.currentRequestIgnoresCache && cacheSpan2 == this.upstreamDataSource ? this.readPosition + 102400L : Long.MAX_VALUE;
        this.checkCachePosition = l2;
        if (bl) {
            Assertions.checkState(this.isBypassingCache());
            if (cacheSpan2 == this.upstreamDataSource) {
                return;
            }
            try {
                this.closeCurrentSource();
            }
            catch (Throwable throwable) {
                if (cacheSpan.isHoleSpan()) {
                    this.cache.releaseHoleSpan(cacheSpan);
                }
                throw throwable;
            }
        }
        if (cacheSpan != null && cacheSpan.isHoleSpan()) {
            this.currentHoleSpan = cacheSpan;
        }
        this.currentDataSource = cacheSpan2;
        bl = object.length == -1L;
        this.currentDataSpecLengthUnset = bl;
        l2 = cacheSpan2.open((DataSpec)object);
        cacheSpan2 = new ContentMetadataMutations();
        if (this.currentDataSpecLengthUnset && l2 != -1L) {
            this.bytesRemaining = l2;
            ContentMetadataInternal.setContentLength((ContentMetadataMutations)cacheSpan2, (long)(this.readPosition + this.bytesRemaining));
        }
        if (this.isReadingFromUpstream()) {
            this.actualUri = this.currentDataSource.getUri();
            if (true ^ this.uri.equals((Object)this.actualUri)) {
                ContentMetadataInternal.setRedirectedUri((ContentMetadataMutations)cacheSpan2, (Uri)this.actualUri);
            } else {
                ContentMetadataInternal.removeRedirectedUri((ContentMetadataMutations)cacheSpan2);
            }
        }
        if (this.isWritingToCache()) {
            this.cache.applyContentMetadataMutations(this.key, (ContentMetadataMutations)cacheSpan2);
        }
    }

    private void setNoBytesRemainingAndMaybeStoreLength() throws IOException {
        this.bytesRemaining = 0L;
        if (this.isWritingToCache()) {
            this.cache.setContentLength(this.key, this.readPosition);
        }
    }

    private int shouldIgnoreCacheForRequest(DataSpec dataSpec) {
        if (this.ignoreCacheOnError && this.seenCacheError) {
            return 0;
        }
        if (this.ignoreCacheForUnsetLengthRequests && dataSpec.length == -1L) {
            return 1;
        }
        return -1;
    }

    public final void close() throws IOException {
        this.uri = null;
        this.actualUri = null;
        this.notifyBytesRead();
        try {
            this.closeCurrentSource();
            return;
        }
        catch (IOException iOException) {
            this.handleBeforeThrow(iOException);
            throw iOException;
        }
    }

    public final Uri getUri() {
        return this.actualUri;
    }

    public final long open(DataSpec dataSpec) throws IOException {
        boolean bl;
        int n2;
        try {
            this.key = CacheUtil.getKey((DataSpec)dataSpec);
            this.uri = dataSpec.uri;
            this.actualUri = CacheDataSource.getRedirectedUriOrDefault(this.cache, this.key, this.uri);
            this.flags = dataSpec.flags;
            this.readPosition = dataSpec.position;
            n2 = this.shouldIgnoreCacheForRequest(dataSpec);
            bl = n2 != -1;
        }
        catch (IOException iOException) {
            this.handleBeforeThrow(iOException);
            throw iOException;
        }
        this.currentRequestIgnoresCache = bl;
        if (this.currentRequestIgnoresCache) {
            this.notifyCacheIgnored(n2);
        }
        if (dataSpec.length == -1L && !this.currentRequestIgnoresCache) {
            this.bytesRemaining = this.cache.getContentLength(this.key);
            if (this.bytesRemaining != -1L) {
                this.bytesRemaining -= dataSpec.position;
                if (this.bytesRemaining <= 0L) {
                    dataSpec = new DataSourceException(0);
                    throw dataSpec;
                }
            }
        } else {
            this.bytesRemaining = dataSpec.length;
        }
        this.openNextSource(false);
        long l2 = this.bytesRemaining;
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int n4;
            if (this.readPosition >= this.checkCachePosition) {
                this.openNextSource(true);
            }
            if ((n4 = this.currentDataSource.read(byArray, n2, n3)) != -1) {
                if (this.isReadingFromCache()) {
                    this.totalCachedBytesRead += (long)n4;
                }
                long l2 = this.readPosition;
                long l3 = n4;
                this.readPosition = l2 + l3;
                if (this.bytesRemaining == -1L) return n4;
                this.bytesRemaining -= l3;
                return n4;
            }
            if (this.currentDataSpecLengthUnset) {
                this.setNoBytesRemainingAndMaybeStoreLength();
                return n4;
            }
            if (this.bytesRemaining <= 0L) {
                if (this.bytesRemaining != -1L) return n4;
            }
            this.closeCurrentSource();
            this.openNextSource(false);
            return this.read(byArray, n2, n3);
        }
        catch (IOException iOException) {
            if (this.currentDataSpecLengthUnset && CacheDataSource.isCausedByPositionOutOfRange(iOException)) {
                this.setNoBytesRemainingAndMaybeStoreLength();
                return -1;
            }
            this.handleBeforeThrow(iOException);
            throw iOException;
        }
    }

    public static @interface CacheIgnoredReason {
    }

    public static interface EventListener {
        public void onCacheIgnored(int var1);

        public void onCachedBytesRead(long var1, long var3);
    }

    public static @interface Flags {
    }
}

