/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.upstream;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.LoaderErrorThrower;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.TraceUtil;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

public final class Loader
implements LoaderErrorThrower {
    public static final int DONT_RETRY = 2;
    public static final int DONT_RETRY_FATAL = 3;
    public static final int RETRY = 0;
    public static final int RETRY_RESET_ERROR_COUNT = 1;
    private LoadTask<? extends Loadable> currentTask;
    private final ExecutorService downloadExecutorService;
    private IOException fatalError;

    public Loader(String string2) {
        this.downloadExecutorService = Util.newSingleThreadExecutor((String)string2);
    }

    static /* synthetic */ LoadTask access$002(Loader loader, LoadTask loadTask) {
        loader.currentTask = loadTask;
        return loadTask;
    }

    static /* synthetic */ IOException access$102(Loader loader, IOException iOException) {
        loader.fatalError = iOException;
        return iOException;
    }

    public final void cancelLoading() {
        this.currentTask.cancel(false);
    }

    public final boolean isLoading() {
        boolean bl = this.currentTask != null;
        return bl;
    }

    public final void maybeThrowError() throws IOException {
        this.maybeThrowError(Integer.MIN_VALUE);
    }

    public final void maybeThrowError(int n2) throws IOException {
        LoadTask<? extends Loadable> loadTask = this.fatalError;
        if (loadTask == null) {
            loadTask = this.currentTask;
            if (loadTask != null) {
                int n3 = n2;
                if (n2 == Integer.MIN_VALUE) {
                    n3 = loadTask.defaultMinRetryCount;
                }
                loadTask.maybeThrowError(n3);
            }
            return;
        }
        throw loadTask;
    }

    public final void release() {
        this.release(null);
    }

    public final void release(ReleaseCallback releaseCallback) {
        LoadTask<? extends Loadable> loadTask = this.currentTask;
        if (loadTask != null) {
            loadTask.cancel(true);
        }
        if (releaseCallback != null) {
            this.downloadExecutorService.execute(new ReleaseTask(releaseCallback));
        }
        this.downloadExecutorService.shutdown();
    }

    public final <T extends Loadable> long startLoading(T t2, Callback<T> callback2, int n2) {
        Looper looper = Looper.myLooper();
        boolean bl = looper != null;
        Assertions.checkState(bl);
        this.fatalError = null;
        long l2 = SystemClock.elapsedRealtime();
        new LoadTask(this, looper, t2, callback2, n2, l2).start(0L);
        return l2;
    }

    public static interface Callback<T extends Loadable> {
        public void onLoadCanceled(T var1, long var2, long var4, boolean var6);

        public void onLoadCompleted(T var1, long var2, long var4);

        public int onLoadError(T var1, long var2, long var4, IOException var6);
    }

    private final class LoadTask<T extends Loadable>
    extends Handler
    implements Runnable {
        private static final int MSG_CANCEL = 1;
        private static final int MSG_END_OF_SOURCE = 2;
        private static final int MSG_FATAL_ERROR = 4;
        private static final int MSG_IO_EXCEPTION = 3;
        private static final int MSG_START = 0;
        private static final String TAG = "LoadTask";
        private Callback<T> callback;
        private volatile boolean canceled;
        private IOException currentError;
        public final int defaultMinRetryCount;
        private int errorCount;
        private volatile Thread executorThread;
        private final T loadable;
        private volatile boolean released;
        private final long startTimeMs;
        final /* synthetic */ Loader this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public LoadTask(Looper looper, T t2, Callback<T> callback2, int n2, long l3) {
            void var2_-1;
            this.this$0 = (Loader)l2;
            super((Looper)var2_-1);
            this.loadable = looper;
            this.callback = t2;
            this.defaultMinRetryCount = (int)callback2;
            this.startTimeMs = n2;
        }

        private void execute() {
            this.currentError = null;
            this.this$0.downloadExecutorService.execute(this.this$0.currentTask);
        }

        private void finish() {
            Loader.access$002(this.this$0, null);
        }

        private long getRetryDelayMillis() {
            return Math.min((this.errorCount - 1) * 1000, 5000);
        }

        public final void cancel(boolean bl) {
            this.released = bl;
            this.currentError = null;
            if (this.hasMessages(0)) {
                this.removeMessages(0);
                if (!bl) {
                    this.sendEmptyMessage(1);
                }
            } else {
                this.canceled = true;
                this.loadable.cancelLoad();
                if (this.executorThread != null) {
                    this.executorThread.interrupt();
                }
            }
            if (bl) {
                this.finish();
                long l2 = SystemClock.elapsedRealtime();
                this.callback.onLoadCanceled(this.loadable, l2, l2 - this.startTimeMs, true);
                this.callback = null;
            }
        }

        public final void handleMessage(Message message) {
            if (this.released) {
                return;
            }
            if (message.what == 0) {
                this.execute();
                return;
            }
            if (message.what != 4) {
                this.finish();
                long l2 = SystemClock.elapsedRealtime();
                long l3 = l2 - this.startTimeMs;
                if (this.canceled) {
                    this.callback.onLoadCanceled(this.loadable, l2, l3, false);
                    return;
                }
                int n2 = message.what;
                int n3 = 1;
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 == 3) {
                            this.currentError = (IOException)message.obj;
                            n2 = this.callback.onLoadError(this.loadable, l2, l3, this.currentError);
                            if (n2 == 3) {
                                Loader.access$102(this.this$0, this.currentError);
                            } else if (n2 != 2) {
                                if (n2 != 1) {
                                    n3 = 1 + this.errorCount;
                                }
                                this.errorCount = n3;
                                this.start(this.getRetryDelayMillis());
                            }
                        }
                    } else {
                        try {
                            this.callback.onLoadCompleted(this.loadable, l2, l3);
                        }
                        catch (RuntimeException runtimeException) {
                            Log.e((String)TAG, (String)"Unexpected exception handling load completed", (Throwable)runtimeException);
                            Loader.access$102(this.this$0, new UnexpectedLoaderException(runtimeException));
                        }
                    }
                } else {
                    this.callback.onLoadCanceled(this.loadable, l2, l3, false);
                }
                return;
            }
            throw (Error)message.obj;
        }

        public final void maybeThrowError(int n2) throws IOException {
            IOException iOException = this.currentError;
            if (iOException != null && this.errorCount > n2) {
                throw iOException;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            try {
                this.executorThread = Thread.currentThread();
                if (!this.canceled) {
                    var1_1 = new StringBuilder();
                    var1_1.append("load:");
                    var1_1.append(this.loadable.getClass().getSimpleName());
                    TraceUtil.beginSection((String)var1_1.toString());
                }
                ** GOTO lbl-1000
            }
            catch (Error var1_3) {
                Log.e((String)"LoadTask", (String)"Unexpected error loading stream", (Throwable)var1_3);
                if (this.released != false) throw var1_3;
                this.obtainMessage(4, var1_3).sendToTarget();
                throw var1_3;
            }
            catch (OutOfMemoryError var1_4) {
                Log.e((String)"LoadTask", (String)"OutOfMemory error loading stream", (Throwable)var1_4);
                if (this.released != false) return;
                this.obtainMessage(3, new UnexpectedLoaderException(var1_4)).sendToTarget();
                return;
            }
            catch (Exception var1_5) {
                Log.e((String)"LoadTask", (String)"Unexpected exception loading stream", (Throwable)var1_5);
                if (this.released != false) return;
                this.obtainMessage(3, new UnexpectedLoaderException(var1_5)).sendToTarget();
                return;
            }
            catch (InterruptedException var1_6) {
                Assertions.checkState(this.canceled);
                if (this.released != false) return;
                this.sendEmptyMessage(2);
                return;
            }
            catch (IOException var1_7) {
                if (this.released != false) return;
                this.obtainMessage(3, var1_7).sendToTarget();
                return;
            }
            try {
                this.loadable.load();
            }
            finally {
                TraceUtil.endSection();
            }
lbl-1000:
            // 2 sources

            {
                if (this.released != false) return;
                this.sendEmptyMessage(2);
                return;
            }
        }

        public final void start(long l2) {
            boolean bl = this.this$0.currentTask == null;
            Assertions.checkState(bl);
            Loader.access$002(this.this$0, this);
            if (l2 > 0L) {
                this.sendEmptyMessageDelayed(0, l2);
            } else {
                this.execute();
            }
        }
    }

    public static interface Loadable {
        public void cancelLoad();

        public void load() throws IOException, InterruptedException;
    }

    public static interface ReleaseCallback {
        public void onLoaderReleased();
    }

    private static final class ReleaseTask
    implements Runnable {
        private final ReleaseCallback callback;

        public ReleaseTask(ReleaseCallback releaseCallback) {
            this.callback = releaseCallback;
        }

        @Override
        public final void run() {
            this.callback.onLoaderReleased();
        }
    }

    public static @interface RetryAction {
    }

    public static final class UnexpectedLoaderException
    extends IOException {
        public UnexpectedLoaderException(Throwable throwable) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unexpected ");
            stringBuilder.append(throwable.getClass().getSimpleName());
            stringBuilder.append(": ");
            stringBuilder.append(throwable.getMessage());
            super(stringBuilder.toString(), throwable);
        }
    }
}

