/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.upstream;

import android.text.TextUtils;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.DataSource;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.DataSpec;
import com.mbridge.msdk.playercommon.exoplayer2.util.Predicate;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface HttpDataSource
extends DataSource {
    public static final Predicate<String> REJECT_PAYWALL_TYPES = new Predicate<String>(){

        public final boolean evaluate(String string2) {
            boolean bl = !TextUtils.isEmpty((CharSequence)(string2 = Util.toLowerInvariant((String)string2))) && (!string2.contains("text") || string2.contains("text/vtt")) && !string2.contains("html") && !string2.contains("xml");
            return bl;
        }
    };

    public void clearAllRequestProperties();

    public void clearRequestProperty(String var1);

    public void close() throws HttpDataSourceException;

    public Map<String, List<String>> getResponseHeaders();

    public long open(DataSpec var1) throws HttpDataSourceException;

    public int read(byte[] var1, int var2, int var3) throws HttpDataSourceException;

    public void setRequestProperty(String var1, String var2);

    public static abstract class BaseFactory
    implements Factory {
        private final RequestProperties defaultRequestProperties = new RequestProperties();

        @Override
        public final void clearAllDefaultRequestProperties() {
            this.defaultRequestProperties.clear();
        }

        @Override
        public final void clearDefaultRequestProperty(String string2) {
            this.defaultRequestProperties.remove(string2);
        }

        @Override
        public final HttpDataSource createDataSource() {
            return this.createDataSourceInternal(this.defaultRequestProperties);
        }

        protected abstract HttpDataSource createDataSourceInternal(RequestProperties var1);

        @Override
        public final RequestProperties getDefaultRequestProperties() {
            return this.defaultRequestProperties;
        }

        @Override
        public final void setDefaultRequestProperty(String string2, String string3) {
            this.defaultRequestProperties.set(string2, string3);
        }
    }

    public static interface Factory
    extends DataSource.Factory {
        public void clearAllDefaultRequestProperties();

        public void clearDefaultRequestProperty(String var1);

        public HttpDataSource createDataSource();

        public RequestProperties getDefaultRequestProperties();

        public void setDefaultRequestProperty(String var1, String var2);
    }

    public static class HttpDataSourceException
    extends IOException {
        public static final int TYPE_CLOSE = 3;
        public static final int TYPE_OPEN = 1;
        public static final int TYPE_READ = 2;
        public final DataSpec dataSpec;
        public final int type;

        public HttpDataSourceException(DataSpec dataSpec, int n2) {
            this.dataSpec = dataSpec;
            this.type = n2;
        }

        public HttpDataSourceException(IOException iOException, DataSpec dataSpec, int n2) {
            super(iOException);
            this.dataSpec = dataSpec;
            this.type = n2;
        }

        public HttpDataSourceException(String string2, DataSpec dataSpec, int n2) {
            super(string2);
            this.dataSpec = dataSpec;
            this.type = n2;
        }

        public HttpDataSourceException(String string2, IOException iOException, DataSpec dataSpec, int n2) {
            super(string2, iOException);
            this.dataSpec = dataSpec;
            this.type = n2;
        }

        public static @interface Type {
        }
    }

    public static final class InvalidContentTypeException
    extends HttpDataSourceException {
        public final String contentType;

        public InvalidContentTypeException(String string2, DataSpec dataSpec) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid content type: ");
            stringBuilder.append(string2);
            super(stringBuilder.toString(), dataSpec, 1);
            this.contentType = string2;
        }
    }

    public static final class InvalidResponseCodeException
    extends HttpDataSourceException {
        public final Map<String, List<String>> headerFields;
        public final int responseCode;

        public InvalidResponseCodeException(int n2, Map<String, List<String>> map, DataSpec dataSpec) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Response code: ");
            stringBuilder.append(n2);
            super(stringBuilder.toString(), dataSpec, 1);
            this.responseCode = n2;
            this.headerFields = map;
        }
    }

    public static final class RequestProperties {
        private final Map<String, String> requestProperties = new HashMap<String, String>();
        private Map<String, String> requestPropertiesSnapshot;

        public final void clear() {
            synchronized (this) {
                this.requestPropertiesSnapshot = null;
                this.requestProperties.clear();
                return;
            }
        }

        public final void clearAndSet(Map<String, String> map) {
            synchronized (this) {
                this.requestPropertiesSnapshot = null;
                this.requestProperties.clear();
                this.requestProperties.putAll(map);
                return;
            }
        }

        public final Map<String, String> getSnapshot() {
            synchronized (this) {
                Map<String, String> map;
                if (this.requestPropertiesSnapshot == null) {
                    map = new Map<String, String>(this.requestProperties);
                    this.requestPropertiesSnapshot = Collections.unmodifiableMap(map);
                }
                map = this.requestPropertiesSnapshot;
                return map;
            }
        }

        public final void remove(String string2) {
            synchronized (this) {
                this.requestPropertiesSnapshot = null;
                this.requestProperties.remove(string2);
                return;
            }
        }

        public final void set(String string2, String string3) {
            synchronized (this) {
                this.requestPropertiesSnapshot = null;
                this.requestProperties.put(string2, string3);
                return;
            }
        }

        public final void set(Map<String, String> map) {
            synchronized (this) {
                this.requestPropertiesSnapshot = null;
                this.requestProperties.putAll(map);
                return;
            }
        }
    }
}

