/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.upstream;

import android.net.Uri;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import java.util.Arrays;

public final class DataSpec {
    public static final int FLAG_ALLOW_CACHING_UNKNOWN_LENGTH = 2;
    public static final int FLAG_ALLOW_GZIP = 1;
    public final long absoluteStreamPosition;
    public final int flags;
    public final String key;
    public final long length;
    public final long position;
    public final byte[] postBody;
    public final Uri uri;

    public DataSpec(Uri uri) {
        this(uri, 0);
    }

    public DataSpec(Uri uri, int n2) {
        this(uri, 0L, -1L, null, n2);
    }

    public DataSpec(Uri uri, long l2, long l3, long l4, String string2, int n2) {
        this(uri, null, l2, l3, l4, string2, n2);
    }

    public DataSpec(Uri uri, long l2, long l3, String string2) {
        this(uri, l2, l2, l3, string2, 0);
    }

    public DataSpec(Uri uri, long l2, long l3, String string2, int n2) {
        this(uri, l2, l2, l3, string2, n2);
    }

    public DataSpec(Uri uri, byte[] byArray, long l2, long l3, long l4, String string2, int n2) {
        boolean bl = true;
        boolean bl2 = l2 >= 0L;
        Assertions.checkArgument(bl2);
        bl2 = l3 >= 0L;
        Assertions.checkArgument(bl2);
        bl2 = bl;
        if (l4 <= 0L) {
            bl2 = l4 == -1L ? bl : false;
        }
        Assertions.checkArgument(bl2);
        this.uri = uri;
        this.postBody = byArray;
        this.absoluteStreamPosition = l2;
        this.position = l3;
        this.length = l4;
        this.key = string2;
        this.flags = n2;
    }

    public final boolean isFlagSet(int n2) {
        boolean bl = (this.flags & n2) == n2;
        return bl;
    }

    public final DataSpec subrange(long l2) {
        long l3 = this.length;
        long l4 = -1L;
        if (l3 != -1L) {
            l4 = l3 - l2;
        }
        return this.subrange(l2, l4);
    }

    public final DataSpec subrange(long l2, long l3) {
        if (l2 == 0L && this.length == l3) {
            return this;
        }
        return new DataSpec(this.uri, this.postBody, this.absoluteStreamPosition + l2, this.position + l2, l3, this.key, this.flags);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataSpec[");
        stringBuilder.append(this.uri);
        stringBuilder.append(", ");
        stringBuilder.append(Arrays.toString(this.postBody));
        stringBuilder.append(", ");
        stringBuilder.append(this.absoluteStreamPosition);
        stringBuilder.append(", ");
        stringBuilder.append(this.position);
        stringBuilder.append(", ");
        stringBuilder.append(this.length);
        stringBuilder.append(", ");
        stringBuilder.append(this.key);
        stringBuilder.append(", ");
        stringBuilder.append(this.flags);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public final DataSpec withUri(Uri uri) {
        return new DataSpec(uri, this.postBody, this.absoluteStreamPosition, this.position, this.length, this.key, this.flags);
    }

    public static @interface Flags {
    }
}

