/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.upstream;

import com.mbridge.msdk.playercommon.exoplayer2.upstream.DataSource;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.DataSpec;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import java.io.IOException;
import java.io.InputStream;

public final class DataSourceInputStream
extends InputStream {
    private boolean closed = false;
    private final DataSource dataSource;
    private final DataSpec dataSpec;
    private boolean opened = false;
    private final byte[] singleByteArray;
    private long totalBytesRead;

    public DataSourceInputStream(DataSource dataSource, DataSpec dataSpec) {
        this.dataSource = dataSource;
        this.dataSpec = dataSpec;
        this.singleByteArray = new byte[1];
    }

    private void checkOpened() throws IOException {
        if (!this.opened) {
            this.dataSource.open(this.dataSpec);
            this.opened = true;
        }
    }

    public final long bytesRead() {
        return this.totalBytesRead;
    }

    @Override
    public final void close() throws IOException {
        if (!this.closed) {
            this.dataSource.close();
            this.closed = true;
        }
    }

    public final void open() throws IOException {
        this.checkOpened();
    }

    @Override
    public final int read() throws IOException {
        int n2 = this.read(this.singleByteArray);
        int n3 = -1;
        if (n2 != -1) {
            n3 = this.singleByteArray[0] & 0xFF;
        }
        return n3;
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        Assertions.checkState(this.closed ^ true);
        this.checkOpened();
        n2 = this.dataSource.read(byArray, n2, n3);
        if (n2 == -1) {
            return -1;
        }
        this.totalBytesRead += (long)n2;
        return n2;
    }
}

