/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.trackselection;

import android.content.Context;
import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.mbridge.msdk.playercommon.exoplayer2.ExoPlaybackException;
import com.mbridge.msdk.playercommon.exoplayer2.Format;
import com.mbridge.msdk.playercommon.exoplayer2.RendererConfiguration;
import com.mbridge.msdk.playercommon.exoplayer2.source.TrackGroup;
import com.mbridge.msdk.playercommon.exoplayer2.source.TrackGroupArray;
import com.mbridge.msdk.playercommon.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.mbridge.msdk.playercommon.exoplayer2.trackselection.FixedTrackSelection;
import com.mbridge.msdk.playercommon.exoplayer2.trackselection.MappingTrackSelector;
import com.mbridge.msdk.playercommon.exoplayer2.trackselection.TrackSelection;
import com.mbridge.msdk.playercommon.exoplayer2.upstream.BandwidthMeter;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import com.mbridge.msdk.playercommon.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultTrackSelector
extends MappingTrackSelector {
    private static final float FRACTION_TO_CONSIDER_FULLSCREEN = 0.98f;
    private static final int[] NO_TRACKS = new int[0];
    private static final int WITHIN_RENDERER_CAPABILITIES_BONUS = 1000;
    private final TrackSelection.Factory adaptiveTrackSelectionFactory;
    private final AtomicReference<Parameters> parametersReference;

    public DefaultTrackSelector() {
        this((TrackSelection.Factory)null);
    }

    public DefaultTrackSelector(TrackSelection.Factory factory) {
        this.adaptiveTrackSelectionFactory = factory;
        this.parametersReference = new AtomicReference<Parameters>(Parameters.DEFAULT);
    }

    public DefaultTrackSelector(BandwidthMeter bandwidthMeter) {
        this((TrackSelection.Factory)new AdaptiveTrackSelection.Factory(bandwidthMeter));
    }

    private static int compareFormatValues(int n2, int n3) {
        int n4 = -1;
        if (n2 == -1) {
            n2 = n4;
            if (n3 == -1) {
                n2 = 0;
            }
        } else {
            n2 = n3 == -1 ? 1 : (n2 -= n3);
        }
        return n2;
    }

    private static int compareInts(int n2, int n3) {
        n2 = n2 > n3 ? 1 : (n3 > n2 ? -1 : 0);
        return n2;
    }

    private static void filterAdaptiveVideoTrackCountForMimeType(TrackGroup trackGroup, int[] nArray, int n2, String string2, int n3, int n4, int n5, List<Integer> list) {
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            int n6 = list.get(i2);
            if (DefaultTrackSelector.isSupportedAdaptiveVideoTrack(trackGroup.getFormat(n6), string2, nArray[n6], n2, n3, n4, n5)) continue;
            list.remove(i2);
        }
    }

    protected static boolean formatHasLanguage(Format format, String string2) {
        boolean bl = string2 != null && TextUtils.equals((CharSequence)string2, (CharSequence)Util.normalizeLanguageCode((String)format.language));
        return bl;
    }

    protected static boolean formatHasNoLanguage(Format format) {
        boolean bl = TextUtils.isEmpty((CharSequence)format.language) || DefaultTrackSelector.formatHasLanguage(format, "und");
        return bl;
    }

    private static int getAdaptiveAudioTrackCount(TrackGroup trackGroup, int[] nArray, AudioConfigurationTuple audioConfigurationTuple) {
        int n2 = 0;
        for (int i2 = 0; i2 < trackGroup.length; ++i2) {
            int n3 = n2;
            if (DefaultTrackSelector.isSupportedAdaptiveAudioTrack(trackGroup.getFormat(i2), nArray[i2], audioConfigurationTuple)) {
                n3 = n2 + 1;
            }
            n2 = n3;
        }
        return n2;
    }

    private static int[] getAdaptiveAudioTracks(TrackGroup trackGroup, int[] nArray, boolean bl) {
        int n2;
        Object object;
        int n3;
        HashSet<AudioConfigurationTuple> hashSet = new HashSet<AudioConfigurationTuple>();
        int n4 = 0;
        Object object2 = null;
        int n5 = 0;
        for (n3 = 0; n3 < trackGroup.length; ++n3) {
            object = trackGroup.getFormat(n3);
            int n6 = object.channelCount;
            n2 = object.sampleRate;
            object = bl ? null : object.sampleMimeType;
            AudioConfigurationTuple audioConfigurationTuple = new AudioConfigurationTuple(n6, n2, (String)object);
            n2 = n5;
            object = object2;
            if (hashSet.add(audioConfigurationTuple)) {
                n6 = DefaultTrackSelector.getAdaptiveAudioTrackCount(trackGroup, nArray, audioConfigurationTuple);
                n2 = n5;
                object = object2;
                if (n6 > n5) {
                    n2 = n6;
                    object = audioConfigurationTuple;
                }
            }
            n5 = n2;
            object2 = object;
        }
        if (n5 > 1) {
            object = new int[n5];
            n2 = 0;
            for (n3 = n4; n3 < trackGroup.length; ++n3) {
                n5 = n2;
                if (DefaultTrackSelector.isSupportedAdaptiveAudioTrack(trackGroup.getFormat(n3), nArray[n3], Assertions.checkNotNull(object2))) {
                    object[n2] = (Format)n3;
                    n5 = n2 + 1;
                }
                n2 = n5;
            }
            return object;
        }
        return NO_TRACKS;
    }

    private static int getAdaptiveVideoTrackCountForMimeType(TrackGroup trackGroup, int[] nArray, int n2, String string2, int n3, int n4, int n5, List<Integer> list) {
        int n6 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n7 = list.get(i2);
            int n8 = n6;
            if (DefaultTrackSelector.isSupportedAdaptiveVideoTrack(trackGroup.getFormat(n7), string2, nArray[n7], n2, n3, n4, n5)) {
                n8 = n6 + 1;
            }
            n6 = n8;
        }
        return n6;
    }

    private static int[] getAdaptiveVideoTracksForGroup(TrackGroup object, int[] nArray, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        String string2;
        if (((TrackGroup)object).length < 2) {
            return NO_TRACKS;
        }
        List<Integer> list = DefaultTrackSelector.getViewportFilteredTrackIndices((TrackGroup)object, n6, n7, bl2);
        if (list.size() < 2) {
            return NO_TRACKS;
        }
        if (!bl) {
            HashSet<String> hashSet = new HashSet<String>();
            string2 = null;
            n6 = 0;
            for (n7 = 0; n7 < list.size(); ++n7) {
                String string3 = object.getFormat((int)list.get((int)n7).intValue()).sampleMimeType;
                String string4 = string2;
                int n8 = n6;
                if (hashSet.add(string3)) {
                    int n9 = DefaultTrackSelector.getAdaptiveVideoTrackCountForMimeType((TrackGroup)object, nArray, n2, string3, n3, n4, n5, list);
                    string4 = string2;
                    n8 = n6;
                    if (n9 > n6) {
                        n8 = n9;
                        string4 = string3;
                    }
                }
                string2 = string4;
                n6 = n8;
            }
        } else {
            string2 = null;
        }
        DefaultTrackSelector.filterAdaptiveVideoTrackCountForMimeType((TrackGroup)object, nArray, n2, string2, n3, n4, n5, list);
        object = list.size() < 2 ? (Object)NO_TRACKS : (Object)Util.toArray(list);
        return object;
    }

    private static Point getMaxVideoSizeInViewport(boolean bl, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        block6: {
            block5: {
                if (!bl) break block5;
                n7 = 1;
                n6 = n4 > n5 ? 1 : 0;
                if (n2 <= n3) {
                    n7 = 0;
                }
                if (n6 != n7) break block6;
            }
            n6 = n3;
            n3 = n2;
            n2 = n6;
        }
        n6 = n4 * n2;
        n7 = n5 * n3;
        if (n6 >= n7) {
            return new Point(n3, Util.ceilDivide((int)n7, (int)n4));
        }
        return new Point(Util.ceilDivide((int)n6, (int)n5), n2);
    }

    private static List<Integer> getViewportFilteredTrackIndices(TrackGroup trackGroup, int n2, int n3, boolean bl) {
        int n4;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(trackGroup.length);
        int n5 = 0;
        for (n4 = 0; n4 < trackGroup.length; ++n4) {
            arrayList.add(n4);
        }
        if (n2 != Integer.MAX_VALUE && n3 != Integer.MAX_VALUE) {
            n4 = Integer.MAX_VALUE;
            while (n5 < trackGroup.length) {
                Format format = trackGroup.getFormat(n5);
                int n6 = n4;
                if (format.width > 0) {
                    n6 = n4;
                    if (format.height > 0) {
                        Point point = DefaultTrackSelector.getMaxVideoSizeInViewport(bl, n2, n3, format.width, format.height);
                        int n7 = format.width * format.height;
                        n6 = n4;
                        if (format.width >= (int)((float)point.x * 0.98f)) {
                            n6 = n4;
                            if (format.height >= (int)((float)point.y * 0.98f)) {
                                n6 = n4;
                                if (n7 < n4) {
                                    n6 = n7;
                                }
                            }
                        }
                    }
                }
                ++n5;
                n4 = n6;
            }
            if (n4 != Integer.MAX_VALUE) {
                for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                    n3 = trackGroup.getFormat(arrayList.get(n2).intValue()).getPixelCount();
                    if (n3 != -1 && n3 <= n4) continue;
                    arrayList.remove(n2);
                }
            }
        }
        return arrayList;
    }

    protected static boolean isSupported(int n2, boolean bl) {
        bl = (n2 &= 7) == 4 || bl && n2 == 3;
        return bl;
    }

    private static boolean isSupportedAdaptiveAudioTrack(Format format, int n2, AudioConfigurationTuple audioConfigurationTuple) {
        boolean bl;
        block2: {
            block3: {
                boolean bl2;
                bl = bl2 = false;
                if (!DefaultTrackSelector.isSupported(n2, false)) break block2;
                bl = bl2;
                if (format.channelCount != audioConfigurationTuple.channelCount) break block2;
                bl = bl2;
                if (format.sampleRate != audioConfigurationTuple.sampleRate) break block2;
                if (audioConfigurationTuple.mimeType == null) break block3;
                bl = bl2;
                if (!TextUtils.equals((CharSequence)audioConfigurationTuple.mimeType, (CharSequence)format.sampleMimeType)) break block2;
            }
            bl = true;
        }
        return bl;
    }

    private static boolean isSupportedAdaptiveVideoTrack(Format format, String string2, int n2, int n3, int n4, int n5, int n6) {
        boolean bl;
        block2: {
            block6: {
                boolean bl2;
                block5: {
                    block4: {
                        block3: {
                            bl = bl2 = false;
                            if (!DefaultTrackSelector.isSupported(n2, false)) break block2;
                            bl = bl2;
                            if ((n2 & n3) == 0) break block2;
                            if (string2 == null) break block3;
                            bl = bl2;
                            if (!Util.areEqual((Object)format.sampleMimeType, (Object)string2)) break block2;
                        }
                        if (format.width == -1) break block4;
                        bl = bl2;
                        if (format.width > n4) break block2;
                    }
                    if (format.height == -1) break block5;
                    bl = bl2;
                    if (format.height > n5) break block2;
                }
                if (format.bitrate == -1) break block6;
                bl = bl2;
                if (format.bitrate > n6) break block2;
            }
            bl = true;
        }
        return bl;
    }

    private static void maybeConfigureRenderersForTunneling(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] nArray, RendererConfiguration[] rendererConfigurationArray, TrackSelection[] trackSelectionArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        block6: {
            if (n2 == 0) {
                return;
            }
            n7 = 0;
            n6 = -1;
            n5 = -1;
            for (n4 = 0; n4 < mappedTrackInfo.getRendererCount(); ++n4) {
                int n8;
                block8: {
                    block11: {
                        block10: {
                            block9: {
                                TrackSelection trackSelection;
                                int n9;
                                block7: {
                                    n9 = mappedTrackInfo.getRendererType(n4);
                                    trackSelection = trackSelectionArray[n4];
                                    if (n9 == 1) break block7;
                                    n8 = n6;
                                    n3 = n5;
                                    if (n9 != 2) break block8;
                                }
                                n8 = n6;
                                n3 = n5;
                                if (trackSelection == null) break block8;
                                n8 = n6;
                                n3 = n5;
                                if (!DefaultTrackSelector.rendererSupportsTunneling(nArray[n4], mappedTrackInfo.getTrackGroups(n4), trackSelection)) break block8;
                                if (n9 != 1) break block9;
                                if (n5 != -1) break block10;
                                n3 = n4;
                                n8 = n6;
                                break block8;
                            }
                            if (n6 == -1) break block11;
                        }
                        n4 = 0;
                        break block6;
                    }
                    n8 = n4;
                    n3 = n5;
                }
                n6 = n8;
                n5 = n3;
            }
            n4 = 1;
        }
        n3 = n7;
        if (n5 != -1) {
            n3 = n7;
            if (n6 != -1) {
                n3 = 1;
            }
        }
        if ((n4 & n3) != 0) {
            mappedTrackInfo = new RendererConfiguration(n2);
            rendererConfigurationArray[n5] = mappedTrackInfo;
            rendererConfigurationArray[n6] = mappedTrackInfo;
        }
    }

    private static boolean rendererSupportsTunneling(int[][] nArray, TrackGroupArray trackGroupArray, TrackSelection trackSelection) {
        if (trackSelection == null) {
            return false;
        }
        int n2 = trackGroupArray.indexOf(trackSelection.getTrackGroup());
        for (int i2 = 0; i2 < trackSelection.length(); ++i2) {
            if ((nArray[n2][trackSelection.getIndexInTrackGroup(i2)] & 0x20) == 32) continue;
            return false;
        }
        return true;
    }

    private static TrackSelection selectAdaptiveVideoTrack(TrackGroupArray trackGroupArray, int[][] nArray, int n2, Parameters parameters, TrackSelection.Factory factory) throws ExoPlaybackException {
        int n3 = parameters.allowNonSeamlessAdaptiveness ? 24 : 16;
        boolean bl = parameters.allowMixedMimeAdaptiveness && (n2 & n3) != 0;
        for (n2 = 0; n2 < trackGroupArray.length; ++n2) {
            TrackGroup trackGroup = trackGroupArray.get(n2);
            int[] nArray2 = DefaultTrackSelector.getAdaptiveVideoTracksForGroup(trackGroup, nArray[n2], bl, n3, parameters.maxVideoWidth, parameters.maxVideoHeight, parameters.maxVideoBitrate, parameters.viewportWidth, parameters.viewportHeight, parameters.viewportOrientationMayChange);
            if (nArray2.length <= 0) continue;
            return Assertions.checkNotNull(factory).createTrackSelection(trackGroup, nArray2);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static TrackSelection selectFixedVideoTrack(TrackGroupArray var0, int[][] var1_1, Parameters var2_2) {
        var3_3 = 0;
        var4_4 = null;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = -1;
        var8_8 = -1;
        while (true) {
            var9_9 = var0 /* !! */ ;
            if (var3_3 >= var9_9.length) break;
            var10_10 = var9_9.get(var3_3);
            var11_11 = DefaultTrackSelector.getViewportFilteredTrackIndices(var10_10, var2_2.viewportWidth, var2_2.viewportHeight, var2_2.viewportOrientationMayChange);
            var12_12 = var1_1[var3_3];
            var13_13 = var7_7;
            var7_7 = var6_6;
            var14_14 = var5_5;
            var15_15 = 0;
            var5_5 = var8_8;
            var6_6 = var13_13;
            var8_8 = var7_7;
            var13_13 = var14_14;
            for (var7_7 = var15_15; var7_7 < var10_10.length; ++var7_7) {
                var9_9 = var4_4;
                var16_16 = var13_13;
                var17_17 = var8_8;
                var18_18 = var6_6;
                var19_19 = var5_5;
                if (DefaultTrackSelector.isSupported(var12_12[var7_7], var2_2.exceedRendererCapabilitiesIfNecessary)) {
                    var20_20 = var10_10.getFormat(var7_7);
                    var19_19 = !(var11_11.contains(var7_7) == false || var20_20.width != -1 && var20_20.width > var2_2.maxVideoWidth || var20_20.height != -1 && var20_20.height > var2_2.maxVideoHeight || var20_20.bitrate != -1 && var20_20.bitrate > var2_2.maxVideoBitrate) ? 1 : 0;
                    if (var19_19 == 0 && !var2_2.exceedVideoConstraintsIfNecessary) {
                        var9_9 = var4_4;
                        var16_16 = var13_13;
                        var17_17 = var8_8;
                        var18_18 = var6_6;
                        var19_19 = var5_5;
                    } else {
                        block12: {
                            var15_15 = var19_19 != 0 ? 2 : 1;
                            var21_21 = DefaultTrackSelector.isSupported(var12_12[var7_7], false);
                            var14_14 = var15_15;
                            if (var21_21) {
                                var14_14 = var15_15 + 1000;
                            }
                            var15_15 = var14_14 > var8_8 ? 1 : 0;
                            if (var14_14 == var8_8) {
                                if (var2_2.forceLowestBitrate) {
                                    if (DefaultTrackSelector.compareFormatValues(var20_20.bitrate, var5_5) < 0) lbl-1000:
                                    // 2 sources

                                    {
                                        while (true) {
                                            var15_15 = 1;
                                            break block12;
                                            break;
                                        }
                                    }
                                    while (true) {
                                        var15_15 = 0;
                                        break block12;
                                        break;
                                    }
                                }
                                var15_15 = var20_20.getPixelCount();
                                var15_15 = var15_15 != var6_6 ? DefaultTrackSelector.compareFormatValues(var15_15, var6_6) : DefaultTrackSelector.compareFormatValues(var20_20.bitrate, var5_5);
                                if (!(var21_21 != false && var19_19 != 0 ? var15_15 > 0 : var15_15 < 0)) ** continue;
                                ** continue;
                            }
                        }
                        var9_9 = var4_4;
                        var16_16 = var13_13;
                        var17_17 = var8_8;
                        var18_18 = var6_6;
                        var19_19 = var5_5;
                        if (var15_15 != 0) {
                            var19_19 = var20_20.bitrate;
                            var18_18 = var20_20.getPixelCount();
                            var16_16 = var7_7;
                            var9_9 = var10_10;
                            var17_17 = var14_14;
                        }
                    }
                }
                var4_4 = var9_9;
                var13_13 = var16_16;
                var8_8 = var17_17;
                var6_6 = var18_18;
                var5_5 = var19_19;
            }
            ++var3_3;
            var7_7 = var8_8;
            var14_14 = var6_6;
            var8_8 = var5_5;
            var5_5 = var13_13;
            var6_6 = var7_7;
            var7_7 = var14_14;
        }
        var0 /* !! */  = var4_4 == null ? null : new FixedTrackSelection((TrackGroup)var4_4, var5_5);
        return var0 /* !! */ ;
    }

    public ParametersBuilder buildUponParameters() {
        return this.getParameters().buildUpon();
    }

    public final void clearSelectionOverride(int n2, TrackGroupArray trackGroupArray) {
        this.setParameters(this.buildUponParameters().clearSelectionOverride(n2, trackGroupArray));
    }

    public final void clearSelectionOverrides() {
        this.setParameters(this.buildUponParameters().clearSelectionOverrides());
    }

    public final void clearSelectionOverrides(int n2) {
        this.setParameters(this.buildUponParameters().clearSelectionOverrides(n2));
    }

    public Parameters getParameters() {
        return this.parametersReference.get();
    }

    public final boolean getRendererDisabled(int n2) {
        return this.getParameters().getRendererDisabled(n2);
    }

    public final SelectionOverride getSelectionOverride(int n2, TrackGroupArray trackGroupArray) {
        return this.getParameters().getSelectionOverride(n2, trackGroupArray);
    }

    public final boolean hasSelectionOverride(int n2, TrackGroupArray trackGroupArray) {
        return this.getParameters().hasSelectionOverride(n2, trackGroupArray);
    }

    protected TrackSelection[] selectAllTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] nArray, int[] nArray2, Parameters parameters) throws ExoPlaybackException {
        int n2;
        int n3;
        int n4;
        int n5 = mappedTrackInfo.getRendererCount();
        TrackSelection[] trackSelectionArray = new TrackSelection[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (true) {
            n4 = 1;
            if (n7 >= n5) break;
            n3 = n6;
            n2 = n8;
            if (2 == mappedTrackInfo.getRendererType(n7)) {
                n3 = n6;
                if (n6 == 0) {
                    trackSelectionArray[n7] = this.selectVideoTrack(mappedTrackInfo.getTrackGroups(n7), nArray[n7], nArray2[n7], parameters, this.adaptiveTrackSelectionFactory);
                    n3 = trackSelectionArray[n7] != null ? 1 : 0;
                }
                n6 = mappedTrackInfo.getTrackGroups((int)n7).length > 0 ? n4 : 0;
                n2 = n8 | n6;
            }
            ++n7;
            n6 = n3;
            n8 = n2;
        }
        n7 = 0;
        n2 = 0;
        for (n6 = 0; n6 < n5; ++n6) {
            int n9 = mappedTrackInfo.getRendererType(n6);
            if (n9 != 1) {
                n3 = n7;
                n4 = n2;
                if (n9 != 2) {
                    if (n9 != 3) {
                        trackSelectionArray[n6] = this.selectOtherTrack(n9, mappedTrackInfo.getTrackGroups(n6), nArray[n6], parameters);
                        n3 = n7;
                        n4 = n2;
                    } else {
                        n3 = n7;
                        n4 = n2;
                        if (n2 == 0) {
                            trackSelectionArray[n6] = this.selectTextTrack(mappedTrackInfo.getTrackGroups(n6), nArray[n6], parameters);
                            n3 = trackSelectionArray[n6] != null ? 1 : 0;
                            n4 = n3;
                            n3 = n7;
                        }
                    }
                }
            } else {
                n3 = n7;
                n4 = n2;
                if (n7 == 0) {
                    TrackGroupArray trackGroupArray = mappedTrackInfo.getTrackGroups(n6);
                    int[][] nArray3 = nArray[n6];
                    n3 = nArray2[n6];
                    TrackSelection.Factory factory = n8 != 0 ? null : this.adaptiveTrackSelectionFactory;
                    trackSelectionArray[n6] = this.selectAudioTrack(trackGroupArray, nArray3, n3, parameters, factory);
                    if (trackSelectionArray[n6] != null) {
                        n3 = 1;
                        n4 = n2;
                    } else {
                        n3 = 0;
                        n4 = n2;
                    }
                }
            }
            n7 = n3;
            n2 = n4;
        }
        return trackSelectionArray;
    }

    protected TrackSelection selectAudioTrack(TrackGroupArray trackGroupArray, int[][] object, int n2, Parameters parameters, TrackSelection.Factory factory) throws ExoPlaybackException {
        AudioTrackScore audioTrackScore = null;
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < trackGroupArray.length; ++n2) {
            TrackGroup trackGroup = trackGroupArray.get(n2);
            int[] nArray = object[n2];
            int n5 = n3;
            int n6 = 0;
            n3 = n4;
            for (n4 = n6; n4 < trackGroup.length; ++n4) {
                AudioTrackScore audioTrackScore2;
                int n7;
                block7: {
                    AudioTrackScore audioTrackScore3;
                    block8: {
                        n7 = n5;
                        audioTrackScore2 = audioTrackScore;
                        n6 = n3;
                        if (!DefaultTrackSelector.isSupported(nArray[n4], parameters.exceedRendererCapabilitiesIfNecessary)) break block7;
                        audioTrackScore3 = new AudioTrackScore(trackGroup.getFormat(n4), parameters, nArray[n4]);
                        if (audioTrackScore == null) break block8;
                        n7 = n5;
                        audioTrackScore2 = audioTrackScore;
                        n6 = n3;
                        if (audioTrackScore3.compareTo(audioTrackScore) <= 0) break block7;
                    }
                    n7 = n2;
                    n6 = n4;
                    audioTrackScore2 = audioTrackScore3;
                }
                n5 = n7;
                audioTrackScore = audioTrackScore2;
                n3 = n6;
            }
            n4 = n3;
            n3 = n5;
        }
        if (n3 == -1) {
            return null;
        }
        trackGroupArray = trackGroupArray.get(n3);
        if (!parameters.forceLowestBitrate && factory != null && ((int[][])(object = (Object)DefaultTrackSelector.getAdaptiveAudioTracks((TrackGroup)trackGroupArray, object[n3], parameters.allowMixedMimeAdaptiveness))).length > 0) {
            return factory.createTrackSelection((TrackGroup)trackGroupArray, (int[])object);
        }
        return new FixedTrackSelection((TrackGroup)trackGroupArray, n4);
    }

    protected TrackSelection selectOtherTrack(int n2, TrackGroupArray object, int[][] nArray, Parameters parameters) throws ExoPlaybackException {
        Object var5_5 = null;
        TrackGroup trackGroup = null;
        n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < object.length; ++i2) {
            TrackGroup trackGroup2 = object.get(i2);
            int[] nArray2 = nArray[i2];
            int n4 = n2;
            int n5 = 0;
            n2 = n3;
            for (n3 = n5; n3 < trackGroup2.length; ++n3) {
                TrackGroup trackGroup3 = trackGroup;
                int n6 = n4;
                int n7 = n2;
                if (DefaultTrackSelector.isSupported(nArray2[n3], parameters.exceedRendererCapabilitiesIfNecessary)) {
                    n5 = trackGroup2.getFormat((int)n3).selectionFlags;
                    n7 = 1;
                    if ((n5 = (n5 & 1) != 0 ? 1 : 0) != 0) {
                        n7 = 2;
                    }
                    n5 = n7;
                    if (DefaultTrackSelector.isSupported(nArray2[n3], false)) {
                        n5 = n7 + 1000;
                    }
                    trackGroup3 = trackGroup;
                    n6 = n4;
                    n7 = n2;
                    if (n5 > n2) {
                        n6 = n3;
                        trackGroup3 = trackGroup2;
                        n7 = n5;
                    }
                }
                trackGroup = trackGroup3;
                n4 = n6;
                n2 = n7;
            }
            n3 = n2;
            n2 = n4;
        }
        object = trackGroup == null ? var5_5 : new FixedTrackSelection(trackGroup, n2);
        return object;
    }

    protected TrackSelection selectTextTrack(TrackGroupArray object, int[][] nArray, Parameters parameters) throws ExoPlaybackException {
        TrackGroup trackGroup = null;
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < object.length; ++i2) {
            TrackGroup trackGroup2 = object.get(i2);
            int[] nArray2 = nArray[i2];
            int n4 = n2;
            for (int i3 = 0; i3 < trackGroup2.length; ++i3) {
                int n5;
                TrackGroup trackGroup3;
                block5: {
                    int n6;
                    block8: {
                        block6: {
                            int n7;
                            Format format;
                            block7: {
                                trackGroup3 = trackGroup;
                                n5 = n4;
                                n2 = n3;
                                if (!DefaultTrackSelector.isSupported(nArray2[i3], parameters.exceedRendererCapabilitiesIfNecessary)) break block5;
                                format = trackGroup2.getFormat(i3);
                                n6 = format.selectionFlags & ~parameters.disabledTextTrackSelectionFlags;
                                n7 = 1;
                                n2 = (n6 & 1) != 0 ? 1 : 0;
                                n6 = (n6 & 2) != 0 ? 1 : 0;
                                n5 = DefaultTrackSelector.formatHasLanguage(format, parameters.preferredTextLanguage) ? 1 : 0;
                                if (n5 != 0 || parameters.selectUndeterminedTextLanguage && DefaultTrackSelector.formatHasNoLanguage(format)) break block6;
                                if (n2 == 0) break block7;
                                n2 = 3;
                                break block8;
                            }
                            trackGroup3 = trackGroup;
                            n5 = n4;
                            n2 = n3;
                            if (n6 == 0) break block5;
                            n2 = n7;
                            if (DefaultTrackSelector.formatHasLanguage(format, parameters.preferredAudioLanguage)) {
                                n2 = 2;
                            }
                            break block8;
                        }
                        n2 = n2 != 0 ? 8 : (n6 == 0 ? 6 : 4);
                        n2 += n5;
                    }
                    n6 = n2;
                    if (DefaultTrackSelector.isSupported(nArray2[i3], false)) {
                        n6 = n2 + 1000;
                    }
                    trackGroup3 = trackGroup;
                    n5 = n4;
                    n2 = n3;
                    if (n6 > n3) {
                        n5 = i3;
                        trackGroup3 = trackGroup2;
                        n2 = n6;
                    }
                }
                trackGroup = trackGroup3;
                n4 = n5;
                n3 = n2;
            }
            n2 = n4;
        }
        object = trackGroup == null ? null : new FixedTrackSelection(trackGroup, n2);
        return object;
    }

    protected final Pair<RendererConfiguration[], TrackSelection[]> selectTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] nArray, int[] object) throws ExoPlaybackException {
        Object object2;
        int n2;
        Parameters parameters = this.parametersReference.get();
        int n3 = mappedTrackInfo.getRendererCount();
        TrackSelection[] trackSelectionArray = this.selectAllTracks(mappedTrackInfo, nArray, (int[])object, parameters);
        for (n2 = 0; n2 < n3; ++n2) {
            if (parameters.getRendererDisabled(n2)) {
                trackSelectionArray[n2] = null;
                continue;
            }
            object = mappedTrackInfo.getTrackGroups(n2);
            if (!parameters.hasSelectionOverride(n2, (TrackGroupArray)object)) continue;
            object2 = parameters.getSelectionOverride(n2, (TrackGroupArray)object);
            trackSelectionArray[n2] = object2 == null ? null : (object2.length == 1 ? new FixedTrackSelection(object.get(object2.groupIndex), object2.tracks[0]) : Assertions.checkNotNull(this.adaptiveTrackSelectionFactory).createTrackSelection(object.get(object2.groupIndex), object2.tracks));
        }
        object2 = new RendererConfiguration[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            boolean bl = !parameters.getRendererDisabled(n2) && (mappedTrackInfo.getRendererType(n2) == 5 || trackSelectionArray[n2] != null);
            object = bl ? (Object)RendererConfiguration.DEFAULT : null;
            object2[n2] = (RendererConfiguration)object;
        }
        DefaultTrackSelector.maybeConfigureRenderersForTunneling(mappedTrackInfo, nArray, object2, trackSelectionArray, parameters.tunnelingAudioSessionId);
        return Pair.create((Object)object2, (Object)trackSelectionArray);
    }

    protected TrackSelection selectVideoTrack(TrackGroupArray trackGroupArray, int[][] nArray, int n2, Parameters parameters, TrackSelection.Factory object) throws ExoPlaybackException {
        object = !parameters.forceLowestBitrate && object != null ? DefaultTrackSelector.selectAdaptiveVideoTrack(trackGroupArray, nArray, n2, parameters, object) : null;
        TrackSelection.Factory factory = object;
        if (object == null) {
            factory = DefaultTrackSelector.selectFixedVideoTrack(trackGroupArray, nArray, parameters);
        }
        return factory;
    }

    public void setParameters(Parameters parameters) {
        Assertions.checkNotNull(parameters);
        if (!this.parametersReference.getAndSet(parameters).equals(parameters)) {
            this.invalidate();
        }
    }

    public void setParameters(ParametersBuilder parametersBuilder) {
        this.setParameters(parametersBuilder.build());
    }

    public final void setRendererDisabled(int n2, boolean bl) {
        this.setParameters(this.buildUponParameters().setRendererDisabled(n2, bl));
    }

    public final void setSelectionOverride(int n2, TrackGroupArray trackGroupArray, SelectionOverride selectionOverride) {
        this.setParameters(this.buildUponParameters().setSelectionOverride(n2, trackGroupArray, selectionOverride));
    }

    public void setTunnelingAudioSessionId(int n2) {
        this.setParameters(this.buildUponParameters().setTunnelingAudioSessionId(n2));
    }

    private static final class AudioConfigurationTuple {
        public final int channelCount;
        public final String mimeType;
        public final int sampleRate;

        public AudioConfigurationTuple(int n2, int n3, String string2) {
            this.channelCount = n2;
            this.sampleRate = n3;
            this.mimeType = string2;
        }

        public final boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (AudioConfigurationTuple)object;
                if (this.channelCount != ((AudioConfigurationTuple)object).channelCount || this.sampleRate != ((AudioConfigurationTuple)object).sampleRate || !TextUtils.equals((CharSequence)this.mimeType, (CharSequence)((AudioConfigurationTuple)object).mimeType)) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public final int hashCode() {
            int n2 = this.channelCount;
            int n3 = this.sampleRate;
            String string2 = this.mimeType;
            int n4 = string2 != null ? string2.hashCode() : 0;
            return (n2 * 31 + n3) * 31 + n4;
        }
    }

    private static final class AudioTrackScore
    implements Comparable<AudioTrackScore> {
        private final int bitrate;
        private final int channelCount;
        private final int defaultSelectionFlagScore;
        private final int matchLanguageScore;
        private final Parameters parameters;
        private final int sampleRate;
        private final int withinRendererCapabilitiesScore;

        public AudioTrackScore(Format format, Parameters parameters, int n2) {
            this.parameters = parameters;
            this.withinRendererCapabilitiesScore = DefaultTrackSelector.isSupported(n2, false) ? 1 : 0;
            this.matchLanguageScore = DefaultTrackSelector.formatHasLanguage(format, parameters.preferredAudioLanguage) ? 1 : 0;
            int n3 = format.selectionFlags;
            n2 = 1;
            if ((n3 & 1) == 0) {
                n2 = 0;
            }
            this.defaultSelectionFlagScore = n2;
            this.channelCount = format.channelCount;
            this.sampleRate = format.sampleRate;
            this.bitrate = format.bitrate;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final int compareTo(AudioTrackScore audioTrackScore) {
            int n2 = this.withinRendererCapabilitiesScore;
            int n3 = audioTrackScore.withinRendererCapabilitiesScore;
            if (n2 != n3) {
                return DefaultTrackSelector.compareInts(n2, n3);
            }
            n2 = this.matchLanguageScore;
            n3 = audioTrackScore.matchLanguageScore;
            if (n2 != n3) {
                return DefaultTrackSelector.compareInts(n2, n3);
            }
            n3 = this.defaultSelectionFlagScore;
            n2 = audioTrackScore.defaultSelectionFlagScore;
            if (n3 != n2) {
                return DefaultTrackSelector.compareInts(n3, n2);
            }
            if (this.parameters.forceLowestBitrate) {
                return DefaultTrackSelector.compareInts(audioTrackScore.bitrate, this.bitrate);
            }
            n2 = this.withinRendererCapabilitiesScore;
            n3 = 1;
            if (n2 != 1) {
                n3 = -1;
            }
            int n4 = this.channelCount;
            n2 = audioTrackScore.channelCount;
            if (n4 != n2) {
                n2 = DefaultTrackSelector.compareInts(n4, n2);
                return n3 * n2;
            }
            n2 = this.sampleRate;
            n4 = audioTrackScore.sampleRate;
            if (n2 != n4) {
                n2 = DefaultTrackSelector.compareInts(n2, n4);
                return n3 * n2;
            }
            n2 = DefaultTrackSelector.compareInts(this.bitrate, audioTrackScore.bitrate);
            return n3 * n2;
        }

        public final boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (AudioTrackScore)object;
                if (this.withinRendererCapabilitiesScore != ((AudioTrackScore)object).withinRendererCapabilitiesScore || this.matchLanguageScore != ((AudioTrackScore)object).matchLanguageScore || this.defaultSelectionFlagScore != ((AudioTrackScore)object).defaultSelectionFlagScore || this.channelCount != ((AudioTrackScore)object).channelCount || this.sampleRate != ((AudioTrackScore)object).sampleRate || this.bitrate != ((AudioTrackScore)object).bitrate) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public final int hashCode() {
            return ((((this.withinRendererCapabilitiesScore * 31 + this.matchLanguageScore) * 31 + this.defaultSelectionFlagScore) * 31 + this.channelCount) * 31 + this.sampleRate) * 31 + this.bitrate;
        }
    }

    public static final class Parameters
    implements Parcelable {
        public static final Parcelable.Creator<Parameters> CREATOR;
        public static final Parameters DEFAULT;
        public final boolean allowMixedMimeAdaptiveness;
        public final boolean allowNonSeamlessAdaptiveness;
        public final int disabledTextTrackSelectionFlags;
        public final boolean exceedRendererCapabilitiesIfNecessary;
        public final boolean exceedVideoConstraintsIfNecessary;
        public final boolean forceLowestBitrate;
        public final int maxVideoBitrate;
        public final int maxVideoHeight;
        public final int maxVideoWidth;
        public final String preferredAudioLanguage;
        public final String preferredTextLanguage;
        private final SparseBooleanArray rendererDisabledFlags;
        public final boolean selectUndeterminedTextLanguage;
        private final SparseArray<Map<TrackGroupArray, SelectionOverride>> selectionOverrides;
        public final int tunnelingAudioSessionId;
        public final int viewportHeight;
        public final boolean viewportOrientationMayChange;
        public final int viewportWidth;

        static {
            DEFAULT = new Parameters();
            CREATOR = new Parcelable.Creator<Parameters>(){

                public final Parameters createFromParcel(Parcel parcel) {
                    return new Parameters(parcel);
                }

                public final Parameters[] newArray(int n2) {
                    return new Parameters[n2];
                }
            };
        }

        private Parameters() {
            this((SparseArray<Map<TrackGroupArray, SelectionOverride>>)new SparseArray(), new SparseBooleanArray(), null, null, false, 0, false, false, true, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true, Integer.MAX_VALUE, Integer.MAX_VALUE, true, 0);
        }

        Parameters(Parcel parcel) {
            this.selectionOverrides = Parameters.readSelectionOverrides(parcel);
            this.rendererDisabledFlags = parcel.readSparseBooleanArray();
            this.preferredAudioLanguage = parcel.readString();
            this.preferredTextLanguage = parcel.readString();
            this.selectUndeterminedTextLanguage = Util.readBoolean((Parcel)parcel);
            this.disabledTextTrackSelectionFlags = parcel.readInt();
            this.forceLowestBitrate = Util.readBoolean((Parcel)parcel);
            this.allowMixedMimeAdaptiveness = Util.readBoolean((Parcel)parcel);
            this.allowNonSeamlessAdaptiveness = Util.readBoolean((Parcel)parcel);
            this.maxVideoWidth = parcel.readInt();
            this.maxVideoHeight = parcel.readInt();
            this.maxVideoBitrate = parcel.readInt();
            this.exceedVideoConstraintsIfNecessary = Util.readBoolean((Parcel)parcel);
            this.exceedRendererCapabilitiesIfNecessary = Util.readBoolean((Parcel)parcel);
            this.viewportWidth = parcel.readInt();
            this.viewportHeight = parcel.readInt();
            this.viewportOrientationMayChange = Util.readBoolean((Parcel)parcel);
            this.tunnelingAudioSessionId = parcel.readInt();
        }

        Parameters(SparseArray<Map<TrackGroupArray, SelectionOverride>> sparseArray, SparseBooleanArray sparseBooleanArray, String string2, String string3, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, int n3, int n4, int n5, boolean bl5, boolean bl6, int n6, int n7, boolean bl7, int n8) {
            this.selectionOverrides = sparseArray;
            this.rendererDisabledFlags = sparseBooleanArray;
            this.preferredAudioLanguage = Util.normalizeLanguageCode((String)string2);
            this.preferredTextLanguage = Util.normalizeLanguageCode((String)string3);
            this.selectUndeterminedTextLanguage = bl;
            this.disabledTextTrackSelectionFlags = n2;
            this.forceLowestBitrate = bl2;
            this.allowMixedMimeAdaptiveness = bl3;
            this.allowNonSeamlessAdaptiveness = bl4;
            this.maxVideoWidth = n3;
            this.maxVideoHeight = n4;
            this.maxVideoBitrate = n5;
            this.exceedVideoConstraintsIfNecessary = bl5;
            this.exceedRendererCapabilitiesIfNecessary = bl6;
            this.viewportWidth = n6;
            this.viewportHeight = n7;
            this.viewportOrientationMayChange = bl7;
            this.tunnelingAudioSessionId = n8;
        }

        private static boolean areRendererDisabledFlagsEqual(SparseBooleanArray sparseBooleanArray, SparseBooleanArray sparseBooleanArray2) {
            int n2 = sparseBooleanArray.size();
            if (sparseBooleanArray2.size() != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (sparseBooleanArray2.indexOfKey(sparseBooleanArray.keyAt(i2)) >= 0) continue;
                return false;
            }
            return true;
        }

        private static boolean areSelectionOverridesEqual(SparseArray<Map<TrackGroupArray, SelectionOverride>> sparseArray, SparseArray<Map<TrackGroupArray, SelectionOverride>> sparseArray2) {
            int n2 = sparseArray.size();
            if (sparseArray2.size() != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = sparseArray2.indexOfKey(sparseArray.keyAt(i2));
                if (n3 >= 0 && Parameters.areSelectionOverridesEqual((Map)sparseArray.valueAt(i2), (Map)sparseArray2.valueAt(n3))) {
                    continue;
                }
                return false;
            }
            return true;
        }

        private static boolean areSelectionOverridesEqual(Map<TrackGroupArray, SelectionOverride> object, Map<TrackGroupArray, SelectionOverride> map) {
            int n2 = object.size();
            if (map.size() != n2) {
                return false;
            }
            for (Map.Entry entry : object.entrySet()) {
                TrackGroupArray trackGroupArray = (TrackGroupArray)entry.getKey();
                if (map.containsKey(trackGroupArray) && Util.areEqual(entry.getValue(), (Object)map.get(trackGroupArray))) continue;
                return false;
            }
            return true;
        }

        private static SparseArray<Map<TrackGroupArray, SelectionOverride>> readSelectionOverrides(Parcel parcel) {
            int n2 = parcel.readInt();
            SparseArray sparseArray = new SparseArray(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = parcel.readInt();
                int n4 = parcel.readInt();
                HashMap<TrackGroupArray, SelectionOverride> hashMap = new HashMap<TrackGroupArray, SelectionOverride>(n4);
                for (int i3 = 0; i3 < n4; ++i3) {
                    hashMap.put((TrackGroupArray)parcel.readParcelable(TrackGroupArray.class.getClassLoader()), (SelectionOverride)parcel.readParcelable(SelectionOverride.class.getClassLoader()));
                }
                sparseArray.put(n3, hashMap);
            }
            return sparseArray;
        }

        private static void writeSelectionOverridesToParcel(Parcel parcel, SparseArray<Map<TrackGroupArray, SelectionOverride>> sparseArray) {
            int n2 = sparseArray.size();
            parcel.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = sparseArray.keyAt(i2);
                Map map = (Map)sparseArray.valueAt(i2);
                int n4 = map.size();
                parcel.writeInt(n3);
                parcel.writeInt(n4);
                for (Map.Entry entry : map.entrySet()) {
                    parcel.writeParcelable((Parcelable)entry.getKey(), 0);
                    parcel.writeParcelable((Parcelable)entry.getValue(), 0);
                }
            }
        }

        public final ParametersBuilder buildUpon() {
            return new ParametersBuilder(this);
        }

        public final int describeContents() {
            return 0;
        }

        public final boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (Parameters)object;
                if (!(this.selectUndeterminedTextLanguage == ((Parameters)object).selectUndeterminedTextLanguage && this.disabledTextTrackSelectionFlags == ((Parameters)object).disabledTextTrackSelectionFlags && this.forceLowestBitrate == ((Parameters)object).forceLowestBitrate && this.allowMixedMimeAdaptiveness == ((Parameters)object).allowMixedMimeAdaptiveness && this.allowNonSeamlessAdaptiveness == ((Parameters)object).allowNonSeamlessAdaptiveness && this.maxVideoWidth == ((Parameters)object).maxVideoWidth && this.maxVideoHeight == ((Parameters)object).maxVideoHeight && this.exceedVideoConstraintsIfNecessary == ((Parameters)object).exceedVideoConstraintsIfNecessary && this.exceedRendererCapabilitiesIfNecessary == ((Parameters)object).exceedRendererCapabilitiesIfNecessary && this.viewportOrientationMayChange == ((Parameters)object).viewportOrientationMayChange && this.viewportWidth == ((Parameters)object).viewportWidth && this.viewportHeight == ((Parameters)object).viewportHeight && this.maxVideoBitrate == ((Parameters)object).maxVideoBitrate && this.tunnelingAudioSessionId == ((Parameters)object).tunnelingAudioSessionId && TextUtils.equals((CharSequence)this.preferredAudioLanguage, (CharSequence)((Parameters)object).preferredAudioLanguage) && TextUtils.equals((CharSequence)this.preferredTextLanguage, (CharSequence)((Parameters)object).preferredTextLanguage) && Parameters.areRendererDisabledFlagsEqual(this.rendererDisabledFlags, ((Parameters)object).rendererDisabledFlags) && Parameters.areSelectionOverridesEqual(this.selectionOverrides, ((Parameters)object).selectionOverrides))) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public final boolean getRendererDisabled(int n2) {
            return this.rendererDisabledFlags.get(n2);
        }

        public final SelectionOverride getSelectionOverride(int n2, TrackGroupArray object) {
            Map map = (Map)this.selectionOverrides.get(n2);
            object = map != null ? (SelectionOverride)map.get(object) : null;
            return object;
        }

        public final boolean hasSelectionOverride(int n2, TrackGroupArray trackGroupArray) {
            Map map = (Map)this.selectionOverrides.get(n2);
            boolean bl = map != null && map.containsKey(trackGroupArray);
            return bl;
        }

        public final int hashCode() {
            int n2 = this.selectUndeterminedTextLanguage;
            int n3 = this.disabledTextTrackSelectionFlags;
            int n4 = this.forceLowestBitrate;
            int n5 = this.allowMixedMimeAdaptiveness;
            int n6 = this.allowNonSeamlessAdaptiveness;
            int n7 = this.maxVideoWidth;
            int n8 = this.maxVideoHeight;
            int n9 = this.exceedVideoConstraintsIfNecessary;
            int n10 = this.exceedRendererCapabilitiesIfNecessary;
            int n11 = this.viewportOrientationMayChange;
            int n12 = this.viewportWidth;
            int n13 = this.viewportHeight;
            int n14 = this.maxVideoBitrate;
            int n15 = this.tunnelingAudioSessionId;
            String string2 = this.preferredAudioLanguage;
            int n16 = 0;
            int n17 = string2 == null ? 0 : string2.hashCode();
            string2 = this.preferredTextLanguage;
            if (string2 != null) {
                n16 = string2.hashCode();
            }
            return ((((((((((((((n2 * 31 + n3) * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31 + n8) * 31 + n9) * 31 + n10) * 31 + n11) * 31 + n12) * 31 + n13) * 31 + n14) * 31 + n15) * 31 + n17) * 31 + n16;
        }

        public final void writeToParcel(Parcel parcel, int n2) {
            Parameters.writeSelectionOverridesToParcel(parcel, this.selectionOverrides);
            parcel.writeSparseBooleanArray(this.rendererDisabledFlags);
            parcel.writeString(this.preferredAudioLanguage);
            parcel.writeString(this.preferredTextLanguage);
            Util.writeBoolean((Parcel)parcel, (boolean)this.selectUndeterminedTextLanguage);
            parcel.writeInt(this.disabledTextTrackSelectionFlags);
            Util.writeBoolean((Parcel)parcel, (boolean)this.forceLowestBitrate);
            Util.writeBoolean((Parcel)parcel, (boolean)this.allowMixedMimeAdaptiveness);
            Util.writeBoolean((Parcel)parcel, (boolean)this.allowNonSeamlessAdaptiveness);
            parcel.writeInt(this.maxVideoWidth);
            parcel.writeInt(this.maxVideoHeight);
            parcel.writeInt(this.maxVideoBitrate);
            Util.writeBoolean((Parcel)parcel, (boolean)this.exceedVideoConstraintsIfNecessary);
            Util.writeBoolean((Parcel)parcel, (boolean)this.exceedRendererCapabilitiesIfNecessary);
            parcel.writeInt(this.viewportWidth);
            parcel.writeInt(this.viewportHeight);
            Util.writeBoolean((Parcel)parcel, (boolean)this.viewportOrientationMayChange);
            parcel.writeInt(this.tunnelingAudioSessionId);
        }
    }

    public static final class ParametersBuilder {
        private boolean allowMixedMimeAdaptiveness;
        private boolean allowNonSeamlessAdaptiveness;
        private int disabledTextTrackSelectionFlags;
        private boolean exceedRendererCapabilitiesIfNecessary;
        private boolean exceedVideoConstraintsIfNecessary;
        private boolean forceLowestBitrate;
        private int maxVideoBitrate;
        private int maxVideoHeight;
        private int maxVideoWidth;
        private String preferredAudioLanguage;
        private String preferredTextLanguage;
        private final SparseBooleanArray rendererDisabledFlags;
        private boolean selectUndeterminedTextLanguage;
        private final SparseArray<Map<TrackGroupArray, SelectionOverride>> selectionOverrides;
        private int tunnelingAudioSessionId;
        private int viewportHeight;
        private boolean viewportOrientationMayChange;
        private int viewportWidth;

        public ParametersBuilder() {
            this(Parameters.DEFAULT);
        }

        private ParametersBuilder(Parameters parameters) {
            this.selectionOverrides = ParametersBuilder.cloneSelectionOverrides((SparseArray<Map<TrackGroupArray, SelectionOverride>>)parameters.selectionOverrides);
            this.rendererDisabledFlags = parameters.rendererDisabledFlags.clone();
            this.preferredAudioLanguage = parameters.preferredAudioLanguage;
            this.preferredTextLanguage = parameters.preferredTextLanguage;
            this.selectUndeterminedTextLanguage = parameters.selectUndeterminedTextLanguage;
            this.disabledTextTrackSelectionFlags = parameters.disabledTextTrackSelectionFlags;
            this.forceLowestBitrate = parameters.forceLowestBitrate;
            this.allowMixedMimeAdaptiveness = parameters.allowMixedMimeAdaptiveness;
            this.allowNonSeamlessAdaptiveness = parameters.allowNonSeamlessAdaptiveness;
            this.maxVideoWidth = parameters.maxVideoWidth;
            this.maxVideoHeight = parameters.maxVideoHeight;
            this.maxVideoBitrate = parameters.maxVideoBitrate;
            this.exceedVideoConstraintsIfNecessary = parameters.exceedVideoConstraintsIfNecessary;
            this.exceedRendererCapabilitiesIfNecessary = parameters.exceedRendererCapabilitiesIfNecessary;
            this.viewportWidth = parameters.viewportWidth;
            this.viewportHeight = parameters.viewportHeight;
            this.viewportOrientationMayChange = parameters.viewportOrientationMayChange;
            this.tunnelingAudioSessionId = parameters.tunnelingAudioSessionId;
        }

        private static SparseArray<Map<TrackGroupArray, SelectionOverride>> cloneSelectionOverrides(SparseArray<Map<TrackGroupArray, SelectionOverride>> sparseArray) {
            SparseArray sparseArray2 = new SparseArray();
            for (int i2 = 0; i2 < sparseArray.size(); ++i2) {
                sparseArray2.put(sparseArray.keyAt(i2), new HashMap((Map)sparseArray.valueAt(i2)));
            }
            return sparseArray2;
        }

        public final Parameters build() {
            return new Parameters(this.selectionOverrides, this.rendererDisabledFlags, this.preferredAudioLanguage, this.preferredTextLanguage, this.selectUndeterminedTextLanguage, this.disabledTextTrackSelectionFlags, this.forceLowestBitrate, this.allowMixedMimeAdaptiveness, this.allowNonSeamlessAdaptiveness, this.maxVideoWidth, this.maxVideoHeight, this.maxVideoBitrate, this.exceedVideoConstraintsIfNecessary, this.exceedRendererCapabilitiesIfNecessary, this.viewportWidth, this.viewportHeight, this.viewportOrientationMayChange, this.tunnelingAudioSessionId);
        }

        public final ParametersBuilder clearSelectionOverride(int n2, TrackGroupArray trackGroupArray) {
            Map map = (Map)this.selectionOverrides.get(n2);
            if (map != null && map.containsKey(trackGroupArray)) {
                map.remove(trackGroupArray);
                if (map.isEmpty()) {
                    this.selectionOverrides.remove(n2);
                }
            }
            return this;
        }

        public final ParametersBuilder clearSelectionOverrides() {
            if (this.selectionOverrides.size() == 0) {
                return this;
            }
            this.selectionOverrides.clear();
            return this;
        }

        public final ParametersBuilder clearSelectionOverrides(int n2) {
            Map map = (Map)this.selectionOverrides.get(n2);
            if (map != null && !map.isEmpty()) {
                this.selectionOverrides.remove(n2);
            }
            return this;
        }

        public final ParametersBuilder clearVideoSizeConstraints() {
            return this.setMaxVideoSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public final ParametersBuilder clearViewportSizeConstraints() {
            return this.setViewportSize(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
        }

        public final ParametersBuilder setAllowMixedMimeAdaptiveness(boolean bl) {
            this.allowMixedMimeAdaptiveness = bl;
            return this;
        }

        public final ParametersBuilder setAllowNonSeamlessAdaptiveness(boolean bl) {
            this.allowNonSeamlessAdaptiveness = bl;
            return this;
        }

        public final ParametersBuilder setDisabledTextTrackSelectionFlags(int n2) {
            this.disabledTextTrackSelectionFlags = n2;
            return this;
        }

        public final ParametersBuilder setExceedRendererCapabilitiesIfNecessary(boolean bl) {
            this.exceedRendererCapabilitiesIfNecessary = bl;
            return this;
        }

        public final ParametersBuilder setExceedVideoConstraintsIfNecessary(boolean bl) {
            this.exceedVideoConstraintsIfNecessary = bl;
            return this;
        }

        public final ParametersBuilder setForceLowestBitrate(boolean bl) {
            this.forceLowestBitrate = bl;
            return this;
        }

        public final ParametersBuilder setMaxVideoBitrate(int n2) {
            this.maxVideoBitrate = n2;
            return this;
        }

        public final ParametersBuilder setMaxVideoSize(int n2, int n3) {
            this.maxVideoWidth = n2;
            this.maxVideoHeight = n3;
            return this;
        }

        public final ParametersBuilder setMaxVideoSizeSd() {
            return this.setMaxVideoSize(1279, 719);
        }

        public final ParametersBuilder setPreferredAudioLanguage(String string2) {
            this.preferredAudioLanguage = string2;
            return this;
        }

        public final ParametersBuilder setPreferredTextLanguage(String string2) {
            this.preferredTextLanguage = string2;
            return this;
        }

        public final ParametersBuilder setRendererDisabled(int n2, boolean bl) {
            if (this.rendererDisabledFlags.get(n2) == bl) {
                return this;
            }
            if (bl) {
                this.rendererDisabledFlags.put(n2, true);
            } else {
                this.rendererDisabledFlags.delete(n2);
            }
            return this;
        }

        public final ParametersBuilder setSelectUndeterminedTextLanguage(boolean bl) {
            this.selectUndeterminedTextLanguage = bl;
            return this;
        }

        public final ParametersBuilder setSelectionOverride(int n2, TrackGroupArray trackGroupArray, SelectionOverride selectionOverride) {
            HashMap<TrackGroupArray, SelectionOverride> hashMap;
            HashMap<TrackGroupArray, SelectionOverride> hashMap2 = hashMap = (HashMap<TrackGroupArray, SelectionOverride>)this.selectionOverrides.get(n2);
            if (hashMap == null) {
                hashMap2 = new HashMap<TrackGroupArray, SelectionOverride>();
                this.selectionOverrides.put(n2, hashMap2);
            }
            if (hashMap2.containsKey(trackGroupArray) && Util.areEqual(hashMap2.get(trackGroupArray), (Object)selectionOverride)) {
                return this;
            }
            hashMap2.put(trackGroupArray, selectionOverride);
            return this;
        }

        public final ParametersBuilder setTunnelingAudioSessionId(int n2) {
            if (this.tunnelingAudioSessionId != n2) {
                this.tunnelingAudioSessionId = n2;
            }
            return this;
        }

        public final ParametersBuilder setViewportSize(int n2, int n3, boolean bl) {
            this.viewportWidth = n2;
            this.viewportHeight = n3;
            this.viewportOrientationMayChange = bl;
            return this;
        }

        public final ParametersBuilder setViewportSizeToPhysicalDisplaySize(Context context, boolean bl) {
            context = Util.getPhysicalDisplaySize((Context)context);
            return this.setViewportSize(context.x, context.y, bl);
        }
    }

    public static final class SelectionOverride
    implements Parcelable {
        public static final Parcelable.Creator<SelectionOverride> CREATOR = new Parcelable.Creator<SelectionOverride>(){

            public final SelectionOverride createFromParcel(Parcel parcel) {
                return new SelectionOverride(parcel);
            }

            public final SelectionOverride[] newArray(int n2) {
                return new SelectionOverride[n2];
            }
        };
        public final int groupIndex;
        public final int length;
        public final int[] tracks;

        public SelectionOverride(int n2, int ... nArray) {
            this.groupIndex = n2;
            this.tracks = Arrays.copyOf(nArray, nArray.length);
            this.length = nArray.length;
            Arrays.sort(this.tracks);
        }

        SelectionOverride(Parcel parcel) {
            this.groupIndex = parcel.readInt();
            this.length = parcel.readByte();
            this.tracks = new int[this.length];
            parcel.readIntArray(this.tracks);
        }

        public final boolean containsTrack(int n2) {
            int[] nArray = this.tracks;
            int n3 = nArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (nArray[i2] != n2) continue;
                return true;
            }
            return false;
        }

        public final int describeContents() {
            return 0;
        }

        public final boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (SelectionOverride)object;
                if (this.groupIndex != ((SelectionOverride)object).groupIndex || !Arrays.equals(this.tracks, ((SelectionOverride)object).tracks)) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public final int hashCode() {
            return this.groupIndex * 31 + Arrays.hashCode(this.tracks);
        }

        public final void writeToParcel(Parcel parcel, int n2) {
            parcel.writeInt(this.groupIndex);
            parcel.writeInt(this.tracks.length);
            parcel.writeIntArray(this.tracks);
        }
    }
}

