/*
 * Decompiled with CFR 0.152.
 */
package com.mbridge.msdk.playercommon.exoplayer2.trackselection;

import android.os.SystemClock;
import com.mbridge.msdk.playercommon.exoplayer2.Format;
import com.mbridge.msdk.playercommon.exoplayer2.source.TrackGroup;
import com.mbridge.msdk.playercommon.exoplayer2.source.chunk.MediaChunk;
import com.mbridge.msdk.playercommon.exoplayer2.trackselection.TrackSelection;
import com.mbridge.msdk.playercommon.exoplayer2.util.Assertions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public abstract class BaseTrackSelection
implements TrackSelection {
    private final long[] blacklistUntilTimes;
    private final Format[] formats;
    protected final TrackGroup group;
    private int hashCode;
    protected final int length;
    protected final int[] tracks;

    public BaseTrackSelection(TrackGroup trackGroup, int ... nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        boolean bl = n2 > 0;
        Assertions.checkState(bl);
        this.group = Assertions.checkNotNull(trackGroup);
        this.length = nArray.length;
        this.formats = new Format[this.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.formats[n2] = trackGroup.getFormat(nArray[n2]);
        }
        Arrays.sort(this.formats, new DecreasingBandwidthComparator());
        this.tracks = new int[this.length];
        for (n2 = n3; n2 < (n3 = this.length); ++n2) {
            this.tracks[n2] = trackGroup.indexOf(this.formats[n2]);
        }
        this.blacklistUntilTimes = new long[n3];
    }

    public final boolean blacklist(int n2, long l2) {
        long l3 = SystemClock.elapsedRealtime();
        boolean bl = this.isBlacklisted(n2, l3);
        for (int i2 = 0; i2 < this.length && !bl; ++i2) {
            bl = i2 != n2 && !this.isBlacklisted(i2, l3);
        }
        if (!bl) {
            return false;
        }
        long[] lArray = this.blacklistUntilTimes;
        lArray[n2] = Math.max(lArray[n2], l3 + l2);
        return true;
    }

    public void disable() {
    }

    public void enable() {
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (BaseTrackSelection)object;
            if (this.group != ((BaseTrackSelection)object).group || !Arrays.equals(this.tracks, ((BaseTrackSelection)object).tracks)) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int evaluateQueueSize(long l2, List<? extends MediaChunk> list) {
        return list.size();
    }

    public final Format getFormat(int n2) {
        return this.formats[n2];
    }

    public final int getIndexInTrackGroup(int n2) {
        return this.tracks[n2];
    }

    public final Format getSelectedFormat() {
        return this.formats[this.getSelectedIndex()];
    }

    public final int getSelectedIndexInTrackGroup() {
        return this.tracks[this.getSelectedIndex()];
    }

    public final TrackGroup getTrackGroup() {
        return this.group;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = System.identityHashCode(this.group) * 31 + Arrays.hashCode(this.tracks);
        }
        return this.hashCode;
    }

    public final int indexOf(int n2) {
        for (int i2 = 0; i2 < this.length; ++i2) {
            if (this.tracks[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public final int indexOf(Format format) {
        for (int i2 = 0; i2 < this.length; ++i2) {
            if (this.formats[i2] != format) continue;
            return i2;
        }
        return -1;
    }

    protected final boolean isBlacklisted(int n2, long l2) {
        boolean bl = this.blacklistUntilTimes[n2] > l2;
        return bl;
    }

    public final int length() {
        return this.tracks.length;
    }

    public void onPlaybackSpeed(float f2) {
    }

    private static final class DecreasingBandwidthComparator
    implements Comparator<Format> {
        private DecreasingBandwidthComparator() {
        }

        @Override
        public final int compare(Format format, Format format2) {
            return format2.bitrate - format.bitrate;
        }
    }
}

